/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.base.JRBaseBox;
import net.sf.jasperreports.engine.export.JRExporterGridCell;

public class JRGridLayout {
    public static final ExporterElements UNIVERSAL_EXPORTER = new ExporterElements(){

        public boolean isToExport(JRPrintElement element) {
            return true;
        }
    };
    public static final ExporterElements NO_IMAGES_EXPORTER = new ExporterElements(){

        public boolean isToExport(JRPrintElement element) {
            return !(element instanceof JRPrintImage);
        }
    };
    public static final ExporterElements TEXT_EXPORTER = new ExporterElements(){

        public boolean isToExport(JRPrintElement element) {
            return element instanceof JRPrintText;
        }
    };
    private final List elements;
    private final int width;
    private final int height;
    private final int offsetX;
    private final int offsetY;
    private final ExporterElements elementsExporter;
    private final boolean deep;
    private final boolean spanCells;
    private final boolean setElementIndexes;
    private final Integer[] initialIndex;
    private List xCuts;
    private List yCuts;
    private JRExporterGridCell[][] grid;
    private boolean[] isRowNotEmpty;
    private boolean[] isColNotEmpty;
    private Map boxesCache;

    public JRGridLayout(List elements, int width, int height, int offsetX, int offsetY, ExporterElements elementsExporter, boolean deep, boolean spanCells, boolean setElementIndexes, Integer[] initialIndex) {
        this(elements, width, height, offsetX, offsetY, elementsExporter, deep, spanCells, setElementIndexes, initialIndex, null);
    }

    public JRGridLayout(List elements, int width, int height, int offsetX, int offsetY, ExporterElements elementsExporter, boolean deep, boolean spanCells, boolean setElementIndexes, Integer[] initialIndex, List xCuts) {
        this.elements = elements;
        this.height = height;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.width = width;
        this.elementsExporter = elementsExporter;
        this.deep = deep;
        this.spanCells = spanCells;
        this.setElementIndexes = setElementIndexes;
        this.initialIndex = initialIndex;
        this.xCuts = xCuts;
        this.boxesCache = new HashMap();
        this.layoutGrid();
    }

    protected void layoutGrid() {
        boolean createXCuts;
        boolean bl = createXCuts = this.xCuts == null;
        if (createXCuts) {
            this.xCuts = new SortedList();
            this.xCuts.add(new Integer(0));
        }
        this.yCuts = new SortedList();
        this.yCuts.add(new Integer(0));
        this.createCuts(this.elements, this.offsetX, this.offsetY, createXCuts);
        this.xCuts.add(new Integer(this.width));
        this.yCuts.add(new Integer(this.height));
        int xCellCount = this.xCuts.size() - 1;
        int yCellCount = this.yCuts.size() - 1;
        this.grid = new JRExporterGridCell[yCellCount][xCellCount];
        this.isRowNotEmpty = new boolean[yCellCount];
        this.isColNotEmpty = new boolean[xCellCount];
        for (int j = 0; j < yCellCount; ++j) {
            for (int i = 0; i < xCellCount; ++i) {
                this.grid[j][i] = new JRExporterGridCell(null, null, (Integer)this.xCuts.get(i + 1) - (Integer)this.xCuts.get(i), (Integer)this.yCuts.get(j + 1) - (Integer)this.yCuts.get(j), 1, 1);
            }
        }
        this.setGridElements(this.elements, this.offsetX, this.offsetY, this.initialIndex);
    }

    protected void createCuts(List elementsList, int elementOffsetX, int elementOffsetY, boolean createXCuts) {
        Iterator it = elementsList.iterator();
        while (it.hasNext()) {
            JRPrintElement element = (JRPrintElement)it.next();
            int x0 = element.getX() + elementOffsetX;
            int y0 = element.getY() + elementOffsetY;
            if (this.elementsExporter.isToExport(element)) {
                if (createXCuts) {
                    this.xCuts.add(new Integer(x0));
                    this.xCuts.add(new Integer(x0 + element.getWidth()));
                }
                this.yCuts.add(new Integer(y0));
                this.yCuts.add(new Integer(y0 + element.getHeight()));
            }
            if (!this.deep || !(element instanceof JRPrintFrame)) continue;
            this.createFrameCuts((JRPrintFrame)element, x0, y0, createXCuts);
        }
    }

    protected void createFrameCuts(JRPrintFrame frame, int x0, int y0, boolean createXCuts) {
        int topPadding = frame.getTopPadding();
        int leftPadding = frame.getLeftPadding();
        this.createCuts(frame.getElements(), x0 + leftPadding, y0 + topPadding, createXCuts);
    }

    protected void setGridElements(List elementsList, int elementOffsetX, int elementOffsetY, Integer[] parentIndexes) {
        for (int i = elementsList.size() - 1; i >= 0; --i) {
            int y2;
            int x2;
            int y1;
            JRPrintFrame frame;
            JRPrintElement element = (JRPrintElement)elementsList.get(i);
            boolean toExport = this.elementsExporter.isToExport(element);
            JRPrintFrame jRPrintFrame = frame = this.deep && element instanceof JRPrintFrame ? (JRPrintFrame)element : null;
            if (!toExport && frame == null) continue;
            int x0 = element.getX() + elementOffsetX;
            int y0 = element.getY() + elementOffsetY;
            if (frame != null) {
                this.setFrameGridElements(frame, x0, y0, i, parentIndexes);
            }
            if (!toExport) continue;
            int x1 = this.xCuts.indexOf(new Integer(x0));
            if (!this.isOverlap(x1, y1 = this.yCuts.indexOf(new Integer(y0)), x2 = this.xCuts.indexOf(new Integer(x0 + element.getWidth())), y2 = this.yCuts.indexOf(new Integer(y0 + element.getHeight())))) {
                this.setGridElement(element, x1, y1, x2, y2, i, parentIndexes);
            }
            if (frame == null) continue;
            this.setFrameCellsStyle(frame, x1, x2, y1, y2);
        }
    }

    protected boolean isOverlap(int x1, int y1, int x2, int y2) {
        boolean isOverlap;
        if (this.spanCells) {
            isOverlap = false;
            for (int yi = y1; yi < y2 && !isOverlap; ++yi) {
                for (int xi = x1; xi < x2 && !isOverlap; ++xi) {
                    if (this.grid[yi][xi].element == null) continue;
                    isOverlap = true;
                }
            }
        } else {
            isOverlap = this.grid[y1][x1].element != null;
        }
        return isOverlap;
    }

    protected void setGridElement(JRPrintElement element, int x1, int y1, int x2, int y2, int elementIndex, Integer[] parentElements) {
        if (this.spanCells) {
            for (int yi = y1; yi < y2; ++yi) {
                for (int xi = x1; xi < x2; ++xi) {
                    this.grid[yi][xi] = JRExporterGridCell.OCCUPIED_CELL;
                }
                this.isRowNotEmpty[yi] = true;
            }
            for (int xi = x1; xi < x2; ++xi) {
                this.isColNotEmpty[xi] = true;
            }
        } else {
            this.isRowNotEmpty[y1] = true;
            this.isColNotEmpty[x1] = true;
        }
        if (x2 - x1 != 0 && y2 - y1 != 0) {
            this.grid[y1][x1] = new JRExporterGridCell(element, this.getElementIndex(elementIndex, parentElements), element.getWidth(), element.getHeight(), x2 - x1, y2 - y1);
            JRBox cellBox = null;
            if (element instanceof JRBox) {
                cellBox = (JRBox)((Object)element);
            }
            this.grid[y1][x1].setBox(cellBox);
        }
    }

    protected Integer[] getElementIndex(int elementIndex, Integer[] parentElements) {
        Integer[] elementIndexes;
        if (!this.setElementIndexes) {
            return null;
        }
        if (parentElements == null) {
            elementIndexes = new Integer[]{new Integer(elementIndex)};
        } else {
            elementIndexes = new Integer[parentElements.length + 1];
            System.arraycopy(parentElements, 0, elementIndexes, 0, parentElements.length);
            elementIndexes[parentElements.length] = new Integer(elementIndex);
        }
        return elementIndexes;
    }

    protected void setFrameGridElements(JRPrintFrame frame, int x0, int y0, int elementIndex, Integer[] parentIndexes) {
        int topPadding = frame.getTopPadding();
        int leftPadding = frame.getLeftPadding();
        this.setGridElements(frame.getElements(), x0 + leftPadding, y0 + topPadding, this.getElementIndex(elementIndex, parentIndexes));
    }

    protected void setFrameCellsStyle(JRPrintFrame frame, int x1, int x2, int y1, int y2) {
        Color backcolor = frame.getMode() == 1 ? frame.getBackcolor() : null;
        for (int yi = y1; yi < y2; ++yi) {
            for (int xi = x1; xi < x2; ++xi) {
                boolean bottom;
                JRExporterGridCell cell = this.grid[yi][xi];
                if (cell.getBackcolor() == null && frame.getMode() == 1) {
                    cell.setBackcolor(backcolor);
                }
                if (cell.getForecolor() == null) {
                    cell.setForecolor(frame.getForecolor());
                }
                boolean left = xi == x1;
                boolean right = xi == x2 - cell.colSpan;
                boolean top = yi == y1;
                boolean bl = bottom = yi == y2 - cell.rowSpan;
                if (!left && !right && !top && !bottom) continue;
                JRBox cellBox = cell.getBox();
                BoxKey key = new BoxKey(frame, cellBox, left, right, top, bottom);
                JRBox modBox = (JRBox)this.boxesCache.get(key);
                if (modBox == null) {
                    modBox = new JRBaseBox(frame, left, right, top, bottom, cellBox);
                    this.boxesCache.put(key, modBox);
                }
                cell.setBox(modBox);
            }
        }
    }

    public JRExporterGridCell[][] getGrid() {
        return this.grid;
    }

    public boolean[] getIsRowNotEmpty() {
        return this.isRowNotEmpty;
    }

    public boolean isRowNotEmpty(int rowIdx) {
        return this.isRowNotEmpty[rowIdx];
    }

    public boolean[] getIsColumnNotEmpty() {
        return this.isColNotEmpty;
    }

    public List getXCuts() {
        return this.xCuts;
    }

    public List getYCuts() {
        return this.yCuts;
    }

    public int getWidth() {
        return this.width;
    }

    public static int getRowHeight(JRExporterGridCell[][] grid, int rowIdx) {
        return JRGridLayout.getRowHeight(grid[rowIdx]);
    }

    public static int getRowHeight(JRExporterGridCell[] row) {
        int col;
        if (row[0].rowSpan == 1 && row[0] != JRExporterGridCell.OCCUPIED_CELL) {
            return row[0].height;
        }
        int rowHeight = 0;
        int minSpanIdx = 0;
        int colCount = row.length;
        for (col = 0; col < colCount; ++col) {
            JRExporterGridCell cell = row[col];
            if (cell == JRExporterGridCell.OCCUPIED_CELL) continue;
            if (cell.rowSpan == 1) {
                rowHeight = cell.height;
                break;
            }
            if (cell.rowSpan >= row[minSpanIdx].rowSpan) continue;
            minSpanIdx = col;
        }
        if (col >= colCount) {
            rowHeight = row[minSpanIdx].height;
        }
        return rowHeight;
    }

    public static List calculateXCuts(List pages, int startPageIndex, int endPageIndex, int offsetX, ExporterElements elementsExporter) {
        SortedList xCuts = new SortedList();
        for (int pageIndex = startPageIndex; pageIndex <= endPageIndex; ++pageIndex) {
            JRPrintPage page = (JRPrintPage)pages.get(pageIndex);
            JRGridLayout.addXCuts(page.getElements(), offsetX, elementsExporter, xCuts);
        }
        return xCuts;
    }

    protected static void addXCuts(List elementsList, int elementOffsetX, ExporterElements elementsExporter, List xCuts) {
        Iterator it = elementsList.iterator();
        while (it.hasNext()) {
            JRPrintElement element = (JRPrintElement)it.next();
            int x0 = element.getX() + elementOffsetX;
            if (elementsExporter.isToExport(element)) {
                xCuts.add(new Integer(x0));
                xCuts.add(new Integer(x0 + element.getWidth()));
            }
            if (!(element instanceof JRPrintFrame)) continue;
            JRPrintFrame frame = (JRPrintFrame)element;
            JRGridLayout.addXCuts(frame.getElements(), x0 + frame.getLeftPadding(), elementsExporter, xCuts);
        }
    }

    protected static class BoxKey {
        final JRBox box;
        final JRBox cellBox;
        final boolean left;
        final boolean right;
        final boolean top;
        final boolean bottom;
        final int hashCode;

        BoxKey(JRBox box, JRBox cellBox, boolean left, boolean right, boolean top, boolean bottom) {
            this.box = box;
            this.cellBox = cellBox;
            this.left = left;
            this.right = right;
            this.top = top;
            this.bottom = bottom;
            int hash = box.hashCode();
            if (cellBox != null) {
                hash = 31 * hash + cellBox.hashCode();
            }
            hash = 31 * hash + (left ? 1231 : 1237);
            hash = 31 * hash + (right ? 1231 : 1237);
            hash = 31 * hash + (top ? 1231 : 1237);
            this.hashCode = hash = 31 * hash + (bottom ? 1231 : 1237);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            BoxKey b = (BoxKey)obj;
            return b.box.equals(this.box) && (b.cellBox == null ? this.cellBox == null : this.cellBox != null && b.cellBox.equals(this.cellBox)) && b.left == this.left && b.right == this.right && b.top == this.top && b.bottom == this.bottom;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    protected static class SortedList
    extends ArrayList {
        private static final long serialVersionUID = 6232843428269907513L;

        protected SortedList() {
        }

        public boolean add(Object o) {
            int idx = Collections.binarySearch(this, o);
            if (idx >= 0) {
                return false;
            }
            this.add(-idx - 1, o);
            return true;
        }

        public int indexOf(Object o) {
            int idx = Collections.binarySearch(this, o);
            if (idx < 0) {
                idx = -1;
            }
            return idx;
        }
    }

    public static interface ExporterElements {
        public boolean isToExport(JRPrintElement var1);
    }
}

