/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;

class MethodVerifier15
extends MethodVerifier {
    MethodVerifier15(LookupEnvironment environment) {
        super(environment);
    }

    boolean areMethodsEqual(MethodBinding one, MethodBinding substituteTwo) {
        return this.areParametersEqual(one, substituteTwo) && !this.doTypeVariablesClash(one, substituteTwo);
    }

    boolean areParametersEqual(MethodBinding one, MethodBinding two) {
        TypeBinding[] oneArgs = one.parameters;
        TypeBinding[] twoArgs = two.parameters;
        if (oneArgs == twoArgs) {
            return true;
        }
        int length = oneArgs.length;
        if (length != twoArgs.length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (!(this.areTypesEqual(oneArgs[i], twoArgs[i]) || !one.declaringClass.isInterface() && oneArgs[i].leafComponentType().isRawType() && oneArgs[i].dimensions() == twoArgs[i].dimensions() && oneArgs[i].leafComponentType().isEquivalentTo(twoArgs[i].leafComponentType()))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean areReturnTypesEqual(MethodBinding one, MethodBinding substituteTwo) {
        if (one.returnType == substituteTwo.returnType) {
            return true;
        }
        if (one.returnType.isBaseType()) {
            return false;
        }
        if (!one.declaringClass.isInterface()) {
            if (one.declaringClass.id == 1) {
                return substituteTwo.returnType.isCompatibleWith(one.returnType);
            }
            return one.returnType.isCompatibleWith(substituteTwo.returnType);
        }
        if (substituteTwo.declaringClass.id == 1) {
            return one.returnType.isCompatibleWith(substituteTwo.returnType);
        }
        if (one.declaringClass.implementsInterface(substituteTwo.declaringClass, true)) {
            return one.returnType.isCompatibleWith(substituteTwo.returnType);
        }
        if (substituteTwo.declaringClass.implementsInterface(one.declaringClass, true)) {
            return substituteTwo.returnType.isCompatibleWith(one.returnType);
        }
        return one.returnType.isCompatibleWith(substituteTwo.returnType) || substituteTwo.returnType.isCompatibleWith(one.returnType);
    }

    boolean areTypesEqual(TypeBinding one, TypeBinding two) {
        if (one == two) {
            return true;
        }
        if (one.isParameterizedType() && two.isParameterizedType()) {
            return one.isEquivalentTo(two) && two.isEquivalentTo(one);
        }
        return false;
    }

    boolean areTypeVariablesInterchangeable(MethodBinding one, MethodBinding two) {
        TypeVariableBinding[] vars = one.typeVariables;
        TypeVariableBinding[] vars2 = two.typeVariables;
        if (vars.length != vars2.length) {
            return false;
        }
        int v = vars.length;
        while (--v >= 0) {
            if (vars[v].isInterchangeableWith(this.environment, vars2[v])) continue;
            return false;
        }
        return true;
    }

    boolean canSkipInheritedMethods() {
        if (this.type.superclass() != null && (this.type.superclass().isAbstract() || this.type.superclass().isParameterizedType())) {
            return false;
        }
        return this.type.superInterfaces() == NoSuperInterfaces;
    }

    boolean canSkipInheritedMethods(MethodBinding one, MethodBinding two) {
        return two == null || one.declaringClass == two.declaringClass && !one.declaringClass.isParameterizedType();
    }

    void checkConcreteInheritedMethod(MethodBinding concreteMethod, MethodBinding[] abstractMethods) {
        super.checkConcreteInheritedMethod(concreteMethod, abstractMethods);
        int i = 0;
        int l = abstractMethods.length;
        while (i < l) {
            MethodBinding abstractMethod = abstractMethods[i];
            if (concreteMethod.isVarargs() != abstractMethod.isVarargs()) {
                this.problemReporter().varargsConflict(concreteMethod, abstractMethod, this.type);
            }
            MethodBinding originalInherited = abstractMethod.original();
            if (originalInherited.returnType != concreteMethod.returnType) {
                TypeBinding currentReturnType;
                if (abstractMethod.returnType.leafComponentType().isParameterizedType()) {
                    if (concreteMethod.returnType.leafComponentType().isRawType()) {
                        this.problemReporter().unsafeReturnTypeOverride(concreteMethod, originalInherited, this.type);
                    }
                } else if (abstractMethod.hasSubstitutedReturnType() && originalInherited.returnType.leafComponentType().isTypeVariable() && ((TypeVariableBinding)originalInherited.returnType.leafComponentType()).declaringElement == originalInherited && (!(currentReturnType = concreteMethod.returnType.leafComponentType()).isTypeVariable() || ((TypeVariableBinding)currentReturnType).declaringElement != concreteMethod)) {
                    this.problemReporter().unsafeReturnTypeOverride(concreteMethod, originalInherited, this.type);
                }
            }
            this.type.addSyntheticBridgeMethod(originalInherited, concreteMethod.original());
            ++i;
        }
    }

    void checkForBridgeMethod(MethodBinding currentMethod, MethodBinding inheritedMethod, MethodBinding[] otherInheritedMethods) {
        if (currentMethod.isVarargs() != inheritedMethod.isVarargs()) {
            this.problemReporter(currentMethod).varargsConflict(currentMethod, inheritedMethod, this.type);
        }
        MethodBinding originalInherited = inheritedMethod.original();
        if (originalInherited.returnType != currentMethod.returnType) {
            TypeBinding currentReturnType;
            if (inheritedMethod.returnType.leafComponentType().isParameterizedType()) {
                if (currentMethod.returnType.leafComponentType().isRawType()) {
                    this.problemReporter(currentMethod).unsafeReturnTypeOverride(currentMethod, originalInherited, this.type);
                }
            } else if (inheritedMethod.hasSubstitutedReturnType() && originalInherited.returnType.leafComponentType().isTypeVariable() && ((TypeVariableBinding)originalInherited.returnType.leafComponentType()).declaringElement == originalInherited && (!(currentReturnType = currentMethod.returnType.leafComponentType()).isTypeVariable() || ((TypeVariableBinding)currentReturnType).declaringElement != currentMethod)) {
                this.problemReporter(currentMethod).unsafeReturnTypeOverride(currentMethod, originalInherited, this.type);
            }
        }
        if (this.type.addSyntheticBridgeMethod(originalInherited, currentMethod.original()) != null) {
            int i = 0;
            int l = otherInheritedMethods.length;
            while (i < l) {
                MethodBinding otherOriginal;
                if (otherInheritedMethods[i] != null && (otherOriginal = otherInheritedMethods[i].original()) != otherInheritedMethods[i] && this.detectInheritedMethodClash(originalInherited, otherOriginal)) {
                    return;
                }
                ++i;
            }
            MethodBinding[] toCheck = (MethodBinding[])this.currentMethods.get(currentMethod.selector);
            int i2 = 0;
            int l2 = toCheck.length;
            while (i2 < l2) {
                if (currentMethod != toCheck[i2] && this.detectNameClash(toCheck[i2], inheritedMethod)) {
                    return;
                }
                ++i2;
            }
        }
    }

    void checkForInheritedNameClash(MethodBinding inheritedMethod, MethodBinding otherInheritedMethod) {
        if (!inheritedMethod.declaringClass.isInterface()) {
            this.detectInheritedMethodClash(inheritedMethod, otherInheritedMethod);
        }
    }

    void checkForNameClash(MethodBinding currentMethod, MethodBinding inheritedMethod) {
        if (currentMethod.declaringClass.isInterface()) {
            return;
        }
        if (!this.detectNameClash(currentMethod, inheritedMethod)) {
            TypeBinding[] currentParams = currentMethod.parameters;
            int length = currentParams.length;
            TypeBinding[] inheritedParams = inheritedMethod.parameters;
            if (length != inheritedParams.length) {
                return;
            }
            int i = 0;
            while (i < length) {
                if (!(currentParams[i] == inheritedParams[i] || currentParams[i].isBaseType() == inheritedParams[i].isBaseType() && inheritedParams[i].isCompatibleWith(currentParams[i]))) {
                    return;
                }
                ++i;
            }
            ReferenceBinding[][] interfacesToVisit = new ReferenceBinding[3][];
            int lastPosition = -1;
            ReferenceBinding[] itsInterfaces = null;
            ReferenceBinding superType = this.type.superclass;
            while (superType != null && superType.isValidBinding()) {
                MethodBinding[] methods = superType.getMethods(currentMethod.selector);
                int m = 0;
                int n = methods.length;
                while (m < n) {
                    if (!this.areMethodsEqual(currentMethod, methods[m]) && this.detectNameClash(currentMethod, methods[m])) {
                        return;
                    }
                    ++m;
                }
                itsInterfaces = superType.superInterfaces();
                if (itsInterfaces != NoSuperInterfaces) {
                    if (++lastPosition == interfacesToVisit.length) {
                        ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                        interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                        System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                    }
                    interfacesToVisit[lastPosition] = itsInterfaces;
                }
                superType = superType.superclass();
            }
            int i2 = 0;
            while (i2 <= lastPosition) {
                ReferenceBinding[] interfaces = interfacesToVisit[i2];
                int j = 0;
                int l = interfaces.length;
                while (j < l) {
                    superType = interfaces[j];
                    if (superType.isValidBinding()) {
                        MethodBinding[] methods = superType.getMethods(currentMethod.selector);
                        int m = 0;
                        int n = methods.length;
                        while (m < n) {
                            if (!this.areMethodsEqual(currentMethod, methods[m]) && this.detectNameClash(currentMethod, methods[m])) {
                                return;
                            }
                            ++m;
                        }
                        itsInterfaces = superType.superInterfaces();
                        if (itsInterfaces != NoSuperInterfaces) {
                            if (++lastPosition == interfacesToVisit.length) {
                                ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                                interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                            }
                            interfacesToVisit[lastPosition] = itsInterfaces;
                        }
                    }
                    ++j;
                }
                ++i2;
            }
        }
    }

    void checkInheritedMethods(MethodBinding[] methods, int length) {
        int count = length;
        int i = 0;
        int l = length - 1;
        block0: while (i < l) {
            MethodBinding method = methods[i++];
            int j = i;
            while (j <= l) {
                if (method.declaringClass == methods[j].declaringClass && this.doesMethodOverride(method, methods[j])) {
                    this.problemReporter().duplicateInheritedMethods(this.type, method, methods[j]);
                    --count;
                    methods[i - 1] = null;
                    continue block0;
                }
                ++j;
            }
        }
        if (count < length) {
            if (count == 1) {
                return;
            }
            MethodBinding[] newMethods = new MethodBinding[count];
            int i2 = length;
            while (--i2 >= 0) {
                if (methods[i2] == null) continue;
                newMethods[--count] = methods[i2];
            }
            methods = newMethods;
            length = newMethods.length;
        }
        super.checkInheritedMethods(methods, length);
    }

    /*
     * Unable to fully structure code
     */
    void checkTypeVariableMethods() {
        methodSelectors = this.inheritedMethods.keyTable;
        s = methodSelectors.length;
        while (--s >= 0) {
            if (methodSelectors[s] == null || (inherited = (MethodBinding[])this.inheritedMethods.valueTable[s]).length == 1) continue;
            index = -1;
            matchingInherited = new MethodBinding[inherited.length];
            i = 0;
            length = inherited.length;
            ** GOTO lbl27
            {
                matchingInherited[index--] = null;
                do {
                    if (index >= 0) continue block1;
                    inheritedMethod = inherited[i];
                    if (inheritedMethod != null) {
                        matchingInherited[++index] = inheritedMethod;
                        j = i + 1;
                        while (j < length) {
                            otherInheritedMethod = inherited[j];
                            if (!this.canSkipInheritedMethods(inheritedMethod, otherInheritedMethod) && (otherInheritedMethod = this.computeSubstituteMethod(otherInheritedMethod, inheritedMethod)) != null && this.areMethodsEqual(inheritedMethod, otherInheritedMethod)) {
                                matchingInherited[++index] = otherInheritedMethod;
                                inherited[j] = null;
                            }
                            ++j;
                        }
                    }
                    if (index > 0) {
                        this.checkInheritedMethods(matchingInherited, index + 1);
                    }
                    ++i;
lbl27:
                    // 2 sources

                } while (i < length);
            }
        }
    }

    MethodBinding computeSubstituteMethod(MethodBinding inheritedMethod, MethodBinding currentMethod) {
        TypeVariableBinding[] inheritedTypeVariables;
        if (inheritedMethod == null) {
            return null;
        }
        if (currentMethod.parameters.length != inheritedMethod.parameters.length) {
            return null;
        }
        if (currentMethod.declaringClass instanceof BinaryTypeBinding) {
            ((BinaryTypeBinding)currentMethod.declaringClass).resolveTypesFor(currentMethod);
        }
        if (inheritedMethod.declaringClass instanceof BinaryTypeBinding) {
            ((BinaryTypeBinding)inheritedMethod.declaringClass).resolveTypesFor(inheritedMethod);
        }
        if ((inheritedTypeVariables = inheritedMethod.typeVariables) == NoTypeVariables) {
            return inheritedMethod;
        }
        int inheritedLength = inheritedTypeVariables.length;
        TypeVariableBinding[] typeVariables = currentMethod.typeVariables;
        int length = typeVariables.length;
        TypeBinding[] arguments = new TypeBinding[inheritedLength];
        if (inheritedLength <= length) {
            System.arraycopy(typeVariables, 0, arguments, 0, inheritedLength);
        } else {
            System.arraycopy(typeVariables, 0, arguments, 0, length);
            int i = length;
            while (i < inheritedLength) {
                arguments[i] = inheritedTypeVariables[i].upperBound();
                ++i;
            }
        }
        ParameterizedGenericMethodBinding substitute = new ParameterizedGenericMethodBinding(inheritedMethod, arguments, this.environment);
        int i = 0;
        while (i < inheritedLength) {
            if (inheritedTypeVariables[i].boundCheck(substitute, arguments[i]) != 0) {
                return inheritedMethod;
            }
            ++i;
        }
        return substitute;
    }

    boolean detectInheritedMethodClash(MethodBinding inherited, MethodBinding otherInherited) {
        if (!inherited.areParameterErasuresEqual(otherInherited) || inherited.returnType.erasure() != otherInherited.returnType.erasure()) {
            return false;
        }
        if (this.doTypeVariablesClash(inherited, otherInherited) || this.doParametersClash(inherited, otherInherited)) {
            this.problemReporter().inheritedMethodsHaveNameClash(this.type, inherited, otherInherited);
            return true;
        }
        return false;
    }

    boolean detectNameClash(MethodBinding current, MethodBinding inherited) {
        MethodBinding original = inherited.original();
        if (!current.areParameterErasuresEqual(original) || current.returnType.erasure() != original.returnType.erasure()) {
            return false;
        }
        if (this.doTypeVariablesClash(current, inherited) || this.doParametersClash(current, original)) {
            this.problemReporter(current).methodNameClash(current, original);
            return true;
        }
        return false;
    }

    public boolean doesMethodOverride(MethodBinding one, MethodBinding two) {
        MethodBinding sub = this.computeSubstituteMethod(two, one);
        return sub != null && super.doesMethodOverride(one, sub);
    }

    boolean doParametersClash(MethodBinding one, MethodBinding substituteTwo) {
        TypeBinding[] oneParams = one.parameters;
        TypeBinding[] twoParams = substituteTwo.parameters;
        int i = 0;
        int l = oneParams.length;
        while (i < l) {
            if (oneParams[i] != twoParams[i]) {
                switch (oneParams[i].leafComponentType().kind()) {
                    case 260: {
                        if (twoParams[i].leafComponentType().isParameterizedType() && oneParams[i].isEquivalentTo(twoParams[i]) && twoParams[i].isEquivalentTo(oneParams[i])) break;
                        return true;
                    }
                    case 4100: {
                        return true;
                    }
                }
                if (twoParams[i].leafComponentType().isTypeVariable()) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    boolean doTypeVariablesClash(MethodBinding one, MethodBinding substituteTwo) {
        if (one.typeVariables == NoTypeVariables) {
            return false;
        }
        MethodBinding subTwo = substituteTwo instanceof ParameterizedGenericMethodBinding ? ((ParameterizedGenericMethodBinding)substituteTwo).originalMethod : substituteTwo;
        return !one.areTypeVariableErasuresEqual(subTwo);
    }

    boolean isInterfaceMethodImplemented(MethodBinding inheritedMethod, MethodBinding existingMethod, ReferenceBinding superType) {
        if (inheritedMethod.original() != inheritedMethod && existingMethod.declaringClass.isInterface()) {
            return false;
        }
        return (inheritedMethod = this.computeSubstituteMethod(inheritedMethod, existingMethod)) != null && inheritedMethod.returnType == existingMethod.returnType && super.isInterfaceMethodImplemented(inheritedMethod, existingMethod, superType);
    }

    void verify(SourceTypeBinding someType) {
        if (someType.isAnnotationType()) {
            someType.detectAnnotationCycle();
        }
        super.verify(someType);
        int i = someType.typeVariables.length;
        while (--i >= 0) {
            TypeVariableBinding var = someType.typeVariables[i];
            if (var.superInterfaces == NoSuperInterfaces || var.superInterfaces.length == 1 && var.superclass.id == 1) continue;
            this.currentMethods = new HashtableOfObject(0);
            ReferenceBinding superclass = var.superclass();
            if (superclass.kind() == 4100) {
                superclass = (ReferenceBinding)superclass.erasure();
            }
            ReferenceBinding[] itsInterfaces = var.superInterfaces();
            ReferenceBinding[] superInterfaces = new ReferenceBinding[itsInterfaces.length];
            int j = itsInterfaces.length;
            while (--j >= 0) {
                ReferenceBinding referenceBinding = superInterfaces[j] = itsInterfaces[j].kind() == 4100 ? (ReferenceBinding)itsInterfaces[j].erasure() : itsInterfaces[j];
            }
            this.computeInheritedMethods(superclass, superInterfaces);
            this.checkTypeVariableMethods();
        }
    }
}

