/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.chart;

import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.chart.ChartDatasetPanel;
import it.businesslogic.ireport.chart.PieDataset;
import it.businesslogic.ireport.chart.gui.SectionItemHyperlinkPanel;
import it.businesslogic.ireport.gui.JRTextExpressionArea;
import it.businesslogic.ireport.util.I18n;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PieDatasetPanel
extends JPanel
implements ChartDatasetPanel {
    private PieDataset pieDataset = null;
    private JLabel jLabelKeyExpression;
    private JLabel jLabelLabelExpression;
    private JLabel jLabelValueExpression;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JRTextExpressionArea jRTextExpressionKey;
    private JRTextExpressionArea jRTextExpressionLabel;
    private JRTextExpressionArea jRTextExpressionValue;
    private JTabbedPane jTabbedPane1;
    private SectionItemHyperlinkPanel sectionItemHyperlinkPanel1;

    public PieDatasetPanel() {
        this.initComponents();
        this.applyI18n();
        this.jRTextExpressionKey.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                PieDatasetPanel.this.jRTextExpressionKeyTextChanged();
            }

            public void insertUpdate(DocumentEvent evt) {
                PieDatasetPanel.this.jRTextExpressionKeyTextChanged();
            }

            public void removeUpdate(DocumentEvent evt) {
                PieDatasetPanel.this.jRTextExpressionKeyTextChanged();
            }
        });
        this.jRTextExpressionValue.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                PieDatasetPanel.this.jRTextExpressionValueTextChanged();
            }

            public void insertUpdate(DocumentEvent evt) {
                PieDatasetPanel.this.jRTextExpressionValueTextChanged();
            }

            public void removeUpdate(DocumentEvent evt) {
                PieDatasetPanel.this.jRTextExpressionValueTextChanged();
            }
        });
        this.jRTextExpressionLabel.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                PieDatasetPanel.this.jRTextExpressionLabelTextChanged();
            }

            public void insertUpdate(DocumentEvent evt) {
                PieDatasetPanel.this.jRTextExpressionLabelTextChanged();
            }

            public void removeUpdate(DocumentEvent evt) {
                PieDatasetPanel.this.jRTextExpressionLabelTextChanged();
            }
        });
    }

    public PieDataset getPieDataset() {
        return this.pieDataset;
    }

    public void setSubDataset(SubDataset sds) {
        this.jRTextExpressionKey.setSubDataset(sds);
        this.jRTextExpressionValue.setSubDataset(sds);
        this.jRTextExpressionLabel.setSubDataset(sds);
        this.sectionItemHyperlinkPanel1.setSubDataset(sds);
    }

    public void setPieDataset(PieDataset pieDataset) {
        this.pieDataset = pieDataset;
        this.jRTextExpressionKey.setText(pieDataset.getKeyExpression());
        this.jRTextExpressionValue.setText(pieDataset.getValueExpression());
        this.jRTextExpressionLabel.setText(pieDataset.getLabelExpression());
        this.sectionItemHyperlinkPanel1.setSectionItemHyperlink(pieDataset.getSectionHyperLink());
    }

    public void jRTextExpressionKeyTextChanged() {
        this.pieDataset.setKeyExpression(this.jRTextExpressionKey.getText());
    }

    public void jRTextExpressionValueTextChanged() {
        this.pieDataset.setValueExpression(this.jRTextExpressionValue.getText());
    }

    public void jRTextExpressionLabelTextChanged() {
        this.pieDataset.setLabelExpression(this.jRTextExpressionLabel.getText());
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jLabelKeyExpression = new JLabel();
        this.jRTextExpressionKey = new JRTextExpressionArea();
        this.jLabelValueExpression = new JLabel();
        this.jRTextExpressionValue = new JRTextExpressionArea();
        this.jLabelLabelExpression = new JLabel();
        this.jRTextExpressionLabel = new JRTextExpressionArea();
        this.jPanel2 = new JPanel();
        this.sectionItemHyperlinkPanel1 = new SectionItemHyperlinkPanel();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabelKeyExpression.setText("Key expression");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jLabelKeyExpression, gridBagConstraints);
        this.jRTextExpressionKey.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionKey.setElectricScroll(0);
        this.jRTextExpressionKey.setMinimumSize(new Dimension(10, 10));
        this.jRTextExpressionKey.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jRTextExpressionKey, gridBagConstraints);
        this.jLabelValueExpression.setText("Value expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabelValueExpression, gridBagConstraints);
        this.jRTextExpressionValue.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionValue.setElectricScroll(0);
        this.jRTextExpressionValue.setMinimumSize(new Dimension(10, 10));
        this.jRTextExpressionValue.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jRTextExpressionValue, gridBagConstraints);
        this.jLabelLabelExpression.setText("Label expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabelLabelExpression, gridBagConstraints);
        this.jRTextExpressionLabel.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionLabel.setElectricScroll(0);
        this.jRTextExpressionLabel.setMinimumSize(new Dimension(10, 10));
        this.jRTextExpressionLabel.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jRTextExpressionLabel, gridBagConstraints);
        this.jTabbedPane1.addTab("Section value", this.jPanel1);
        this.jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.sectionItemHyperlinkPanel1, gridBagConstraints);
        this.jTabbedPane1.addTab("Section hyperlink", this.jPanel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jTabbedPane1, gridBagConstraints);
    }

    public void applyI18n() {
        this.jLabelKeyExpression.setText(I18n.getString("pieDatasetPanel.labelKeyExpression", "Key expression"));
        this.jLabelLabelExpression.setText(I18n.getString("pieDatasetPanel.labelLabelExpression", "Label expression"));
        this.jLabelValueExpression.setText(I18n.getString("pieDatasetPanel.labelValueExpression", "Value expression"));
        this.jTabbedPane1.setTitleAt(0, I18n.getString("chartSeries.tab.SectionValue", "Section value"));
        this.jTabbedPane1.setTitleAt(1, I18n.getString("chartSeries.tab.SectionHyperlink", "Section hyperlink"));
    }
}

