/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.chart;

import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.chart.ChartDatasetPanel;
import it.businesslogic.ireport.chart.TimeSeries;
import it.businesslogic.ireport.chart.TimeSeriesDataset;
import it.businesslogic.ireport.chart.TimeSeriesDialog;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.sheet.Tag;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TimeSeriesDatasetPanel
extends JPanel
implements ChartDatasetPanel {
    private TimeSeriesDataset timeSeriesDataset = null;
    private boolean init = false;
    private SubDataset subDataset = null;
    private JButton jButtonAdd;
    private JButton jButtonModify;
    private JButton jButtonRemove;
    private JComboBox jComboBoxPeriod;
    private JLabel jLabel1;
    private JLabel jLabelPeriod;
    private JList jList1;
    private JMenuItem jMenuItemCopy;
    private JMenuItem jMenuItemPaste;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanelPeriod;
    private JPopupMenu jPopupMenuSeries;
    private JScrollPane jScrollPane1;

    public TimeSeriesDatasetPanel() {
        this.initComponents();
        this.applyI18n();
        this.jComboBoxPeriod.addItem(new Tag("Year", I18n.getString("charts.timePeriod.Year", "Year")));
        this.jComboBoxPeriod.addItem(new Tag("Quarter", I18n.getString("charts.timePeriod.Quarter", "Quarter")));
        this.jComboBoxPeriod.addItem(new Tag("Month", I18n.getString("charts.timePeriod.Month", "Month")));
        this.jComboBoxPeriod.addItem(new Tag("Week", I18n.getString("charts.timePeriod.Week", "Week")));
        this.jComboBoxPeriod.addItem(new Tag("Day", I18n.getString("charts.timePeriod.Day", "Day")));
        this.jComboBoxPeriod.addItem(new Tag("Hour", I18n.getString("charts.timePeriod.Hour", "Hour")));
        this.jComboBoxPeriod.addItem(new Tag("Minute", I18n.getString("charts.timePeriod.Minute", "Minute")));
        this.jComboBoxPeriod.addItem(new Tag("Second", I18n.getString("charts.timePeriod.Second", "Second")));
        this.jComboBoxPeriod.addItem(new Tag("Milisecond", I18n.getString("charts.timePeriod.Milisecond", "Milisecond")));
        this.jList1.setModel(new DefaultListModel());
    }

    public void setTimeSeriesDataset(TimeSeriesDataset timeSeriesDataset) {
        this.init = true;
        this.timeSeriesDataset = timeSeriesDataset;
        this.jButtonModify.setEnabled(false);
        this.jButtonModify.setEnabled(false);
        DefaultListModel lm = (DefaultListModel)this.jList1.getModel();
        lm.removeAllElements();
        Vector v = timeSeriesDataset.getTimeSeries();
        for (int i = 0; i < v.size(); ++i) {
            lm.addElement(v.elementAt(i));
        }
        Misc.setComboboxSelectedTagValue(this.jComboBoxPeriod, timeSeriesDataset.getTimePeriod());
        this.init = false;
    }

    public TimeSeriesDataset getTimeSeriesDataset() {
        return this.timeSeriesDataset;
    }

    private void initComponents() {
        this.jPopupMenuSeries = new JPopupMenu();
        this.jMenuItemCopy = new JMenuItem();
        this.jMenuItemPaste = new JMenuItem();
        this.jPanelPeriod = new JPanel();
        this.jLabelPeriod = new JLabel();
        this.jComboBoxPeriod = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jPanel1 = new JPanel();
        this.jButtonAdd = new JButton();
        this.jButtonModify = new JButton();
        this.jButtonRemove = new JButton();
        this.jPanel2 = new JPanel();
        this.jMenuItemCopy.setText("Copy series");
        this.jMenuItemCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TimeSeriesDatasetPanel.this.jMenuItemCopyActionPerformed(evt);
            }
        });
        this.jPopupMenuSeries.add(this.jMenuItemCopy);
        this.jMenuItemPaste.setText("Paste series");
        this.jMenuItemPaste.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TimeSeriesDatasetPanel.this.jMenuItemPasteActionPerformed(evt);
            }
        });
        this.jPopupMenuSeries.add(this.jMenuItemPaste);
        this.setLayout(new GridBagLayout());
        this.jPanelPeriod.setLayout(new GridBagLayout());
        this.jLabelPeriod.setText("Time period");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelPeriod.add((Component)this.jLabelPeriod, gridBagConstraints);
        this.jComboBoxPeriod.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TimeSeriesDatasetPanel.this.jComboBoxPeriodActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanelPeriod.add((Component)this.jComboBoxPeriod, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanelPeriod, gridBagConstraints);
        this.jLabel1.setText("Time series");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                TimeSeriesDatasetPanel.this.jList1ValueChanged(evt);
            }
        });
        this.jList1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                TimeSeriesDatasetPanel.this.jList1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setMinimumSize(new Dimension(100, 0));
        this.jPanel1.setPreferredSize(new Dimension(100, 0));
        this.jButtonAdd.setText("Add");
        this.jButtonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TimeSeriesDatasetPanel.this.jButtonAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 4);
        this.jPanel1.add((Component)this.jButtonAdd, gridBagConstraints);
        this.jButtonModify.setText("Modify");
        this.jButtonModify.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TimeSeriesDatasetPanel.this.jButtonModifyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 4);
        this.jPanel1.add((Component)this.jButtonModify, gridBagConstraints);
        this.jButtonRemove.setText("Remove");
        this.jButtonRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TimeSeriesDatasetPanel.this.jButtonRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 4);
        this.jPanel1.add((Component)this.jButtonRemove, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 99;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void jList1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 1) {
            if (evt.getButton() == 3) {
                this.jMenuItemCopy.setEnabled(this.jList1.getSelectedIndex() >= 0);
                this.jMenuItemPaste.setEnabled(MainFrame.getMainInstance().getChartSeriesClipBoard() != null && MainFrame.getMainInstance().getChartSeriesClipBoard().size() > 0);
                this.jPopupMenuSeries.show(this.jList1, evt.getPoint().x, evt.getPoint().y);
                return;
            }
        }
        if (evt.getClickCount() != 2) return;
        if (evt.getButton() != 1) return;
        this.jButtonModifyActionPerformed(null);
    }

    private void jMenuItemPasteActionPerformed(ActionEvent evt) {
        Vector v = MainFrame.getMainInstance().getChartSeriesClipBoard();
        if (v != null && v.size() > 0) {
            for (int i = 0; i < v.size(); ++i) {
                if (!(v.elementAt(i) instanceof TimeSeries)) continue;
                TimeSeries cs = (TimeSeries)v.elementAt(i);
                cs = cs.cloneMe();
                this.getTimeSeriesDataset().getTimeSeries().addElement(cs);
                ((DefaultListModel)this.jList1.getModel()).addElement(cs);
            }
            this.jList1.updateUI();
        }
    }

    private void jMenuItemCopyActionPerformed(ActionEvent evt) {
        Object[] values = this.jList1.getSelectedValues();
        Vector<TimeSeries> copy_c = new Vector<TimeSeries>();
        for (int i = 0; i < values.length; ++i) {
            copy_c.add(((TimeSeries)values[i]).cloneMe());
        }
        MainFrame.getMainInstance().setChartSeriesClipBoard(copy_c);
    }

    private void jComboBoxPeriodActionPerformed(ActionEvent evt) {
        if (this.init || this.timeSeriesDataset == null) {
            return;
        }
        this.timeSeriesDataset.setTimePeriod(((Tag)this.jComboBoxPeriod.getSelectedItem()).getValue() + "");
    }

    private void jButtonModifyActionPerformed(ActionEvent evt) {
        if (this.jList1.getSelectedIndex() >= 0) {
            TimeSeries cs = (TimeSeries)this.jList1.getSelectedValue();
            TimeSeriesDialog csd = new TimeSeriesDialog((Frame)MainFrame.getMainInstance(), true);
            csd.setSeriesExpression(cs.getSeriesExpression());
            csd.setTimePeriodExpression(cs.getTimePeriodExpression());
            csd.setValueExpression(cs.getValueExpression());
            csd.setLabelExpression(cs.getLabelExpression());
            csd.setSectionItemHyperlink(cs.getSectionItemHyperlink());
            csd.setSubDataset(this.getSubDataset());
            csd.setVisible(true);
            if (csd.getDialogResult() == 0) {
                cs.setSeriesExpression(csd.getSeriesExpression());
                cs.setTimePeriodExpression(csd.getTimePeriodExpression());
                cs.setValueExpression(csd.getValueExpression());
                cs.setLabelExpression(csd.getLabelExpression());
                cs.setSectionItemHyperlink(csd.getSectionItemHyperlink());
                this.jList1.updateUI();
            }
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        TimeSeriesDialog csd = new TimeSeriesDialog((Frame)MainFrame.getMainInstance(), true);
        csd.setSubDataset(this.getSubDataset());
        csd.setVisible(true);
        if (csd.getDialogResult() == 0) {
            TimeSeries cs = new TimeSeries();
            cs.setSeriesExpression(csd.getSeriesExpression());
            cs.setTimePeriodExpression(csd.getTimePeriodExpression());
            cs.setValueExpression(csd.getValueExpression());
            cs.setLabelExpression(csd.getLabelExpression());
            cs.setSectionItemHyperlink(csd.getSectionItemHyperlink());
            this.getTimeSeriesDataset().getTimeSeries().addElement(cs);
            ((DefaultListModel)this.jList1.getModel()).addElement(cs);
        }
    }

    private void jButtonRemoveActionPerformed(ActionEvent evt) {
        while (this.jList1.getSelectedIndex() >= 0) {
            this.getTimeSeriesDataset().getTimeSeries().remove(this.jList1.getSelectedValue());
            ((DefaultListModel)this.jList1.getModel()).removeElementAt(this.jList1.getSelectedIndex());
        }
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        if (this.jList1.getSelectedIndex() >= 0) {
            this.jButtonModify.setEnabled(true);
            this.jButtonModify.setEnabled(true);
        } else {
            this.jButtonModify.setEnabled(false);
            this.jButtonModify.setEnabled(false);
        }
    }

    public void applyI18n() {
        this.jLabel1.setText(I18n.getString("timeSeriesDatasetPanel.label1", "Time series"));
        this.jButtonAdd.setText(I18n.getString("charts.newseries", "Add series"));
        this.jButtonModify.setText(I18n.getString("charts.modifyseries", "Modify series"));
        this.jButtonRemove.setText(I18n.getString("charts.removeseries", "Remove series"));
        this.jLabelPeriod.setText(I18n.getString("charts.timePeriod", "Time period"));
        this.jMenuItemCopy.setText(I18n.getString("charts.copyseries", "Copy series"));
        this.jMenuItemPaste.setText(I18n.getString("charts.pasteseries", "Paste series"));
        this.updateUI();
    }

    public SubDataset getSubDataset() {
        return this.subDataset;
    }

    public void setSubDataset(SubDataset subDataset) {
        this.subDataset = subDataset;
    }
}

