/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRResultSetDataSource;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import net.sf.jasperreports.engine.query.JRSqlInClause;
import net.sf.jasperreports.engine.query.JRSqlNotInClause;
import net.sf.jasperreports.engine.util.JRProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRJdbcQueryExecuter
extends JRAbstractQueryExecuter {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$jasperreports$engine$query$JRJdbcQueryExecuter == null ? (class$net$sf$jasperreports$engine$query$JRJdbcQueryExecuter = JRJdbcQueryExecuter.class$("net.sf.jasperreports.engine.query.JRJdbcQueryExecuter")) : class$net$sf$jasperreports$engine$query$JRJdbcQueryExecuter));
    protected static final String CLAUSE_ID_IN = "IN";
    protected static final String CLAUSE_ID_NOTIN = "NOTIN";
    private Connection connection = (Connection)this.getParameterValue("REPORT_CONNECTION");
    private PreparedStatement statement;
    private ResultSet resultSet;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$query$JRJdbcQueryExecuter;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$util$Date;

    public JRJdbcQueryExecuter(JRDataset dataset, Map parameters) {
        super(dataset, parameters);
        if (this.connection == null && log.isWarnEnabled()) {
            log.warn((Object)"The supplied java.sql.Connection object is null.");
        }
        this.registerFunctions();
        this.parseQuery();
    }

    protected void registerFunctions() {
        this.registerClauseFunction(CLAUSE_ID_IN, JRSqlInClause.instance());
        this.registerClauseFunction(CLAUSE_ID_NOTIN, JRSqlNotInClause.instance());
    }

    protected String getParameterReplacement(String parameterName) {
        return "?";
    }

    public JRDataSource createDatasource() throws JRException {
        JRResultSetDataSource dataSource = null;
        this.createStatement();
        if (this.statement != null) {
            try {
                Integer reportMaxCount = (Integer)this.getParameterValue("REPORT_MAX_COUNT");
                if (reportMaxCount != null) {
                    this.statement.setMaxRows(reportMaxCount);
                }
                this.resultSet = this.statement.executeQuery();
                dataSource = new JRResultSetDataSource(this.resultSet);
            }
            catch (SQLException e) {
                throw new JRException("Error executing SQL statement for : " + this.dataset.getName(), e);
            }
        }
        return dataSource;
    }

    private void createStatement() throws JRException {
        String queryString = this.getQueryString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("SQL query string: " + queryString));
        }
        if (this.connection != null && queryString != null && queryString.trim().length() > 0) {
            try {
                List parameterNames;
                this.statement = this.connection.prepareStatement(queryString);
                int fetchSize = JRProperties.getIntegerProperty(this.dataset.getPropertiesMap(), "net.sf.jasperreports.jdbc.fetch.size", 0);
                if (fetchSize > 0) {
                    this.statement.setFetchSize(fetchSize);
                }
                if (!(parameterNames = this.getCollectedParameters()).isEmpty()) {
                    int paramIdx = 1;
                    for (int i = 0; i < parameterNames.size(); ++i) {
                        JRAbstractQueryExecuter.QueryParameter queryParameter = (JRAbstractQueryExecuter.QueryParameter)parameterNames.get(i);
                        if (queryParameter.isMulti()) {
                            paramIdx += this.setStatementMultiParameters(paramIdx, queryParameter.getName());
                            continue;
                        }
                        this.setStatementParameter(paramIdx, queryParameter.getName());
                        ++paramIdx;
                    }
                }
            }
            catch (SQLException e) {
                throw new JRException("Error preparing statement for executing the report query : \n\n" + queryString + "\n\n", e);
            }
        }
    }

    protected void setStatementParameter(int parameterIndex, String parameterName) throws SQLException {
        JRValueParameter parameter = this.getValueParameter(parameterName);
        Class clazz = parameter.getValueClass();
        Object parameterValue = parameter.getValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parameter #" + parameterIndex + " (" + parameterName + " of type " + clazz.getName() + "): " + parameterValue));
        }
        this.setStatementParameter(parameterIndex, clazz, parameterValue);
    }

    protected int setStatementMultiParameters(int parameterIndex, String parameterName) throws SQLException {
        int count;
        Object paramValue = this.getParameterValue(parameterName);
        if (paramValue.getClass().isArray()) {
            int arrayCount = Array.getLength(paramValue);
            for (count = 0; count < arrayCount; ++count) {
                Object value = Array.get(paramValue, count);
                this.setStatementMultiParameter(parameterIndex + count, parameterName, count, value);
            }
        } else if (paramValue instanceof Collection) {
            Collection values = (Collection)paramValue;
            count = 0;
            Iterator it = values.iterator();
            while (it.hasNext()) {
                Object value = it.next();
                this.setStatementMultiParameter(parameterIndex + count, parameterName, count, value);
                ++count;
            }
        } else {
            throw new JRRuntimeException("Multi parameter value is not array nor collection.");
        }
        return count;
    }

    protected void setStatementMultiParameter(int parameterIndex, String parameterName, int valueIndex, Object value) throws SQLException {
        if (value == null) {
            throw new JRRuntimeException("Multi parameters cannot contain null values.");
        }
        Class<?> type = value.getClass();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parameter #" + parameterIndex + " (" + parameterName + "[" + valueIndex + "] of type " + type.getName() + "): " + value));
        }
        this.setStatementParameter(parameterIndex, type, value);
    }

    protected void setStatementParameter(int parameterIndex, Class parameterType, Object parameterValue) throws SQLException {
        if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = JRJdbcQueryExecuter.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, -7);
            } else {
                this.statement.setBoolean(parameterIndex, (Boolean)parameterValue);
            }
        } else if ((class$java$lang$Byte == null ? (class$java$lang$Byte = JRJdbcQueryExecuter.class$("java.lang.Byte")) : class$java$lang$Byte).isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, -6);
            } else {
                this.statement.setByte(parameterIndex, (Byte)parameterValue);
            }
        } else if ((class$java$lang$Double == null ? (class$java$lang$Double = JRJdbcQueryExecuter.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, 8);
            } else {
                this.statement.setDouble(parameterIndex, (Double)parameterValue);
            }
        } else if ((class$java$lang$Float == null ? (class$java$lang$Float = JRJdbcQueryExecuter.class$("java.lang.Float")) : class$java$lang$Float).isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, 6);
            } else {
                this.statement.setFloat(parameterIndex, ((Float)parameterValue).floatValue());
            }
        } else if ((class$java$lang$Integer == null ? (class$java$lang$Integer = JRJdbcQueryExecuter.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, 4);
            } else {
                this.statement.setInt(parameterIndex, (Integer)parameterValue);
            }
        } else if ((class$java$lang$Long == null ? (class$java$lang$Long = JRJdbcQueryExecuter.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, -5);
            } else {
                this.statement.setLong(parameterIndex, (Long)parameterValue);
            }
        } else if ((class$java$lang$Short == null ? (class$java$lang$Short = JRJdbcQueryExecuter.class$("java.lang.Short")) : class$java$lang$Short).isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, 5);
            } else {
                this.statement.setShort(parameterIndex, (Short)parameterValue);
            }
        } else if ((class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JRJdbcQueryExecuter.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, 3);
            } else {
                this.statement.setBigDecimal(parameterIndex, (BigDecimal)parameterValue);
            }
        } else if ((class$java$lang$String == null ? (class$java$lang$String = JRJdbcQueryExecuter.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, 12);
            } else {
                this.statement.setString(parameterIndex, parameterValue.toString());
            }
        } else if ((class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = JRJdbcQueryExecuter.class$("java.sql.Timestamp")) : class$java$sql$Timestamp).isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, 93);
            } else {
                this.statement.setTimestamp(parameterIndex, (Timestamp)parameterValue);
            }
        } else if ((class$java$sql$Time == null ? (class$java$sql$Time = JRJdbcQueryExecuter.class$("java.sql.Time")) : class$java$sql$Time).isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, 92);
            } else {
                this.statement.setTime(parameterIndex, (Time)parameterValue);
            }
        } else if ((class$java$util$Date == null ? (class$java$util$Date = JRJdbcQueryExecuter.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, 91);
            } else {
                this.statement.setDate(parameterIndex, new Date(((java.util.Date)parameterValue).getTime()));
            }
        } else if (parameterValue == null) {
            this.statement.setNull(parameterIndex, 2000);
        } else {
            this.statement.setObject(parameterIndex, parameterValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (SQLException e) {
                log.error((Object)"Error while closing result set.", (Throwable)e);
            }
            finally {
                this.resultSet = null;
            }
        }
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException e) {
                log.error((Object)"Error while closing statement.", (Throwable)e);
            }
            finally {
                this.statement = null;
            }
        }
    }

    public synchronized boolean cancelQuery() throws JRException {
        if (this.statement != null) {
            try {
                this.statement.cancel();
                return true;
            }
            catch (Throwable t) {
                throw new JRException("Error cancelling SQL statement", t);
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

