/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.syntax.lexer;

import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.syntax.ReadException;
import org.codehaus.groovy.syntax.lexer.CharStream;
import org.codehaus.groovy.syntax.lexer.GroovyLexerBase;
import org.codehaus.groovy.syntax.lexer.Lexer;
import org.codehaus.groovy.syntax.lexer.LexerException;
import org.codehaus.groovy.syntax.lexer.UnexpectedCharacterException;

public class GroovyLexer
extends GroovyLexerBase {
    private CharStream charStream;
    protected int line;
    protected int column;
    private final char[] buf = new char[5];
    private final int[] charWidth = new int[this.buf.length];
    private int cur = 0;
    private int charsInBuffer = 0;
    private boolean eosRead = false;
    private boolean escapeLookahead = false;
    private char escapeLookaheadChar;
    private boolean boundary = false;

    public GroovyLexer(CharStream charStream) {
        this.charStream = charStream;
        this.line = 1;
        this.column = 1;
    }

    public CharStream getCharStream() {
        return this.charStream;
    }

    public void setSource(Lexer source) {
        throw new GroovyBugError("you can't set a source on the GroovyLexer");
    }

    public void unsetSource() {
        throw new GroovyBugError("you can't unset a source on the GroovyLexer");
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public char la(int k) throws LexerException, ReadException {
        if (k > this.charsInBuffer) {
            if (k > this.buf.length) {
                throw new GroovyBugError("Could not look ahead for character: " + k + " due to buffer exhaustion");
            }
            int i = 0;
            while (i != this.charsInBuffer) {
                this.buf[i] = this.buf[this.cur];
                this.charWidth[i] = this.charWidth[this.cur];
                ++i;
                ++this.cur;
            }
            this.fillBuffer();
        }
        return this.buf[this.cur + k - 1];
    }

    public char consume() throws LexerException, ReadException {
        if (this.charsInBuffer == 0) {
            this.fillBuffer();
        }
        --this.charsInBuffer;
        int width = this.charWidth[this.cur];
        char c = this.buf[this.cur++];
        this.column += width;
        if (this.boundary || c == '\n' && width == 1) {
            this.boundary = false;
            ++this.line;
            this.column = 1;
        } else if (c == '\r' && width == 1) {
            if (this.la(1) != '\n') {
                ++this.line;
                this.column = 1;
            } else if (this.charWidth[this.cur] == 1) {
                this.boundary = true;
            }
        }
        return c;
    }

    private void fillBuffer() throws ReadException, LexerException {
        this.cur = 0;
        do {
            if (this.eosRead) {
                this.buf[this.charsInBuffer] = 65535;
                continue;
            }
            char c = this.escapeLookahead ? this.escapeLookaheadChar : this.charStream.consume();
            this.escapeLookahead = false;
            this.charWidth[this.charsInBuffer] = 1;
            if (c == '\uffff') {
                this.eosRead = true;
            }
            if (c == '\\') {
                c = this.charStream.consume();
                if (c == 'u') {
                    do {
                        int n = this.charsInBuffer;
                        this.charWidth[n] = this.charWidth[n] + 1;
                    } while ((c = (char)this.charStream.consume()) == 117);
                    try {
                        c = (char)Integer.parseInt(new String(new char[]{c, this.charStream.consume(), this.charStream.consume(), this.charStream.consume()}), 16);
                        int n = this.charsInBuffer;
                        this.charWidth[n] = this.charWidth[n] + 4;
                    }
                    catch (NumberFormatException e) {
                        throw new UnexpectedCharacterException(this.getStartLine(), this.getStartColumn() + 1, c, new char[0]);
                    }
                } else {
                    this.escapeLookahead = true;
                    this.escapeLookaheadChar = c;
                    c = '\\';
                }
            }
            this.buf[this.charsInBuffer] = c;
        } while (++this.charsInBuffer != this.buf.length);
    }
}

