/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import mondrian.gui.PropertyTableModel;
import mondrian.gui.SchemaExplorer;
import mondrian.gui.SchemaPropertyCellRenderer;
import mondrian.olap.MondrianDef;

public class SchemaPropertyCellEditor
implements TableCellEditor {
    ArrayList listeners = new ArrayList();
    JTextField stringEditor = new JTextField();
    JCheckBox booleanEditor;
    JTextField integerEditor;
    JTable tableEditor;
    Component activeEditor;

    public SchemaPropertyCellEditor() {
        this.stringEditor.setFont(Font.decode("Dialog"));
        this.stringEditor.setBorder(null);
        this.booleanEditor = new JCheckBox();
        this.booleanEditor.setBackground(Color.white);
        this.integerEditor = new JTextField();
        this.integerEditor.setBorder(null);
        this.integerEditor.setHorizontalAlignment(4);
        this.integerEditor.setFont(Font.decode("Courier"));
        this.tableEditor = new JTable();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof String) {
            this.activeEditor = this.stringEditor;
            this.stringEditor.setText((String)value);
        } else if (value instanceof Boolean) {
            this.activeEditor = this.booleanEditor;
            this.booleanEditor.setSelected((Boolean)value);
        } else if (value instanceof Integer) {
            this.activeEditor = this.integerEditor;
            this.integerEditor.setText((String)value);
        } else if (value == null) {
            value = "";
            this.activeEditor = this.stringEditor;
            this.stringEditor.setText((String)value);
        } else if (value.getClass() == MondrianDef.Join.class) {
            SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor();
            this.tableEditor.setDefaultEditor(Object.class, spce);
            SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer();
            this.tableEditor.setDefaultRenderer(Object.class, spcr);
            PropertyTableModel ptm = new PropertyTableModel(value, SchemaExplorer.DEF_JOIN);
            this.tableEditor.setModel(ptm);
            this.activeEditor = this.tableEditor;
        } else {
            if (value.getClass() == MondrianDef.NameExpression.class) {
                return null;
            }
            if (value.getClass() == MondrianDef.Relation.class) {
                SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor();
                this.tableEditor.setDefaultEditor(Object.class, spce);
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer();
                this.tableEditor.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(value, SchemaExplorer.DEF_RELATION);
                this.tableEditor.setModel(ptm);
                this.activeEditor = this.tableEditor;
                return null;
            }
            if (value.getClass() == MondrianDef.OrdinalExpression.class) {
                SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor();
                this.tableEditor.setDefaultEditor(Object.class, spce);
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer();
                this.tableEditor.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(value, SchemaExplorer.DEF_SQL);
                this.tableEditor.setModel(ptm);
                this.activeEditor = this.tableEditor;
            } else if (value.getClass() == MondrianDef.Table.class) {
                SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor();
                this.tableEditor.setDefaultEditor(Object.class, spce);
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer();
                this.tableEditor.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(value, SchemaExplorer.DEF_TABLE);
                this.tableEditor.setModel(ptm);
                this.activeEditor = this.tableEditor;
            } else if (value.getClass() == MondrianDef.Property.class) {
                SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor();
                this.tableEditor.setDefaultEditor(Object.class, spce);
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer();
                this.tableEditor.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(value, SchemaExplorer.DEF_PROPERTY);
                this.tableEditor.setModel(ptm);
                this.activeEditor = this.tableEditor;
            } else {
                value = "";
                this.activeEditor = this.stringEditor;
                this.stringEditor.setText((String)value);
            }
        }
        this.activeEditor.setVisible(true);
        return this.activeEditor;
    }

    public void addCellEditorListener(CellEditorListener l) {
        this.listeners.add(l);
    }

    public void cancelCellEditing() {
        if (this.activeEditor != null) {
            this.activeEditor.setVisible(false);
            this.fireEditingCancelled();
        }
    }

    public Object getCellEditorValue() {
        if (this.activeEditor == this.stringEditor) {
            return this.stringEditor.getText();
        }
        if (this.activeEditor == this.booleanEditor) {
            return new Boolean(this.booleanEditor.isSelected());
        }
        if (this.activeEditor == this.tableEditor) {
            return ((PropertyTableModel)this.tableEditor.getModel()).getValue();
        }
        return null;
    }

    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.remove(l);
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    public boolean stopCellEditing() {
        if (this.activeEditor != null) {
            this.activeEditor.setVisible(false);
            this.fireEditingStopped();
        }
        return true;
    }

    protected void fireEditingStopped() {
        ChangeEvent ce = new ChangeEvent(this);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((CellEditorListener)this.listeners.get(i)).editingStopped(ce);
        }
    }

    protected void fireEditingCancelled() {
        ChangeEvent ce = new ChangeEvent(this);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((CellEditorListener)this.listeners.get(i)).editingCanceled(ce);
        }
    }
}

