/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.Map;
import java.util.Set;
import mondrian.olap.Evaluator;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.Util;
import mondrian.rolap.CellReader;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMeasure;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.agg.CellRequest;

public abstract class RolapAggregationManager
implements CellReader {
    static final /* synthetic */ boolean $assertionsDisabled;

    static CellRequest makeRequest(Member[] members, boolean extendedContext) {
        boolean showNames = extendedContext;
        if (!(members[0] instanceof RolapStoredMeasure)) {
            return null;
        }
        RolapStoredMeasure measure = (RolapStoredMeasure)members[0];
        RolapStar.Measure starMeasure = (RolapStar.Measure)measure.getStarMeasure();
        Util.assertTrue(starMeasure != null);
        RolapStar star = starMeasure.getStar();
        CellRequest request = new CellRequest(starMeasure);
        Map mapLevelToColumn = star.getMapLevelToColumn(measure.getCube());
        for (int i = 1; i < members.length; ++i) {
            Member member = members[i];
            RolapLevel previousLevel = null;
            Hierarchy hierarchy = member.getHierarchy();
            if (extendedContext) {
                Level[] levels = hierarchy.getLevels();
                int depth = member.getLevel().getDepth();
                for (int j = levels.length - 1; j > depth; --j) {
                    RolapLevel level = (RolapLevel)levels[j];
                    RolapStar.Column column = (RolapStar.Column)mapLevelToColumn.get(level);
                    if (column == null) continue;
                    request.addConstrainedColumn(column, null);
                    if (!showNames || level.getNameExp() == null) continue;
                    RolapStar.Column nameColumn = column.getNameColumn();
                    Util.assertTrue(nameColumn != null);
                    request.addConstrainedColumn(nameColumn, null);
                }
            }
            for (Member m = member; m != null; m = m.getParentMember()) {
                RolapStar.Column column;
                RolapMember rm = (RolapMember)m;
                if (rm.getKey() == null) {
                    if (m == m.getHierarchy().getNullMember()) {
                        return null;
                    }
                    if (m.isAll()) continue;
                    throw Util.newInternal("why is key null?");
                }
                RolapLevel level = (RolapLevel)m.getLevel();
                if (level == previousLevel) continue;
                previousLevel = level;
                if (level.hasClosedPeer() && member.getDataMember() != null) {
                    level = level.getClosedPeer();
                    RolapMember allMember = (RolapMember)hierarchy.getDefaultMember();
                    if (!$assertionsDisabled && !allMember.isAll()) {
                        throw new AssertionError();
                    }
                    member = new RolapMember((Member)allMember, level, ((RolapMember)member).getKey());
                }
                if ((column = (RolapStar.Column)mapLevelToColumn.get(level)) == null) {
                    return null;
                }
                request.addConstrainedColumn(column, m);
                if (!showNames || level.getNameExp() == null) continue;
                RolapStar.Column nameColumn = column.getNameColumn();
                Util.assertTrue(nameColumn != null);
                request.addConstrainedColumn(nameColumn, null);
            }
        }
        return request;
    }

    protected RolapAggregationManager() {
    }

    public Object getCellFromCache(Member[] members) {
        CellRequest request = RolapAggregationManager.makeRequest(members, false);
        return request == null ? Util.nullValue : this.getCellFromCache(request);
    }

    public abstract Object getCellFromCache(CellRequest var1);

    public abstract Object getCellFromCache(CellRequest var1, Set var2);

    public Object getCell(Member[] members) {
        CellRequest request = RolapAggregationManager.makeRequest(members, false);
        RolapMeasure measure = (RolapMeasure)members[0];
        RolapStar.Measure starMeasure = (RolapStar.Measure)measure.getStarMeasure();
        Util.assertTrue(starMeasure != null);
        RolapStar star = starMeasure.getStar();
        return star.getCell(request);
    }

    public Object get(Evaluator evaluator) {
        RolapEvaluator rolapEvaluator = (RolapEvaluator)evaluator;
        return this.getCell(rolapEvaluator.getCurrentMembers());
    }

    public abstract String getDrillThroughSQL(CellRequest var1);

    static {
        $assertionsDisabled = !RolapAggregationManager.class.desiredAssertionStatus();
    }
}

