/*
 * Decompiled with CFR 0.152.
 */
package mondrian.web.taglib;

import java.io.InputStream;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import mondrian.web.taglib.Listener;

public class ApplResources
implements Listener.ApplicationContext {
    private static final String ATTRNAME = "mondrian.web.taglib.ApplResources";
    private ServletContext context;
    private HashMap templatesCache = new HashMap();

    public static ApplResources getInstance(ServletContext context) {
        return (ApplResources)context.getAttribute(ATTRNAME);
    }

    public Transformer getTransformer(String xsltURI, boolean useCache) {
        try {
            Templates templates = null;
            if (useCache) {
                templates = (Templates)this.templatesCache.get(xsltURI);
            }
            if (templates == null) {
                TransformerFactory tf = TransformerFactory.newInstance();
                InputStream input = this.context.getResourceAsStream(xsltURI);
                templates = tf.newTemplates(new StreamSource(input));
                if (useCache) {
                    this.templatesCache.put(xsltURI, templates);
                }
            }
            return templates.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
            throw new RuntimeException(e.toString());
        }
    }

    public void init(ServletContextEvent event) {
        this.context = event.getServletContext();
        this.context.setAttribute(ATTRNAME, (Object)this);
    }

    public void destroy(ServletContextEvent ev) {
    }
}

