/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.editor;

import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import nickyb.sqleonardo.common.gui.CustomLineBorder;
import nickyb.sqleonardo.environment.ctrl.editor.BuildBaseEntity;
import nickyb.sqleonardo.environment.ctrl.editor.BuildBasePane;
import nickyb.sqleonardo.environment.ctrl.editor._BuildOwner;
import nickyb.sqleonardo.querybuilder.syntax.QueryTokens;
import nickyb.sqleonardo.querybuilder.syntax.SQLFormatter;

public class BuildInsert
extends BuildBasePane {
    private BuildBaseEntity entity;

    public BuildInsert(_BuildOwner owner) {
        super(owner);
    }

    void initComponents() {
        this.entity = new BuildBaseEntity(this);
        this.entity.setBorder(new CustomLineBorder(true, true, false, false));
        JScrollPane scroll = new JScrollPane(this.entity);
        scroll.setBorder(new TitledBorder(" values "));
        this.setComponentCenter(scroll);
    }

    void add(QueryTokens.Column column) {
        this.entity.addField(SQLFormatter.ensureQuotes(column.getName(), this.owner.getIdentifierQuoteString(), false));
    }

    void clear() {
        this.entity.removeRows();
    }

    public String getSyntax() {
        StringBuffer fields = new StringBuffer();
        StringBuffer values = new StringBuffer();
        if (this.entity != null) {
            for (int i = 0; i < this.entity.getRowCount(); ++i) {
                if (!this.entity.isCellEditable(i, 2)) continue;
                fields.append(this.entity.getValueAt(i, 1).toString() + ", ");
                values.append((this.entity.getValueAt(i, 2) != null ? this.entity.getValueAt(i, 2).toString() : null) + ", ");
            }
            if (fields.length() > 0) {
                fields.deleteCharAt(fields.length() - 2);
            }
            if (values.length() > 0) {
                values.deleteCharAt(values.length() - 2);
            }
            return "INSERT INTO " + this.owner.getTable() + " (" + fields.toString().trim() + ") VALUES (" + values.toString().trim() + ")";
        }
        return "INSERT INTO";
    }
}

