/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.mdi;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import nickyb.sqleonardo.common.gui.AbstractDialogWizard;
import nickyb.sqleonardo.common.gui.AbstractMaskChooser;
import nickyb.sqleonardo.common.gui.BorderLayoutPanel;
import nickyb.sqleonardo.common.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.common.jdbc.ConnectionHandler;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.io.FileStreamLQY;
import nickyb.sqleonardo.environment.io.FileStreamSQL;
import nickyb.sqleonardo.environment.io.FileStreamXLQ;
import nickyb.sqleonardo.environment.mdi.DefaultMaskChooser;
import nickyb.sqleonardo.querybuilder.QueryModel;

public class DialogQuery
extends AbstractDialogWizard {
    private static final String LOAD = "query.load";
    private static final String SAVE = "query.save";
    private AbstractMaskChooser mkc;
    private MaskPreview mkp = new MaskPreview();
    private boolean terminated;

    private DialogQuery(String title) {
        super((Component)Application.window, title);
    }

    private DialogQuery(String title, QueryModel model) {
        this(title);
        this.setDefaultCloseOperation(1);
        this.mkp.setModel(model);
    }

    public static Object[] showLoad() {
        DialogQuery dlg = new DialogQuery(LOAD);
        dlg.show();
        return DialogQuery.onDispose(dlg);
    }

    public static Object[] showSave(QueryModel model) {
        DialogQuery dlg = new DialogQuery(SAVE, model);
        dlg.show();
        return DialogQuery.onDispose(dlg);
    }

    private static Object[] onDispose(DialogQuery dlg) {
        Object[] ret = new Object[4];
        if (dlg.terminated) {
            ret[0] = dlg.mkc.getSelectedFile();
            ret[1] = dlg.mkp.getModel();
            ret[2] = dlg.mkp.cbxConnections.getSelectedItem();
            ret[3] = dlg.mkp.cbxSchemas.getSelectedItem();
        }
        dlg.dispose();
        return ret;
    }

    public void actionPerformed(ActionEvent ae) {
        this.terminated = ae.getSource() == this.btnNext && this.getStep() == 1;
        super.actionPerformed(ae);
    }

    protected boolean onNext() {
        if (this.getTitle().equals(LOAD)) {
            if (this.getStep() == 0) {
                return this.doLoad();
            }
            if (this.mkp.cbxConnections.getSelectedItem() == null) {
                Application.alert("SQLeonardo", "Please, choose a connection.");
                return false;
            }
        } else if (this.getStep() == 1) {
            return this.doSave();
        }
        return true;
    }

    protected void onOpen() {
        if (this.getTitle().equals(LOAD)) {
            this.mkc = new DefaultMaskChooser(0, 0, false);
            this.addStep(this.mkc);
            this.addStep(this.mkp);
            this.mkc.setFileFilter(new LQYFilter());
        } else {
            this.mkc = new DefaultMaskChooser(1, 0, false);
            this.addStep(this.mkp);
            this.addStep(this.mkc);
        }
        this.mkc.setFileFilter(new XLQFilter());
        this.mkc.setFileFilter(new SQLFilter());
        this.getContentPane().validate();
    }

    private boolean doLoad() {
        if (this.mkc.getSelectedFile() == null) {
            return false;
        }
        String filename = this.mkc.getSelectedFile().toString();
        try {
            QueryModel model;
            if (filename.endsWith(".xlq")) {
                model = FileStreamXLQ.read(filename);
            } else if (filename.endsWith(".lqy")) {
                model = FileStreamLQY.read(filename);
            } else if (filename.endsWith(".sql")) {
                model = FileStreamSQL.read(filename);
            } else {
                return false;
            }
            this.mkp.setModel(model);
            return true;
        }
        catch (Exception e) {
            Application.println(e, true);
            e.printStackTrace();
            this.show();
            return false;
        }
    }

    private boolean doSave() {
        if (this.mkc.getSelectedFile() == null) {
            return false;
        }
        String filename = this.mkc.getSelectedFile().toString();
        AbstractMaskChooser.AbstractFileFilter filter = (AbstractMaskChooser.AbstractFileFilter)this.mkc.getFileFilter();
        if (filter.getPerformType() == 1 && !filename.endsWith(".xlq")) {
            filename = filename + ".xlq";
            this.mkc.setSelectedFile(new File(filename));
        } else if (filter.getPerformType() == 2 && !filename.endsWith(".sql")) {
            filename = filename + ".sql";
            this.mkc.setSelectedFile(new File(filename));
        }
        try {
            if (filter.getPerformType() == 1) {
                FileStreamXLQ.write(filename, this.mkp.qmodel);
            } else if (filter.getPerformType() == 2) {
                FileStreamSQL.write(filename, this.mkp.qmodel);
            } else {
                return false;
            }
            return true;
        }
        catch (Exception e) {
            Application.println(e, true);
            e.printStackTrace();
            return false;
        }
    }

    private class MaskPreview
    extends BorderLayoutPanel
    implements ItemListener {
        private QueryModel qmodel;
        JComboBox cbxConnections;
        JComboBox cbxSchemas;
        JTextArea txt;

        MaskPreview() {
            super(5, 5);
            this.txt = new JTextArea();
            this.txt.setEditable(false);
            this.cbxConnections = new JComboBox<Object>(ConnectionAssistant.getHandlers().toArray());
            this.cbxSchemas = new JComboBox();
            this.cbxConnections.setSelectedItem(null);
            this.cbxSchemas.setEnabled(false);
            this.cbxConnections.addItemListener(this);
            JPanel pnlLabels = new JPanel(new GridLayout(2, 1, 0, 3));
            JPanel pnlCbxs = new JPanel(new GridLayout(2, 1, 0, 3));
            pnlLabels.add(new JLabel("connection:"));
            pnlLabels.add(new JLabel("schema:"));
            pnlCbxs.add(this.cbxConnections);
            pnlCbxs.add(this.cbxSchemas);
            BorderLayoutPanel pnlSouth = new BorderLayoutPanel(3, 3);
            pnlSouth.setComponentWest(pnlLabels);
            pnlSouth.setComponentCenter(pnlCbxs);
            pnlSouth.setVisible(DialogQuery.this.getTitle().equals(DialogQuery.LOAD));
            this.setComponentCenter(new JScrollPane(this.txt));
            this.setComponentSouth(pnlSouth);
        }

        QueryModel getModel() {
            return this.qmodel;
        }

        void setModel(QueryModel model) {
            this.qmodel = model;
            if (model != null) {
                this.txt.setText(this.qmodel.toString(true));
            }
        }

        public void itemStateChanged(ItemEvent ie) {
            ConnectionHandler ch = ConnectionAssistant.getHandler(ie.getItem().toString());
            ArrayList schemas = (ArrayList)ch.getObject("$schema_names");
            this.cbxSchemas.setModel(new DefaultComboBoxModel<Object>(schemas.toArray()));
            this.cbxSchemas.setEnabled(this.cbxSchemas.getItemCount() > 0);
            this.cbxSchemas.setSelectedItem(this.qmodel.getSchema());
        }
    }

    private static class SQLFilter
    extends AbstractMaskChooser.AbstractFileFilter {
        SQLFilter() {
            super("statement, (.sql)", new String[]{".sql"});
        }

        public short getPerformType() {
            return 2;
        }
    }

    private static class XLQFilter
    extends AbstractMaskChooser.AbstractFileFilter {
        XLQFilter() {
            super("sqleonardo query, (.xlq)", new String[]{".xlq"});
        }

        public short getPerformType() {
            return 1;
        }
    }

    private static class LQYFilter
    extends AbstractMaskChooser.AbstractFileFilter {
        LQYFilter() {
            super("sqleonardo query < 2006.08, (.lqy)", new String[]{".lqy"});
        }

        public short getPerformType() {
            return 0;
        }
    }
}

