/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.compiler;

import it.businesslogic.ireport.compiler.JasperReportErrorHandler;
import it.businesslogic.ireport.compiler.xml.SourceLocation;
import it.businesslogic.ireport.compiler.xml.SourceTraceDigester;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRCompilationSourceCode;
import net.sf.jasperreports.engine.design.JRCompilationUnit;
import net.sf.jasperreports.engine.design.JRJdtCompiler;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;

public class ExtendedJRJdtCompiler
extends JRJdtCompiler {
    private JasperReportErrorHandler errorHandler = null;
    private SourceTraceDigester digester = null;
    private ICompilerRequestor superCompilerRequestor = null;

    protected ICompilerRequestor getCompilerRequestor(JRCompilationUnit[] units, StringBuffer problemBuffer) {
        return new CompilerRequestor(super.getCompilerRequestor(units, problemBuffer), units);
    }

    public JasperReportErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(JasperReportErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public SourceTraceDigester getDigester() {
        return this.digester;
    }

    public void setDigester(SourceTraceDigester digester) {
        this.digester = digester;
    }

    protected static class ExpressionErrorKey {
        private final IProblem problem;
        private final int hash;

        public ExpressionErrorKey(IProblem problem) {
            this.problem = problem;
            this.hash = this.computeHash();
        }

        private int computeHash() {
            int h = this.problem.getMessage().hashCode();
            return h;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof ExpressionErrorKey) || this.hash != o.hashCode()) {
                return false;
            }
            if (this == o) {
                return true;
            }
            ExpressionErrorKey k = (ExpressionErrorKey)o;
            return this.problem.getMessage().equals(k.problem.getMessage());
        }
    }

    protected class CompilerRequestor
    implements ICompilerRequestor {
        private ICompilerRequestor superCompilerRequestor = null;
        private final Map expressionErrors = new HashMap();
        private final JRCompilationUnit[] units;

        protected CompilerRequestor(ICompilerRequestor superCompilerRequestor, JRCompilationUnit[] units) {
            this.superCompilerRequestor = superCompilerRequestor;
            this.units = units;
        }

        public void acceptResult(CompilationResult result) {
            if (this.superCompilerRequestor != null) {
                this.superCompilerRequestor.acceptResult(result);
            }
            if (result.hasErrors()) {
                String className = String.valueOf(result.getCompilationUnit().getMainTypeName());
                JRCompilationUnit unit = null;
                for (int classIdx = 0; classIdx < this.units.length; ++classIdx) {
                    if (!className.equals(this.units[classIdx].getName())) continue;
                    unit = this.units[classIdx];
                    break;
                }
                IProblem[] errors = result.getErrors();
                for (int i = 0; i < errors.length; ++i) {
                    IProblem problem = errors[i];
                    int line = problem.getSourceLineNumber();
                    JRCompilationSourceCode sourceCode = unit.getCompilationSource();
                    JRExpression expression = sourceCode.getExpressionAtLine(line);
                    if (expression == null) {
                        ExtendedJRJdtCompiler.this.getErrorHandler().addMarker(problem, null);
                        continue;
                    }
                    if (!this.addExpressionError(expression, problem)) continue;
                    SourceLocation location = ExtendedJRJdtCompiler.this.getDigester().getLocation(expression);
                    ExtendedJRJdtCompiler.this.getErrorHandler().addMarker(problem, location);
                }
            }
        }

        protected boolean addExpressionError(JRExpression expression, IProblem problem) {
            HashSet<ExpressionErrorKey> errors = (HashSet<ExpressionErrorKey>)this.expressionErrors.get(expression);
            if (errors == null) {
                errors = new HashSet<ExpressionErrorKey>();
                this.expressionErrors.put(expression, errors);
            }
            return errors.add(new ExpressionErrorKey(problem));
        }
    }
}

