/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.compiler.xml;

import it.businesslogic.ireport.compiler.xml.SourceLocation;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.sf.jasperreports.engine.xml.JRXmlDigester;
import org.apache.commons.digester.FactoryCreateRule;
import org.apache.commons.digester.Rule;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SourceTraceDigester
extends JRXmlDigester {
    private final Map sourceLocations = new HashMap();
    private final ElementStack elementStack = new ElementStack();

    public SourceTraceDigester() {
    }

    public SourceTraceDigester(XMLReader xmlReader) {
        super(xmlReader);
    }

    public void addFactoryCreate(String pattern, Class clazz) {
        this.addRule(pattern, (Rule)new SourceTraceFactoryCreateRule(clazz));
    }

    public void addFactoryCreate(String pattern, String className) {
        this.addRule(pattern, (Rule)new SourceTraceFactoryCreateRule(className));
    }

    public void addFactoryCreate(String pattern, Class clazz, String attributeName) {
        this.addRule(pattern, (Rule)new SourceTraceFactoryCreateRule(clazz, attributeName));
    }

    public void addFactoryCreate(String pattern, String className, String attributeName) {
        this.addRule(pattern, (Rule)new SourceTraceFactoryCreateRule(className, attributeName));
    }

    public SourceLocation getLocation(Object instance) {
        return (SourceLocation)this.sourceLocations.get(instance);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes list) throws SAXException {
        String name = localName != null && localName.length() > 0 ? localName : qName;
        this.elementStack.pushElement(name);
        super.startElement(namespaceURI, localName, qName, list);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        super.endElement(namespaceURI, localName, qName);
        this.elementStack.popElement();
    }

    protected void objectCreated() {
        Object instance = this.peek();
        if (instance != null && !this.sourceLocations.containsKey(instance)) {
            SourceLocation location = this.currentLocation();
            this.sourceLocations.put(instance, location);
        }
    }

    protected SourceLocation currentLocation() {
        Locator documentLocator = this.getDocumentLocator();
        SourceLocation location = new SourceLocation();
        location.setLineNumber(documentLocator.getLineNumber());
        location.setColumnNumber(documentLocator.getColumnNumber());
        location.setXPath(this.elementStack.getCurrentPath());
        return location;
    }

    protected class SourceTraceFactoryCreateRule
    extends FactoryCreateRule {
        public SourceTraceFactoryCreateRule(Class clazz) {
            super(clazz, false);
        }

        public SourceTraceFactoryCreateRule(String className) {
            super(className, false);
        }

        public SourceTraceFactoryCreateRule(Class clazz, String attributeName) {
            super(clazz, attributeName, false);
        }

        public SourceTraceFactoryCreateRule(String className, String attributeName) {
            super(className, attributeName, false);
        }

        public void begin(String namespace, String name, Attributes attributes) throws Exception {
            super.begin(namespace, name, attributes);
            SourceTraceDigester.this.objectCreated();
        }
    }

    protected static class ElementStack {
        private final LinkedList infoStack = new LinkedList();

        protected ElementStack() {
        }

        public void pushElement(String elementName) {
            String currentPath;
            if (this.infoStack.isEmpty()) {
                currentPath = "/" + elementName;
            } else {
                ElementInfo parentInfo = (ElementInfo)this.infoStack.getFirst();
                int position = parentInfo.addChild(elementName);
                currentPath = parentInfo.getPath() + "/" + elementName + "[" + position + "]";
            }
            ElementInfo info = new ElementInfo();
            info.setPath(currentPath);
            this.infoStack.addFirst(info);
        }

        public void popElement() {
            this.infoStack.removeFirst();
        }

        public String getCurrentPath() {
            ElementInfo info = (ElementInfo)this.infoStack.getFirst();
            return info.getPath();
        }

        protected static class ElementInfo {
            private String path;
            private final Map childrenCounts = new HashMap();

            protected ElementInfo() {
            }

            public int addChild(String name) {
                Integer last = (Integer)this.childrenCounts.get(name);
                int position = last == null ? 1 : last + 1;
                this.childrenCounts.put(name, new Integer(position));
                return position;
            }

            public String getPath() {
                return this.path;
            }

            public void setPath(String path) {
                this.path = path;
            }
        }
    }
}

