/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.gui.event.ValueChangedEvent;
import it.businesslogic.ireport.gui.event.ValueChangedListener;
import it.businesslogic.ireport.util.Misc;
import java.text.DecimalFormatSymbols;
import javax.swing.event.EventListenerList;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class NumberDocument
extends PlainDocument {
    private char groupingSeparator = (char)44;
    private char decimalSeparator = (char)46;
    private double value = 0.0;
    private EventListenerList listenerList = null;

    public NumberDocument() {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        this.groupingSeparator = dfs.getGroupingSeparator();
        this.decimalSeparator = dfs.getDecimalSeparator();
    }

    public boolean checkNumber(String proposedResult) {
        if (this.groupingSeparator != '.' || proposedResult.indexOf(this.decimalSeparator) >= 0) {
            proposedResult = Misc.string_replace("", "" + this.groupingSeparator, proposedResult);
        }
        proposedResult = proposedResult.replace(this.decimalSeparator, '.');
        try {
            if (proposedResult.trim().length() == 0) {
                return true;
            }
            double oldValue = this.getValue();
            double newValue = 0.0;
            if (proposedResult.length() > 0) {
                newValue = Double.parseDouble(proposedResult);
            }
            this.fireValueChangedListenerValueChanged(new ValueChangedEvent(null, oldValue, newValue));
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (str == null || str.length() == 0) {
            super.insertString(offs, str, a);
            return;
        }
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(offs, currentText.length());
        String proposedResult = beforeOffset + str + afterOffset;
        if (this.checkNumber(proposedResult)) {
            super.insertString(offs, str, a);
        }
    }

    public void remove(int offs, int len) throws BadLocationException {
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(len + offs, currentText.length());
        String proposedResult = beforeOffset + afterOffset;
        if (this.checkNumber(proposedResult)) {
            super.remove(offs, len);
        }
    }

    public void replace(int offset, int length, String str, AttributeSet attrs) throws BadLocationException {
        if (str == null || str.length() == 0) {
            super.replace(offset, length, str, attrs);
            return;
        }
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offset);
        String afterOffset = currentText.substring(length + offset, currentText.length());
        String proposedResult = beforeOffset + str + afterOffset;
        if (this.checkNumber(proposedResult)) {
            super.replace(offset, length, str, attrs);
        }
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public synchronized void addValueChangedListener(ValueChangedListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ValueChangedListener.class, listener);
    }

    public synchronized void removeValueChangedListener(ValueChangedListener listener) {
        this.listenerList.remove(ValueChangedListener.class, listener);
    }

    private void fireValueChangedListenerValueChanged(ValueChangedEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$it$businesslogic$ireport$gui$event$ValueChangedListener == null ? NumberDocument.class$("it.businesslogic.ireport.gui.event.ValueChangedListener") : class$it$businesslogic$ireport$gui$event$ValueChangedListener)) continue;
            ((ValueChangedListener)listeners[i + 1]).valueChanged(event);
        }
    }
}

