/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.undo;

import it.businesslogic.ireport.CrosstabReportElement;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.UndoOperation;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.event.ReportElementChangedEvent;

public class InsertElementOperation
implements UndoOperation {
    private ReportElement element = null;
    private JReportFrame jrf = null;
    private CrosstabReportElement crosstabReportElement = null;

    public InsertElementOperation(JReportFrame jrf, CrosstabReportElement crosstabReportElement, ReportElement element) {
        this.crosstabReportElement = crosstabReportElement;
        this.element = element;
        this.jrf = jrf;
    }

    public InsertElementOperation(JReportFrame jrf, ReportElement element) {
        this(jrf, null, element);
    }

    public void undo() {
        if (this.jrf == null && this.crosstabReportElement == null) {
            return;
        }
        if (this.crosstabReportElement != null) {
            this.crosstabReportElement.getElements().remove(this.element);
            this.jrf.getCrosstabEditor(this.crosstabReportElement).getPanelEditor().getSelectedElements().remove(this.element);
            this.jrf.getCrosstabEditor(this.crosstabReportElement).getPanelEditor().repaint();
        } else {
            this.jrf.getReport().getElements().remove(this.element);
            this.jrf.getSelectedElements().remove(this.element);
            if (this.element instanceof CrosstabReportElement) {
                this.jrf.removeCrosstabEditor((CrosstabReportElement)this.element);
            }
            this.jrf.getReportPanel().repaint();
        }
        this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, this.crosstabReportElement, this.element, 1));
    }

    public void redo() {
        if (this.jrf == null && this.crosstabReportElement == null) {
            return;
        }
        if (this.crosstabReportElement != null) {
            this.crosstabReportElement.getElements().addElement(this.element);
            this.jrf.getCrosstabEditor(this.crosstabReportElement).getPanelEditor().setSelectedElement(this.element);
            this.jrf.getCrosstabEditor(this.crosstabReportElement).getPanelEditor().repaint();
        } else {
            this.jrf.getReport().getElements().addElement(this.element);
            if (this.element instanceof CrosstabReportElement) {
                this.jrf.addCrosstabEditor((CrosstabReportElement)this.element);
            }
            this.jrf.setSelectedElement(this.element);
            this.jrf.getReportPanel().repaint();
        }
        this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, this.crosstabReportElement, this.element, 2));
    }

    public String toString() {
        return "insert element";
    }

    public CrosstabReportElement getCrosstabReportElement() {
        return this.crosstabReportElement;
    }

    public void setCrosstabReportElement(CrosstabReportElement crosstabReportElement) {
        this.crosstabReportElement = crosstabReportElement;
    }
}

