/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import rex.exceptions.RexXMLAExecuteException;
import rex.metadata.CubeSlicer;
import rex.metadata.ExecuteResult;
import rex.metadata.ExecuteResultParseException;
import rex.metadata.ServerMetadata;
import rex.metadata.resultelements.Axis;
import rex.metadata.resultelements.Cell;
import rex.metadata.resultelements.HierarchyInfo;
import rex.metadata.resultelements.Member;
import rex.metadata.resultelements.Tuple;
import rex.xmla.RexXMLAExecuteProperties;
import rex.xmla.XMLAExecuteProperties;

public class JRXmlaDataSource
implements JRDataSource {
    private ExecuteResult exResult;
    private CubeSlicer cubeSlicer;
    private int columnCount;
    private int rowCount;
    private int currentRow = -1;
    private int currentColumn = -1;
    private final String axis0 = "Axis0";
    private final String axis1 = "Axis1";
    private final String slicer = "SlicerAxis";
    private boolean columnsFirst = false;
    private DateFormat dateFormat = new SimpleDateFormat();
    public static String url;
    public static String datasource;
    public static String catalog;
    private int axisCount;
    private boolean doDump = false;
    private boolean didDump = false;
    private boolean measureFound = false;
    private HashMap fieldMap = new HashMap();

    private boolean addMDXAxisInfo(ExecuteResult exResult, String axisName) {
        if (this.doDump && !this.didDump) {
            exResult.debugPrintAxesTable();
            this.didDump = true;
        }
        this.axisCount = 0;
        if (exResult == null || axisName == null) {
            return false;
        }
        if (axisName.compareTo("Axis0") != 0 && axisName.compareTo("Axis1") != 0 && axisName.compareTo("SlicerAxis") != 0) {
            return false;
        }
        Axis axis = exResult.getAxis(axisName);
        if (axis == null) {
            return false;
        }
        int leftPar = 91;
        int rightPar = 93;
        Tuple tuple = null;
        int hierarchyCount = axis.getHierarchyInfoCount();
        for (int hierIndex = 0; hierIndex < hierarchyCount; ++hierIndex) {
            HierarchyInfo hierInfo = axis.getHierarchyInfoAt(hierIndex);
            if (hierInfo == null) {
                return false;
            }
            int measureCounter = 0;
            int tupleCount = axis.getTupleCount();
            for (int tupleIndex = 0; tupleIndex < tupleCount; ++tupleIndex) {
                tuple = axis.getTupleAt(tupleIndex);
                int tupleMemberCount = tuple.getMemberCount();
                for (int tupleMemberIndex = 0; tupleMemberIndex < tupleMemberCount; ++tupleMemberIndex) {
                    String shortName;
                    String longName;
                    if (tuple.getMemberAt(tupleMemberIndex).isMeasure()) {
                        this.measureFound = true;
                        ++this.axisCount;
                        longName = tuple.getMemberAt(tupleMemberIndex).getUniqueName();
                        shortName = longName.substring(longName.lastIndexOf(leftPar) + 1, longName.lastIndexOf(rightPar));
                        this.fieldMap.put(shortName, new fieldInfo(axis, tupleIndex, tupleMemberIndex, measureCounter++));
                        continue;
                    }
                    longName = tuple.getMemberAt(tupleMemberIndex).getLname();
                    shortName = longName.substring(longName.lastIndexOf(leftPar) + 1, longName.lastIndexOf(rightPar));
                    if (this.fieldMap.containsKey(shortName)) continue;
                    this.fieldMap.put(shortName, new fieldInfo(axis, tupleIndex, tupleMemberIndex));
                }
            }
        }
        if (this.axisCount == 0) {
            this.axisCount = 1;
        }
        if (axisName.compareTo("Axis1") == 0) {
            this.rowCount = axis.getTupleCount() - (this.axisCount - 1);
        } else if (axisName.compareTo("Axis0") == 0) {
            this.columnCount = axis.getTupleCount() - (this.axisCount - 1);
        }
        return true;
    }

    public JRXmlaDataSource(String strUrl, String strDataSource, String strCatalog) throws Exception {
        try {
            ServerMetadata smd = new ServerMetadata(strUrl, null);
            if (!smd.isValidUrl()) {
                throw new Exception("No url connection");
            }
            RexXMLAExecuteProperties rexProp = new RexXMLAExecuteProperties();
            rexProp.setDataSourceInfo(strDataSource);
            rexProp.setCatalog(strCatalog);
        }
        catch (Exception e) {
            this.exResult = null;
            throw e;
        }
    }

    public JRXmlaDataSource(String theUrl, String theDatasource, String theCatalog, String groupFieldName, String mdxQuery) throws RexXMLAExecuteException, IOException, ExecuteResultParseException, Exception {
        try {
            HierarchyInfo hierarchyInfo;
            Axis axis;
            ServerMetadata smd = new ServerMetadata(theUrl, null);
            if (!smd.isValidUrl()) {
                throw new Exception("No url connection");
            }
            RexXMLAExecuteProperties rexProp = new RexXMLAExecuteProperties();
            rexProp.setDataSourceInfo(theDatasource);
            rexProp.setCatalog(theCatalog);
            this.exResult = new ExecuteResult(smd.execute(mdxQuery, (XMLAExecuteProperties)rexProp), null);
            if (this.exResult == null) {
                throw new Exception("Error executing mdx query");
            }
            if (groupFieldName != null && (axis = this.exResult.getAxis("Axis1")) != null && (hierarchyInfo = axis.getHierarchyInfoAt(0)) != null) {
                this.columnsFirst = hierarchyInfo.getCaption().compareTo(groupFieldName) == 0;
            }
            this.cubeSlicer = new CubeSlicer(1, 0);
            if (!this.addMDXAxisInfo(this.exResult, "Axis0")) {
                throw new Exception("Axis0 missing");
            }
            if (!this.addMDXAxisInfo(this.exResult, "Axis1")) {
                throw new Exception("Axis1 missing");
            }
            if (!this.addMDXAxisInfo(this.exResult, "SlicerAxis")) {
                throw new Exception("SlicerAxis missing");
            }
            if (!this.measureFound) {
                this.fieldMap.put("DefaultMeasure", new fieldInfo(null, -1, -1, 0));
            }
        }
        catch (RexXMLAExecuteException rxee) {
            this.exResult = null;
            throw rxee;
        }
        catch (IOException ioe) {
            this.exResult = null;
            throw ioe;
        }
        catch (ExecuteResultParseException erpe) {
            this.exResult = null;
            throw erpe;
        }
        catch (Exception e) {
            this.exResult = null;
            throw e;
        }
    }

    public String getUrl() {
        return url;
    }

    public String getDatasource() {
        return datasource;
    }

    public String getCatalog() {
        return catalog;
    }

    public void setUrl(String strUrl) {
        url = strUrl;
    }

    public void setDatasource(String strDatasource) {
        datasource = strDatasource;
    }

    public void setCatalog(String strCatalog) {
        catalog = strCatalog;
    }

    public boolean next() throws JRException {
        if (this.exResult == null || this.rowCount <= 0 || this.columnCount <= 0) {
            return false;
        }
        if (this.currentRow == -1) {
            this.currentRow = 0;
            this.currentColumn = 0;
            return true;
        }
        if (this.columnsFirst) {
            ++this.currentColumn;
            if (this.currentColumn == this.columnCount) {
                ++this.currentRow;
                this.currentColumn = 0;
                if (this.currentRow == this.rowCount) {
                    return false;
                }
            }
            return true;
        }
        ++this.currentRow;
        if (this.currentRow == this.rowCount) {
            ++this.currentColumn;
            this.currentRow = 0;
            if (this.currentColumn == this.columnCount) {
                return false;
            }
        }
        return true;
    }

    private Object convertValue(JRField jrField, String fieldValue) throws JRException {
        Class valueClass;
        if (Number.class.isAssignableFrom(valueClass = jrField.getValueClass())) {
            fieldValue = fieldValue.trim();
        }
        if (fieldValue.length() == 0) {
            fieldValue = "0";
        }
        try {
            if (valueClass.equals(String.class)) {
                return fieldValue;
            }
            if (valueClass.equals(Boolean.class)) {
                return fieldValue.equalsIgnoreCase("true") ? Boolean.TRUE : Boolean.FALSE;
            }
            if (valueClass.equals(Byte.class)) {
                return new Byte(fieldValue);
            }
            if (valueClass.equals(Integer.class)) {
                return new Integer(fieldValue);
            }
            if (valueClass.equals(Long.class)) {
                return new Long(fieldValue);
            }
            if (valueClass.equals(Short.class)) {
                return new Short(fieldValue);
            }
            if (valueClass.equals(Double.class)) {
                return new Double(fieldValue);
            }
            if (valueClass.equals(Float.class)) {
                return new Float(fieldValue);
            }
            if (valueClass.equals(BigDecimal.class)) {
                return new BigDecimal(fieldValue);
            }
            if (valueClass.equals(Date.class)) {
                return this.dateFormat.parse(fieldValue);
            }
            if (valueClass.equals(Timestamp.class)) {
                return new Timestamp(this.dateFormat.parse(fieldValue).getTime());
            }
            if (valueClass.equals(Time.class)) {
                return new Time(this.dateFormat.parse(fieldValue).getTime());
            }
            throw new JRException("Field '" + jrField.getName() + "' is of class '" + valueClass.getName() + "' and can not be converted");
        }
        catch (Exception e) {
            throw new JRException("Unable to get value for field '" + jrField.getName() + "' of class '" + valueClass.getName() + "'", (Throwable)e);
        }
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        fieldInfo fInfo = (fieldInfo)this.fieldMap.get(jrField.getName());
        if (fInfo != null) {
            Member member;
            if (fInfo.theAxis == null || fInfo.theAxis.getName().compareTo("Axis0") == 0) {
                if (fInfo.isMeasure) {
                    Cell cell = this.exResult.getRowCol(this.currentRow, fInfo.measureIndex, this.cubeSlicer);
                    if (cell != null) {
                        return this.convertValue(jrField, cell.getCellValue());
                    }
                    return "measureColumnError";
                }
                Tuple tuple = fInfo.theAxis.getTupleAt(this.currentColumn);
                if (tuple != null) {
                    Member member2 = tuple.getMemberAt(fInfo.tupleMemberIndex);
                    if (member2 != null) {
                        return this.convertValue(jrField, member2.getCaption());
                    }
                    return "dimensionColumnError";
                }
                return "tupleColumnError";
            }
            if (fInfo.theAxis.getName().compareTo("Axis1") == 0) {
                if (fInfo.isMeasure) {
                    Cell cell = this.exResult.getRowCol(fInfo.measureIndex, this.currentColumn, this.cubeSlicer);
                    if (cell != null) {
                        return this.convertValue(jrField, cell.getCellValue());
                    }
                    return "measureRowError";
                }
                Tuple tuple = fInfo.theAxis.getTupleAt(this.currentRow);
                if (tuple != null) {
                    Member member3 = tuple.getMemberAt(fInfo.tupleMemberIndex);
                    if (member3 != null) {
                        return this.convertValue(jrField, member3.getCaption());
                    }
                    return "dimensionRowError";
                }
                return "tupleRowError";
            }
            if (fInfo.isMeasure) {
                Cell cell = this.exResult.getRowCol(this.currentRow, this.currentColumn, this.cubeSlicer);
                if (cell != null) {
                    return this.convertValue(jrField, cell.getCellValue());
                }
                return "measureSlicerError";
            }
            Tuple tuple = fInfo.theAxis.getTupleAt(0);
            if (tuple != null && (member = tuple.getMemberAt(fInfo.tupleMemberIndex)) != null) {
                return this.convertValue(jrField, member.getCaption());
            }
        }
        return null;
    }

    class fieldInfo {
        Axis theAxis;
        boolean isMeasure;
        int measureIndex;
        int tupleMemberIndex;
        int tupleIndex;

        fieldInfo(Axis theAxis, int tupleIndex, int tupleMemberIndex) {
            this.theAxis = theAxis;
            this.tupleIndex = tupleIndex;
            this.tupleMemberIndex = tupleMemberIndex;
            this.isMeasure = false;
            this.measureIndex = -1;
        }

        fieldInfo(Axis theAxis, int tupleIndex, int tupleMemberIndex, int measureIndex) {
            this.theAxis = theAxis;
            this.tupleIndex = tupleIndex;
            this.tupleMemberIndex = tupleMemberIndex;
            this.measureIndex = measureIndex;
            this.isMeasure = true;
        }
    }
}

