/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.web.context.support.WebApplicationObjectSupport;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;

public abstract class AbstractCachingViewResolver
extends WebApplicationObjectSupport
implements ViewResolver {
    private boolean cache = true;
    private final Map viewCache = new HashMap();

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public boolean isCache() {
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View resolveViewName(String viewName, Locale locale) throws Exception {
        if (!this.isCache()) {
            this.logger.warn((Object)"View caching is SWITCHED OFF -- DEVELOPMENT SETTING ONLY: This can severely impair performance");
            return this.createView(viewName, locale);
        }
        String cacheKey = this.getCacheKey(viewName, locale);
        Map map = this.viewCache;
        synchronized (map) {
            View view = (View)this.viewCache.get(cacheKey);
            if (view == null) {
                view = this.createView(viewName, locale);
                this.viewCache.put(cacheKey, view);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Cached view '" + cacheKey + "'"));
                }
            }
            return view;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromCache(String viewName, Locale locale) {
        if (!this.cache) {
            this.logger.warn((Object)"View caching is SWITCHED OFF -- removal not necessary");
        } else {
            String cacheKey = this.getCacheKey(viewName, locale);
            Object cachedView = null;
            Map map = this.viewCache;
            synchronized (map) {
                this.viewCache.remove(cacheKey);
            }
            if (cachedView == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("No cached instance for view '" + cacheKey + "' was found"));
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Cach for view " + cacheKey + " has been cleared"));
            }
        }
    }

    protected String getCacheKey(String viewName, Locale locale) {
        return viewName + "_" + locale;
    }

    protected View createView(String viewName, Locale locale) throws Exception {
        return this.loadView(viewName, locale);
    }

    protected abstract View loadView(String var1, Locale var2) throws Exception;
}

