/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovyRuntimeException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class GroovyMBean
extends GroovyObjectSupport {
    private MBeanServerConnection server;
    private ObjectName name;
    private MBeanInfo beanInfo;
    private Map operations = new HashMap();

    public GroovyMBean(MBeanServerConnection server, ObjectName name) throws JMException, IOException {
        this.server = server;
        this.name = name;
        this.beanInfo = server.getMBeanInfo(name);
        MBeanOperationInfo[] operationInfos = this.beanInfo.getOperations();
        for (int i = 0; i < operationInfos.length; ++i) {
            MBeanOperationInfo info = operationInfos[i];
            this.operations.put(info.getName(), this.createSignature(info));
        }
    }

    public MBeanServerConnection server() {
        return this.server;
    }

    public ObjectName name() {
        return this.name;
    }

    public MBeanInfo info() {
        return this.beanInfo;
    }

    public Object getProperty(String property) {
        try {
            return this.server.getAttribute(this.name, property);
        }
        catch (MBeanException e) {
            throw new GroovyRuntimeException("Could not access property: " + property + ". Reason: " + e, e.getTargetException());
        }
        catch (Exception e) {
            throw new GroovyRuntimeException("Could not access property: " + property + ". Reason: " + e, e);
        }
    }

    public void setProperty(String property, Object value) {
        try {
            this.server.setAttribute(this.name, new Attribute(property, value));
        }
        catch (MBeanException e) {
            throw new GroovyRuntimeException("Could not set property: " + property + ". Reason: " + e, e.getTargetException());
        }
        catch (Exception e) {
            throw new GroovyRuntimeException("Could not set property: " + property + ". Reason: " + e, e);
        }
    }

    public Object invokeMethod(String method, Object arguments) {
        String[] signature = (String[])this.operations.get(method);
        if (signature != null) {
            Object[] argArray = null;
            argArray = arguments instanceof Object[] ? (Object[])arguments : new Object[]{arguments};
            try {
                return this.server.invoke(this.name, method, argArray, signature);
            }
            catch (MBeanException e) {
                throw new GroovyRuntimeException("Could not invoke method: " + method + ". Reason: " + e, e.getTargetException());
            }
            catch (Exception e) {
                throw new GroovyRuntimeException("Could not invoke method: " + method + ". Reason: " + e, e);
            }
        }
        return super.invokeMethod(method, arguments);
    }

    protected String[] createSignature(MBeanOperationInfo info) {
        MBeanParameterInfo[] params = info.getSignature();
        String[] answer = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            answer[i] = params[i].getType();
        }
        return answer;
    }
}

