/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRBreak;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JREllipse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLine;
import net.sf.jasperreports.engine.JRRectangle;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.base.JRBaseBox;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.export.TextRenderer;
import net.sf.jasperreports.engine.fill.TextMeasurer;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import org.xml.sax.SAXException;

public class JRDesignRenderer {
    private static final double THIN_CORNER_OFFSET = 0.25;
    private static final double ONE_POINT_CORNER_OFFSET = 0.5;
    private static final Stroke STROKE_THIN = new BasicStroke(0.5f);
    private static final Stroke STROKE_1_POINT = new BasicStroke(1.0f);
    private static final Stroke STROKE_2_POINT = new BasicStroke(2.0f);
    private static final Stroke STROKE_4_POINT = new BasicStroke(4.0f);
    private static final Stroke STROKE_DOTTED = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{5.0f, 3.0f}, 0.0f);
    private static final Stroke BORDER_STROKE_THIN = new BasicStroke(0.5f, 0, 0);
    private static final Stroke BORDER_STROKE_1_POINT = new BasicStroke(1.0f, 0, 0);
    private static final Stroke BORDER_STROKE_DOTTED = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{5.0f, 3.0f}, 0.0f);
    protected JRReport report;
    protected ImageObserver imageObserver;
    protected int offsetY;
    protected int upColumns;
    protected int downColumns;
    protected JRStyledTextParser styledTextParser = new JRStyledTextParser();
    protected TextRenderer textRenderer = TextRenderer.getInstance();
    private static final ThreadLocal threadZoom = new ThreadLocal();

    public JRDesignRenderer(JRReport report, ImageObserver imageObserver) {
        this.report = report;
        this.imageObserver = imageObserver;
        this.setOffsetY();
    }

    private void setOffsetY() {
        int i;
        this.offsetY = this.report.getTopMargin();
        this.offsetY += this.report.getTitle() != null ? this.report.getTitle().getHeight() : 0;
        this.offsetY += this.report.getPageHeader() != null ? this.report.getPageHeader().getHeight() : 0;
        this.upColumns = this.offsetY;
        this.offsetY += this.report.getColumnHeader() != null ? this.report.getColumnHeader().getHeight() : 0;
        JRGroup group = null;
        JRGroup[] groups = this.report.getGroups();
        if (groups != null && groups.length > 0) {
            for (i = 0; i < groups.length; ++i) {
                group = groups[i];
                this.offsetY += group.getGroupHeader() != null ? group.getGroupHeader().getHeight() : 0;
            }
        }
        this.offsetY += this.report.getDetail() != null ? this.report.getDetail().getHeight() : 0;
        if (groups != null && groups.length > 0) {
            for (i = groups.length - 1; i >= 0; --i) {
                group = groups[i];
                this.offsetY += group.getGroupFooter() != null ? group.getGroupFooter().getHeight() : 0;
            }
        }
        this.offsetY += this.report.getColumnFooter() != null ? this.report.getColumnFooter().getHeight() : 0;
        this.downColumns = this.offsetY;
        this.offsetY += this.report.getPageFooter() != null ? this.report.getPageFooter().getHeight() : 0;
        this.offsetY += this.report.getLastPageFooter() != null ? this.report.getLastPageFooter().getHeight() : 0;
        this.offsetY += this.report.getSummary() != null ? this.report.getSummary().getHeight() : 0;
        this.offsetY += this.report.getBottomMargin();
    }

    public JRReport getReport() {
        return this.report;
    }

    public RenderDimesion getDimension(float zoom) {
        RenderDimesion dim = new RenderDimesion((int)((float)this.report.getPageWidth() * zoom) + 1, (int)((float)this.offsetY * zoom) + 1);
        return dim;
    }

    public Image renderToImage(float zoom) {
        RenderDimesion dim = this.getDimension(zoom);
        BufferedImage designImage = new BufferedImage(dim.width, dim.height, 1);
        Graphics2D grx = (Graphics2D)((Image)designImage).getGraphics();
        grx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        grx.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        grx.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        AffineTransform atrans = new AffineTransform();
        atrans.scale(zoom, zoom);
        grx.transform(atrans);
        this.render(grx, zoom);
        grx.dispose();
        return designImage;
    }

    public void render(Graphics2D grx) {
        this.render(grx, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Graphics2D grx, float zoom) {
        this.setZoom(zoom);
        try {
            this.renderDesign(grx);
        }
        finally {
            this.resetZoom();
        }
    }

    protected void renderDesign(Graphics2D grx) {
        int i;
        BasicStroke dashedStroke = new BasicStroke(1.0f / this.getZoom(), 0, 2, 0.0f, new float[]{5.0f, 3.0f}, 0.0f);
        Color dashedColor = new Color(170, 170, 255);
        grx.setColor(Color.white);
        grx.fillRect(0, 0, this.report.getPageWidth() + 1, this.offsetY + 1);
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(this.report.getLeftMargin(), 0, this.report.getLeftMargin(), this.offsetY + 1);
        grx.drawLine(this.report.getPageWidth() - this.report.getRightMargin(), 0, this.report.getPageWidth() - this.report.getRightMargin(), this.offsetY + 1);
        grx.drawLine(this.report.getLeftMargin() + this.report.getColumnWidth(), this.upColumns, this.report.getLeftMargin() + this.report.getColumnWidth(), this.downColumns);
        grx.drawLine(this.report.getLeftMargin() + this.report.getColumnWidth() + this.report.getColumnSpacing(), this.upColumns, this.report.getLeftMargin() + this.report.getColumnWidth() + this.report.getColumnSpacing(), this.downColumns);
        grx.translate(this.report.getLeftMargin(), this.report.getTopMargin());
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        grx.setColor(Color.black);
        grx.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getTitle(), grx);
        grx.translate(0, this.report.getTitle() != null ? this.report.getTitle().getHeight() : 0);
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        grx.setColor(Color.black);
        grx.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getPageHeader(), grx);
        grx.translate(0, this.report.getPageHeader() != null ? this.report.getPageHeader().getHeight() : 0);
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        grx.setColor(Color.black);
        grx.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getColumnHeader(), grx);
        grx.translate(0, this.report.getColumnHeader() != null ? this.report.getColumnHeader().getHeight() : 0);
        JRGroup group = null;
        JRGroup[] groups = this.report.getGroups();
        if (groups != null && groups.length > 0) {
            for (i = 0; i < groups.length; ++i) {
                group = groups[i];
                grx.setStroke(dashedStroke);
                grx.setColor(dashedColor);
                grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
                grx.setColor(Color.black);
                grx.setStroke(new BasicStroke(1.0f));
                this.printBand(group.getGroupHeader(), grx);
                grx.translate(0, group.getGroupHeader() != null ? group.getGroupHeader().getHeight() : 0);
            }
        }
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        grx.setColor(Color.black);
        grx.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getDetail(), grx);
        grx.translate(0, this.report.getDetail() != null ? this.report.getDetail().getHeight() : 0);
        if (groups != null && groups.length > 0) {
            for (i = groups.length - 1; i >= 0; --i) {
                group = groups[i];
                grx.setStroke(dashedStroke);
                grx.setColor(dashedColor);
                grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
                grx.setColor(Color.black);
                grx.setStroke(new BasicStroke(1.0f));
                this.printBand(group.getGroupFooter(), grx);
                grx.translate(0, group.getGroupFooter() != null ? group.getGroupFooter().getHeight() : 0);
            }
        }
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        grx.setColor(Color.black);
        grx.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getColumnFooter(), grx);
        grx.translate(0, this.report.getColumnFooter() != null ? this.report.getColumnFooter().getHeight() : 0);
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        grx.setColor(Color.black);
        grx.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getPageFooter(), grx);
        grx.translate(0, this.report.getPageFooter() != null ? this.report.getPageFooter().getHeight() : 0);
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        grx.setColor(Color.black);
        grx.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getLastPageFooter(), grx);
        grx.translate(0, this.report.getLastPageFooter() != null ? this.report.getLastPageFooter().getHeight() : 0);
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        grx.setColor(Color.black);
        grx.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getSummary(), grx);
        grx.translate(0, this.report.getSummary() != null ? this.report.getSummary().getHeight() : 0);
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
    }

    protected void printBand(JRBand band, Graphics2D grx) {
        if (band != null) {
            this.printElements(band.getElements(), grx);
        }
    }

    protected void printElements(JRElement[] elements, Graphics2D grx) {
        if (elements != null && elements.length > 0) {
            for (int i = 0; i < elements.length; ++i) {
                JRElement element = elements[i];
                if (element instanceof JRBreak) {
                    this.printBreak((JRBreak)element, grx);
                    continue;
                }
                if (element instanceof JRLine) {
                    this.printLine((JRLine)element, grx);
                    continue;
                }
                if (element instanceof JRRectangle) {
                    this.printRectangle((JRRectangle)element, grx);
                    continue;
                }
                if (element instanceof JREllipse) {
                    this.printEllipse((JREllipse)element, grx);
                    continue;
                }
                if (element instanceof JRImage) {
                    this.printImage((JRImage)element, grx);
                    continue;
                }
                if (element instanceof JRStaticText) {
                    this.printText((JRTextElement)element, grx);
                    continue;
                }
                if (element instanceof JRTextField) {
                    this.printText((JRTextElement)element, grx);
                    continue;
                }
                if (element instanceof JRSubreport) {
                    this.printSubreport((JRSubreport)element, grx);
                    continue;
                }
                if (element instanceof JRChart) {
                    this.printChart((JRChart)element, grx);
                    continue;
                }
                if (element instanceof JRCrosstab) {
                    this.printCrosstab((JRCrosstab)element, grx);
                    continue;
                }
                if (!(element instanceof JRFrame)) continue;
                this.printFrame((JRFrame)element, grx);
            }
        }
    }

    protected void printBreak(JRBreak breakElement, Graphics2D grx) {
        grx.setColor(breakElement.getForecolor());
        grx.setStroke(JRDesignRenderer.getStroke((byte)4));
        grx.drawLine(0, breakElement.getY(), this.report.getColumnWidth(), breakElement.getY());
    }

    protected static Stroke getStroke(byte pen) {
        switch (pen) {
            case 4: {
                return STROKE_DOTTED;
            }
            case 3: {
                return STROKE_4_POINT;
            }
            case 2: {
                return STROKE_2_POINT;
            }
            case 0: {
                return null;
            }
            case 5: {
                return STROKE_THIN;
            }
        }
        return STROKE_1_POINT;
    }

    protected void printLine(JRLine line, Graphics2D grx) {
        grx.setColor(line.getForecolor());
        Stroke stroke = JRDesignRenderer.getStroke(line.getPen());
        if (stroke != null) {
            grx.setStroke(stroke);
            grx.translate(0.5, 0.5);
            if (line.getDirection() == 1) {
                grx.drawLine(line.getX(), line.getY(), line.getX() + line.getWidth() - 1, line.getY() + line.getHeight() - 1);
            } else {
                grx.drawLine(line.getX(), line.getY() + line.getHeight() - 1, line.getX() + line.getWidth() - 1, line.getY());
            }
            grx.translate(-0.5, -0.5);
        }
    }

    protected void printRectangle(JRRectangle rectangle, Graphics2D grx) {
        if (rectangle.getMode() == 1) {
            grx.setColor(rectangle.getBackcolor());
            if (rectangle.getRadius() > 0) {
                grx.fillRoundRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight(), 2 * rectangle.getRadius(), 2 * rectangle.getRadius());
            } else {
                grx.fillRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
            }
        }
        grx.setColor(rectangle.getForecolor());
        byte pen = rectangle.getPen();
        Stroke stroke = JRDesignRenderer.getStroke(pen);
        if (stroke != null) {
            double cornerOffset = this.getBorderCornerOffset(pen);
            int sizeAdjust = this.getRectangleSizeAdjust(pen);
            AffineTransform transform = grx.getTransform();
            grx.translate((double)rectangle.getX() + cornerOffset, (double)rectangle.getY() + cornerOffset);
            if (pen == 5) {
                grx.scale(((double)rectangle.getWidth() - 0.5) / (double)rectangle.getWidth(), ((double)rectangle.getHeight() - 0.5) / (double)rectangle.getHeight());
            }
            grx.setStroke(stroke);
            if (rectangle.getRadius() > 0) {
                grx.drawRoundRect(0, 0, rectangle.getWidth() - sizeAdjust, rectangle.getHeight() - sizeAdjust, 2 * rectangle.getRadius(), 2 * rectangle.getRadius());
            } else {
                grx.drawRect(0, 0, rectangle.getWidth() - sizeAdjust, rectangle.getHeight() - sizeAdjust);
            }
            grx.setTransform(transform);
        }
    }

    protected double getBorderCornerOffset(byte pen) {
        switch (pen) {
            case 5: {
                return 0.25;
            }
            case 1: 
            case 4: {
                return 0.5;
            }
        }
        return 0.0;
    }

    protected int getRectangleSizeAdjust(byte pen) {
        switch (pen) {
            case 1: 
            case 4: {
                return 1;
            }
        }
        return 0;
    }

    protected void printEllipse(JREllipse ellipse, Graphics2D grx) {
        if (ellipse.getMode() == 1) {
            grx.setColor(ellipse.getBackcolor());
            grx.fillOval(ellipse.getX(), ellipse.getY(), ellipse.getWidth(), ellipse.getHeight());
        }
        grx.setColor(ellipse.getForecolor());
        byte pen = ellipse.getPen();
        Stroke stroke = JRDesignRenderer.getStroke(pen);
        if (stroke != null) {
            double cornerOffset = this.getBorderCornerOffset(pen);
            int sizeAdjust = this.getRectangleSizeAdjust(pen);
            AffineTransform transform = grx.getTransform();
            grx.translate((double)ellipse.getX() + cornerOffset, (double)ellipse.getY() + cornerOffset);
            if (pen == 5) {
                grx.scale(((double)ellipse.getWidth() - 0.5) / (double)ellipse.getWidth(), ((double)ellipse.getHeight() - 0.5) / (double)ellipse.getHeight());
            }
            grx.setStroke(stroke);
            grx.drawOval(0, 0, ellipse.getWidth() - sizeAdjust, ellipse.getHeight() - sizeAdjust);
            grx.setTransform(transform);
        }
    }

    protected void printImage(JRImage jrImage, Graphics2D grx) {
        if (jrImage.getMode() == 1) {
            grx.setColor(jrImage.getBackcolor());
            grx.fillRect(jrImage.getX(), jrImage.getY(), jrImage.getWidth(), jrImage.getHeight());
        }
        int topPadding = jrImage.getTopPadding();
        int leftPadding = jrImage.getLeftPadding();
        int bottomPadding = jrImage.getBottomPadding();
        int rightPadding = jrImage.getRightPadding();
        int availableImageWidth = jrImage.getWidth() - leftPadding - rightPadding;
        availableImageWidth = availableImageWidth < 0 ? 0 : availableImageWidth;
        int availableImageHeight = jrImage.getHeight() - topPadding - bottomPadding;
        int n = availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
        if (availableImageWidth > 0 && availableImageHeight > 0) {
            String location;
            JRExpressionChunk firstChunk;
            Image awtImage = null;
            JRExpression jrExpression = jrImage.getExpression();
            if (jrExpression != null && jrExpression.getChunks().length == 1 && (firstChunk = jrExpression.getChunks()[0]).getType() == 1 && (location = firstChunk.getText().trim()).startsWith("\"") && location.endsWith("\"")) {
                location = location.substring(1, location.length() - 1);
                try {
                    awtImage = JRImageLoader.loadImage(JRLoader.loadBytesFromLocation(location));
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
            }
            if (awtImage != null) {
                int awtWidth = awtImage.getWidth(null);
                int awtHeight = awtImage.getHeight(null);
                float xalignFactor = 0.0f;
                switch (jrImage.getHorizontalAlignment()) {
                    case 3: {
                        xalignFactor = 1.0f;
                        break;
                    }
                    case 2: {
                        xalignFactor = 0.5f;
                        break;
                    }
                    default: {
                        xalignFactor = 0.0f;
                    }
                }
                float yalignFactor = 0.0f;
                switch (jrImage.getVerticalAlignment()) {
                    case 3: {
                        yalignFactor = 1.0f;
                        break;
                    }
                    case 2: {
                        yalignFactor = 0.5f;
                        break;
                    }
                    default: {
                        yalignFactor = 0.0f;
                    }
                }
                switch (jrImage.getScaleImage()) {
                    case 1: {
                        int xoffset = (int)(xalignFactor * (float)(availableImageWidth - awtWidth));
                        int yoffset = (int)(yalignFactor * (float)(availableImageHeight - awtHeight));
                        Shape clip = grx.getClip();
                        grx.clipRect(jrImage.getX() + leftPadding, jrImage.getY() + topPadding, availableImageWidth, availableImageHeight);
                        grx.drawImage(awtImage, jrImage.getX() + leftPadding + xoffset, jrImage.getY() + topPadding + yoffset, awtWidth, awtHeight, this.imageObserver);
                        grx.setClip(clip);
                        break;
                    }
                    case 2: {
                        grx.drawImage(awtImage, jrImage.getX() + leftPadding, jrImage.getY() + topPadding, availableImageWidth, availableImageHeight, this.imageObserver);
                        break;
                    }
                    default: {
                        if (jrImage.getHeight() > 0) {
                            double ratio = (double)awtWidth / (double)awtHeight;
                            if (ratio > (double)availableImageWidth / (double)availableImageHeight) {
                                awtWidth = availableImageWidth;
                                awtHeight = (int)((double)availableImageWidth / ratio);
                            } else {
                                awtWidth = (int)((double)availableImageHeight * ratio);
                                awtHeight = availableImageHeight;
                            }
                            int xoffset = (int)(xalignFactor * (float)(availableImageWidth - awtWidth));
                            int yoffset = (int)(yalignFactor * (float)(availableImageHeight - awtHeight));
                            grx.drawImage(awtImage, jrImage.getX() + leftPadding + xoffset, jrImage.getY() + topPadding + yoffset, awtWidth, awtHeight, this.imageObserver);
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else {
                try {
                    awtImage = JRImageLoader.getImage((byte)1);
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
                Shape clip = grx.getClip();
                grx.clipRect(jrImage.getX() + leftPadding, jrImage.getY() + topPadding, availableImageWidth, availableImageHeight);
                grx.drawImage(awtImage, jrImage.getX() + leftPadding + 2, jrImage.getY() + topPadding + 2, awtImage.getWidth(null), awtImage.getHeight(null), this.imageObserver);
                grx.setClip(clip);
            }
        }
        if (jrImage.getTopBorder() == 0 && jrImage.getLeftBorder() == 0 && jrImage.getBottomBorder() == 0 && jrImage.getRightBorder() == 0) {
            if (jrImage.getPen() != 0) {
                JRBaseBox box = new JRBaseBox(jrImage.getPen(), jrImage.getForecolor());
                this.printBox(box, jrImage, grx);
            }
        } else {
            this.printBox(jrImage, jrImage, grx);
        }
    }

    protected void printBox(JRBox box, JRElement element, Graphics2D grx) {
        this.printBox(box, element.getForecolor(), element.getX(), element.getY(), element.getWidth(), element.getHeight(), grx);
    }

    protected void printBox(JRBox box, Color defaultBorderColor, int x, int y, int width, int height, Graphics2D grx) {
        double cornerOffset;
        Stroke topStroke = null;
        Stroke leftStroke = null;
        Stroke bottomStroke = null;
        Stroke rightStroke = null;
        if (box != null) {
            topStroke = this.getBorderStroke(box.getTopBorder());
            leftStroke = this.getBorderStroke(box.getLeftBorder());
            bottomStroke = this.getBorderStroke(box.getBottomBorder());
            rightStroke = this.getBorderStroke(box.getRightBorder());
        }
        if (topStroke != null) {
            cornerOffset = this.getBorderCornerOffset(box.getTopBorder());
            grx.setStroke(topStroke);
            grx.setColor(box.getTopBorderColor() == null ? defaultBorderColor : box.getTopBorderColor());
            grx.translate(0.0, cornerOffset);
            grx.drawLine(x, y, x + width, y);
            grx.translate(0.0, -cornerOffset);
        }
        if (leftStroke != null) {
            cornerOffset = this.getBorderCornerOffset(box.getLeftBorder());
            grx.setStroke(leftStroke);
            grx.setColor(box.getLeftBorderColor() == null ? defaultBorderColor : box.getLeftBorderColor());
            grx.translate(cornerOffset, 0.0);
            grx.drawLine(x, y, x, y + height);
            grx.translate(-cornerOffset, 0.0);
        }
        if (bottomStroke != null) {
            cornerOffset = this.getBorderCornerOffset(box.getBottomBorder());
            grx.setStroke(bottomStroke);
            grx.setColor(box.getBottomBorderColor() == null ? defaultBorderColor : box.getBottomBorderColor());
            grx.translate(0.0, -cornerOffset);
            grx.drawLine(x, y + height, x + width, y + height);
            grx.translate(0.0, cornerOffset);
        }
        if (rightStroke != null) {
            cornerOffset = this.getBorderCornerOffset(box.getRightBorder());
            grx.setStroke(rightStroke);
            grx.setColor(box.getRightBorderColor() == null ? defaultBorderColor : box.getRightBorderColor());
            grx.translate(-cornerOffset, 0.0);
            grx.drawLine(x + width, y, x + width, y + height);
            grx.translate(cornerOffset, 0.0);
        }
        if (topStroke == null && leftStroke == null && bottomStroke == null && rightStroke == null) {
            grx.setColor(defaultBorderColor);
            grx.setStroke(new BasicStroke(1.0f / this.getZoom()));
            grx.drawRect(x, y, width, height);
        }
    }

    protected Stroke getBorderStroke(byte pen) {
        switch (pen) {
            case 4: {
                return BORDER_STROKE_DOTTED;
            }
            case 3: {
                return STROKE_4_POINT;
            }
            case 2: {
                return STROKE_2_POINT;
            }
            case 0: {
                return null;
            }
            case 5: {
                return BORDER_STROKE_THIN;
            }
        }
        return BORDER_STROKE_1_POINT;
    }

    protected void printText(JRTextElement text, Graphics2D grx) {
        JRStyledText styledText = this.getStyledText(text);
        if (styledText == null) {
            return;
        }
        String allText = styledText.getText();
        int x = text.getX();
        int y = text.getY();
        int width = text.getWidth();
        int height = text.getHeight();
        int topPadding = text.getTopPadding();
        int leftPadding = text.getLeftPadding();
        int bottomPadding = text.getBottomPadding();
        int rightPadding = text.getRightPadding();
        double angle = 0.0;
        switch (text.getRotation()) {
            case 1: {
                y = text.getY() + text.getHeight();
                width = text.getHeight();
                height = text.getWidth();
                int tmpPadding = topPadding;
                topPadding = leftPadding;
                leftPadding = bottomPadding;
                bottomPadding = rightPadding;
                rightPadding = tmpPadding;
                angle = -1.5707963267948966;
                break;
            }
            case 2: {
                x = text.getX() + text.getWidth();
                width = text.getHeight();
                height = text.getWidth();
                int tmpPadding = topPadding;
                topPadding = rightPadding;
                rightPadding = bottomPadding;
                bottomPadding = leftPadding;
                leftPadding = tmpPadding;
                angle = 1.5707963267948966;
                break;
            }
            case 3: {
                x = text.getX() + text.getWidth();
                y = text.getY() + text.getHeight();
                int tmpPadding = topPadding;
                topPadding = bottomPadding;
                bottomPadding = tmpPadding;
                tmpPadding = leftPadding;
                leftPadding = rightPadding;
                rightPadding = tmpPadding;
                angle = Math.PI;
                break;
            }
        }
        grx.rotate(angle, x, y);
        if (text.getMode() == 1) {
            grx.setColor(text.getBackcolor());
            grx.fillRect(x, y, width, height);
        }
        grx.setColor(text.getForecolor());
        TextMeasurer textMeasurer = new TextMeasurer(text);
        textMeasurer.measure(styledText, allText, 0, 0);
        this.textRenderer.render(grx, x, y, width, height, topPadding, leftPadding, bottomPadding, rightPadding, textMeasurer.getTextHeight(), text.getHorizontalAlignment(), text.getVerticalAlignment(), textMeasurer.getLineSpacingFactor(), textMeasurer.getLeadingOffset(), text.getFontSize(), text.isStyledText(), styledText, allText);
        grx.rotate(-angle, x, y);
        this.printBox(text, text, grx);
    }

    protected JRStyledText getStyledText(JRTextElement textElement) {
        JRExpression textExpression;
        JRStyledText styledText = null;
        String text = null;
        if (textElement instanceof JRStaticText) {
            text = ((JRStaticText)textElement).getText();
        } else if (textElement instanceof JRTextField && (textExpression = ((JRTextField)textElement).getExpression()) != null) {
            text = textExpression.getText();
        }
        if (text == null) {
            text = "";
        }
        HashMap<TextAttribute, Color> attributes = new HashMap<TextAttribute, Color>();
        JRFontUtil.setAttributes(attributes, textElement);
        attributes.put(TextAttribute.FOREGROUND, textElement.getForecolor());
        if (textElement instanceof JRStaticText && textElement.isStyledText()) {
            try {
                styledText = this.styledTextParser.parse(attributes, text);
            }
            catch (SAXException e) {
                // empty catch block
            }
        }
        if (styledText == null) {
            styledText = new JRStyledText();
            styledText.append(text);
            styledText.addRun(new JRStyledText.Run(attributes, 0, text.length()));
        }
        return styledText;
    }

    protected void printSubreport(JRSubreport subreport, Graphics2D grx) {
        if (subreport.getMode() == 1) {
            grx.setColor(subreport.getBackcolor());
            grx.fillRect(subreport.getX(), subreport.getY(), subreport.getWidth(), subreport.getHeight());
        }
        Image image = null;
        try {
            image = JRImageLoader.getImage((byte)2);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
        Shape clip = grx.getClip();
        grx.clipRect(subreport.getX(), subreport.getY(), subreport.getWidth(), subreport.getHeight());
        grx.drawImage(image, subreport.getX() + 2, subreport.getY() + 2, image.getWidth(null), image.getHeight(null), this.imageObserver);
        grx.setClip(clip);
        grx.setColor(subreport.getForecolor());
        grx.setStroke(new BasicStroke(1.0f / this.getZoom()));
        grx.drawRect(subreport.getX(), subreport.getY(), subreport.getWidth() - 1, subreport.getHeight() - 1);
    }

    private void printChart(JRChart chart, Graphics2D grx) {
        if (chart.getMode() == 1) {
            grx.setColor(chart.getBackcolor());
            grx.fillRect(chart.getX(), chart.getY(), chart.getWidth(), chart.getHeight());
        }
        Image image = null;
        try {
            image = JRImageLoader.getImage((byte)3);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
        grx.setClip(chart.getX(), chart.getY(), chart.getWidth(), chart.getHeight());
        grx.drawImage(image, chart.getX() + 2, chart.getY() + 2, image.getWidth(null), image.getHeight(null), this.imageObserver);
        grx.setClip(-this.report.getLeftMargin(), 0, this.report.getPageWidth(), this.report.getPageHeight());
        grx.setColor(chart.getForecolor());
        grx.setStroke(new BasicStroke(1.0f / this.getZoom()));
        grx.drawRect(chart.getX(), chart.getY(), chart.getWidth() - 1, chart.getHeight() - 1);
    }

    protected void printFrame(JRFrame frame, Graphics2D grx) {
        if (frame.getMode() == 1) {
            grx.setColor(frame.getBackcolor());
            grx.fillRect(frame.getX(), frame.getY(), frame.getWidth(), frame.getHeight());
        }
        int topPadding = frame.getTopPadding();
        int leftPadding = frame.getLeftPadding();
        grx.translate(frame.getX() + leftPadding, frame.getY() + topPadding);
        this.printElements(frame.getElements(), grx);
        grx.translate(-(frame.getX() + leftPadding), -(frame.getY() + topPadding));
        this.printBox(frame, frame, grx);
    }

    protected void printCrosstab(JRCrosstab crosstab, Graphics2D grx) {
        grx.setClip(crosstab.getX(), crosstab.getY(), crosstab.getWidth(), crosstab.getHeight());
        JRCrosstabRowGroup[] rowGroups = crosstab.getRowGroups();
        int rowHeadersXOffset = 0;
        for (int i = 0; i < rowGroups.length; ++i) {
            rowHeadersXOffset += rowGroups[i].getWidth();
        }
        JRCrosstabColumnGroup[] columnGroups = crosstab.getColumnGroups();
        int colHeadersYOffset = 0;
        for (int i = 0; i < columnGroups.length; ++i) {
            colHeadersYOffset += columnGroups[i].getHeight();
        }
        JRCellContents headerCell = crosstab.getHeaderCell();
        if (headerCell != null) {
            grx.translate(crosstab.getX(), crosstab.getY());
            this.printCellContents(headerCell, grx, 0, 0, false, false);
            grx.translate(-crosstab.getX(), -crosstab.getY());
        }
        grx.translate(crosstab.getX() + rowHeadersXOffset, crosstab.getY());
        this.printCrosstabColumnHeaders(crosstab, grx);
        grx.translate(-(crosstab.getX() + rowHeadersXOffset), -crosstab.getY());
        grx.translate(crosstab.getX(), crosstab.getY() + colHeadersYOffset);
        this.printCrosstabRows(crosstab, grx, rowHeadersXOffset);
        grx.translate(-crosstab.getX(), -(crosstab.getY() + colHeadersYOffset));
        grx.setClip(-this.report.getLeftMargin(), 0, this.report.getPageWidth(), this.report.getPageHeight());
    }

    protected void printCellContents(JRCellContents cell, Graphics2D grx, int x, int y, boolean left, boolean top) {
        if (cell.getWidth() == 0 || cell.getHeight() == 0) {
            return;
        }
        JRDesignFrame frame = this.createCrosstabCellFrame(cell, x, y, left, top);
        this.printFrame(frame, grx);
    }

    protected JRDesignFrame createCrosstabCellFrame(JRCellContents cell, int x, int y, boolean left, boolean top) {
        List children;
        JRDesignFrame frame = new JRDesignFrame(cell.getDefaultStyleProvider());
        frame.setX(x);
        frame.setY(y);
        frame.setWidth(cell.getWidth());
        frame.setHeight(cell.getHeight());
        frame.setMode(cell.getMode());
        frame.setBackcolor(cell.getBackcolor());
        frame.setStyle(cell.getStyle());
        JRBox box = cell.getBox();
        if (box != null) {
            boolean copyTop;
            frame.setBox(box);
            boolean copyLeft = left && box.getLeftBorder() == 0 && box.getRightBorder() != 0;
            boolean bl = copyTop = top && box.getTopBorder() == 0 && box.getBottomBorder() != 0;
            if (copyLeft) {
                frame.setLeftBorder(box.getRightBorder());
                frame.setLeftBorderColor(box.getRightBorderColor());
            }
            if (copyTop) {
                frame.setTopBorder(box.getBottomBorder());
                frame.setTopBorderColor(box.getBottomBorderColor());
            }
        }
        if ((children = cell.getChildren()) != null) {
            Iterator it = children.iterator();
            while (it.hasNext()) {
                JRChild child = (JRChild)it.next();
                if (child instanceof JRElement) {
                    frame.addElement((JRElement)child);
                    continue;
                }
                if (!(child instanceof JRElementGroup)) continue;
                frame.addElementGroup((JRElementGroup)child);
            }
        }
        return frame;
    }

    protected void printCrosstabColumnHeaders(JRCrosstab crosstab, Graphics2D grx) {
        JRCrosstabColumnGroup[] groups = crosstab.getColumnGroups();
        int x = 0;
        int y = 0;
        for (int i = 0; i < groups.length; ++i) {
            JRCrosstabColumnGroup group = groups[i];
            if (group.getTotalPosition() == 1) {
                JRCellContents totalHeader = group.getTotalHeader();
                this.printCellContents(totalHeader, grx, x, y, x == 0 && crosstab.getHeaderCell() == null, false);
                x += totalHeader.getWidth();
            }
            JRCellContents header = group.getHeader();
            this.printCellContents(header, grx, x, y, x == 0 && crosstab.getHeaderCell() == null, false);
            if (group.getTotalPosition() == 2) {
                JRCellContents totalHeader = group.getTotalHeader();
                this.printCellContents(totalHeader, grx, x + header.getWidth(), y, false, false);
            }
            y += group.getHeight();
        }
    }

    protected void printCrosstabRows(JRCrosstab crosstab, Graphics2D grx, int rowHeadersXOffset) {
        JRCrosstabRowGroup[] groups = crosstab.getRowGroups();
        int x = 0;
        int y = 0;
        for (int i = 0; i < groups.length; ++i) {
            JRCrosstabRowGroup group = groups[i];
            if (group.getTotalPosition() == 1) {
                JRCellContents totalHeader = group.getTotalHeader();
                this.printCellContents(totalHeader, grx, x, y, false, y == 0 && crosstab.getHeaderCell() == null);
                this.printCrosstabDataCellsRow(crosstab, grx, rowHeadersXOffset, y, i);
                y += totalHeader.getHeight();
            }
            JRCellContents header = group.getHeader();
            this.printCellContents(header, grx, x, y, false, y == 0 && crosstab.getHeaderCell() == null);
            if (i == groups.length - 1) {
                this.printCrosstabDataCellsRow(crosstab, grx, rowHeadersXOffset, y, groups.length);
            }
            if (group.getTotalPosition() == 2) {
                JRCellContents totalHeader = group.getTotalHeader();
                this.printCellContents(totalHeader, grx, x, y + header.getHeight(), false, false);
                this.printCrosstabDataCellsRow(crosstab, grx, rowHeadersXOffset, y + header.getHeight(), i);
            }
            x += group.getWidth();
        }
    }

    protected void printCrosstabDataCellsRow(JRCrosstab crosstab, Graphics2D grx, int rowOffsetX, int rowOffsetY, int rowIndex) {
        grx.translate(rowOffsetX, rowOffsetY);
        JRCrosstabColumnGroup[] colGroups = crosstab.getColumnGroups();
        JRCrosstabCell[][] cells = crosstab.getCells();
        int x = 0;
        for (int i = 0; i < colGroups.length; ++i) {
            JRCrosstabColumnGroup group = colGroups[i];
            if (group.getTotalPosition() == 1) {
                this.printCellContents(cells[rowIndex][i].getContents(), grx, x, 0, false, false);
                x += cells[rowIndex][i].getContents().getWidth();
            }
            if (i == colGroups.length - 1) {
                this.printCellContents(cells[rowIndex][colGroups.length].getContents(), grx, x, 0, false, false);
            }
            if (group.getTotalPosition() != 2) continue;
            this.printCellContents(cells[rowIndex][i].getContents(), grx, x + group.getHeader().getWidth(), 0, false, false);
        }
        grx.translate(-rowOffsetX, -rowOffsetY);
    }

    protected void setZoom(float zoom) {
        threadZoom.set(new Float(zoom));
    }

    protected float getZoom() {
        return ((Float)threadZoom.get()).floatValue();
    }

    protected void resetZoom() {
        threadZoom.set(null);
    }

    public static class RenderDimesion {
        public final int width;
        public final int height;

        public RenderDimesion(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }
}

