/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.IReportCompiler;
import it.businesslogic.ireport.ReportWriter;
import it.businesslogic.ireport.compiler.xml.SourceLocation;
import it.businesslogic.ireport.compiler.xml.SourceTraceDigester;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.event.ReportDocumentStatusChangedEvent;
import it.businesslogic.ireport.gui.event.ReportDocumentStatusChangedListener;
import it.businesslogic.ireport.gui.logpane.ProblemItem;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.design.JRValidationFault;
import net.sf.jasperreports.engine.design.JasperDesign;

public class DesignVerifyerThread
implements Runnable,
ReportDocumentStatusChangedListener {
    private boolean reportChanged = true;
    private Thread thisThread = null;
    private boolean stop = false;
    private JReportFrame jReportFrame = null;

    public DesignVerifyerThread(JReportFrame jReportFrame) {
        this.jReportFrame = jReportFrame;
        this.jReportFrame.getReport().addReportDocumentStatusChangedListener(this);
        this.thisThread = new Thread(this);
    }

    public void start() {
        this.thisThread.start();
    }

    public void stop() {
        this.setStop(true);
    }

    public void run() {
        while (!this.isStop()) {
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.getJReportFrame() == null || !this.isReportChanged() || MainFrame.getMainInstance().getActiveReportFrame() != this.getJReportFrame()) continue;
            this.setReportChanged(false);
            this.verifyDesign();
        }
    }

    public JReportFrame getJReportFrame() {
        return this.jReportFrame;
    }

    public void setJReportFrame(JReportFrame jReportFrame) {
        this.jReportFrame = jReportFrame;
    }

    public boolean isReportChanged() {
        return this.reportChanged;
    }

    public void setReportChanged(boolean reportChanged) {
        this.reportChanged = reportChanged;
    }

    public void reportDocumentStatusChanged(ReportDocumentStatusChangedEvent evt) {
        this.setReportChanged(true);
    }

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public void verifyDesign() {
        for (int i = 0; i < this.getJReportFrame().getReportProblems().size(); ++i) {
            ProblemItem pii = (ProblemItem)this.getJReportFrame().getReportProblems().get(i);
            if (pii.getProblemType() != 1) continue;
            this.getJReportFrame().getReportProblems().remove(i);
            --i;
        }
        try {
            SourceTraceDigester digester = IReportCompiler.createDigester();
            ReportWriter rw = new ReportWriter(this.getJReportFrame().getReport());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            rw.writeToOutputStream(baos);
            JasperDesign jd = IReportCompiler.loadJasperDesign(new ByteArrayInputStream(baos.toByteArray()), digester);
            Collection ls = JasperCompileManager.verifyDesign((JasperDesign)jd);
            Iterator iterator = ls.iterator();
            while (iterator.hasNext()) {
                JRValidationFault fault = (JRValidationFault)iterator.next();
                String s = fault.getMessage();
                SourceLocation sl = digester.getLocation(fault.getSource());
                this.getJReportFrame().getReportProblems().add(new ProblemItem(1, s, fault.getSource(), sl.getXPath()));
            }
        }
        catch (Exception ex) {
            this.getJReportFrame().getReportProblems().add(new ProblemItem(1, ex.getMessage(), null, null));
        }
        Runnable runner = new Runnable(){

            public void run() {
                MainFrame.getMainInstance().getLogPane().getProblemsPanel().setProblems(DesignVerifyerThread.this.getJReportFrame().getReportProblems());
            }
        };
        SwingUtilities.invokeLater(runner);
    }
}

