/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.connection;

import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.IReportConnectionEditor;
import it.businesslogic.ireport.connection.DriverPool;
import it.businesslogic.ireport.connection.gui.JDBCConnectionEditor;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.PasswordDialog;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;

public class JDBCConnection
extends IReportConnection {
    private String JDBCDriver;
    private String username;
    private String password = null;
    private String url;
    private String database;
    private boolean savePassword;
    private String name;
    private String serverAddress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() {
        try {
            MainFrame.getMainInstance().getReportClassLoader().rescanLibDirectory();
            try {
                DriverPool.registerDriver(this.getJDBCDriver(), MainFrame.getMainInstance().getReportClassLoader());
            }
            catch (Exception ex) {
                DriverPool.registerDriver(this.getJDBCDriver(), this.getClass().getClassLoader());
            }
            Driver driver = DriverPool.getDriver(this.url);
            Properties connectProps = new Properties();
            if ((this.password == null || this.password.equals("")) && !this.isSavePassword()) {
                this.password = this.getPassword();
            }
            connectProps.setProperty("user", this.username);
            connectProps.setProperty("password", this.password);
            Connection conn = driver.connect(this.url, connectProps);
            if (this.getJDBCDriver().toLowerCase().indexOf("oracle") >= 0 && (MainFrame.getMainInstance().getProperties().getProperty("oracle_language", "").trim().length() > 0 || MainFrame.getMainInstance().getProperties().getProperty("oracle_territory", "").trim().length() > 0)) {
                Statement stmt = null;
                try {
                    stmt = conn.createStatement();
                    if (MainFrame.getMainInstance().getProperties().getProperty("oracle_language", "").trim().length() > 0) {
                        stmt.execute("ALTER SESSION SET NLS_LANGUAGE = '" + MainFrame.getMainInstance().getProperties().getProperty("oracle_language", "").trim() + "'");
                    }
                    if (MainFrame.getMainInstance().getProperties().getProperty("oracle_territory", "").trim().length() > 0) {
                        stmt.execute("ALTER SESSION SET NLS_TERRITORY='" + MainFrame.getMainInstance().getProperties().getProperty("oracle_territory", "").trim() + "'");
                    }
                }
                catch (Exception ex) {
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            return conn;
        }
        catch (NoClassDefFoundError ex) {
            this.showErrorMessage(I18n.getFormattedString("messages.connection.noClassDefFoundError", "{0}\nNoClassDefFoundError!!\nCheck your classpath!\n{1}", new Object[]{"" + this.getName(), "" + ex.getMessage()}), I18n.getString("message.title.exception", "Exception"));
            return null;
        }
        catch (ClassNotFoundException ex) {
            this.showErrorMessage(I18n.getFormattedString("messages.connection.classNotFoundError", "{0}\nClassNotFoundError!\nMsg: {1}\nPossible not found class: {2}\nCheck your classpath!", new Object[]{"" + this.getName(), "" + ex.getMessage(), "" + this.getJDBCDriver()}), I18n.getString("message.title.exception", "Exception"));
            return null;
        }
        catch (SQLException ex) {
            if (!this.savePassword) {
                this.password = null;
            }
            this.showErrorMessage(I18n.getFormattedString("messages.connection.sqlError", "{0}\nSQL problems: {1}\n{2}", new Object[]{"" + this.getName(), "" + ex.getMessage(), "" + this.url}), I18n.getString("message.title.exception", "Exception"));
            return null;
        }
        catch (Exception ex) {
            this.showErrorMessage(I18n.getFormattedString("messages.connection.generalError", "{0}\nGeneral problem: {1}\nPlease check your username and password. The DBMS is running?!", new Object[]{"" + this.getName(), "" + ex.getMessage()}), I18n.getString("message.title.exception", "Exception"));
            return null;
        }
    }

    private void showErrorMessage(String errorMsg, final String title) {
        String[] lines = errorMsg.split("\r\n|\n|\r");
        if (lines.length > 25) {
            errorMsg = "";
            for (int i = 0; i < 25; ++i) {
                errorMsg = errorMsg + lines[i] + "\n";
            }
            errorMsg = errorMsg + "\n...";
        }
        final String fErrorMsg = errorMsg;
        Runnable r = new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(MainFrame.getMainInstance(), fErrorMsg, title, 0);
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        } else {
            r.run();
        }
    }

    public JRDataSource getJRDataSource() {
        return new JREmptyDataSource();
    }

    public boolean isJDBCConnection() {
        return true;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getJDBCDriver() {
        return this.JDBCDriver;
    }

    public void setJDBCDriver(String JDBCDriver) {
        this.JDBCDriver = JDBCDriver;
    }

    public String getPassword() {
        if (this.isSavePassword()) {
            return this.password;
        }
        try {
            return PasswordDialog.askPassword();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isSavePassword() {
        return this.savePassword;
    }

    public void setSavePassword(boolean savePassword) {
        this.savePassword = savePassword;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public HashMap getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("JDBCDriver", Misc.nvl(this.getJDBCDriver(), ""));
        map.put("Url", Misc.nvl(this.getUrl(), ""));
        map.put("Database", Misc.nvl(this.getDatabase(), ""));
        map.put("Username", Misc.nvl(this.getUsername(), ""));
        if (this.isSavePassword()) {
            map.put("Password", Misc.nvl(this.getPassword(), ""));
        } else {
            map.put("Password", "");
        }
        map.put("SavePassword", "" + this.isSavePassword());
        map.put("ServerAddress", Misc.nvl(this.getServerAddress(), ""));
        return map;
    }

    public void loadProperties(HashMap map) {
        this.setJDBCDriver((String)map.get("JDBCDriver"));
        this.setUrl((String)map.get("Url"));
        this.setDatabase((String)map.get("Database"));
        this.setUsername((String)map.get("Username"));
        this.setSavePassword(("" + map.get("SavePassword")).equals("true"));
        if (this.isSavePassword()) {
            this.setPassword(Misc.nvl((String)map.get("Password"), ""));
        }
        this.setServerAddress(Misc.nvl((String)map.get("ServerAddress"), ""));
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public String getDescription() {
        return I18n.getString("connectionType.jdbc", "Database JDBC connection");
    }

    public IReportConnectionEditor getIReportConnectionEditor() {
        return new JDBCConnectionEditor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() throws Exception {
        Connection conn = null;
        try {
            conn = this.getConnection();
            if (conn == null) {
                throw new Exception("");
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
        JOptionPane.showMessageDialog(MainFrame.getMainInstance(), I18n.getString("messages.connectionDialog.connectionTestSuccessful", "Connection test successful!"), "", 1);
    }
}

