/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.logpane;

import it.businesslogic.ireport.gui.logpane.LogTextArea;
import it.businesslogic.ireport.gui.logpane.ProblemsPanel;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.LanguageChangedListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;

public class LogPane
extends JPanel
implements ActionListener {
    private LogTextArea mainLogTextArea;
    private ProblemsPanel problemsPanel;
    private Vector logsComponents = new Vector();
    private LogTextArea pointedLogTextArea = null;
    private Properties properties;
    private JMenuItem jMenuItemClearLog;
    private JMenuItem jMenuItemCloseLog;
    private JMenuItem jMenuItemKeepLog;
    private JPopupMenu jPopupMenuLog;
    private JTabbedPane jTabbedPaneLogs;

    public LogPane() {
        this.initComponents();
        this.mainLogTextArea = new LogTextArea(I18n.getString("logPane.mainConsole", "Main console"));
        this.mainLogTextArea.setLogPane(this);
        this.mainLogTextArea.addActionListener(this);
        this.problemsPanel = new ProblemsPanel();
        this.jTabbedPaneLogs.add(this.mainLogTextArea.getTitle(), this.mainLogTextArea);
        this.jTabbedPaneLogs.add(this.problemsPanel.getName(), this.problemsPanel);
        this.add((Component)this.jTabbedPaneLogs, "Center");
        I18n.addOnLanguageChangedListener(new LanguageChangedListener(){

            public void languageChanged(LanguageChangedEvent evt) {
                LogPane.this.applyI18n();
            }
        });
        this.applyI18n();
    }

    protected void updateLogTabs() {
        int i;
        for (i = 2; i < this.jTabbedPaneLogs.getComponentCount(); ++i) {
            this.jTabbedPaneLogs.remove(i);
        }
        if (this.logsComponents.size() > 0) {
            for (i = 0; i < this.logsComponents.size(); ++i) {
                this.jTabbedPaneLogs.add(((LogTextArea)this.logsComponents.elementAt(i)).getTitle(), (LogTextArea)this.logsComponents.elementAt(i));
            }
        }
        this.updateUI();
    }

    private void initComponents() {
        this.jPopupMenuLog = new JPopupMenu();
        this.jMenuItemClearLog = new JMenuItem();
        this.jMenuItemCloseLog = new JMenuItem();
        this.jMenuItemKeepLog = new JMenuItem();
        this.jTabbedPaneLogs = new JTabbedPane();
        this.jMenuItemClearLog.setText("Clear log");
        this.jMenuItemClearLog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogPane.this.jMenuItemClearLogActionPerformed(evt);
            }
        });
        this.jPopupMenuLog.add(this.jMenuItemClearLog);
        this.jMenuItemCloseLog.setText("Close log");
        this.jMenuItemCloseLog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogPane.this.jMenuItemCloseLogActionPerformed(evt);
            }
        });
        this.jPopupMenuLog.add(this.jMenuItemCloseLog);
        this.jMenuItemKeepLog.setText("Keep log");
        this.jMenuItemKeepLog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogPane.this.jMenuItemKeepLogActionPerformed(evt);
            }
        });
        this.jPopupMenuLog.add(this.jMenuItemKeepLog);
        this.setLayout(new BorderLayout());
        this.jTabbedPaneLogs.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                LogPane.this.jTabbedPaneLogsMouseClicked(evt);
            }
        });
        this.add((Component)this.jTabbedPaneLogs, "Center");
    }

    private void jMenuItemKeepLogActionPerformed(ActionEvent evt) {
        this.pointedLogTextArea.setRemovable(false);
    }

    private void jMenuItemCloseLogActionPerformed(ActionEvent evt) {
        if (this.pointedLogTextArea != null && this.pointedLogTextArea != this.getMainLogTextArea()) {
            this.removeLog(this.pointedLogTextArea);
        }
    }

    private void jTabbedPaneLogsMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3 && evt.getClickCount() == 1) {
            if (this.jTabbedPaneLogs.getSelectedComponent() instanceof LogTextArea) {
                this.jPopupMenuLog.show(this, evt.getPoint().x, evt.getPoint().y);
                this.pointedLogTextArea = (LogTextArea)this.jTabbedPaneLogs.getSelectedComponent();
            } else {
                this.pointedLogTextArea = null;
            }
        }
    }

    private void jMenuItemClearLogActionPerformed(ActionEvent evt) {
        if (this.pointedLogTextArea != null) {
            this.pointedLogTextArea.clearConsole();
        }
    }

    public LogTextArea createNewLog() {
        LogTextArea lta = new LogTextArea(I18n.getString("logPane.log", "Log"));
        lta.setLogPane(this);
        lta.addActionListener(this);
        this.logsComponents.addElement(lta);
        for (int i = 0; i < this.logsComponents.size(); ++i) {
            Object component = this.logsComponents.elementAt(i);
            if (!(component instanceof LogTextArea) || !((LogTextArea)component).isRemovable()) continue;
            this.logsComponents.removeElementAt(i);
            --i;
        }
        this.updateLogTabs();
        return lta;
    }

    public void removeLog(LogTextArea logTextArea) {
        if (logTextArea.isRemovable()) {
            this.logsComponents.removeElement(logTextArea);
            this.updateLogTabs();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == null) {
            return;
        }
        for (int i = 2; i < this.jTabbedPaneLogs.getComponentCount(); ++i) {
            LogTextArea lta = (LogTextArea)this.jTabbedPaneLogs.getComponent(i);
            if (lta != actionEvent.getSource()) continue;
            this.jTabbedPaneLogs.setTitleAt(i, lta.getTitle());
            break;
        }
    }

    public LogTextArea getMainLogTextArea() {
        return this.mainLogTextArea;
    }

    public void setMainLogTextArea(LogTextArea mainLogTextArea) {
        this.mainLogTextArea = mainLogTextArea;
    }

    public void setActiveLog(LogTextArea c) {
        try {
            this.jTabbedPaneLogs.setSelectedComponent(c);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setActiveLogComponent(Component c) {
        try {
            this.jTabbedPaneLogs.setSelectedComponent(c);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void applyI18n() {
        this.jMenuItemCloseLog.setText(I18n.getString("logPane.menuItemCloseLog", "Close log"));
        this.jMenuItemKeepLog.setText(I18n.getString("logPane.menuItemKeepLog", "Keep log"));
        this.jMenuItemClearLog.setText(I18n.getString("clearLog", "Clear log"));
    }

    public void languageChanged(LanguageChangedEvent evt) {
        this.applyI18n();
    }

    public ProblemsPanel getProblemsPanel() {
        return this.problemsPanel;
    }

    public void setProblemsPanel(ProblemsPanel problemsPanel) {
        this.problemsPanel = problemsPanel;
    }
}

