/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.sheet;

import it.businesslogic.ireport.gui.JNumberComboBox;
import it.businesslogic.ireport.gui.JNumberField;
import it.businesslogic.ireport.gui.event.SheetPropertyValueChangedEvent;
import it.businesslogic.ireport.gui.event.SheetPropertyValueChangedListener;
import it.businesslogic.ireport.gui.sheet.ExpressionSheetPropertyComponent;
import it.businesslogic.ireport.gui.sheet.NumberComboBoxSheetProperty;
import it.businesslogic.ireport.gui.sheet.PatternSheetPropertyComponent;
import it.businesslogic.ireport.gui.sheet.ResetButton;
import it.businesslogic.ireport.gui.sheet.SheetProperty;
import it.businesslogic.ireport.gui.sheet.Tag;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.LanguageChangedListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;

public class CategorySheetPanel
extends JPanel
implements SheetPropertyValueChangedListener {
    public static final int VIEW_BY_CATEGORY = 1;
    public static final int VIEW_SORTED = 2;
    public static final int VIEW_UNSORTED = 3;
    public static final ImageIcon opened_icon = new ImageIcon(CategorySheetPanel.class.getResource("/it/businesslogic/ireport/icons/sheet/opened.png"));
    public static final ImageIcon closed_icon = new ImageIcon(CategorySheetPanel.class.getResource("/it/businesslogic/ireport/icons/sheet/closed.png"));
    private GridBagConstraints staticGridBagConstraints = null;
    private static final Dimension standardComponentDimension = new Dimension(50, 0);
    private static final Dimension dimension16x19 = new Dimension(16, 19);
    private static final Dimension dimension0x1 = new Dimension(0, 1);
    private static final EmptyBorder emptyBorder = new EmptyBorder(0, 0, 0, 0);
    private static final Insets inset0202 = new Insets(0, 2, 0, 2);
    private static final Insets inset0000 = new Insets(0, 0, 0, 0);
    private static final Dimension dimension41x18 = new Dimension(41, 18);
    private static final Color color_234_234_234 = new Color(234, 234, 234);
    private static GridBagConstraints spGridBagConstraints = new GridBagConstraints();
    protected Vector properties;
    protected Vector categories;
    protected HashMap propCategories;
    protected Vector compressedCategories;
    private int viewMode = 1;
    private int current_position = 0;
    private boolean showResetButton = true;
    private ButtonGroup buttonGroupToolbar;
    private JButton jButtonOrderByAlpha;
    private JButton jButtonOrderByCategory;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanelEditors;
    private JPanel jPanelFiller;
    private JPanel jPanelFillerEditors;
    private JPanel jPanelFillerLabels;
    private JPanel jPanelLabels;
    private JPanel jPanelSheet;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private EventListenerList listenerList = null;
    public String DIFFERENT_VALUES = "<different values>";

    public CategorySheetPanel() {
        this.initComponents();
        this.jPanel1.setBackground(color_234_234_234);
        this.properties = new Vector();
        this.categories = new Vector();
        this.propCategories = new HashMap();
        this.compressedCategories = new Vector();
        this.jSplitPane1.setResizeWeight(0.5);
        this.jPanelLabels.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanelEditors.setLayout(new GridBagLayout());
        this.staticGridBagConstraints = new GridBagConstraints();
        this.staticGridBagConstraints.gridx = 0;
        this.staticGridBagConstraints.gridy = 400;
        this.staticGridBagConstraints.weighty = 1.0;
        CategorySheetPanel.spGridBagConstraints.gridx = 0;
        CategorySheetPanel.spGridBagConstraints.gridy = 0;
        CategorySheetPanel.spGridBagConstraints.fill = 2;
        CategorySheetPanel.spGridBagConstraints.weightx = 1.0;
        CategorySheetPanel.spGridBagConstraints.insets = inset0000;
        this.recreateSheet();
        I18n.addOnLanguageChangedListener(new LanguageChangedListener(){

            public void languageChanged(LanguageChangedEvent evt) {
                CategorySheetPanel.this.updateUI();
            }
        });
        this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(19);
        this.applyI18n();
    }

    public Properties getPropertiesValues() {
        Properties prop = new Properties();
        for (int i = 0; i < this.getProperties().size(); ++i) {
            SheetProperty sp = (SheetProperty)this.getProperties().elementAt(i);
            Object value = "";
            value = this.getPropertyValue(i);
            if (value == null) continue;
            prop.setProperty(sp.getKeyName(), value + "");
        }
        return prop;
    }

    public void setPropertiesValues(Properties prop) {
        Enumeration<Object> enum_keys = prop.keys();
        while (enum_keys.hasMoreElements()) {
            String key = (String)enum_keys.nextElement();
            for (int i = 0; i < this.getProperties().size(); ++i) {
                SheetProperty sp = (SheetProperty)this.getProperties().elementAt(i);
                if (!sp.getKeyName().equals(key)) continue;
                String value = prop.getProperty(key);
                sp.setEditorValue((JComponent)this.jPanelEditors.getComponent(2 * i + 1), value);
            }
        }
    }

    public void setPropertyValue(String propertyName, Object value) {
        for (int i = 0; i < this.getProperties().size(); ++i) {
            SheetProperty sp = (SheetProperty)this.getProperties().elementAt(i);
            if (!sp.getKeyName().equals(propertyName)) continue;
            sp.setValue(value);
        }
    }

    public Object getPropertyValue(String propertyName) {
        for (int i = 0; i < this.getProperties().size(); ++i) {
            SheetProperty sp = (SheetProperty)this.getProperties().elementAt(i);
            if (!sp.getKeyName().equals(propertyName)) continue;
            return sp.getValue();
        }
        return null;
    }

    public Object getSheetProperty(String propertyName) {
        for (int i = 0; i < this.getProperties().size(); ++i) {
            SheetProperty sp = (SheetProperty)this.getProperties().elementAt(i);
            if (sp == null || !sp.getKeyName().equals(propertyName)) continue;
            return sp;
        }
        return null;
    }

    public Object getPropertyValue(int index) {
        SheetProperty sp = (SheetProperty)this.getProperties().elementAt(index);
        return sp.getValue();
    }

    public void removeAllProperties() {
        for (int i = 0; i < this.getProperties().size(); ++i) {
            SheetProperty sp = (SheetProperty)this.getProperties().elementAt(i);
            sp.removeSheetPropertyValueChangedListener(this);
        }
        this.getProperties().removeAllElements();
        this.categories.removeAllElements();
        this.propCategories.clear();
    }

    public void addSheetProperty(String category, SheetProperty sp) {
        this.properties.add(sp);
        Vector<SheetProperty> v_category = (Vector<SheetProperty>)this.propCategories.get(category);
        if (v_category == null) {
            v_category = new Vector<SheetProperty>();
            this.categories.add(category);
            this.propCategories.put(category, v_category);
        }
        v_category.add(sp);
    }

    public void recreateSheet() {
        this.current_position = 0;
        this.jPanelLabels.removeAll();
        this.jPanel1.removeAll();
        this.jPanelEditors.removeAll();
        this.jPanelEditors.setMinimumSize(standardComponentDimension);
        this.jPanelLabels.setMinimumSize(standardComponentDimension);
        if (this.getViewMode() == 1) {
            for (int i = 0; i < this.categories.size(); ++i) {
                this.addCategory("" + this.categories.elementAt(i));
            }
        } else if (this.getViewMode() == 3) {
            this.addItems(this.properties);
        } else {
            Vector items = this.getSortedProperties(this.properties);
            this.addItems(items);
        }
        this.jPanelSheet.setMinimumSize(new Dimension(16, 19 * this.current_position));
        this.jPanelSheet.setPreferredSize(new Dimension(16, 19 * this.current_position));
        this.jPanelEditors.add((Component)this.jPanelFillerEditors, this.staticGridBagConstraints);
        this.jPanelLabels.add((Component)this.jPanelFillerLabels, this.staticGridBagConstraints);
        this.jPanel1.add((Component)this.jPanelFiller, this.staticGridBagConstraints);
        this.jPanelLabels.updateUI();
        this.jPanelEditors.updateUI();
        this.jScrollPane1.updateUI();
    }

    protected void addItem(SheetProperty sp) {
        JComponent editor;
        JLabel jLabel;
        boolean setting;
        block15: {
            block14: {
                setting = sp.isSetting();
                sp.setSetting(true);
                sp.addSheetPropertyValueChangedListener(this);
                jLabel = new JLabel(sp.getName());
                if (sp.getType() != 99) {
                    jLabel.setToolTipText(sp.getName());
                } else {
                    jLabel.setText("<html><table><tr><td nowrap><b>" + sp.getName() + "</b></td></tr></table></html>");
                }
                jLabel.setMaximumSize(dimension41x18);
                jLabel.setMinimumSize(dimension41x18);
                jLabel.setPreferredSize(dimension41x18);
                CategorySheetPanel.spGridBagConstraints.gridx = 0;
                CategorySheetPanel.spGridBagConstraints.gridy = this.current_position * 2;
                CategorySheetPanel.spGridBagConstraints.fill = 2;
                CategorySheetPanel.spGridBagConstraints.weightx = 1.0;
                CategorySheetPanel.spGridBagConstraints.insets = inset0000;
                if (sp.getType() != 99) {
                    CategorySheetPanel.spGridBagConstraints.insets = inset0202;
                } else {
                    CategorySheetPanel.spGridBagConstraints.insets = inset0000;
                    jLabel.setBackground(color_234_234_234);
                    jLabel.setOpaque(true);
                }
                this.jPanelLabels.add((Component)jLabel, spGridBagConstraints);
                CategorySheetPanel.spGridBagConstraints.insets = inset0000;
                if (sp.getType() == 99) {
                    JLabel b = new JLabel(!this.compressedCategories.contains(sp.getName()) ? opened_icon : closed_icon);
                    b.setName(sp.getName());
                    b.setMinimumSize(dimension16x19);
                    b.setMaximumSize(dimension16x19);
                    b.setPreferredSize(dimension16x19);
                    b.setBorder(emptyBorder);
                    b.setOpaque(false);
                    this.jPanel1.add((Component)b, spGridBagConstraints);
                    b.addMouseListener(new MouseAdapter(){

                        public void mouseClicked(MouseEvent evt) {
                            CategorySheetPanel.this.categoryClicked(evt);
                        }
                    });
                } else {
                    JPanel p = new JPanel();
                    p.setMinimumSize(dimension16x19);
                    p.setMaximumSize(dimension16x19);
                    p.setPreferredSize(dimension16x19);
                    p.setBorder(emptyBorder);
                    p.setOpaque(false);
                    this.jPanel1.add((Component)p, spGridBagConstraints);
                }
                CategorySheetPanel.spGridBagConstraints.insets = inset0202;
                editor = sp.getEditor();
                if (sp.isReadOnly()) {
                    editor.setEnabled(false);
                } else {
                    editor.setEnabled(true);
                }
                if (sp.getType() != 99) {
                    editor.setOpaque(false);
                    editor.setBackground(Color.WHITE);
                    CategorySheetPanel.spGridBagConstraints.gridwidth = !sp.isShowResetButton() ? 2 : 1;
                } else {
                    CategorySheetPanel.spGridBagConstraints.insets = inset0000;
                    CategorySheetPanel.spGridBagConstraints.gridwidth = 2;
                    editor.setBackground(color_234_234_234);
                    editor.setOpaque(true);
                }
                editor.setMaximumSize(dimension41x18);
                editor.setMinimumSize(dimension41x18);
                editor.setPreferredSize(dimension41x18);
                if (editor instanceof JPanel) break block14;
                if (sp.getType() == 99) break block15;
            }
            CategorySheetPanel.spGridBagConstraints.insets = inset0000;
        }
        this.jPanelEditors.add((Component)editor, spGridBagConstraints);
        CategorySheetPanel.spGridBagConstraints.gridwidth = 1;
        if (sp.getType() != 99 && sp.isShowResetButton()) {
            CategorySheetPanel.spGridBagConstraints.gridx = 1;
            CategorySheetPanel.spGridBagConstraints.gridy = this.current_position * 2;
            CategorySheetPanel.spGridBagConstraints.fill = 2;
            CategorySheetPanel.spGridBagConstraints.weightx = 0.0;
            CategorySheetPanel.spGridBagConstraints.insets = inset0000;
            ResetButton resetButton = new ResetButton(sp);
            this.jPanelEditors.add((Component)resetButton, spGridBagConstraints);
        }
        JSeparator jSeparator1 = new JSeparator(0);
        jSeparator1.setPreferredSize(dimension0x1);
        CategorySheetPanel.spGridBagConstraints.insets = inset0000;
        CategorySheetPanel.spGridBagConstraints.gridx = 0;
        CategorySheetPanel.spGridBagConstraints.gridwidth = 2;
        CategorySheetPanel.spGridBagConstraints.weightx = 0.0;
        CategorySheetPanel.spGridBagConstraints.gridy = this.current_position * 2 + 1;
        CategorySheetPanel.spGridBagConstraints.fill = 2;
        this.jPanelEditors.add((Component)jSeparator1, spGridBagConstraints);
        JSeparator jSeparator = new JSeparator(0);
        jSeparator.setPreferredSize(dimension0x1);
        this.jPanelLabels.add((Component)jSeparator, spGridBagConstraints);
        Dimension tmpdim = new Dimension(30, 20 * this.properties.size());
        this.jPanelLabels.setMinimumSize(tmpdim);
        this.jPanelLabels.setPreferredSize(tmpdim);
        this.jPanelEditors.setMinimumSize(tmpdim);
        this.jPanelEditors.setPreferredSize(tmpdim);
        sp.setLabelComponent(jLabel);
        sp.updateLabel();
        ++this.current_position;
        sp.setSetting(setting);
    }

    protected Vector getSortedProperties(Vector props) {
        SheetProperty[] names = new SheetProperty[props.size()];
        HashMap unsorted_hm = new HashMap();
        for (int i = 0; i < props.size(); ++i) {
            SheetProperty sp;
            names[i] = sp = (SheetProperty)props.elementAt(i);
        }
        Arrays.sort(names, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((SheetProperty)o1).getName().compareTo(((SheetProperty)o2).getName());
            }
        });
        Vector<SheetProperty> v = new Vector<SheetProperty>();
        for (int i = 0; i < names.length; ++i) {
            v.add(i, names[i]);
        }
        return v;
    }

    protected void addItems(Vector sheetProperties) {
        for (int i = 0; i < sheetProperties.size(); ++i) {
            this.addItem((SheetProperty)sheetProperties.elementAt(i));
        }
    }

    protected void addCategory(String name) {
        SheetProperty sp = new SheetProperty(name, name, 99);
        this.addItem(sp);
        if (!this.compressedCategories.contains(sp.getName())) {
            this.addItems((Vector)this.propCategories.get(name));
        }
    }

    public Vector getProperties() {
        return this.properties;
    }

    public void setProperties(Vector properties) {
        this.properties = properties;
    }

    public int getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(int viewMode) {
        this.viewMode = viewMode;
        this.recreateSheet();
    }

    private void initComponents() {
        this.buttonGroupToolbar = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.jPanelSheet = new JPanel();
        this.jPanel1 = new JPanel();
        this.jPanelFiller = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.jPanelLabels = new JPanel();
        this.jPanelFillerLabels = new JPanel();
        this.jPanelEditors = new JPanel();
        this.jPanelFillerEditors = new JPanel();
        this.jPanel2 = new JPanel();
        this.jButtonOrderByCategory = new JButton();
        this.jButtonOrderByAlpha = new JButton();
        this.jPanel3 = new JPanel();
        this.setLayout(new BorderLayout());
        this.setBackground(new Color(255, 255, 255));
        this.setMinimumSize(new Dimension(22, 200));
        this.setPreferredSize(new Dimension(128, 200));
        this.jScrollPane1.setBackground(new Color(255, 255, 255));
        this.jScrollPane1.setMinimumSize(new Dimension(22, 0));
        this.jScrollPane1.setOpaque(false);
        this.jPanelSheet.setLayout(new GridBagLayout());
        this.jPanelSheet.setBackground(new Color(255, 255, 255));
        this.jPanelSheet.setMinimumSize(new Dimension(126, 0));
        this.jPanelSheet.setPreferredSize(new Dimension(126, 0));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setMaximumSize(new Dimension(16, Integer.MAX_VALUE));
        this.jPanel1.setMinimumSize(new Dimension(16, 20));
        this.jPanel1.setPreferredSize(new Dimension(16, 0));
        this.jPanelFiller.setMinimumSize(new Dimension(10, 0));
        this.jPanelFiller.setPreferredSize(new Dimension(10, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 400;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanelFiller, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jPanelSheet.add((Component)this.jPanel1, gridBagConstraints);
        this.jSplitPane1.setBackground(new Color(255, 255, 255));
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setDividerSize(1);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jSplitPane1.setContinuousLayout(true);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jSplitPane1.setOpaque(false);
        this.jSplitPane1.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                CategorySheetPanel.this.jSplitPane1MouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                CategorySheetPanel.this.jSplitPane1MouseExited(evt);
            }
        });
        this.jPanelLabels.setLayout(new GridBagLayout());
        this.jPanelLabels.setBackground(new Color(255, 255, 255));
        this.jPanelLabels.setMinimumSize(new Dimension(70, 10));
        this.jPanelLabels.setPreferredSize(new Dimension(70, 10));
        this.jPanelFillerLabels.setMinimumSize(new Dimension(10, 0));
        this.jPanelFillerLabels.setPreferredSize(new Dimension(10, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 400;
        gridBagConstraints.weighty = 1.0;
        this.jPanelLabels.add((Component)this.jPanelFillerLabels, gridBagConstraints);
        this.jSplitPane1.setLeftComponent(this.jPanelLabels);
        this.jPanelEditors.setLayout(new GridBagLayout());
        this.jPanelEditors.setBackground(new Color(255, 255, 255));
        this.jPanelFillerEditors.setMinimumSize(new Dimension(10, 0));
        this.jPanelFillerEditors.setPreferredSize(new Dimension(10, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 400;
        gridBagConstraints.weighty = 1.0;
        this.jPanelEditors.add((Component)this.jPanelFillerEditors, gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.jPanelEditors);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelSheet.add((Component)this.jSplitPane1, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.jPanelSheet);
        this.add((Component)this.jScrollPane1, "Center");
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setMinimumSize(new Dimension(10, 20));
        this.jPanel2.setPreferredSize(new Dimension(10, 24));
        this.jButtonOrderByCategory.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/sheet/tree.png")));
        this.jButtonOrderByCategory.setBorderPainted(false);
        this.buttonGroupToolbar.add(this.jButtonOrderByCategory);
        this.jButtonOrderByCategory.setContentAreaFilled(false);
        this.jButtonOrderByCategory.setFocusPainted(false);
        this.jButtonOrderByCategory.setMinimumSize(new Dimension(25, 25));
        this.jButtonOrderByCategory.setPreferredSize(new Dimension(25, 25));
        this.jButtonOrderByCategory.setSelected(true);
        this.jButtonOrderByCategory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CategorySheetPanel.this.jButtonOrderByCategoryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 2, 2);
        this.jPanel2.add((Component)this.jButtonOrderByCategory, gridBagConstraints);
        this.jButtonOrderByAlpha.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/sheet/az.png")));
        this.jButtonOrderByAlpha.setBorderPainted(false);
        this.buttonGroupToolbar.add(this.jButtonOrderByAlpha);
        this.jButtonOrderByAlpha.setContentAreaFilled(false);
        this.jButtonOrderByAlpha.setFocusPainted(false);
        this.jButtonOrderByAlpha.setMinimumSize(new Dimension(25, 25));
        this.jButtonOrderByAlpha.setPreferredSize(new Dimension(25, 25));
        this.jButtonOrderByAlpha.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CategorySheetPanel.this.jButtonOrderByAlphaActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.jPanel2.add((Component)this.jButtonOrderByAlpha, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jPanel3, gridBagConstraints);
        this.add((Component)this.jPanel2, "North");
    }

    private void jButtonOrderByAlphaActionPerformed(ActionEvent evt) {
        this.setViewMode(2);
    }

    private void jButtonOrderByCategoryActionPerformed(ActionEvent evt) {
        this.setViewMode(1);
    }

    private void jSplitPane1MouseExited(MouseEvent evt) {
    }

    private void jSplitPane1MouseEntered(MouseEvent evt) {
    }

    public void categoryClicked(MouseEvent evt) {
        String category = "";
        try {
            JLabel jlabel = (JLabel)evt.getSource();
            if (this.compressedCategories.contains(jlabel.getName())) {
                jlabel.setIcon(opened_icon);
                this.compressedCategories.removeElement(jlabel.getName());
                this.recreateSheet();
            } else {
                jlabel.setIcon(closed_icon);
                this.compressedCategories.add(jlabel.getName());
                this.recreateSheet();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void collapseCategory(String category) {
        if (!this.compressedCategories.contains(category)) {
            this.compressedCategories.add(category);
            this.recreateSheet();
            return;
        }
    }

    public void explodeCategory(String category) {
        if (this.compressedCategories.contains(category)) {
            this.compressedCategories.removeElement(category);
            this.recreateSheet();
            return;
        }
    }

    public synchronized void addSheetPropertyValueChangedListener(SheetPropertyValueChangedListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(SheetPropertyValueChangedListener.class, listener);
    }

    public synchronized void removeSheetPropertyValueChangedListener(SheetPropertyValueChangedListener listener) {
        this.listenerList.remove(SheetPropertyValueChangedListener.class, listener);
    }

    private void fireSheetPropertyValueChangedListenerSheetPropertyValueChanged(SheetPropertyValueChangedEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$it$businesslogic$ireport$gui$event$SheetPropertyValueChangedListener == null ? CategorySheetPanel.class$("it.businesslogic.ireport.gui.event.SheetPropertyValueChangedListener") : class$it$businesslogic$ireport$gui$event$SheetPropertyValueChangedListener)) continue;
            ((SheetPropertyValueChangedListener)listeners[i + 1]).sheetPropertyValueChanged(event);
        }
    }

    public void sheetPropertyValueChanged(SheetPropertyValueChangedEvent evt) {
        evt.setSource(this);
        this.fireSheetPropertyValueChangedListenerSheetPropertyValueChanged(evt);
    }

    public boolean isShowResetButton() {
        return this.showResetButton;
    }

    public void setShowResetButton(boolean showResetButton) {
        this.showResetButton = showResetButton;
        for (int i = 0; i < this.getProperties().size(); ++i) {
            SheetProperty sp = (SheetProperty)this.getProperties().elementAt(i);
            sp.setShowResetButton(showResetButton);
        }
    }

    public void setResizeWeight(double resizeWeight) {
        this.jSplitPane1.setResizeWeight(resizeWeight);
    }

    public void updateUI() {
        super.updateUI();
        if (this.jPanelLabels != null && this.getProperties().size() > 0) {
            this.recreateSheet();
        }
    }

    public void applyI18n() {
        this.DIFFERENT_VALUES = I18n.getString("gui.elementpropertiessheet.differentValues", "<different values>");
    }

    public void setPropertyLabelError(String propertyName, String error) {
        final SheetProperty sp = (SheetProperty)this.getSheetProperty(propertyName);
        if (sp == null) {
            return;
        }
        sp.setLabelError(error);
        sp.updateLabel();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CategorySheetPanel.this.ensureVisible(sp);
            }
        });
    }

    public void ensureVisible(String propertyName) {
        this.ensureVisible((SheetProperty)this.getSheetProperty(propertyName));
    }

    public void ensureVisible(SheetProperty sp) {
        if (sp == null) {
            return;
        }
        Component[] components = this.jPanelLabels.getComponents();
        int y = sp.getLabelComponent().getY();
        int h = sp.getLabelComponent().getHeight();
        if (h > this.jScrollPane1.getVisibleRect().height) {
            h = this.jScrollPane1.getVisibleRect().height;
        }
        int visible_h = this.jScrollPane1.getVisibleRect().height;
        int scroll_val = this.jScrollPane1.getVerticalScrollBar().getValue();
        int max_y_visible_now = scroll_val + visible_h;
        if (max_y_visible_now < y) {
            this.jScrollPane1.getVerticalScrollBar().setValue(y + h - visible_h);
        } else if (scroll_val > y) {
            this.jScrollPane1.getVerticalScrollBar().setValue(y);
        } else if (visible_h > h && max_y_visible_now < y + h) {
            this.jScrollPane1.getVerticalScrollBar().setValue(y + h - visible_h);
        }
    }

    protected boolean setComboBox(boolean firstTime, Object value, JComboBox comboField) {
        if (!firstTime && comboField.getSelectedItem() != value) {
            comboField.insertItemAt(this.DIFFERENT_VALUES, 0);
            comboField.setSelectedIndex(0);
            return false;
        }
        try {
            comboField.setSelectedItem(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    protected boolean setTextArea(boolean firstTime, String value, SheetProperty textProperty) {
        if (!firstTime && !textProperty.getValue().equals(value)) {
            JComponent editor = textProperty.getEditor();
            if (editor instanceof ExpressionSheetPropertyComponent) {
                ((ExpressionSheetPropertyComponent)editor).setExpression("");
                ((ExpressionSheetPropertyComponent)editor).setText(this.DIFFERENT_VALUES);
            }
            return false;
        }
        try {
            textProperty.setValue(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    protected boolean setTextPattern(boolean firstTime, Object value, SheetProperty textProperty) {
        if (!firstTime && !(textProperty.getValue() + "").equals(value)) {
            JComponent editor = textProperty.getEditor();
            if (editor instanceof PatternSheetPropertyComponent) {
                ((PatternSheetPropertyComponent)editor).setExpression("");
                ((PatternSheetPropertyComponent)editor).setText(this.DIFFERENT_VALUES);
            }
            return false;
        }
        try {
            textProperty.setValue(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    protected boolean setTagComboBox(boolean firstTime, Object value, SheetProperty sp) {
        if (firstTime) {
            this.removeNullItem(sp);
            sp.setValue(value);
            return true;
        }
        Object s = sp.getValue();
        if (s == null && value == null) {
            return true;
        }
        if (s != null && s.equals(value)) {
            return true;
        }
        sp.setSetting(true);
        JComboBox combobox = (JComboBox)sp.getEditor();
        if (combobox.getItemCount() > 0) {
            Object obj = combobox.getItemAt(0);
            sp.setValue(null);
            if (!(obj + "").equals(this.DIFFERENT_VALUES)) {
                ((JComboBox)sp.getEditor()).insertItemAt(new Tag(null, this.DIFFERENT_VALUES), 0);
            }
        }
        ((JComboBox)sp.getEditor()).setSelectedIndex(0);
        sp.setSetting(false);
        return false;
    }

    protected boolean setElementNumber(boolean firstTime, double value, JNumberField numberField) {
        if (numberField == null) {
            return false;
        }
        if (!firstTime && numberField.getValue() != value) {
            numberField.setText("");
            return false;
        }
        try {
            numberField.setValue(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    protected boolean setElementNumber(boolean firstTime, int defaultValue, Object value, NumberComboBoxSheetProperty sp) {
        if (sp == null) {
            return false;
        }
        if (!firstTime && !(sp.getValue() + "").equals("" + value)) {
            boolean setting = sp.isSetting();
            sp.setSetting(true);
            sp.setValue(null);
            sp.setSetting(setting);
            sp.setEditorValue(sp.getEditor(), "");
            return false;
        }
        try {
            boolean setting = sp.isSetting();
            sp.setSetting(true);
            sp.setValue(value);
            if (value == null) {
                if (!firstTime && !(((JNumberComboBox)sp.getEditor()).getSelectedItem() + "").equals("" + defaultValue)) {
                    sp.setEditorValue(sp.getEditor(), "");
                } else {
                    sp.setEditorValue(sp.getEditor(), new Integer(defaultValue));
                }
            }
            sp.setSetting(setting);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    protected boolean setGenericSheetProperty(boolean firstTime, Object value, SheetProperty sp) {
        if (firstTime) {
            try {
                sp.setValue(value);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return true;
        }
        Object value2 = sp.getValue();
        if (value2 == value) {
            return true;
        }
        if (value2 != null && ("" + value2).equals(value + "")) {
            return true;
        }
        sp.setValue(null);
        return false;
    }

    protected boolean setColorProperty(boolean firstTime, Color color, SheetProperty sp) {
        if (firstTime) {
            try {
                sp.setValue(color);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return true;
        }
        Color c1 = (Color)sp.getValue();
        if (c1 == color) {
            return true;
        }
        if (c1 != null && color != null && c1.getRGB() == color.getRGB()) {
            return true;
        }
        sp.setValue(null);
        return false;
    }

    protected boolean setCheckBox(boolean firstTime, boolean value, boolean isNull, SheetProperty sp) {
        if (firstTime) {
            try {
                if (isNull) {
                    sp.setValue(null);
                    sp.setSetting(true);
                    ((JCheckBox)sp.getEditor()).setSelected(value);
                    sp.setSetting(false);
                } else {
                    sp.setValue("" + value);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return true;
        }
        if (sp.getValue() == null && isNull) {
            return true;
        }
        if (sp.getValue() != null && sp.getValue().equals("" + value)) {
            return true;
        }
        sp.setValue(null);
        return false;
    }

    public void removeNullItem(SheetProperty comboProperty) {
        Object obj;
        JComboBox combobox;
        if (comboProperty == null) {
            return;
        }
        if (comboProperty.getEditor() instanceof JComboBox && (combobox = (JComboBox)comboProperty.getEditor()).getSelectedIndex() > 0 && ((obj = combobox.getItemAt(0)) + "").equals(this.DIFFERENT_VALUES)) {
            combobox.removeItemAt(0);
        }
    }

    public boolean isNullItem(SheetProperty comboProperty) {
        Object obj;
        JComboBox combobox;
        if (comboProperty == null) {
            return false;
        }
        return comboProperty.getEditor() instanceof JComboBox && (combobox = (JComboBox)comboProperty.getEditor()).getSelectedIndex() == 0 && ((obj = combobox.getItemAt(0)) + "").equals(this.DIFFERENT_VALUES);
    }
}

