/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.mdi;

import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import nickyb.sqleonardo.common.gui.Toolbar;
import nickyb.sqleonardo.common.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.common.util.I18n;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.editor._TaskSource;
import nickyb.sqleonardo.environment.io.FileStreamSQL;
import nickyb.sqleonardo.environment.io.FileStreamXLQ;
import nickyb.sqleonardo.environment.mdi.ClientContent;
import nickyb.sqleonardo.environment.mdi.DialogQuery;
import nickyb.sqleonardo.environment.mdi.MDIActions;
import nickyb.sqleonardo.environment.mdi.MDIClient;
import nickyb.sqleonardo.querybuilder.QueryBuilder;
import nickyb.sqleonardo.querybuilder.QueryModel;
import nickyb.sqleonardo.querybuilder.syntax.SQLParser;

public class ClientQueryBuilder
extends MDIClient
implements ChangeListener {
    public static final String DEFAULT_TITLE = "QUERY";
    public static int counter = 0;
    private QueryBuilder builder;
    private JTextArea syntax;
    private JTabbedPane control;
    private JMenuItem[] m_actions;
    private Toolbar toolbar;
    private String keycah = null;
    private String filename = null;

    public ClientQueryBuilder(String keycah) {
        super(DEFAULT_TITLE);
        this.setMaximizable(false);
        this.setResizable(false);
        this.keycah = keycah;
        this.control = new JTabbedPane(3);
        this.setComponentCenter(this.control);
        this.builder = new QueryBuilder();
        this.control.add(I18n.getString("application.builder", "builder"), this.builder);
        this.syntax = new JTextArea();
        this.control.add(I18n.getString("application.syntax", "syntax"), new JScrollPane(this.syntax));
        this.control.addChangeListener(this);
        this.createToolbar();
        this.initMenuActions();
        if (keycah != null) {
            this.builder.setConnection(ConnectionAssistant.getHandler(keycah).get());
        }
        this.setFileName(null);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameActivated(InternalFrameEvent ife) {
                ClientQueryBuilder.this.setQueryParameters();
            }
        });
    }

    private void createToolbar() {
        this.toolbar = new Toolbar(0);
        this.toolbar.add(new ActionLaunch());
        this.toolbar.add(new ActionSave());
        this.setComponentEast(this.toolbar);
    }

    private void initMenuActions() {
        JCheckBoxMenuItem cbxm = new JCheckBoxMenuItem(this.builder.getActionMap().get("fields-draggable"));
        cbxm.setSelected(this.builder.isDragAndDropEnabled());
        this.m_actions = new JMenuItem[]{cbxm, null, new JMenuItem(this.builder.getActionMap().get("entities-arrange")), new JMenuItem(this.builder.getActionMap().get("entities-pack")), new JMenuItem(this.builder.getActionMap().get("entities-remove")), null, new JMenuItem(this.builder.getActionMap().get("copy-syntax"))};
    }

    public JMenuItem[] getMenuActions() {
        return this.m_actions;
    }

    public Toolbar getSubToolbar() {
        return this.toolbar;
    }

    public void stateChanged(ChangeEvent ce) {
        this.m_actions[2].setEnabled(this.control.getSelectedIndex() == 0);
        this.m_actions[3].setEnabled(this.control.getSelectedIndex() == 0);
        this.m_actions[4].setEnabled(this.control.getSelectedIndex() == 0);
        if (this.control.getSelectedIndex() == 0) {
            String msql = this.builder.getModel().toString(true);
            String tsql = this.syntax.getText();
            if (!tsql.equals(msql) && Application.confirm("SQLeonardo", I18n.getString("application.syntaxChanged", "syntax changed!\ndo you want to apply changes (builder need to reload)?"))) {
                new Thread(new Runnable(){

                    public void run() {
                        while (!ClientQueryBuilder.this.builder.isVisible()) {
                        }
                        try {
                            QueryModel qm = SQLParser.toQueryModel(ClientQueryBuilder.this.syntax.getText());
                            ClientQueryBuilder.this.builder.setModel(qm);
                        }
                        catch (IOException e) {
                            Application.println(e, true);
                        }
                    }
                }).start();
            }
        } else {
            this.syntax.setText(this.builder.getModel().toString(true));
        }
    }

    protected void setPreferences() {
    }

    public final void setFileName(String filename) {
        this.filename = filename;
        String filename2 = filename == null ? "<untitled" + ++counter + ">" : filename;
        super.setTitle(this.getID() + " - " + DEFAULT_TITLE + " : " + filename2 + " : " + this.keycah);
    }

    public final void setModel(QueryModel model) {
        this.builder.setModel(model);
    }

    private void setQueryParameters() {
        if (ConnectionAssistant.hasHandler(this.keycah)) {
            QueryBuilder.identifierQuoteString = ConnectionAssistant.getHandler(this.keycah).getObject("$identifierQuoteString").toString();
            QueryBuilder.maxColumnNameLength = (Integer)ConnectionAssistant.getHandler(this.keycah).getObject("$maxColumnNameLength");
        }
    }

    public class ActionSave
    extends MDIActions.AbstractBase {
        private ActionSave() {
            this.setText(I18n.getString("application.saveQuery", "save query"));
            this.setIcon("icon.010");
            this.setTooltip(I18n.getString("application.saveQuery", "save query"));
        }

        private void saveAs() {
            Object[] ret = DialogQuery.showSave(ClientQueryBuilder.this.builder.getModel());
            if (ret[0] != null) {
                ClientQueryBuilder.this.setFileName(ret[0].toString());
            }
        }

        private void replace() {
            try {
                String fn = ClientQueryBuilder.this.filename;
                if (fn.endsWith(".sql")) {
                    FileStreamSQL.write(fn, ClientQueryBuilder.this.builder.getModel());
                } else {
                    if (!fn.endsWith(".xlq")) {
                        fn = fn + ".xlq";
                    }
                    FileStreamXLQ.write(fn, ClientQueryBuilder.this.builder.getModel());
                }
                ClientQueryBuilder.this.setFileName(fn);
            }
            catch (Exception e) {
                Application.println(e, true);
                e.printStackTrace();
            }
        }

        public void actionPerformed(ActionEvent ae) {
            if (ClientQueryBuilder.this.filename == null) {
                this.saveAs();
            } else {
                String message = I18n.getFormattedString("application.message.replaceFile", "{0}\nreplace existing file?", new Object[]{"" + ClientQueryBuilder.this.filename});
                int ret = JOptionPane.showConfirmDialog(Application.window, message, "query.save", 1);
                if (ret == 0) {
                    this.replace();
                } else if (ret == 1) {
                    this.saveAs();
                }
            }
        }
    }

    private class ActionLaunch
    extends MDIActions.AbstractBase
    implements _TaskSource {
        private ActionLaunch() {
            super(I18n.getString("application.launchQuery", "launch query"));
            this.setIcon("icon.151");
            this.setTooltip(I18n.getString("application.launchQuery", "launch query"));
        }

        public void actionPerformed(ActionEvent ae) {
            if (ClientQueryBuilder.this.builder.getConnection() == null) {
                Application.alert("SQLeonardo", "no connection!");
            } else {
                int pos = ClientQueryBuilder.this.getTitle().indexOf(":");
                String subtitle = ClientQueryBuilder.this.getTitle().substring(pos);
                Application.window.add(new ClientContent("PREVIEW " + subtitle, this, true, true));
            }
        }

        public String getHandlerKey() {
            return ClientQueryBuilder.this.keycah;
        }

        public String getSyntax() {
            return ClientQueryBuilder.this.builder.getModel().toString();
        }
    }
}

