/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.xom;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.ElementDef;
import org.eigenbase.xom.MetaDef;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.XOMUtil;

public class MetaTester {
    private Class rootDef;
    private Constructor rootConstructor;
    private Parser parser;
    private MetaDef.Model model;
    private String modelDocType;
    private int parserType;

    public MetaTester(String string, String string2, int n) throws XOMException, IOException {
        Object object;
        this.parserType = n;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (IOException iOException) {
            throw new XOMException("Loading of model file " + string + " failed: " + iOException.getMessage());
        }
        Parser parser = XOMUtil.createDefaultParser();
        try {
            object = parser.parse(fileInputStream);
            this.model = new MetaDef.Model((DOMWrapper)object);
        }
        catch (XOMException xOMException) {
            throw new XOMException(xOMException, "Failed to parse XML file: " + string);
        }
        object = MetaTester.getModelRoot(this.model);
        try {
            this.rootDef = Class.forName(this.model.className + "$" + (String)object);
            Class[] classArray = new Class[]{DOMWrapper.class};
            this.rootConstructor = this.rootDef.getConstructor(classArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new XOMException("Model class " + this.model.className + "." + (String)object + " could not be " + "loaded: " + classNotFoundException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new XOMException("Model class " + this.model.className + "." + (String)object + " has no " + "constructor which takes a " + "DOMWrapper.");
        }
        boolean bl = false;
        for (int i = 0; i < this.model.elements.length; ++i) {
            if (!(this.model.elements[i] instanceof MetaDef.Plugin) && !(this.model.elements[i] instanceof MetaDef.Import)) continue;
            bl = true;
            break;
        }
        this.modelDocType = null;
        if (bl) {
            System.out.println("Plugins or imports are in use: ignoring DTD.");
        } else {
            this.modelDocType = MetaTester.getModelDocType(this.model);
            System.out.println("No plugins or imports: using DTD with DocType " + this.modelDocType + ".");
        }
        parser = XOMUtil.makeParser(n, bl, string2, this.model.dtdName, this.modelDocType);
    }

    private static void readerToWriter(Reader reader, Writer writer) throws IOException {
        int n;
        char[] cArray = new char[16384];
        while ((n = reader.read(cArray)) != -1) {
            if (n <= 0) continue;
            writer.write(cArray, 0, n);
        }
    }

    private static String getModelRoot(MetaDef.Model model) throws XOMException {
        if (model.root != null) {
            return model.root;
        }
        for (int i = 0; i < model.elements.length; ++i) {
            if (!(model.elements[i] instanceof MetaDef.Element)) continue;
            return ((MetaDef.Element)model.elements[i]).type;
        }
        throw new XOMException("Model " + model.name + " has no " + "root element defined and has no first " + "element.");
    }

    private static String getModelDocType(MetaDef.Model model) throws XOMException {
        if (model.root != null) {
            return model.root;
        }
        for (int i = 0; i < model.elements.length; ++i) {
            if (!(model.elements[i] instanceof MetaDef.Element)) continue;
            MetaDef.Element element = (MetaDef.Element)model.elements[i];
            if (model.root != null && !model.root.equals(element.type)) continue;
            if (element.dtdName != null) {
                return element.dtdName;
            }
            if (model.prefix != null) {
                return model.prefix + element.type;
            }
            return element.type;
        }
        if (model.root == null) {
            throw new XOMException("Model " + model.name + " has no " + "root element defined and has no first " + "element.");
        }
        throw new XOMException("Model root element " + model.root + " is not defined as an Element.");
    }

    private ElementDef instantiate(DOMWrapper dOMWrapper) throws XOMException {
        ElementDef elementDef = null;
        try {
            Object[] objectArray = new Object[]{dOMWrapper};
            elementDef = (ElementDef)this.rootConstructor.newInstance(objectArray);
        }
        catch (InstantiationException instantiationException) {
            throw new XOMException("Unable to instantiate holder class " + this.rootDef.getName() + ": " + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new XOMException("Unable to instantiate holder class " + this.rootDef.getName() + ": " + illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof XOMException) {
                throw (XOMException)throwable;
            }
            throw new XOMException("Exeception occurred while instantiating holder class " + this.rootDef.getName() + ": " + throwable.toString());
        }
        return elementDef;
    }

    public void testFile(String string, String string2) throws XOMException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        File file = new File(string2, this.model.dtdName);
        String string3 = "file:" + file.getAbsolutePath();
        String string4 = null;
        try {
            object5 = new StringWriter();
            object4 = new FileReader(string);
            if (this.parserType != 1) {
                object3 = new PrintWriter((Writer)object5);
                ((PrintWriter)object3).println("<?xml version=\"1.0\" ?>");
                if (this.modelDocType != null) {
                    ((PrintWriter)object3).println("<!DOCTYPE " + this.modelDocType + " SYSTEM \"" + string3 + "\">");
                }
                ((PrintWriter)object3).flush();
            }
            MetaTester.readerToWriter((Reader)object4, (Writer)object5);
            ((InputStreamReader)object4).close();
            string4 = ((StringWriter)object5).toString();
        }
        catch (IOException iOException) {
            throw new XOMException("Unable to read input test " + string + ": " + iOException.getMessage());
        }
        object5 = this.parser.parse(string4);
        object4 = this.instantiate((DOMWrapper)object5);
        System.out.println("Testing model " + string);
        System.out.println("Display:");
        System.out.println(((ElementDef)object4).toString());
        System.out.println();
        object3 = ((ElementDef)object4).toXML();
        System.out.println();
        System.out.println("Regurgitated XML:");
        System.out.println((String)object3);
        if (this.parserType != 1) {
            object2 = new StringWriter();
            object = new PrintWriter((Writer)object2);
            ((PrintWriter)object).println("<?xml version=\"1.0\" ?>");
            if (this.modelDocType != null) {
                ((PrintWriter)object).println("<!DOCTYPE " + this.modelDocType + " SYSTEM \"" + string3 + "\">");
            }
            ((PrintWriter)object).println((String)object3);
            ((PrintWriter)object).flush();
            object3 = ((StringWriter)object2).toString();
        }
        object2 = this.parser.parse((String)object3);
        object = this.instantiate((DOMWrapper)object2);
        try {
            ((ElementDef)object4).verifyEqual((ElementDef)object);
        }
        catch (XOMException xOMException) {
            System.err.println("Equality failure.  Regurgitated XML:");
            System.err.println((String)object3);
            throw xOMException;
        }
        if (!((ElementDef)object4).equals(object)) {
            throw new XOMException("Equality check failed even though verifyEqual passed.");
        }
    }

    public static void main(String[] stringArray) throws XOMException, IOException {
        int n = 0;
        if (stringArray.length > 0 && stringArray[0].equals("-debug")) {
            System.err.println("MetaTester pausing for debugging.  Attach your debugger and press return.");
            try {
                System.in.read();
                ++n;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        int n2 = 1;
        if (n < stringArray.length && stringArray[n].equals("-msxml")) {
            n2 = 1;
            ++n;
        } else if (n < stringArray.length && stringArray[n].equals("-xerces")) {
            n2 = 2;
            ++n;
        }
        if (stringArray.length < n + 2) {
            System.err.println("Usage: java MetaTester [-debug] [-msxml | -xerces] <model XML file> <output dir> <tests> ...");
            System.exit(-1);
        }
        MetaTester metaTester = new MetaTester(stringArray[0 + n], stringArray[1 + n], n2);
        for (int i = 2 + n; i < stringArray.length; ++i) {
            metaTester.testFile(stringArray[i], stringArray[1 + n]);
        }
    }
}

