/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved. 
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 *
 *
 *
 *
 * JRFieldDialog.java
 * 
 * Created on 9 maggio 2003, 17.25
 *
 */

package it.businesslogic.ireport.gui.style;

import it.businesslogic.ireport.gui.*;
import it.businesslogic.ireport.util.*;
import it.businesslogic.ireport.*;
import java.util.Iterator;
import javax.swing.JOptionPane;
/**
 *
 * @author  Administrator
 */
public class JRTemplateDialog extends javax.swing.JDialog {
	/** Creates new form JRParameterDialog */
    Template tmpTemplate = null;

    public JRTemplateDialog(java.awt.Frame parent, boolean modal) {
		super(parent, modal);
		initComponents();
                applyI18n();
                setClassTypes();
		this.jComboBoxType.setSelectedItem("java.lang.String");
                
                javax.swing.KeyStroke escape =  javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_ESCAPE, 0, false);
                javax.swing.Action escapeAction = new javax.swing.AbstractAction() {
                    public void actionPerformed(java.awt.event.ActionEvent e) {
                        jButtonCancelActionPerformed(e);
                    }
                };

                getRootPane().getInputMap(javax.swing.JComponent.WHEN_IN_FOCUSED_WINDOW).put(escape, "ESCAPE");
                getRootPane().getActionMap().put("ESCAPE", escapeAction);


                //to make the default button ...
                this.getRootPane().setDefaultButton(this.jButtonOK);
	}
	
	public void setClassTypes() {
		jComboBoxType.setModel(
                           new javax.swing.DefaultComboBoxModel(new String[] {
                    "java.lang.String", 
                    "java.io.File", 
                    "java.net.URL", 
                    "java.io.InputStream", 
                    "net.sf.jasperreports.engine.JRTemplate" }));
	}
	
	
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel2 = new javax.swing.JLabel();
        jComboBoxType = new javax.swing.JComboBox();
        jLabel4 = new javax.swing.JLabel();
        jRTextExpressionArea = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jPanel1 = new javax.swing.JPanel();
        jSeparator1 = new javax.swing.JSeparator();
        jButtonOK = new javax.swing.JButton();
        jButtonCancel = new javax.swing.JButton();

        setTitle("Add/modify field");
        setModal(true);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });
        getContentPane().setLayout(new java.awt.GridBagLayout());

        jLabel2.setText("Template expression class");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(jLabel2, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(jComboBoxType, gridBagConstraints);

        jLabel4.setText("Template expression");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(jLabel4, gridBagConstraints);

        jRTextExpressionArea.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jRTextExpressionArea.setMinimumSize(new java.awt.Dimension(100, 204));
        jRTextExpressionArea.setPreferredSize(new java.awt.Dimension(350, 150));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        getContentPane().add(jRTextExpressionArea, gridBagConstraints);

        jPanel1.setLayout(new java.awt.GridBagLayout());

        jSeparator1.setMinimumSize(new java.awt.Dimension(2, 2));
        jSeparator1.setPreferredSize(new java.awt.Dimension(2, 2));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(8, 0, 4, 0);
        jPanel1.add(jSeparator1, gridBagConstraints);

        jButtonOK.setMnemonic('o');
        jButtonOK.setText("OK");
        jButtonOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOKActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 4);
        jPanel1.add(jButtonOK, gridBagConstraints);

        jButtonCancel.setMnemonic('c');
        jButtonCancel.setText("Cancel");
        jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        jPanel1.add(jButtonCancel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHEAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(jPanel1, gridBagConstraints);

        pack();
        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        java.awt.Dimension dialogSize = getSize();
        setLocation((screenSize.width-dialogSize.width)/2,(screenSize.height-dialogSize.height)/2);
    }// </editor-fold>//GEN-END:initComponents
	
    private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelActionPerformed
	    setVisible(false);
	    this.setDialogResult( javax.swing.JOptionPane.CANCEL_OPTION);
	    dispose();
    }//GEN-LAST:event_jButtonCancelActionPerformed
    
    private void jButtonOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOKActionPerformed
	    
	    if (this.jRTextExpressionArea.getText().trim().length() <= 0) {
		    javax.swing.JOptionPane.showMessageDialog(this,
                            I18n.getString( "messages.jRFieldDialog.notValidTemplateExpression","Please insert a valid template expression!"),
                            I18n.getString( "messages.jRFieldDialog.notValidTemplateExpressionCaption","Invalid expression!"),
                            javax.swing.JOptionPane.WARNING_MESSAGE );
		    return;
	    }
	    
	    tmpTemplate = new Template( this.jRTextExpressionArea.getText(), ""+jComboBoxType.getSelectedItem() );
            
            setVisible(false);
	    this.setDialogResult( javax.swing.JOptionPane.OK_OPTION);
	    dispose();
    }//GEN-LAST:event_jButtonOKActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
	    setVisible(false);
	    this.setDialogResult( javax.swing.JOptionPane.CLOSED_OPTION);
	    dispose();
    }//GEN-LAST:event_closeDialog
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
	    new JRParameterDialog(new javax.swing.JFrame(), true).setVisible(true);
    }
    
    /** Getter for property tmpParameter.
     * @return Value of property tmpParameter.
     *
     */
    public it.businesslogic.ireport.Template getTemplate() {
	    return tmpTemplate;
    }
    
    /** Setter for property tmpParameter.
     * @param tmpParameter New value of property tmpParameter.
     *
     */
    public void setTemplate(it.businesslogic.ireport.Template tmpTemplate) {
            
        this.jComboBoxType.setSelectedItem( new String(tmpTemplate.getExpressionClass()));
	this.jRTextExpressionArea.setText(tmpTemplate.getExpression());
        
        
    }
    
    /** Getter for property dialogResult.
     * @return Value of property dialogResult.
     *
     */
    public int getDialogResult() {
	    return dialogResult;
    }
    
    /** Setter for property dialogResult.
     * @param dialogResult New value of property dialogResult.
     *
     */
    public void setDialogResult(int dialogResult) {
	    this.dialogResult = dialogResult;
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonCancel;
    private javax.swing.JButton jButtonOK;
    private javax.swing.JComboBox jComboBoxType;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JPanel jPanel1;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionArea;
    private javax.swing.JSeparator jSeparator1;
    // End of variables declaration//GEN-END:variables
	
	private int dialogResult;
	
    public void applyI18n(){
                // Start autogenerated code ----------------------
                jButtonCancel.setText(I18n.getString("jRTemplateDialog.buttonCancel","Cancel"));
                jButtonOK.setText(I18n.getString("jRTemplateDialog.buttonOK","OK"));
                jLabel2.setText(I18n.getString("jRTemplateDialog.label2","Template expression class type"));
                jLabel4.setText(I18n.getString("jRTemplateDialog.label4","Template expression"));
                // End autogenerated code ----------------------
                this.setTitle(I18n.getString("jRTemplateDialog.title","Add/modify template"));
                jButtonCancel.setMnemonic(I18n.getString("jRTemplateDialog.buttonCancelMnemonic","c").charAt(0));
                jButtonOK.setMnemonic(I18n.getString("jRTemplateDialog.buttonOKMnemonic","o").charAt(0));
    }

   
}
