/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.xml.JRXmlDigester;
import net.sf.jasperreports.engine.xml.JRXmlTemplateDigesterFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class JRXmlTemplateLoader {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$jasperreports$engine$xml$JRXmlTemplateLoader == null ? (class$net$sf$jasperreports$engine$xml$JRXmlTemplateLoader = JRXmlTemplateLoader.class$("net.sf.jasperreports.engine.xml.JRXmlTemplateLoader")) : class$net$sf$jasperreports$engine$xml$JRXmlTemplateLoader));
    static /* synthetic */ Class class$net$sf$jasperreports$engine$xml$JRXmlTemplateLoader;

    protected JRXmlTemplateLoader() {
    }

    public static JRTemplate load(String location) throws JRException {
        byte[] data = JRLoader.loadBytesFromLocation(location);
        return JRXmlTemplateLoader.load(new ByteArrayInputStream(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JRTemplate load(File file) {
        BufferedInputStream fileIn;
        try {
            fileIn = new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new JRRuntimeException("Template XML file not found", e);
        }
        try {
            JRTemplate jRTemplate = JRXmlTemplateLoader.load(fileIn);
            return jRTemplate;
        }
        finally {
            try {
                fileIn.close();
            }
            catch (IOException e) {
                log.warn((Object)"Error closing XML file", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JRTemplate load(URL url) {
        InputStream input;
        try {
            input = url.openStream();
        }
        catch (IOException e) {
            throw new JRRuntimeException("Error opening connection to template URL " + url, e);
        }
        try {
            JRTemplate jRTemplate = JRXmlTemplateLoader.load(input);
            return jRTemplate;
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                log.warn((Object)("Error closing connection to template URL " + url), (Throwable)e);
            }
        }
    }

    public static JRTemplate load(InputStream data) {
        JRXmlTemplateLoader loader = new JRXmlTemplateLoader();
        return loader.loadTemplate(data);
    }

    protected JRTemplate loadTemplate(InputStream data) {
        JRXmlDigester digester = JRXmlTemplateDigesterFactory.instance().createDigester();
        try {
            JRTemplate template = (JRTemplate)digester.parse(data);
            return template;
        }
        catch (IOException e) {
            throw new JRRuntimeException("Error reading template XML", e);
        }
        catch (SAXException e) {
            throw new JRRuntimeException("Error parsing template XML", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

