/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.queryexecuters;

import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.queryexecuters.QueryExecuterDef;
import it.businesslogic.ireport.gui.queryexecuters.QueryExecuterDialog;
import it.businesslogic.ireport.gui.table.CustomColumnControlButton;
import it.businesslogic.ireport.gui.table.JDragTable;
import it.businesslogic.ireport.gui.table.SortChangedEvent;
import it.businesslogic.ireport.gui.table.SortChangedListener;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.swingx.icon.ColumnControlIcon;

public class QueryExecutersDialog
extends JDialog {
    private JButton jButtonDeleteProperty;
    private JButton jButtonModifyProperty;
    private JButton jButtonMoveDown;
    private JButton jButtonMoveUp;
    private JButton jButtonNewProperty;
    private JButton jButtonSave;
    private JPanel jPanel1;
    private JPanel jPanelButtons2;
    private JPanel jPanelFields;
    private JScrollPane jScrollPane3;
    private JDragTable jTableProperties;

    public QueryExecutersDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public QueryExecutersDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public void initAll() {
        this.initComponents();
        this.setSize(420, 250);
        DefaultTableColumnModel dtcm = (DefaultTableColumnModel)this.jTableProperties.getColumnModel();
        this.jTableProperties.setColumnControl((JComponent)((Object)new CustomColumnControlButton(this.jTableProperties, (Icon)new ColumnControlIcon())));
        this.jTableProperties.addSortChangedListener(new SortChangedListener(){

            public void sortChanged(SortChangedEvent evt) {
                QueryExecutersDialog.this.tableSortChanged(evt);
            }
        });
        dtcm.getColumn(0).setWidth(150);
        dtcm.getColumn(0).setPreferredWidth(150);
        DefaultListSelectionModel dlsm = (DefaultListSelectionModel)this.jTableProperties.getSelectionModel();
        dlsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                QueryExecutersDialog.this.jTablePropertiesListSelectionValueChanged(e);
            }
        });
        this.applyI18n();
        Misc.centerFrame(this);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                QueryExecutersDialog.this.jButtonSaveActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonSave);
        this.updateQueryExecuters();
    }

    public void tableSortChanged(SortChangedEvent evt) {
        this.jTablePropertiesListSelectionValueChanged(null);
    }

    public void jTablePropertiesListSelectionValueChanged(ListSelectionEvent e) {
        if (this.jTableProperties.getSelectedRowCount() > 0) {
            this.jButtonModifyProperty.setEnabled(true);
            this.jButtonDeleteProperty.setEnabled(true);
            if (this.jTableProperties.getSortedColumn() == null) {
                this.jButtonMoveUp.setEnabled(true);
                this.jButtonMoveDown.setEnabled(true);
            }
        } else {
            this.jButtonModifyProperty.setEnabled(false);
            this.jButtonDeleteProperty.setEnabled(false);
            this.jButtonMoveUp.setEnabled(false);
            this.jButtonMoveDown.setEnabled(false);
        }
    }

    private void initComponents() {
        this.jPanelFields = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jTableProperties = new JDragTable();
        this.jPanelButtons2 = new JPanel();
        this.jButtonNewProperty = new JButton();
        this.jButtonModifyProperty = new JButton();
        this.jButtonDeleteProperty = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonMoveUp = new JButton();
        this.jButtonMoveDown = new JButton();
        this.jPanel1 = new JPanel();
        this.setTitle("Values");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                QueryExecutersDialog.this.closeDialog(evt);
            }
        });
        this.jPanelFields.setLayout(new GridBagLayout());
        this.jScrollPane3.setBackground(new Color(255, 255, 255));
        this.jScrollPane3.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                QueryExecutersDialog.this.jScrollPane3MouseClicked(evt);
            }
        });
        this.jTableProperties.setModel(new DefaultTableModel(new Object[0][], new String[]{"Language", "Factory class", "Fields Provider"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTableProperties.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                QueryExecutersDialog.this.jTablePropertiesMouseClicked(evt);
            }
        });
        this.jTableProperties.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                QueryExecutersDialog.this.jTablePropertiesPropertyChange(evt);
            }
        });
        this.jScrollPane3.setViewportView((Component)((Object)this.jTableProperties));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.jPanelFields.add((Component)this.jScrollPane3, gridBagConstraints);
        this.jPanelButtons2.setMinimumSize(new Dimension(100, 10));
        this.jPanelButtons2.setPreferredSize(new Dimension(130, 100));
        this.jPanelButtons2.setLayout(new GridBagLayout());
        this.jButtonNewProperty.setText("New");
        this.jButtonNewProperty.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                QueryExecutersDialog.this.jButtonNewPropertyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanelButtons2.add((Component)this.jButtonNewProperty, gridBagConstraints);
        this.jButtonModifyProperty.setText("Modify");
        this.jButtonModifyProperty.setEnabled(false);
        this.jButtonModifyProperty.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                QueryExecutersDialog.this.jButtonModifyPropertyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 4, 0, 4);
        this.jPanelButtons2.add((Component)this.jButtonModifyProperty, gridBagConstraints);
        this.jButtonDeleteProperty.setText("Delete");
        this.jButtonDeleteProperty.setEnabled(false);
        this.jButtonDeleteProperty.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                QueryExecutersDialog.this.jButtonDeletePropertyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelButtons2.add((Component)this.jButtonDeleteProperty, gridBagConstraints);
        this.jButtonSave.setMnemonic('c');
        this.jButtonSave.setText("Close");
        this.jButtonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                QueryExecutersDialog.this.jButtonSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanelButtons2.add((Component)this.jButtonSave, gridBagConstraints);
        this.jButtonMoveUp.setText("Move up");
        this.jButtonMoveUp.setEnabled(false);
        this.jButtonMoveUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                QueryExecutersDialog.this.jButtonDeletePropertyActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelButtons2.add((Component)this.jButtonMoveUp, gridBagConstraints);
        this.jButtonMoveDown.setText("Move down");
        this.jButtonMoveDown.setEnabled(false);
        this.jButtonMoveDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                QueryExecutersDialog.this.jButtonDeletePropertyActionPerformed2(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelButtons2.add((Component)this.jButtonMoveDown, gridBagConstraints);
        this.jPanel1.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weighty = 1.0;
        this.jPanelButtons2.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanelFields.add((Component)this.jPanelButtons2, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanelFields, "Center");
        this.pack();
    }

    private void jTablePropertiesPropertyChange(PropertyChangeEvent evt) {
    }

    private void jButtonDeletePropertyActionPerformed2(ActionEvent evt) {
        if (this.jTableProperties.getSortedColumn() != null) {
            return;
        }
        if (this.jTableProperties.getSelectedRowCount() > 0) {
            int i;
            DefaultTableModel dtm = (DefaultTableModel)this.jTableProperties.getModel();
            int[] indices = this.jTableProperties.getSelectedRows();
            for (i = indices.length - 1; i >= 0; --i) {
                if (indices[i] >= dtm.getRowCount() - 1) continue;
                Object val = dtm.getValueAt(indices[i], 0);
                dtm.removeRow(indices[i]);
                dtm.insertRow(indices[i] + 1, new Object[]{val, ((QueryExecuterDef)val).getClassName(), ((QueryExecuterDef)val).getFieldsProvider()});
                int n = i;
                indices[n] = indices[n] + 1;
            }
            for (i = 0; i < indices.length; ++i) {
                this.jTableProperties.addRowSelectionInterval(indices[i], indices[i]);
            }
        }
    }

    private void jButtonDeletePropertyActionPerformed1(ActionEvent evt) {
        if (this.jTableProperties.getSortedColumn() != null) {
            return;
        }
        if (this.jTableProperties.getSelectedRowCount() > 0) {
            int i;
            DefaultTableModel dtm = (DefaultTableModel)this.jTableProperties.getModel();
            int[] indices = this.jTableProperties.getSelectedRows();
            for (i = 0; i < indices.length; ++i) {
                if (indices[i] == 0) continue;
                Object val = dtm.getValueAt(indices[i], 0);
                dtm.removeRow(indices[i]);
                dtm.insertRow(indices[i] - 1, new Object[]{val, ((QueryExecuterDef)val).getClassName(), ((QueryExecuterDef)val).getFieldsProvider()});
                int n = i;
                indices[n] = indices[n] - 1;
            }
            for (i = 0; i < indices.length; ++i) {
                this.jTableProperties.addRowSelectionInterval(indices[i], indices[i]);
            }
        }
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void jScrollPane3MouseClicked(MouseEvent evt) {
    }

    private void jTablePropertiesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            if (evt.getButton() == 1 && this.jTableProperties.getSelectedRow() >= 0) {
                this.jButtonModifyPropertyActionPerformed(new ActionEvent(this.jButtonModifyProperty, 0, ""));
            }
        }
    }

    private void jButtonNewPropertyActionPerformed(ActionEvent evt) {
        Frame parent = Misc.frameFromComponent(this);
        QueryExecuterDialog jrpd = new QueryExecuterDialog(parent, true);
        jrpd.setVisible(true);
        if (jrpd.getDialogResult() == 0) {
            QueryExecuterDef qe = jrpd.getQueryExecuterDef();
            ((DefaultTableModel)this.jTableProperties.getModel()).addRow(new Object[]{qe, qe.getClassName(), qe.getFieldsProvider()});
        }
    }

    private void jButtonModifyPropertyActionPerformed(ActionEvent evt) {
        DefaultTableModel dtm = (DefaultTableModel)this.jTableProperties.getModel();
        int index = this.jTableProperties.convertRowIndexToModel(this.jTableProperties.getSelectedRow());
        QueryExecuterDef qe = (QueryExecuterDef)dtm.getValueAt(index, 0);
        Frame parent = Misc.frameFromComponent(this);
        QueryExecuterDialog jrpd = new QueryExecuterDialog(parent, true);
        jrpd.setQueryExecuterDef(qe);
        jrpd.setVisible(true);
        if (jrpd.getDialogResult() == 0) {
            dtm.setValueAt(jrpd.getQueryExecuterDef(), index, 0);
            dtm.setValueAt(jrpd.getQueryExecuterDef().getClassName(), index, 1);
            dtm.setValueAt(jrpd.getQueryExecuterDef().getFieldsProvider(), index, 2);
        }
    }

    private void jButtonDeletePropertyActionPerformed(ActionEvent evt) {
        int[] rows = this.jTableProperties.getSelectedRows();
        DefaultTableModel dtm = (DefaultTableModel)this.jTableProperties.getModel();
        for (int i = rows.length - 1; i >= 0; --i) {
            int index = this.jTableProperties.convertRowIndexToModel(rows[i]);
            Object obj = dtm.getValueAt(index, 0);
            dtm.removeRow(index);
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.saveAll();
        this.setVisible(false);
    }

    public void updateQueryExecuters() {
        DefaultTableModel dtm = (DefaultTableModel)this.jTableProperties.getModel();
        dtm.setRowCount(0);
        Enumeration e = MainFrame.getMainInstance().getQueryExecuters().elements();
        while (e.hasMoreElements()) {
            QueryExecuterDef qe = (QueryExecuterDef)e.nextElement();
            Vector<Object> row = new Vector<Object>();
            row.addElement(qe);
            row.addElement(qe.getClassName());
            row.addElement(qe.getFieldsProvider());
            dtm.addRow(row);
        }
    }

    public void applyI18n() {
        this.jButtonNewProperty.setText(I18n.getString("new", "New"));
        this.jButtonModifyProperty.setText(I18n.getString("modify", "Modify"));
        this.jButtonDeleteProperty.setText(I18n.getString("delete", "Delete"));
        this.jButtonMoveUp.setText(I18n.getString("moveUp", "Move up"));
        this.jButtonMoveDown.setText(I18n.getString("moveDown", "Move down"));
        this.jButtonSave.setText(I18n.getString("close", "Close"));
        this.jTableProperties.getColumnModel().getColumn(0).setHeaderValue(I18n.getString("queryExecutersDialog.tablecolumn.language", "Language"));
        this.jTableProperties.getColumnModel().getColumn(1).setHeaderValue(I18n.getString("queryExecutersDialog.tablecolumn.factoryClass", "Factory class"));
        this.jTableProperties.getColumnModel().getColumn(2).setHeaderValue(I18n.getString("queryExecutersDialog.tablecolumn.fieldsProvider", "Fields Provider"));
        this.setTitle(I18n.getString("queryExecutersDialog.title", "Query executers"));
        this.jButtonSave.setMnemonic(I18n.getString("queryExecutersDialog.buttonSaveMnemonic", "s").charAt(0));
    }

    public void languageChanged(LanguageChangedEvent evt) {
        this.applyI18n();
    }

    public void saveAll() {
        Vector v = MainFrame.getMainInstance().getQueryExecuters();
        v.clear();
        DefaultTableModel dtm = (DefaultTableModel)this.jTableProperties.getModel();
        for (int i = 0; i < dtm.getRowCount(); ++i) {
            QueryExecuterDef qe = (QueryExecuterDef)dtm.getValueAt(i, 0);
            v.add(qe);
        }
        MainFrame.getMainInstance().saveiReportConfiguration();
    }
}

