/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.draw;

import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.export.draw.ElementDrawer;

public class RectangleDrawer
extends ElementDrawer {
    public void draw(Graphics2D grx, JRPrintElement element, int offsetX, int offsetY) {
        JRPrintRectangle rectangle = (JRPrintRectangle)element;
        if (rectangle.getMode() == 1) {
            grx.setColor(rectangle.getBackcolor());
            if (rectangle.getRadius() > 0) {
                grx.fillRoundRect(rectangle.getX() + offsetX, rectangle.getY() + offsetY, rectangle.getWidth(), rectangle.getHeight(), 2 * rectangle.getRadius(), 2 * rectangle.getRadius());
            } else {
                grx.fillRect(rectangle.getX() + offsetX, rectangle.getY() + offsetY, rectangle.getWidth(), rectangle.getHeight());
            }
        }
        grx.setColor(rectangle.getLinePen().getLineColor());
        Stroke stroke = RectangleDrawer.getStroke(rectangle.getLinePen());
        if (stroke != null) {
            AffineTransform transform = grx.getTransform();
            grx.translate(rectangle.getX() + offsetX, rectangle.getY() + offsetY);
            grx.setStroke(stroke);
            if (rectangle.getRadius() > 0) {
                grx.drawRoundRect(0, 0, rectangle.getWidth(), rectangle.getHeight(), 2 * rectangle.getRadius(), 2 * rectangle.getRadius());
            } else {
                grx.drawRect(0, 0, rectangle.getWidth(), rectangle.getHeight());
            }
            grx.setTransform(transform);
        }
    }
}

