/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class SplashDialog
extends JDialog {
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JProgressBar jProgressBar1;

    public SplashDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        try {
            Properties p = MainFrame.getBrandingProperties();
            this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource(p.getProperty("ireport.splashscreen"))));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.applyI18n();
        this.pack();
        Misc.centerFrame(this);
    }

    public void updateLoadingStatus(int status, String label) {
        try {
            final int f_status = status;
            final String f_label = label;
            Runnable r = new Runnable(){

                public void run() {
                    SplashDialog.this.jProgressBar1.setValue(f_status);
                    if (f_label != null) {
                        SplashDialog.this.jProgressBar1.setString(f_label);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(r);
            } else {
                SwingUtilities.invokeAndWait(r);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jProgressBar1 = new JProgressBar();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setUndecorated(true);
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/logo132.png")));
        this.jLabel1.setIconTextGap(0);
        this.jPanel1.add((Component)this.jLabel1, "Center");
        this.jProgressBar1.setMinimumSize(new Dimension(10, 21));
        this.jProgressBar1.setPreferredSize(new Dimension(148, 21));
        this.jProgressBar1.setString("Loading");
        this.jProgressBar1.setStringPainted(true);
        this.jPanel1.add((Component)this.jProgressBar1, "South");
        this.getContentPane().add((Component)this.jPanel1, "North");
        this.pack();
    }

    public void applyI18n() {
    }
}

