/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.box;

import it.businesslogic.ireport.Box;
import it.businesslogic.ireport.gui.box.SampleBoxPanel;
import it.businesslogic.ireport.gui.sheet.HexColorChooserPanel;
import it.businesslogic.ireport.gui.sheet.Tag;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class BoxPanel
extends JPanel {
    private boolean init = false;
    SampleBoxPanel samplePanel = null;
    private Box box = null;
    private JButton jButtonBoxColorBottom;
    private JButton jButtonBoxColorLeft;
    private JButton jButtonBoxColorRight;
    private JButton jButtonBoxColorTop;
    private JComboBox jComboBoxBottom;
    private JComboBox jComboBoxLeft;
    private JComboBox jComboBoxRight;
    private JComboBox jComboBoxTop;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JSpinner jSpinnerBottom;
    private JSpinner jSpinnerLeft;
    private JSpinner jSpinnerRight;
    private JSpinner jSpinnerTop;

    public BoxPanel() {
        this.initComponents();
        this.applyI18n();
        this.samplePanel = new SampleBoxPanel();
        this.init = true;
        this.jComboBoxTop.addItem(new Tag("None", I18n.getString("lineType.None", "None")));
        this.jComboBoxTop.addItem(new Tag("Thin", I18n.getString("lineType.Thin", "Thin")));
        this.jComboBoxTop.addItem(new Tag("1Point", I18n.getString("lineType.1Point", "1Point")));
        this.jComboBoxTop.addItem(new Tag("2Point", I18n.getString("lineType.2Point", "2Point")));
        this.jComboBoxTop.addItem(new Tag("4Point", I18n.getString("lineType.4Point", "4Point")));
        this.jComboBoxTop.addItem(new Tag("Dotted", I18n.getString("lineType.Dotted", "Dotted")));
        this.jComboBoxTop.setSelectedIndex(0);
        this.jComboBoxLeft.addItem(new Tag("None", I18n.getString("lineType.None", "None")));
        this.jComboBoxLeft.addItem(new Tag("Thin", I18n.getString("lineType.Thin", "Thin")));
        this.jComboBoxLeft.addItem(new Tag("1Point", I18n.getString("lineType.1Point", "1Point")));
        this.jComboBoxLeft.addItem(new Tag("2Point", I18n.getString("lineType.2Point", "2Point")));
        this.jComboBoxLeft.addItem(new Tag("4Point", I18n.getString("lineType.4Point", "4Point")));
        this.jComboBoxLeft.addItem(new Tag("Dotted", I18n.getString("lineType.Dotted", "Dotted")));
        this.jComboBoxLeft.setSelectedIndex(0);
        this.jComboBoxRight.addItem(new Tag("None", I18n.getString("lineType.None", "None")));
        this.jComboBoxRight.addItem(new Tag("Thin", I18n.getString("lineType.Thin", "Thin")));
        this.jComboBoxRight.addItem(new Tag("1Point", I18n.getString("lineType.1Point", "1Point")));
        this.jComboBoxRight.addItem(new Tag("2Point", I18n.getString("lineType.2Point", "2Point")));
        this.jComboBoxRight.addItem(new Tag("4Point", I18n.getString("lineType.4Point", "4Point")));
        this.jComboBoxRight.addItem(new Tag("Dotted", I18n.getString("lineType.Dotted", "Dotted")));
        this.jComboBoxRight.setSelectedIndex(0);
        this.jComboBoxBottom.addItem(new Tag("None", I18n.getString("lineType.None", "None")));
        this.jComboBoxBottom.addItem(new Tag("Thin", I18n.getString("lineType.Thin", "Thin")));
        this.jComboBoxBottom.addItem(new Tag("1Point", I18n.getString("lineType.1Point", "1Point")));
        this.jComboBoxBottom.addItem(new Tag("2Point", I18n.getString("lineType.2Point", "2Point")));
        this.jComboBoxBottom.addItem(new Tag("4Point", I18n.getString("lineType.4Point", "4Point")));
        this.jComboBoxBottom.addItem(new Tag("Dotted", I18n.getString("lineType.Dotted", "Dotted")));
        this.jComboBoxBottom.setSelectedIndex(0);
        SpinnerNumberModel snmTop = new SpinnerNumberModel(0, 0, 10000, 1);
        this.jSpinnerTop.setModel(snmTop);
        snmTop.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                BoxPanel.this.jSpinnerTopStateChanged(evt);
            }
        });
        SpinnerNumberModel snmBottom = new SpinnerNumberModel(0, 0, 10000, 1);
        this.jSpinnerBottom.setModel(snmBottom);
        snmBottom.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                BoxPanel.this.jSpinnerBottomStateChanged(evt);
            }
        });
        SpinnerNumberModel snmRight = new SpinnerNumberModel(0, 0, 10000, 1);
        this.jSpinnerRight.setModel(snmRight);
        snmRight.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                BoxPanel.this.jSpinnerRightStateChanged(evt);
            }
        });
        SpinnerNumberModel snmLeft = new SpinnerNumberModel(0, 0, 10000, 1);
        this.jSpinnerLeft.setModel(snmLeft);
        snmLeft.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                BoxPanel.this.jSpinnerLeftStateChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.jPanel3.add((Component)this.samplePanel, gridBagConstraints);
        this.init = false;
    }

    private void jSpinnerTopStateChanged(ChangeEvent evt) {
        this.box.setTopPadding(Integer.parseInt(this.jSpinnerTop.getValue() + ""));
        this.fireActionListenerActionPerformed(new ActionEvent(this, 0, "TopPadding"));
    }

    private void jSpinnerLeftStateChanged(ChangeEvent evt) {
        this.box.setLeftPadding(Integer.parseInt(this.jSpinnerLeft.getValue() + ""));
        this.fireActionListenerActionPerformed(new ActionEvent(this, 0, "LeftPadding"));
    }

    private void jSpinnerRightStateChanged(ChangeEvent evt) {
        this.box.setRightPadding(Integer.parseInt(this.jSpinnerRight.getValue() + ""));
        this.fireActionListenerActionPerformed(new ActionEvent(this, 0, "RightPadding"));
    }

    private void jSpinnerBottomStateChanged(ChangeEvent evt) {
        this.box.setBottomPadding(Integer.parseInt(this.jSpinnerBottom.getValue() + ""));
        this.fireActionListenerActionPerformed(new ActionEvent(this, 0, "BottomPadding"));
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jSpinnerLeft = new JSpinner();
        this.jLabel4 = new JLabel();
        this.jSpinnerTop = new JSpinner();
        this.jLabel5 = new JLabel();
        this.jSpinnerRight = new JSpinner();
        this.jLabel6 = new JLabel();
        this.jSpinnerBottom = new JSpinner();
        this.jPanel1 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jComboBoxTop = new JComboBox();
        this.jButtonBoxColorTop = new JButton();
        this.jButtonBoxColorLeft = new JButton();
        this.jComboBoxLeft = new JComboBox();
        this.jButtonBoxColorBottom = new JButton();
        this.jButtonBoxColorRight = new JButton();
        this.jComboBoxRight = new JComboBox();
        this.jComboBoxBottom = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.setMinimumSize(new Dimension(309, 80));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Padding"));
        this.jLabel3.setText("Left");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints);
        this.jSpinnerLeft.setMinimumSize(new Dimension(50, 20));
        this.jSpinnerLeft.setPreferredSize(new Dimension(50, 20));
        this.jSpinnerLeft.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                BoxPanel.this.jSpinnerLeftPropertyChange(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jSpinnerLeft, gridBagConstraints);
        this.jLabel4.setText("Top");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints);
        this.jSpinnerTop.setMinimumSize(new Dimension(50, 20));
        this.jSpinnerTop.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jSpinnerTop, gridBagConstraints);
        this.jLabel5.setText("Right");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        this.jSpinnerRight.setMinimumSize(new Dimension(50, 20));
        this.jSpinnerRight.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jSpinnerRight, gridBagConstraints);
        this.jLabel6.setText("Bottom");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel2.add((Component)this.jLabel6, gridBagConstraints);
        this.jSpinnerBottom.setMinimumSize(new Dimension(50, 20));
        this.jSpinnerBottom.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jSpinnerBottom, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Border"));
        this.jPanel1.setMinimumSize(new Dimension(360, 230));
        this.jPanel1.setPreferredSize(new Dimension(360, 230));
        this.jPanel3.setLayout(new GridBagLayout());
        this.jPanel3.setBackground(new Color(204, 204, 255));
        this.jPanel3.setBorder(BorderFactory.createEtchedBorder(0));
        this.jPanel3.setMinimumSize(new Dimension(100, 100));
        this.jPanel3.setPreferredSize(new Dimension(100, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        this.jComboBoxTop.setMinimumSize(new Dimension(100, 24));
        this.jComboBoxTop.setPreferredSize(new Dimension(100, 24));
        this.jComboBoxTop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BoxPanel.this.jComboBoxTopActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jComboBoxTop, gridBagConstraints);
        this.jButtonBoxColorTop.setBackground(new Color(0, 0, 0));
        this.jButtonBoxColorTop.setBorder(BorderFactory.createEtchedBorder());
        this.jButtonBoxColorTop.setMaximumSize(new Dimension(100, 10));
        this.jButtonBoxColorTop.setMinimumSize(new Dimension(100, 10));
        this.jButtonBoxColorTop.setPreferredSize(new Dimension(100, 10));
        this.jButtonBoxColorTop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BoxPanel.this.jButtonBoxColorTopActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jButtonBoxColorTop, gridBagConstraints);
        this.jButtonBoxColorLeft.setBackground(new Color(0, 0, 0));
        this.jButtonBoxColorLeft.setBorder(BorderFactory.createEtchedBorder());
        this.jButtonBoxColorLeft.setMaximumSize(new Dimension(10, 100));
        this.jButtonBoxColorLeft.setMinimumSize(new Dimension(10, 100));
        this.jButtonBoxColorLeft.setPreferredSize(new Dimension(10, 100));
        this.jButtonBoxColorLeft.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BoxPanel.this.jButtonBoxColorLeftActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jButtonBoxColorLeft, gridBagConstraints);
        this.jComboBoxLeft.setMinimumSize(new Dimension(100, 24));
        this.jComboBoxLeft.setPreferredSize(new Dimension(100, 24));
        this.jComboBoxLeft.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BoxPanel.this.jComboBoxLeftActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.jPanel1.add((Component)this.jComboBoxLeft, gridBagConstraints);
        this.jButtonBoxColorBottom.setBackground(new Color(0, 0, 0));
        this.jButtonBoxColorBottom.setBorder(BorderFactory.createEtchedBorder());
        this.jButtonBoxColorBottom.setMaximumSize(new Dimension(100, 10));
        this.jButtonBoxColorBottom.setMinimumSize(new Dimension(100, 10));
        this.jButtonBoxColorBottom.setPreferredSize(new Dimension(100, 10));
        this.jButtonBoxColorBottom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BoxPanel.this.jButtonBoxColorBottomActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jButtonBoxColorBottom, gridBagConstraints);
        this.jButtonBoxColorRight.setBackground(new Color(0, 0, 0));
        this.jButtonBoxColorRight.setBorder(BorderFactory.createEtchedBorder());
        this.jButtonBoxColorRight.setMaximumSize(new Dimension(10, 100));
        this.jButtonBoxColorRight.setMinimumSize(new Dimension(10, 100));
        this.jButtonBoxColorRight.setPreferredSize(new Dimension(10, 100));
        this.jButtonBoxColorRight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BoxPanel.this.jButtonBoxColorRightActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jButtonBoxColorRight, gridBagConstraints);
        this.jComboBoxRight.setMinimumSize(new Dimension(100, 24));
        this.jComboBoxRight.setPreferredSize(new Dimension(100, 24));
        this.jComboBoxRight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BoxPanel.this.jComboBoxRightActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.jPanel1.add((Component)this.jComboBoxRight, gridBagConstraints);
        this.jComboBoxBottom.setMinimumSize(new Dimension(100, 24));
        this.jComboBoxBottom.setPreferredSize(new Dimension(100, 24));
        this.jComboBoxBottom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BoxPanel.this.jComboBoxBottomActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.jPanel1.add((Component)this.jComboBoxBottom, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 6, 6);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void jSpinnerLeftPropertyChange(PropertyChangeEvent evt) {
    }

    private void jComboBoxLeftActionPerformed(ActionEvent evt) {
        if (this.init) {
            return;
        }
        this.box.setLeftBorder(Misc.getComboboxSelectedValue(this.jComboBoxLeft) + "");
        this.fireActionListenerActionPerformed(new ActionEvent(this, 0, "LeftBorder"));
    }

    private void jComboBoxBottomActionPerformed(ActionEvent evt) {
        if (this.init) {
            return;
        }
        this.box.setBottomBorder(Misc.getComboboxSelectedValue(this.jComboBoxBottom) + "");
        this.fireActionListenerActionPerformed(new ActionEvent(this, 0, "BottomBorder"));
    }

    private void jComboBoxRightActionPerformed(ActionEvent evt) {
        if (this.init) {
            return;
        }
        this.box.setRightBorder(Misc.getComboboxSelectedValue(this.jComboBoxRight) + "");
        this.fireActionListenerActionPerformed(new ActionEvent(this, 0, "RightBorder"));
    }

    private void jComboBoxTopActionPerformed(ActionEvent evt) {
        if (this.init) {
            return;
        }
        this.box.setTopBorder(Misc.getComboboxSelectedValue(this.jComboBoxTop) + "");
        this.fireActionListenerActionPerformed(new ActionEvent(this, 0, "TopBorder"));
    }

    private void jButtonBoxColorLeftActionPerformed(ActionEvent evt) {
        Color color = HexColorChooserPanel.showDialog(null, I18n.getString("messages.boxPanel.selectColor", "Select color..."), this.jButtonBoxColorLeft.getBackground());
        if (color != null) {
            this.box.setLeftBorderColor(color);
            this.jButtonBoxColorLeft.setBackground(color);
            this.fireActionListenerActionPerformed(new ActionEvent(this, 0, "LeftBorderColor"));
        }
    }

    private void jButtonBoxColorBottomActionPerformed(ActionEvent evt) {
        Color color = HexColorChooserPanel.showDialog(null, I18n.getString("messages.boxPanel.selectColor", "Select color..."), this.jButtonBoxColorBottom.getBackground());
        if (color != null) {
            this.box.setBottomBorderColor(color);
            this.jButtonBoxColorBottom.setBackground(color);
            this.fireActionListenerActionPerformed(new ActionEvent(this, 0, "BottomBorderColor"));
        }
    }

    private void jButtonBoxColorRightActionPerformed(ActionEvent evt) {
        Color color = HexColorChooserPanel.showDialog(null, I18n.getString("messages.boxPanel.selectColor", "Select color..."), this.jButtonBoxColorRight.getBackground());
        if (color != null) {
            this.box.setRightBorderColor(color);
            this.jButtonBoxColorRight.setBackground(color);
            this.fireActionListenerActionPerformed(new ActionEvent(this, 0, "RightBorderColor"));
        }
    }

    private void jButtonBoxColorTopActionPerformed(ActionEvent evt) {
        Color color = HexColorChooserPanel.showDialog(null, I18n.getString("messages.boxPanel.selectColor", "Select color..."), this.jButtonBoxColorTop.getBackground());
        if (color != null) {
            this.box.setTopBorderColor(color);
            this.jButtonBoxColorTop.setBackground(color);
            this.fireActionListenerActionPerformed(new ActionEvent(this, 0, "TopBorderColor"));
        }
    }

    public synchronized void addActionListener(ActionListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ActionListener.class, listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    private void fireActionListenerActionPerformed(ActionEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(event);
        }
        if (this.samplePanel != null) {
            this.samplePanel.setBox(this.box);
        }
    }

    public Box getBox() {
        return this.box;
    }

    public void setBox(Box box) {
        this.box = box;
        if (box == null) {
            box = new Box();
        }
        this.init = true;
        Color c = box.getLeftBorderColor();
        this.jButtonBoxColorLeft.setBackground(c);
        this.jButtonBoxColorLeft.updateUI();
        c = box.getTopBorderColor();
        this.jButtonBoxColorTop.setBackground(c);
        this.jButtonBoxColorTop.updateUI();
        c = box.getRightBorderColor();
        this.jButtonBoxColorRight.setBackground(c);
        this.jButtonBoxColorRight.updateUI();
        c = box.getBottomBorderColor();
        this.jButtonBoxColorBottom.setBackground(c);
        this.jButtonBoxColorBottom.updateUI();
        Misc.setComboboxSelectedTagValue(this.jComboBoxTop, box.getTopBorder());
        Misc.setComboboxSelectedTagValue(this.jComboBoxLeft, box.getLeftBorder());
        Misc.setComboboxSelectedTagValue(this.jComboBoxRight, box.getRightBorder());
        Misc.setComboboxSelectedTagValue(this.jComboBoxBottom, box.getBottomBorder());
        this.jSpinnerBottom.setValue(new Integer(box.getBottomPadding()));
        this.jSpinnerTop.setValue(new Integer(box.getTopPadding()));
        this.jSpinnerLeft.setValue(new Integer(box.getLeftPadding()));
        this.jSpinnerRight.setValue(new Integer(box.getRightPadding()));
        if (this.samplePanel != null) {
            this.samplePanel.setBox(box);
        }
        this.init = false;
    }

    public void applyI18n() {
        this.jLabel3.setText(I18n.getString("boxPanel.label3", "Left"));
        this.jLabel4.setText(I18n.getString("boxPanel.label4", "Top"));
        this.jLabel5.setText(I18n.getString("boxPanel.label5", "Right"));
        this.jLabel6.setText(I18n.getString("boxPanel.label6", "Bottom"));
        ((TitledBorder)this.jPanel1.getBorder()).setTitle(I18n.getString("boxPanel.panelBorder.Border", "Border"));
        ((TitledBorder)this.jPanel2.getBorder()).setTitle(I18n.getString("boxPanel.panelBorder.Padding", "Padding"));
    }
}

