/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jmx;

import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.jmx.HibernateServiceMBean;
import org.hibernate.jmx.SessionFactoryStub;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.util.ExternalSessionFactoryConfig;
import org.hibernate.util.NamingHelper;

public class HibernateService
extends ExternalSessionFactoryConfig
implements HibernateServiceMBean {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$jmx$HibernateServiceMBean == null ? (class$org$hibernate$jmx$HibernateServiceMBean = HibernateService.class$("org.hibernate.jmx.HibernateServiceMBean")) : class$org$hibernate$jmx$HibernateServiceMBean));
    private String boundName;
    private Properties properties = new Properties();
    static /* synthetic */ Class class$org$hibernate$jmx$HibernateServiceMBean;

    public void start() throws HibernateException {
        this.boundName = this.getJndiName();
        try {
            this.buildSessionFactory();
        }
        catch (HibernateException he) {
            log.info((Object)("Could not build SessionFactory using the MBean classpath - will try again using client classpath: " + he.getMessage()));
            log.debug((Object)"Error was", (Throwable)he);
            new SessionFactoryStub(this);
        }
    }

    public void stop() {
        log.info((Object)"stopping service");
        try {
            InitialContext context = NamingHelper.getInitialContext(this.buildProperties());
            ((SessionFactory)context.lookup(this.boundName)).close();
        }
        catch (Exception e) {
            log.warn((Object)"exception while stopping service", (Throwable)e);
        }
    }

    SessionFactory buildSessionFactory() throws HibernateException {
        log.info((Object)("starting service at JNDI name: " + this.boundName));
        log.info((Object)("service properties: " + this.properties));
        return this.buildConfiguration().buildSessionFactory();
    }

    protected Map getExtraProperties() {
        return this.properties;
    }

    public String getTransactionStrategy() {
        return this.getProperty("hibernate.transaction.factory_class");
    }

    public void setTransactionStrategy(String txnStrategy) {
        this.setProperty("hibernate.transaction.factory_class", txnStrategy);
    }

    public String getUserTransactionName() {
        return this.getProperty("jta.UserTransaction");
    }

    public void setUserTransactionName(String utName) {
        this.setProperty("jta.UserTransaction", utName);
    }

    public String getTransactionManagerLookupStrategy() {
        return this.getProperty("hibernate.transaction.manager_lookup_class");
    }

    public void setTransactionManagerLookupStrategy(String lkpStrategy) {
        this.setProperty("hibernate.transaction.manager_lookup_class", lkpStrategy);
    }

    public String getPropertyList() {
        return this.buildProperties().toString();
    }

    public String getProperty(String property) {
        return this.properties.getProperty(property);
    }

    public void setProperty(String property, String value) {
        this.properties.setProperty(property, value);
    }

    public void dropSchema() {
        new SchemaExport(this.buildConfiguration()).drop(false, true);
    }

    public void createSchema() {
        new SchemaExport(this.buildConfiguration()).create(false, true);
    }

    public String getName() {
        return this.getProperty("hibernate.session_factory_name");
    }

    public String getDatasource() {
        return this.getProperty("hibernate.connection.datasource");
    }

    public void setDatasource(String datasource) {
        this.setProperty("hibernate.connection.datasource", datasource);
    }

    public String getJndiName() {
        return this.getProperty("hibernate.session_factory_name");
    }

    public void setJndiName(String jndiName) {
        this.setProperty("hibernate.session_factory_name", jndiName);
    }

    public String getUserName() {
        return this.getProperty("hibernate.connection.username");
    }

    public void setUserName(String userName) {
        this.setProperty("hibernate.connection.username", userName);
    }

    public String getPassword() {
        return this.getProperty("hibernate.connection.password");
    }

    public void setPassword(String password) {
        this.setProperty("hibernate.connection.password", password);
    }

    public void setFlushBeforeCompletionEnabled(String enabled) {
        this.setProperty("hibernate.transaction.flush_before_completion", enabled);
    }

    public String getFlushBeforeCompletionEnabled() {
        return this.getProperty("hibernate.transaction.flush_before_completion");
    }

    public void setAutoCloseSessionEnabled(String enabled) {
        this.setProperty("hibernate.transaction.auto_close_session", enabled);
    }

    public String getAutoCloseSessionEnabled() {
        return this.getProperty("hibernate.transaction.auto_close_session");
    }

    public Properties getProperties() {
        return this.buildProperties();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

