/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.treetable;

import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;

public class DefaultTreeTableModel
extends AbstractTreeTableModel {
    protected boolean asksAllowsChildren;

    public DefaultTreeTableModel() {
        this(null);
    }

    public DefaultTreeTableModel(TreeNode root) {
        this(root, false);
    }

    public DefaultTreeTableModel(TreeNode root, boolean asksAllowsChildren) {
        super(root);
        this.asksAllowsChildren = asksAllowsChildren;
    }

    public void setRoot(TreeNode root) {
        Object oldRoot = this.root;
        this.root = root;
        if (root == null && oldRoot != null) {
            this.fireTreeStructureChanged(this, null);
        } else {
            this.nodeStructureChanged(root);
        }
    }

    private void fireTreeStructureChanged(Object source, TreePath path) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path);
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
    }

    public boolean asksAllowsChildren() {
        return this.asksAllowsChildren;
    }

    public void setAsksAllowsChildren(boolean newValue) {
        this.asksAllowsChildren = newValue;
    }

    public Object getValueAt(Object node, int column) {
        return node + "@column " + column;
    }

    public void setValueAt(Object value, Object node, int column) {
    }

    public TreeNode[] getPathToRoot(TreeNode node) {
        return this.getPathToRoot(node, 0);
    }

    protected TreeNode[] getPathToRoot(TreeNode node, int depth) {
        TreeNode[] retNodes;
        if (node == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new TreeNode[depth];
        } else {
            retNodes = node == this.root ? new TreeNode[depth] : this.getPathToRoot(node.getParent(), ++depth);
            retNodes[retNodes.length - depth] = node;
        }
        return retNodes;
    }

    public boolean isLeaf(Object node) {
        if (node instanceof TreeNode && this.asksAllowsChildren) {
            return !((TreeNode)node).getAllowsChildren();
        }
        return super.isLeaf(node);
    }

    public void reload() {
        TreeNode treeNode;
        try {
            treeNode = (TreeNode)this.root;
        }
        catch (ClassCastException ex) {
            return;
        }
        this.reload(treeNode);
    }

    public void reload(TreeNode node) {
        if (node != null) {
            this.fireTreeStructureChanged(this, this.getPathToRoot(node), null, null);
        }
    }

    public void nodesWereInserted(TreeNode node, int[] childIndices) {
        if (this.listenerList != null && node != null && childIndices != null && childIndices.length > 0) {
            int cCount = childIndices.length;
            Object[] newChildren = new Object[cCount];
            for (int counter = 0; counter < cCount; ++counter) {
                newChildren[counter] = node.getChildAt(childIndices[counter]);
            }
            this.fireTreeNodesInserted(this, this.getPathToRoot(node), childIndices, newChildren);
        }
    }

    public void nodesWereRemoved(TreeNode node, int[] childIndices, Object[] removedChildren) {
        if (node != null && childIndices != null) {
            this.fireTreeNodesRemoved(this, this.getPathToRoot(node), childIndices, removedChildren);
        }
    }

    public void nodesChanged(TreeNode node, int[] childIndices) {
        if (node != null) {
            if (childIndices != null) {
                int cCount = childIndices.length;
                if (cCount > 0) {
                    Object[] cChildren = new Object[cCount];
                    for (int counter = 0; counter < cCount; ++counter) {
                        cChildren[counter] = node.getChildAt(childIndices[counter]);
                    }
                    this.fireTreeNodesChanged(this, this.getPathToRoot(node), childIndices, cChildren);
                }
            } else if (node == this.getRoot()) {
                this.fireTreeNodesChanged(this, this.getPathToRoot(node), null, null);
            }
        }
    }

    public void nodeStructureChanged(TreeNode node) {
        if (node != null) {
            this.fireTreeStructureChanged(this, this.getPathToRoot(node), null, null);
        }
    }
}

