/*
 * Decompiled with CFR 0.152.
 */
package be.savat.components;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.MouseInputListener;

public class JBookPanel
extends JPanel
implements MouseInputListener,
ActionListener {
    protected static final double PI_DIV_2 = 1.5707963267948966;
    protected static final int AUTO_TURN = 0;
    protected static final int AUTO_DROP_GO_BACK = 1;
    protected static final int AUTO_DROP_BUT_TURN = 2;
    protected int rotationX;
    protected double nextPageAngle;
    protected double backPageAngle;
    protected Timer timer;
    protected Integer action;
    protected Point autoPoint;
    protected Point tmpPoint;
    protected int leftPageIndex;
    protected Image currentLeftImage;
    protected Image currentRightImage;
    protected Image nextLeftImage;
    protected Image nextRightImage;
    protected Image previousLeftImage;
    protected Image previousRightImage;
    protected String pageLocation;
    protected String pageName;
    protected String pageExtension;
    protected int nrOfPages;
    protected boolean leftPageTurn;
    protected int refreshSpeed;
    protected Rectangle bookBounds;
    protected int pageWidth;
    protected int shadowWidth;
    protected int cornerRegionSize;
    protected boolean softClipping;
    protected boolean borderLinesVisible;
    protected Color shadowDarkColor;
    protected Color shadowNeutralColor;
    protected GeneralPath clipPath;

    public JBookPanel() {
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.getInputMap().put(KeyStroke.getKeyStroke(39, 0), "nextPage");
        this.getInputMap().put(KeyStroke.getKeyStroke(38, 0), "nextPage");
        this.getActionMap().put("nextPage", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JBookPanel.this.leftPageTurn = false;
                JBookPanel.this.nextPage();
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(37, 0), "previousPage");
        this.getInputMap().put(KeyStroke.getKeyStroke(40, 0), "previousPage");
        this.getActionMap().put("previousPage", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JBookPanel.this.previousPage();
            }
        });
        this.refreshSpeed = 25;
        this.shadowWidth = 100;
        this.cornerRegionSize = 20;
        this.bookBounds = new Rectangle();
        this.softClipping = false;
        this.borderLinesVisible = true;
        this.clipPath = new GeneralPath();
        this.shadowDarkColor = new Color(0, 0, 0, 130);
        this.shadowNeutralColor = new Color(255, 255, 255, 0);
        this.setBackground(Color.LIGHT_GRAY);
        this.timer = new Timer(this.refreshSpeed, this);
        this.timer.stop();
        this.leftPageIndex = 1;
        this.setPages(null, null, null, 13, 210, 342);
        this.setMargins(70, 80);
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        this.setGraphicsHints(g2);
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.paintPage(g2, this.currentLeftImage, this.bookBounds.x, this.bookBounds.y, this.pageWidth, this.bookBounds.height, this, false);
        this.paintPage(g2, this.currentRightImage, this.bookBounds.x + this.pageWidth, this.bookBounds.y, this.pageWidth, this.bookBounds.height, this, true);
        if (this.leftPageTurn) {
            if (this.softClipping) {
                this.paintLeftPageSoftClipped(g2);
            } else {
                this.paintLeftPage(g2);
            }
        } else if (this.softClipping) {
            this.paintRightPageSoftClipped(g2);
        } else {
            this.paintRightPage(g2);
        }
    }

    protected void paintLeftPage(Graphics2D g2) {
        g2.translate(this.bookBounds.width + this.bookBounds.x - this.rotationX + this.bookBounds.x, this.bookBounds.y + this.bookBounds.height);
        g2.rotate(-this.backPageAngle);
        int done = this.bookBounds.width + this.bookBounds.x - this.rotationX;
        g2.translate(done - this.pageWidth, 0);
        this.clipPath.reset();
        this.clipPath.moveTo(this.pageWidth, 0.0f);
        this.clipPath.lineTo(this.pageWidth - done, 0.0f);
        this.clipPath.lineTo(this.pageWidth, -1 * (int)(Math.tan(1.5707963267948966 - this.nextPageAngle) * (double)done));
        this.clipPath.closePath();
        Shape s = g2.getClip();
        g2.clip(this.clipPath);
        this.paintPage(g2, this.previousRightImage, 0, 0 - this.bookBounds.height, this.pageWidth, this.bookBounds.height, this, false);
        g2.setClip(s);
        g2.translate(this.pageWidth - done, 0);
        g2.rotate(this.backPageAngle);
        g2.translate(this.rotationX - this.bookBounds.width - this.bookBounds.x - this.bookBounds.x, -this.bookBounds.y - this.bookBounds.height);
        this.clipPath.reset();
        this.clipPath.moveTo(this.bookBounds.x, this.bookBounds.height + this.bookBounds.y);
        this.clipPath.lineTo(this.bookBounds.x + done, this.bookBounds.height + this.bookBounds.y);
        this.clipPath.lineTo(this.bookBounds.x, this.bookBounds.height + this.bookBounds.y - (int)(Math.tan(1.5707963267948966 - this.nextPageAngle) * (double)done));
        this.clipPath.closePath();
        g2.clip(this.clipPath);
        this.paintPage(g2, this.previousLeftImage, this.bookBounds.x, this.bookBounds.y, this.pageWidth, this.bookBounds.height, this, true);
        GradientPaint grad = new GradientPaint(this.bookBounds.x + done, this.bookBounds.height + this.bookBounds.y, this.shadowDarkColor, this.bookBounds.x + done - this.shadowWidth, this.bookBounds.height + this.bookBounds.y + (int)(Math.cos(1.5707963267948966 - this.nextPageAngle) * (double)this.shadowWidth), this.shadowNeutralColor, false);
        g2.setPaint(grad);
        g2.fillRect(this.bookBounds.x, this.bookBounds.y, this.pageWidth, this.bookBounds.height);
    }

    protected void paintLeftPageSoftClipped(Graphics2D g2) {
        int done = this.bookBounds.width + this.bookBounds.x - this.rotationX;
        this.clipPath.reset();
        this.clipPath.moveTo(this.pageWidth, 0.0f);
        this.clipPath.lineTo(this.pageWidth - done, 0.0f);
        this.clipPath.lineTo(this.pageWidth, -1 * (int)(Math.tan(1.5707963267948966 - this.nextPageAngle) * (double)done));
        this.clipPath.closePath();
        GraphicsConfiguration gc = g2.getDeviceConfiguration();
        BufferedImage img = gc.createCompatibleImage(this.getWidth(), this.getHeight(), 3);
        Graphics2D gImg = img.createGraphics();
        gImg.translate(this.bookBounds.width + this.bookBounds.x - this.rotationX + this.bookBounds.x, this.bookBounds.y + this.bookBounds.height);
        gImg.rotate(-this.backPageAngle);
        gImg.translate(done - this.pageWidth, 0);
        gImg.setComposite(AlphaComposite.Clear);
        gImg.fillRect(0, 0, this.getWidth(), this.getHeight());
        gImg.setComposite(AlphaComposite.Src);
        gImg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gImg.setColor(Color.WHITE);
        gImg.fill(this.clipPath);
        gImg.setColor(new Color(255, 255, 255, 0));
        gImg.fillRect(0, 0 - this.bookBounds.height - this.bookBounds.height, this.pageWidth + 10, this.bookBounds.height);
        gImg.setComposite(AlphaComposite.SrcAtop);
        this.paintPage(gImg, this.previousRightImage, 0, 0 - this.bookBounds.height, this.pageWidth, this.bookBounds.height, this, false);
        gImg.translate(this.pageWidth - done, 0);
        gImg.rotate(this.backPageAngle);
        gImg.translate(this.rotationX - this.bookBounds.width - this.bookBounds.x - this.bookBounds.x, -this.bookBounds.y - this.bookBounds.height);
        gImg.dispose();
        g2.drawImage((Image)img, 0, 0, null);
        this.clipPath.reset();
        this.clipPath.moveTo(this.bookBounds.x, this.bookBounds.height + this.bookBounds.y);
        this.clipPath.lineTo(this.bookBounds.x + done, this.bookBounds.height + this.bookBounds.y);
        this.clipPath.lineTo(this.bookBounds.x, this.bookBounds.height + this.bookBounds.y - (int)(Math.tan(1.5707963267948966 - this.nextPageAngle) * (double)done));
        this.clipPath.closePath();
        img = gc.createCompatibleImage(this.getWidth(), this.getHeight(), 3);
        gImg = img.createGraphics();
        gImg.setComposite(AlphaComposite.Clear);
        gImg.fillRect(0, 0, this.getWidth(), this.getHeight());
        gImg.setComposite(AlphaComposite.Src);
        gImg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gImg.setColor(Color.WHITE);
        gImg.fill(this.clipPath);
        gImg.setColor(new Color(255, 255, 255, 0));
        gImg.fillRect(0, 0, this.getWidth(), this.bookBounds.y);
        gImg.setComposite(AlphaComposite.SrcAtop);
        this.paintPage(gImg, this.previousLeftImage, this.bookBounds.x, this.bookBounds.y, this.pageWidth, this.bookBounds.height, this, true);
        GradientPaint grad = new GradientPaint(this.bookBounds.x + done, this.bookBounds.height + this.bookBounds.y, this.shadowDarkColor, this.bookBounds.x + done - this.shadowWidth, this.bookBounds.height + this.bookBounds.y + (int)(Math.cos(1.5707963267948966 - this.nextPageAngle) * (double)this.shadowWidth), this.shadowNeutralColor, false);
        gImg.setPaint(grad);
        gImg.fillRect(this.bookBounds.x, this.bookBounds.y, this.pageWidth, this.bookBounds.height);
        gImg.dispose();
        g2.drawImage((Image)img, 0, 0, null);
    }

    protected void paintRightPage(Graphics2D g2) {
        g2.translate(this.rotationX, this.bookBounds.y + this.bookBounds.height);
        g2.rotate(this.backPageAngle);
        int done = this.bookBounds.width + this.bookBounds.x - this.rotationX;
        g2.translate(-done, 0);
        this.clipPath.reset();
        this.clipPath.moveTo(0.0f, 0.0f);
        this.clipPath.lineTo(done, 0.0f);
        this.clipPath.lineTo(0.0f, -1 * (int)(Math.tan(1.5707963267948966 - this.nextPageAngle) * (double)done));
        this.clipPath.closePath();
        Shape s = g2.getClip();
        g2.clip(this.clipPath);
        this.paintPage(g2, this.nextLeftImage, 0, 0 - this.bookBounds.height, this.pageWidth, this.bookBounds.height, this, false);
        g2.setClip(s);
        g2.translate(done, 0);
        g2.rotate(-this.backPageAngle);
        g2.translate(-this.rotationX, -this.bookBounds.y - this.bookBounds.height);
        this.clipPath.reset();
        this.clipPath.moveTo(this.bookBounds.width + this.bookBounds.x, this.bookBounds.height + this.bookBounds.y);
        this.clipPath.lineTo(this.rotationX, this.bookBounds.height + this.bookBounds.y);
        this.clipPath.lineTo(this.bookBounds.width + this.bookBounds.x, this.bookBounds.height + this.bookBounds.y - (int)(Math.tan(1.5707963267948966 - this.nextPageAngle) * (double)done));
        this.clipPath.closePath();
        g2.clip(this.clipPath);
        this.paintPage(g2, this.nextRightImage, this.pageWidth + this.bookBounds.x, this.bookBounds.y, this.pageWidth, this.bookBounds.height, this, true);
        GradientPaint grad = new GradientPaint(this.rotationX, this.bookBounds.height + this.bookBounds.y, this.shadowDarkColor, this.rotationX + this.shadowWidth, this.bookBounds.height + this.bookBounds.y + (int)(Math.cos(1.5707963267948966 - this.nextPageAngle) * (double)this.shadowWidth), this.shadowNeutralColor, false);
        g2.setPaint(grad);
        g2.fillRect(this.pageWidth + this.bookBounds.x, this.bookBounds.y, this.pageWidth, this.bookBounds.height);
    }

    protected void paintRightPageSoftClipped(Graphics2D g2) {
        int done = this.bookBounds.width + this.bookBounds.x - this.rotationX;
        this.clipPath.reset();
        this.clipPath.moveTo(0.0f, 0.0f);
        this.clipPath.lineTo(done, 0.0f);
        this.clipPath.lineTo(0.0f, -1 * (int)(Math.tan(1.5707963267948966 - this.nextPageAngle) * (double)done));
        this.clipPath.closePath();
        GraphicsConfiguration gc = g2.getDeviceConfiguration();
        BufferedImage img = gc.createCompatibleImage(this.getWidth(), this.getHeight(), 3);
        Graphics2D gImg = img.createGraphics();
        gImg.translate(this.rotationX, this.bookBounds.y + this.bookBounds.height);
        gImg.rotate(this.backPageAngle);
        gImg.translate(-done, 0);
        gImg.setComposite(AlphaComposite.Clear);
        gImg.fillRect(0, 0, this.getWidth(), this.getHeight());
        gImg.setComposite(AlphaComposite.Src);
        gImg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gImg.setColor(Color.WHITE);
        gImg.fill(this.clipPath);
        gImg.setColor(new Color(255, 255, 255, 0));
        gImg.fillRect(-10, 0 - this.bookBounds.height - this.bookBounds.height, this.pageWidth + 10, this.bookBounds.height);
        gImg.setComposite(AlphaComposite.SrcAtop);
        this.paintPage(gImg, this.nextLeftImage, 0, 0 - this.bookBounds.height, this.pageWidth, this.bookBounds.height, this, false);
        gImg.translate(done, 0);
        gImg.rotate(-this.backPageAngle);
        gImg.translate(-this.rotationX, -this.bookBounds.y - this.bookBounds.height);
        gImg.dispose();
        g2.drawImage((Image)img, 0, 0, null);
        this.clipPath.reset();
        this.clipPath.moveTo(this.bookBounds.width + this.bookBounds.x, this.bookBounds.height + this.bookBounds.y);
        this.clipPath.lineTo(this.rotationX, this.bookBounds.height + this.bookBounds.y);
        this.clipPath.lineTo(this.bookBounds.width + this.bookBounds.x, this.bookBounds.height + this.bookBounds.y - (int)(Math.tan(1.5707963267948966 - this.nextPageAngle) * (double)done));
        this.clipPath.closePath();
        img = gc.createCompatibleImage(this.getWidth(), this.getHeight(), 3);
        gImg = img.createGraphics();
        gImg.setComposite(AlphaComposite.Clear);
        gImg.fillRect(0, 0, this.getWidth(), this.getHeight());
        gImg.setComposite(AlphaComposite.Src);
        gImg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gImg.setColor(Color.WHITE);
        gImg.fill(this.clipPath);
        gImg.setColor(new Color(255, 255, 255, 0));
        gImg.fillRect(0, 0, this.getWidth(), this.bookBounds.y);
        gImg.setComposite(AlphaComposite.SrcAtop);
        this.paintPage(gImg, this.nextRightImage, this.pageWidth + this.bookBounds.x, this.bookBounds.y, this.pageWidth, this.bookBounds.height, this, true);
        GradientPaint grad = new GradientPaint(this.rotationX, this.bookBounds.height + this.bookBounds.y, this.shadowDarkColor, this.rotationX + this.shadowWidth, this.bookBounds.height + this.bookBounds.y + (int)(Math.cos(1.5707963267948966 - this.nextPageAngle) * (double)this.shadowWidth), this.shadowNeutralColor, false);
        gImg.setPaint(grad);
        gImg.fillRect(this.pageWidth + this.bookBounds.x, this.bookBounds.y, this.pageWidth, this.bookBounds.height);
        gImg.dispose();
        g2.drawImage((Image)img, 0, 0, null);
    }

    protected void paintPage(Graphics2D g, Image img, int x, int y, int w, int h, ImageObserver o, boolean rightPage) {
        if (img == null) {
            Color oldColor = g.getColor();
            g.setColor(this.getBackground());
            g.fillRect(x, y, w + 10, h + 10);
            g.setColor(oldColor);
            return;
        }
        Color oldColor = g.getColor();
        g.drawImage(img, x, y, w, h, o);
        if (!this.borderLinesVisible) {
            return;
        }
        if (rightPage) {
            g.setColor(Color.GRAY);
            g.drawLine(x + w, y, x + w, y + h);
            g.drawLine(x, y, x + w, y);
            g.drawLine(x, y + h, x + w, y + h);
            g.setColor(Color.LIGHT_GRAY);
            g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 1);
            g.drawLine(x, y + 1, x + w - 1, y + 1);
            g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            g.drawLine(x, y + 2, x, y + h - 2);
            g.setColor(oldColor);
        } else {
            g.setColor(Color.GRAY);
            g.drawLine(x, y, x, y + h);
            g.drawLine(x, y, x + w, y);
            g.drawLine(x, y + h, x + w, y + h);
            g.setColor(Color.LIGHT_GRAY);
            g.drawLine(x + 1, y + 1, x + 1, y + h - 1);
            g.drawLine(x + 1, y + 1, x + w - 1, y + 1);
            g.drawLine(x + 1, y + h - 1, x + w - 1, y + h - 1);
            g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 2);
            g.setColor(oldColor);
        }
    }

    protected void paintPageNumber(Graphics g, int index, int width, int height) {
        g.setFont(new Font("Arial", 1, 11));
        int w = (int)g.getFontMetrics().getStringBounds(String.valueOf(index), g).getWidth();
        int x = index % 2 == 0 ? width - 8 - w : 8;
        int y = height - 10;
        g.setColor(Color.GRAY);
        g.drawString(String.valueOf(index), x, y);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        if (this.isMouseInRegion(e)) {
            this.nextPage();
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.action != null) {
            return;
        }
        if (this.rotationX == this.bookBounds.x + this.bookBounds.width && e.getPoint().x < this.bookBounds.x + this.pageWidth) {
            this.leftPageTurn = true;
        }
        if (this.isMouseInBook(e)) {
            if (this.getCursor().getType() != 12) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            }
            this.calculate(e.getPoint());
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (this.action != null) {
            return;
        }
        if (this.isMouseInRegion(e)) {
            int xOffset = this.leftPageTurn ? 10 : -10;
            Point p = new Point(e.getX() + xOffset, e.getY() - 10);
            this.calculate(p);
        } else if (this.rotationX != this.bookBounds.width + this.bookBounds.x) {
            this.rotationX = this.bookBounds.width + this.bookBounds.x;
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.getCursor().getType() != 0) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (this.rotationX != this.bookBounds.width + this.bookBounds.x && this.rotationX != this.bookBounds.x) {
            if (this.passedThreshold()) {
                System.out.println("drop turn");
                this.action = new Integer(2);
                this.autoPoint = (Point)e.getPoint().clone();
                if (this.leftPageTurn) {
                    this.autoPoint.x = this.transformIndex(this.autoPoint.x);
                }
                this.tmpPoint = (Point)this.autoPoint.clone();
                this.timer.restart();
            } else {
                System.out.println("drop go back");
                this.action = new Integer(1);
                this.autoPoint = (Point)e.getPoint().clone();
                if (this.leftPageTurn) {
                    this.autoPoint.x = this.transformIndex(this.autoPoint.x);
                }
                this.tmpPoint = (Point)this.autoPoint.clone();
                this.timer.restart();
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        switch (this.action) {
            case 0: {
                double nextX;
                double x = nextX = this.autoPoint.getX() - 15.0;
                x = x - (double)this.bookBounds.x - (double)this.pageWidth;
                double y = -1.0 * Math.pow(x / (double)this.pageWidth, 2.0);
                y += 1.0;
                y *= 50.0;
                if (this.leftPageTurn) {
                    nextX = this.transformIndex(nextX);
                }
                this.autoPoint.setLocation(nextX, (double)(this.bookBounds.y + this.bookBounds.height) - y);
                if (nextX <= (double)this.bookBounds.x || nextX >= (double)(this.bookBounds.x + this.bookBounds.width)) {
                    this.timer.stop();
                    this.action = null;
                    this.switchImages();
                    this.autoPoint.x = this.bookBounds.x;
                    this.calculate(this.autoPoint);
                    this.initRotationX();
                    this.repaint();
                    return;
                }
                this.calculate(this.autoPoint);
                break;
            }
            case 1: {
                int xDiff = this.bookBounds.width + this.bookBounds.x - this.autoPoint.x;
                int stepsNeeded = 1 + xDiff / 15;
                if (stepsNeeded == 0) {
                    stepsNeeded = 1;
                }
                int yStep = (this.bookBounds.y + this.bookBounds.height - this.autoPoint.y) / stepsNeeded;
                this.tmpPoint.x += 15;
                this.tmpPoint.y += yStep;
                if (this.tmpPoint.x >= this.bookBounds.width + this.bookBounds.x) {
                    this.timer.stop();
                    this.action = null;
                }
                Point newPoint = (Point)this.tmpPoint.clone();
                if (this.leftPageTurn) {
                    newPoint.x = this.transformIndex(this.tmpPoint.x);
                }
                this.calculate(newPoint);
                break;
            }
            case 2: {
                int xDiff2 = this.autoPoint.x - this.bookBounds.x;
                int stepsNeeded2 = 1 + xDiff2 / 15;
                if (stepsNeeded2 == 0) {
                    stepsNeeded2 = 1;
                }
                int yStep2 = (this.bookBounds.y + this.bookBounds.height - this.autoPoint.y) / stepsNeeded2;
                this.tmpPoint.x -= 15;
                this.tmpPoint.y += yStep2;
                if (this.tmpPoint.x <= this.bookBounds.x) {
                    this.timer.stop();
                    this.action = null;
                    this.switchImages();
                    this.tmpPoint.x = this.leftPageTurn ? this.transformIndex(this.bookBounds.x) : this.bookBounds.x;
                    this.tmpPoint.y = this.bookBounds.y + this.bookBounds.height;
                    this.calculate(this.tmpPoint);
                    this.initRotationX();
                    this.repaint();
                    return;
                }
                Point newPoint2 = (Point)this.tmpPoint.clone();
                if (this.leftPageTurn) {
                    newPoint2.x = this.transformIndex(this.tmpPoint.x);
                }
                this.calculate(newPoint2);
            }
        }
    }

    protected boolean isMouseInRegion(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        int maxX = this.bookBounds.x + this.bookBounds.width;
        int minX = maxX - this.cornerRegionSize;
        int maxY = this.bookBounds.y + this.bookBounds.height;
        int minY = maxY - this.cornerRegionSize;
        int minX2 = this.bookBounds.x;
        int maxX2 = minX2 + this.cornerRegionSize;
        this.leftPageTurn = x < maxX2 && x > minX2;
        return y < maxY && y > minY && (x < maxX && x > minX || x < maxX2 && x > minX2);
    }

    protected boolean isMouseInBook(MouseEvent e) {
        return this.bookBounds.contains(e.getX(), e.getY());
    }

    protected double transformIndex(double x) {
        return (double)(this.bookBounds.width + this.bookBounds.x) - x + (double)this.bookBounds.x;
    }

    protected int transformIndex(int x) {
        return this.bookBounds.width + this.bookBounds.x - x + this.bookBounds.x;
    }

    protected void calculate(Point p) {
        if (this.leftPageTurn) {
            p.x = this.transformIndex(p.x);
        }
        if (this.currentRightImage == null && !this.leftPageTurn) {
            this.rotationX = this.bookBounds.width + this.bookBounds.x;
            this.nextPageAngle = 0.0;
            this.backPageAngle = 0.0;
            return;
        }
        if (this.currentLeftImage == null && this.leftPageTurn) {
            this.rotationX = this.bookBounds.width + this.bookBounds.x;
            this.nextPageAngle = 0.0;
            this.backPageAngle = 0.0;
            return;
        }
        Point cp = new Point(this.bookBounds.width + this.bookBounds.x, this.bookBounds.y + this.bookBounds.height);
        double bRico = 1.0 * ((double)cp.x - p.getX()) / ((double)cp.y - p.getY());
        bRico = -bRico;
        Point mid = new Point(0, 0);
        mid.x = (int)(((double)cp.x + p.getX()) / 2.0);
        mid.y = (int)(((double)cp.y + p.getY()) / 2.0);
        double c = (double)mid.y - bRico * (double)mid.x;
        this.rotationX = Math.max((int)(((double)cp.y - c) / bRico), this.pageWidth + this.bookBounds.x);
        this.nextPageAngle = 1.5707963267948966 - Math.abs(Math.atan(bRico));
        this.backPageAngle = 2.0 * this.nextPageAngle;
        this.repaint();
    }

    public void nextPage() {
        this.action = new Integer(0);
        this.autoPoint = new Point(this.bookBounds.x + this.bookBounds.width, this.bookBounds.y + this.bookBounds.height);
        this.timer.restart();
    }

    public void previousPage() {
        this.leftPageTurn = true;
        this.nextPage();
    }

    protected void initRotationX() {
        this.rotationX = this.bookBounds.width + this.bookBounds.x;
    }

    protected boolean passedThreshold() {
        int done = this.bookBounds.width + this.bookBounds.x - this.rotationX;
        double X = Math.min(Math.tan(1.5707963267948966 - this.nextPageAngle) * (double)done, (double)this.bookBounds.height);
        double threshold = this.bookBounds.height * this.pageWidth;
        return (X *= (double)(done * 2)) > threshold;
    }

    protected void switchImages() {
        if (this.leftPageTurn) {
            this.leftPageIndex -= 2;
            this.currentLeftImage = this.previousLeftImage;
            this.currentRightImage = this.previousRightImage;
        } else {
            this.leftPageIndex += 2;
            this.currentLeftImage = this.nextLeftImage;
            this.currentRightImage = this.nextRightImage;
        }
        this.nextLeftImage = this.getPage(this.leftPageIndex + 2);
        this.nextRightImage = this.getPage(this.leftPageIndex + 3);
        this.previousLeftImage = this.getPage(this.leftPageIndex - 2);
        this.previousRightImage = this.getPage(this.leftPageIndex - 1);
    }

    protected BufferedImage getBlankPage(int index) {
        BufferedImage img = new BufferedImage(this.pageWidth, this.bookBounds.height, 5);
        Graphics gfx = img.getGraphics();
        gfx.setColor(Color.WHITE);
        gfx.fillRect(0, 0, img.getWidth(), img.getHeight());
        return img;
    }

    protected void setGraphicsHints(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }

    protected Image loadPage(int index) {
        return new ImageIcon(JBookPanel.class.getResource(this.pageLocation + this.pageName + index + "." + this.pageExtension)).getImage();
    }

    protected Image getPage(int index) {
        if (index > this.nrOfPages) {
            if ((index - 1) % 2 == 0) {
                return this.getBlankPage(index);
            }
            return null;
        }
        if (index < 1) {
            if (index == 0) {
                try {
                    return this.loadPage(index);
                }
                catch (Exception e) {
                    return this.getBlankPage(index);
                }
            }
            return null;
        }
        if (this.pageLocation == null || this.pageName == null || this.pageExtension == null) {
            BufferedImage img = this.getBlankPage(index);
            Graphics gfx = img.getGraphics();
            Graphics2D g2 = (Graphics2D)gfx;
            this.setGraphicsHints(g2);
            this.paintPageNumber(gfx, index, img.getWidth(), img.getHeight());
            return img;
        }
        return this.loadPage(index);
    }

    public void setMargins(int top, int left) {
        this.bookBounds.x = left;
        this.bookBounds.y = top;
        this.initRotationX();
    }

    public void setPages(String pageLocation, String pageName, String pageExtension, int nrOfPages, int pageWidth, int pageHeight) {
        this.pageLocation = pageLocation;
        this.pageName = pageName;
        this.pageExtension = pageExtension;
        this.nrOfPages = nrOfPages;
        this.pageWidth = pageWidth;
        this.bookBounds.width = 2 * pageWidth;
        this.bookBounds.height = pageHeight;
        this.initRotationX();
        this.currentLeftImage = this.getPage(this.leftPageIndex);
        this.currentRightImage = this.getPage(this.leftPageIndex + 1);
        this.nextLeftImage = this.getPage(this.leftPageIndex + 2);
        this.nextRightImage = this.getPage(this.leftPageIndex + 3);
        this.previousLeftImage = this.getPage(this.leftPageIndex - 2);
        this.previousRightImage = this.getPage(this.leftPageIndex - 1);
    }

    public int getRefreshSpeed() {
        return this.refreshSpeed;
    }

    public void setRefreshSpeed(int refreshSpeed) {
        this.refreshSpeed = refreshSpeed;
    }

    public Color getShadowDarkColor() {
        return this.shadowDarkColor;
    }

    public void setShadowDarkColor(Color shadowDarkColor) {
        this.shadowDarkColor = shadowDarkColor;
    }

    public Color getShadowNeutralColor() {
        return this.shadowNeutralColor;
    }

    public void setShadowNeutralColor(Color shadowNeutralColor) {
        this.shadowNeutralColor = shadowNeutralColor;
    }

    public int getShadowWidth() {
        return this.shadowWidth;
    }

    public void setShadowWidth(int shadowWidth) {
        this.shadowWidth = shadowWidth;
    }

    public boolean isSoftClipping() {
        return this.softClipping;
    }

    public void setSoftClipping(boolean softClipping) {
        this.softClipping = softClipping;
    }

    public boolean isBorderLinesVisible() {
        return this.borderLinesVisible;
    }

    public void setBorderLinesVisible(boolean borderLinesVisible) {
        this.borderLinesVisible = borderLinesVisible;
    }

    public int getLeftPageIndex() {
        return this.leftPageIndex;
    }

    public void setLeftPageIndex(int leftPageIndex) {
        if (leftPageIndex <= -1) {
            leftPageIndex = -1;
        }
        this.leftPageIndex = leftPageIndex;
        this.previousLeftImage = this.getPage(leftPageIndex - 2);
        this.previousRightImage = this.getPage(leftPageIndex - 1);
        this.currentLeftImage = this.getPage(leftPageIndex);
        this.currentRightImage = this.getPage(leftPageIndex + 1);
        this.nextLeftImage = this.getPage(leftPageIndex + 2);
        this.nextRightImage = this.getPage(leftPageIndex + 3);
    }
}

