/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.irplugin.gui;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ListItem;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.irplugin.IRPlugin;
import com.jaspersoft.jasperserver.irplugin.JServer;
import com.jaspersoft.jasperserver.irplugin.RepositoryFolder;
import com.jaspersoft.jasperserver.irplugin.gui.ValidationUtils;
import it.businesslogic.ireport.util.Misc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class ListOfValuesDialog
extends JDialog {
    private int dialogResult = 2;
    private JServer server = null;
    private String parentFolder = null;
    private RepositoryFolder resource = null;
    private ResourceDescriptor newResourceDescriptor = null;
    private boolean doNotStore = false;
    private ButtonGroup buttonGroup1;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonDown;
    private JButton jButtonInsert;
    private JButton jButtonSave;
    private JButton jButtonUp;
    private JEditorPane jEditorPaneDescription;
    private JLabel jLabel1;
    private JLabel jLabelDescription;
    private JLabel jLabelLabel;
    private JLabel jLabelName;
    private JLabel jLabelUriString;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTabbedPane jTabbedPane1;
    private JTable jTableLOV;
    private JTextField jTextFieldLabel;
    private JTextField jTextFieldName;
    private JTextField jTextFieldUriString;
    static /* synthetic */ Class class$java$lang$String;

    public ListOfValuesDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        Misc.centerFrame((Component)this);
        DocumentListener changesListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                ListOfValuesDialog.this.updateSaveButton();
            }

            public void insertUpdate(DocumentEvent evt) {
                ListOfValuesDialog.this.updateSaveButton();
            }

            public void removeUpdate(DocumentEvent evt) {
                ListOfValuesDialog.this.updateSaveButton();
            }
        };
        DefaultTableModel lm = (DefaultTableModel)this.jTableLOV.getModel();
        lm.setRowCount(0);
        this.jTableLOV.updateUI();
        this.jTextFieldLabel.getDocument().addDocumentListener(changesListener);
        this.jTextFieldName.getDocument().addDocumentListener(changesListener);
        this.jTextFieldName.requestFocusInWindow();
        this.jTableLOV.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ListOfValuesDialog.this.jTableValueChanged(evt);
            }
        });
        this.jTableValueChanged(null);
        this.applyI18n();
    }

    public void applyI18n() {
        this.jButtonClose.setText(IRPlugin.getString("listOfValuesDialog.buttonCancel", "Cancel"));
        this.jButtonDelete.setText(IRPlugin.getString("listOfValuesDialog.buttonDelete", "Delete"));
        this.jButtonDown.setText(IRPlugin.getString("listOfValuesDialog.buttonMoveDown", "Move down"));
        this.jButtonInsert.setText(IRPlugin.getString("listOfValuesDialog.buttonAdd", "Add"));
        this.jButtonSave.setText(IRPlugin.getString("listOfValuesDialog.buttonSave", "Save"));
        this.jButtonUp.setText(IRPlugin.getString("listOfValuesDialog.buttonMoveUp", "Move up"));
        this.jLabel1.setText(IRPlugin.getString("listOfValuesDialog.title", "List of values"));
        this.jLabelDescription.setText(IRPlugin.getString("listOfValuesDialog.labelDescription", "Description"));
        this.jLabelLabel.setText(IRPlugin.getString("listOfValuesDialog.labelLabel", "Label"));
        this.jLabelName.setText(IRPlugin.getString("listOfValuesDialog.labelName", "Name"));
        this.jLabelUriString.setText(IRPlugin.getString("listOfValuesDialog.labelParentFolder", "Parent folder"));
        this.jTabbedPane1.setTitleAt(0, IRPlugin.getString("listOfValuesDialog.tabGeneral", "General"));
        this.jTabbedPane1.setTitleAt(1, IRPlugin.getString("listOfValuesDialog.tabDetails", "List of values"));
        this.jTableLOV.getColumn("Label").setHeaderValue(IRPlugin.getString("listOfValuesDialog.tableColumn.label", "Label"));
        this.jTableLOV.getColumn("Value").setHeaderValue(IRPlugin.getString("listOfValuesDialog.tableColumn.value", "Value"));
        this.jTableLOV.updateUI();
    }

    private void jTableValueChanged(ListSelectionEvent evt) {
        if (this.jTableLOV.getSelectedRow() >= 0) {
            this.jButtonDelete.setEnabled(true);
            this.jButtonUp.setEnabled(this.jTableLOV.getSelectedRow() > 0);
            int[] selection = this.jTableLOV.getSelectedRows();
            this.jButtonDown.setEnabled(selection[selection.length - 1] < this.jTableLOV.getRowCount() - 1);
        } else {
            this.jButtonDelete.setEnabled(false);
            this.jButtonUp.setEnabled(false);
            this.jButtonDown.setEnabled(false);
        }
    }

    private void updateSaveButton() {
        if (this.jTextFieldLabel.getText().length() > 0 && this.jTextFieldName.getText().length() > 0) {
            this.jButtonSave.setEnabled(true);
        } else {
            this.jButtonSave.setEnabled(false);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jLabelUriString = new JLabel();
        this.jTextFieldUriString = new JTextField();
        this.jLabelName = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jSeparator2 = new JSeparator();
        this.jLabelLabel = new JLabel();
        this.jTextFieldLabel = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jEditorPaneDescription = new JEditorPane();
        this.jLabelDescription = new JLabel();
        this.jPanel3 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jTableLOV = new JTable();
        this.jPanel5 = new JPanel();
        this.jButtonInsert = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonUp = new JButton();
        this.jButtonDown = new JButton();
        this.jPanel6 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jButtonSave = new JButton();
        this.jButtonClose = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.setTitle("Data Type");
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jLabel1.setFont(new Font("Dialog", 1, 12));
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/jasperserver/irplugin/res/datasource_new.png")));
        this.jLabel1.setText("List of values");
        this.jLabel1.setVerticalAlignment(3);
        this.jLabel1.setVerticalTextPosition(3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jSeparator1.setMinimumSize(new Dimension(2, 2));
        this.jSeparator1.setPreferredSize(new Dimension(2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setPreferredSize(new Dimension(400, 185));
        this.jLabelUriString.setText("Parent folder");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabelUriString, gridBagConstraints);
        this.jTextFieldUriString.setEditable(false);
        this.jTextFieldUriString.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jTextFieldUriString.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jTextFieldUriString, gridBagConstraints);
        this.jLabelName.setText("Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabelName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jTextFieldName, gridBagConstraints);
        this.jSeparator2.setMinimumSize(new Dimension(0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 6, 4);
        this.jPanel2.add((Component)this.jSeparator2, gridBagConstraints);
        this.jLabelLabel.setText("Label");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabelLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jTextFieldLabel, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.jEditorPaneDescription);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabelDescription.setText("Description");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel2.add((Component)this.jLabelDescription, gridBagConstraints);
        this.jTabbedPane1.addTab("General", this.jPanel2);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jScrollPane2.setPreferredSize(new Dimension(200, 200));
        this.jTableLOV.setModel(new DefaultTableModel(new Object[0][], new String[]{"Label", "Value"}){
            Class[] types = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ListOfValuesDialog.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ListOfValuesDialog.class$("java.lang.String")) : class$java$lang$String};

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.jScrollPane2.setViewportView(this.jTableLOV);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel3.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jPanel5.setLayout(new GridBagLayout());
        this.jPanel5.setMinimumSize(new Dimension(100, 50));
        this.jButtonInsert.setText("Add");
        this.jButtonInsert.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListOfValuesDialog.this.jButtonInsertActionPerformed(evt);
            }
        });
        this.jButtonInsert.addAncestorListener(new AncestorListener(){

            public void ancestorMoved(AncestorEvent evt) {
            }

            public void ancestorAdded(AncestorEvent evt) {
                ListOfValuesDialog.this.jButtonInsertAncestorAdded(evt);
            }

            public void ancestorRemoved(AncestorEvent evt) {
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel5.add((Component)this.jButtonInsert, gridBagConstraints);
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListOfValuesDialog.this.jButtonDeleteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel5.add((Component)this.jButtonDelete, gridBagConstraints);
        this.jButtonUp.setText("Move up");
        this.jButtonUp.setEnabled(false);
        this.jButtonUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListOfValuesDialog.this.jButtonUpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel5.add((Component)this.jButtonUp, gridBagConstraints);
        this.jButtonDown.setText("Move down");
        this.jButtonDown.setEnabled(false);
        this.jButtonDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListOfValuesDialog.this.jButtonDownActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel5.add((Component)this.jButtonDown, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel5.add((Component)this.jPanel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanel3.add((Component)this.jPanel5, gridBagConstraints);
        this.jTabbedPane1.addTab("List of values", this.jPanel3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jTabbedPane1, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setMinimumSize(new Dimension(10, 30));
        this.jPanel4.setPreferredSize(new Dimension(10, 30));
        this.jButtonSave.setText("Save");
        this.jButtonSave.setEnabled(false);
        this.jButtonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListOfValuesDialog.this.jButtonSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel4.add((Component)this.jButtonSave, gridBagConstraints);
        this.jButtonClose.setText("Cancel");
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListOfValuesDialog.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.jButtonClose, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jPanel4, gridBagConstraints);
        this.pack();
    }

    private void jButtonDownActionPerformed(ActionEvent evt) {
        if (this.jTableLOV.getSelectedRow() >= 0) {
            DefaultTableModel dtm = (DefaultTableModel)this.jTableLOV.getModel();
            int[] indices = this.jTableLOV.getSelectedRows();
            for (int i = indices.length - 1; i >= 0; --i) {
                if (indices[i] == dtm.getRowCount() - 1) continue;
                dtm.moveRow(indices[i], indices[i], indices[i] + 1);
                ((DefaultListSelectionModel)this.jTableLOV.getSelectionModel()).removeSelectionInterval(indices[i], indices[i]);
                int n = i;
                indices[n] = indices[n] + 1;
                ((DefaultListSelectionModel)this.jTableLOV.getSelectionModel()).addSelectionInterval(indices[i], indices[i]);
            }
        }
    }

    private void jButtonUpActionPerformed(ActionEvent evt) {
        if (this.jTableLOV.getSelectedRow() >= 0) {
            DefaultTableModel dtm = (DefaultTableModel)this.jTableLOV.getModel();
            int[] indices = this.jTableLOV.getSelectedRows();
            for (int i = 0; i < indices.length; ++i) {
                if (indices[i] == 0) continue;
                dtm.moveRow(indices[i], indices[i], indices[i] - 1);
                ((DefaultListSelectionModel)this.jTableLOV.getSelectionModel()).removeIndexInterval(indices[i], indices[i]);
                int n = i;
                indices[n] = indices[n] - 1;
                ((DefaultListSelectionModel)this.jTableLOV.getSelectionModel()).addSelectionInterval(indices[i], indices[i]);
            }
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        while (this.jTableLOV.getSelectedRowCount() > 0) {
            ((DefaultTableModel)this.jTableLOV.getModel()).removeRow(this.jTableLOV.getSelectedRow());
        }
    }

    private void jButtonInsertActionPerformed(ActionEvent evt) {
        ((DefaultTableModel)this.jTableLOV.getModel()).addRow(new Object[]{"", ""});
    }

    private void jButtonInsertAncestorAdded(AncestorEvent evt) {
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        ResourceDescriptor rd = new ResourceDescriptor();
        rd.setDescription(this.jEditorPaneDescription.getText().trim());
        rd.setName(this.jTextFieldName.getText());
        String uri = this.getParentFolder();
        if (!uri.endsWith("/")) {
            uri = uri + "/";
        }
        uri = uri + this.jTextFieldName.getText();
        rd.setUriString(uri);
        rd.setLabel(this.jTextFieldLabel.getText().trim());
        rd.setParentFolder(this.getParentFolder());
        rd.setIsNew(this.resource == null);
        rd.setWsType("lov");
        ArrayList<ListItem> items = new ArrayList<ListItem>();
        for (int i = 0; i < this.jTableLOV.getRowCount(); ++i) {
            String s1 = (String)this.jTableLOV.getValueAt(i, 0);
            String s2 = (String)this.jTableLOV.getValueAt(i, 1);
            s1 = s1.trim();
            s2 = s2.trim();
            if (s1.length() == 0 || s2.length() == 0) {
                JOptionPane.showMessageDialog(this, "Labels and values cannot be blank.");
                return;
            }
            items.add(new ListItem(s1, (Object)s2));
        }
        rd.setListOfValues(items);
        try {
            this.validate(rd);
            this.newResourceDescriptor = !this.doNotStore ? this.getServer().getWSClient().addOrModifyResource(rd, null) : rd;
            this.setDialogResult(0);
            if (this.resource != null) {
                this.resource.setDescriptor(this.newResourceDescriptor);
            }
            ((Component)this).setVisible(false);
            this.dispose();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, IRPlugin.getFormattedString("messages.error.3", "Error:\n {0}", new Object[]{ex.getMessage()}));
            ex.printStackTrace();
            return;
        }
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public JServer getServer() {
        return this.server;
    }

    public void setServer(JServer server) {
        this.server = server;
    }

    public String getParentFolder() {
        return this.parentFolder;
    }

    public void setParentFolder(String parentFolder) {
        this.parentFolder = parentFolder;
        this.jTextFieldUriString.setText(parentFolder);
    }

    public ResourceDescriptor getNewResourceDescriptor() {
        return this.newResourceDescriptor;
    }

    public void setResource(RepositoryFolder resource) {
        this.resource = resource;
        if (resource != null) {
            this.setResource(resource.getDescriptor());
            this.jTextFieldName.setEditable(false);
            this.jTextFieldName.setOpaque(false);
        }
    }

    public void setResource(ResourceDescriptor descriptor) {
        this.resource = this.resource;
        this.jTextFieldName.setText(descriptor.getName());
        this.jTextFieldLabel.setText(descriptor.getLabel());
        this.jEditorPaneDescription.setText(descriptor.getDescription());
        List list = descriptor.getListOfValues();
        if (list != null) {
            DefaultTableModel dtm = (DefaultTableModel)this.jTableLOV.getModel();
            for (int i = 0; i < list.size(); ++i) {
                ListItem li = (ListItem)list.get(i);
                dtm.addRow(new Object[]{li.getLabel(), li.getValue() == null ? "" : li.getValue() + ""});
            }
        }
    }

    public void validate(ResourceDescriptor dataType) throws Exception {
        ValidationUtils.validateName(dataType.getName());
        ValidationUtils.validateLabel(dataType.getLabel());
        ValidationUtils.validateDesc(dataType.getDescription());
    }

    public boolean isDoNotStore() {
        return this.doNotStore;
    }

    public void setDoNotStore(boolean doNotStore) {
        this.doNotStore = doNotStore;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

