/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.irplugin.gui;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Argument;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceProperty;
import com.jaspersoft.jasperserver.irplugin.ControlsSet;
import com.jaspersoft.jasperserver.irplugin.IRPlugin;
import com.jaspersoft.jasperserver.irplugin.JServer;
import com.jaspersoft.jasperserver.irplugin.ReportRunner;
import com.jaspersoft.jasperserver.irplugin.RepositoryFile;
import com.jaspersoft.jasperserver.irplugin.RepositoryFolder;
import com.jaspersoft.jasperserver.irplugin.RepositoryJrxmlFile;
import com.jaspersoft.jasperserver.irplugin.RepositoryReportUnit;
import com.jaspersoft.jasperserver.irplugin.ResourcesSet;
import com.jaspersoft.jasperserver.irplugin.gui.DataSourceDialog;
import com.jaspersoft.jasperserver.irplugin.gui.DataTypeDialog;
import com.jaspersoft.jasperserver.irplugin.gui.InputControlDialog;
import com.jaspersoft.jasperserver.irplugin.gui.ListOfValuesDialog;
import com.jaspersoft.jasperserver.irplugin.gui.NewResourceDialog;
import com.jaspersoft.jasperserver.irplugin.gui.ObjectPropertiesDialog;
import com.jaspersoft.jasperserver.irplugin.gui.QueryDialog;
import com.jaspersoft.jasperserver.irplugin.gui.ReportElementTransferHandler;
import com.jaspersoft.jasperserver.irplugin.gui.ReportOptionsDialog;
import com.jaspersoft.jasperserver.irplugin.gui.ReportUnitDialog;
import com.jaspersoft.jasperserver.irplugin.gui.ReportUnitRunDialog;
import com.jaspersoft.jasperserver.irplugin.gui.RepositoryTreeCellRenderer;
import com.jaspersoft.jasperserver.irplugin.gui.ResourceReferenceDialog;
import com.jaspersoft.jasperserver.irplugin.gui.ServerDialog;
import com.jaspersoft.jasperserver.irplugin.gui.XMLAConnectionDialog;
import com.jaspersoft.jasperserver.irplugin.gui.explorer.ResourceChooser;
import com.jaspersoft.jasperserver.irplugin.gui.wizard.NewReportUnitWizard;
import com.jaspersoft.jasperserver.irplugin.wsclient.WSClient;
import com.jaspersoft.jasperserver.ws.xml.Marshaller;
import it.businesslogic.ireport.FontListLoader;
import it.businesslogic.ireport.IRFont;
import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.connection.JDBCConnection;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.docking.GenericDragTargetListener;
import it.businesslogic.ireport.gui.logpane.LogTextArea;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.LanguageChangedListener;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class RepositoryExplorer
extends JPanel {
    private IRPlugin plugin = null;
    private boolean treeEnabled = true;
    int nFont = 0;
    private JButton jButtonAddServer;
    private JButton jButtonNewReportUnit;
    private JButton jButtonRunReport;
    private JButton jButtonSaveJrxml;
    private JMenu jMenuAdd;
    private JMenuItem jMenuItemBundle;
    private JMenuItem jMenuItemConnection;
    private JMenuItem jMenuItemDataType;
    private JMenuItem jMenuItemDatasource;
    private JMenuItem jMenuItemDelete;
    private JMenuItem jMenuItemEditJRXML;
    private JMenuItem jMenuItemExplore;
    private JMenuItem jMenuItemFolder;
    private JMenuItem jMenuItemFont;
    private JMenuItem jMenuItemGet;
    private JMenuItem jMenuItemImage;
    private JMenuItem jMenuItemImportFont;
    private JMenuItem jMenuItemInputControl;
    private JMenuItem jMenuItemJar;
    private JMenuItem jMenuItemJrxml;
    private JMenuItem jMenuItemLinkInputControl;
    private JMenuItem jMenuItemListOfValues;
    private JMenuItem jMenuItemLocalInputControl;
    private JMenuItem jMenuItemLogin;
    private JMenuItem jMenuItemNewServer;
    private JMenuItem jMenuItemProperties;
    private JMenuItem jMenuItemQuery;
    private JMenuItem jMenuItemReference;
    private JMenuItem jMenuItemRefresh;
    private JMenuItem jMenuItemRefreshContent;
    private JMenuItem jMenuItemReportUnit;
    private JMenuItem jMenuItemRunRU;
    private JMenuItem jMenuItemServerDelete;
    private JMenuItem jMenuItemServerSettings;
    private JMenuItem jMenuItemXMLADatasource;
    private JPopupMenu jPopupMenuRUInputControls;
    private JPopupMenu jPopupMenuServer;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;
    private JSeparator jSeparator7;
    private JToolBar jToolBar1;
    private JTree jTreeRepository;

    public RepositoryExplorer(IRPlugin plugin) {
        this.initComponents();
        this.jTreeRepository.setDragEnabled(true);
        this.jTreeRepository.setTransferHandler(new ReportElementTransferHandler());
        this.jTreeRepository.setDropTarget(new DropTarget(this.jTreeRepository, (DropTargetListener)new GenericDragTargetListener()));
        this.setPlugin(plugin);
        this.jTreeRepository.setCellRenderer(new RepositoryTreeCellRenderer());
        this.jTreeRepository.getSelectionModel().setSelectionMode(1);
        this.loadServerList();
        I18n.addOnLanguageChangedListener((LanguageChangedListener)new LanguageChangedListener(){

            public void languageChanged(LanguageChangedEvent languageChangedEvent) {
                RepositoryExplorer.this.applyI18n();
                RepositoryExplorer.this.jTreeRepository.updateUI();
            }
        });
        this.applyI18n();
    }

    public void applyI18n() {
        this.jButtonAddServer.setToolTipText(IRPlugin.getString("tooltip.newserver", "Add new server"));
        this.jButtonNewReportUnit.setToolTipText(IRPlugin.getString("tooltip.newreportunit", "Create a new Report Unit"));
        this.jButtonSaveJrxml.setToolTipText(IRPlugin.getString("tooltip.savejrxml", "Save jrxml"));
        this.jButtonRunReport.setToolTipText(IRPlugin.getString("tooltip.runreportunit", "Run Report Unit"));
        this.jMenuAdd.setText(IRPlugin.getString("menu.add", "Add"));
        this.jMenuItemBundle.setText(IRPlugin.getString("menu.bundle", "Resource bundle"));
        this.jMenuItemConnection.setText(IRPlugin.getString("menu.connection", "Import JDBC connection definition"));
        this.jMenuItemDataType.setText(IRPlugin.getString("menu.dataType", "Datatype"));
        this.jMenuItemDatasource.setText(IRPlugin.getString("menu.datasource", "Datasource"));
        this.jMenuItemXMLADatasource.setText(IRPlugin.getString("menu.xmlaConnection", "XMLA Connection"));
        this.jMenuItemDelete.setText(IRPlugin.getString("menu.delete", "Delete"));
        this.jMenuItemEditJRXML.setText(IRPlugin.getString("menu.editJRXML", "Edit JRXML"));
        this.jMenuItemExplore.setText(IRPlugin.getString("menu.explore", "Explore"));
        this.jMenuItemFolder.setText(IRPlugin.getString("menu.folder", "Folder"));
        this.jMenuItemFont.setText(IRPlugin.getString("menu.font", "Font file"));
        this.jMenuItemGet.setText(IRPlugin.getString("menu.get", "Export file"));
        this.jMenuItemImage.setText(IRPlugin.getString("menu.image", "Image"));
        this.jMenuItemImportFont.setText(IRPlugin.getString("menu.importFont", "Add this font to the font list"));
        this.jMenuItemInputControl.setText(IRPlugin.getString("menu.inputControl", "Input control"));
        this.jMenuItemJar.setText(IRPlugin.getString("menu.jar", "Jar archive"));
        this.jMenuItemJrxml.setText(IRPlugin.getString("menu.Jrxml", "JRXML document"));
        this.jMenuItemLinkInputControl.setText(IRPlugin.getString("menu.linkInputControl", "Link an existing input control"));
        this.jMenuItemListOfValues.setText(IRPlugin.getString("menu.listOfValues", "List of values"));
        this.jMenuItemLocalInputControl.setText(IRPlugin.getString("menu.localInputControl", "Create a local input control"));
        this.jMenuItemLogin.setText(IRPlugin.getString("menu.login", "Login"));
        this.jMenuItemNewServer.setText(IRPlugin.getString("menu.newServer", "New server"));
        this.jMenuItemProperties.setText(IRPlugin.getString("menu.properties", "Properties"));
        this.jMenuItemQuery.setText(IRPlugin.getString("menu.query", "Query"));
        this.jMenuItemReference.setText(IRPlugin.getString("menu.reference", "Reference"));
        this.jMenuItemRefresh.setText(IRPlugin.getString("menu.refresh", "Refresh"));
        this.jMenuItemRefreshContent.setText(IRPlugin.getString("menu.refreshContent", "Refresh content"));
        this.jMenuItemReportUnit.setText(IRPlugin.getString("menu.reportUnit", "Report Unit"));
        this.jMenuItemRunRU.setText(IRPlugin.getString("menu.runReportUnit", "Run Report Unit"));
        this.jMenuItemServerDelete.setText(IRPlugin.getString("menu.serverDelete", "Delete server"));
        this.jMenuItemServerSettings.setText(IRPlugin.getString("menu.serverSettings", "Server settings"));
    }

    public void loadServerList() {
        this.jTreeRepository.removeAll();
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        ((DefaultTreeModel)this.jTreeRepository.getModel()).setRoot(rootNode);
        for (int i = 0; i < this.getPlugin().getJServers().size(); ++i) {
            JServer server = (JServer)this.getPlugin().getJServers().get(i);
            DefaultMutableTreeNode serverNode = new DefaultMutableTreeNode(server);
            rootNode.add(serverNode);
        }
        this.jTreeRepository.updateUI();
    }

    public IRPlugin getPlugin() {
        return this.plugin;
    }

    public void setPlugin(IRPlugin plugin) {
        this.plugin = plugin;
    }

    public void updateToolBar() {
        RepositoryFolder rf;
        TreePath path = this.jTreeRepository.getSelectionPath();
        if (path == null) {
            return;
        }
        this.jButtonSaveJrxml.setEnabled(false);
        this.jButtonNewReportUnit.setEnabled(false);
        this.jButtonRunReport.setEnabled(false);
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (selectedNode.getUserObject() instanceof RepositoryJrxmlFile && ((RepositoryJrxmlFile)(rf = (RepositoryJrxmlFile)selectedNode.getUserObject())).getReportFrame() != null) {
            this.jButtonSaveJrxml.setEnabled(true);
        }
        if (selectedNode.getUserObject() instanceof RepositoryFolder) {
            rf = (RepositoryFolder)selectedNode.getUserObject();
            if (rf.getDescriptor().getWsType().equals("folder")) {
                this.jButtonNewReportUnit.setEnabled(true);
            }
            if (rf.getDescriptor().getWsType().equals("ReportOptionsResource")) {
                this.jButtonRunReport.setEnabled(true);
            }
        }
        if (RepositoryExplorer.getParentReportUnit(selectedNode) != null) {
            this.jButtonRunReport.setEnabled(true);
        } else if (selectedNode.getUserObject() instanceof JServer) {
            this.jButtonNewReportUnit.setEnabled(true);
        }
    }

    private void initComponents() {
        this.jPopupMenuServer = new JPopupMenu();
        this.jMenuItemRunRU = new JMenuItem();
        this.jMenuItemEditJRXML = new JMenuItem();
        this.jMenuItemConnection = new JMenuItem();
        this.jMenuItemImportFont = new JMenuItem();
        this.jMenuItemExplore = new JMenuItem();
        this.jMenuItemGet = new JMenuItem();
        this.jMenuItemDelete = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.jMenuAdd = new JMenu();
        this.jMenuItemReportUnit = new JMenuItem();
        this.jSeparator5 = new JSeparator();
        this.jMenuItemFolder = new JMenuItem();
        this.jMenuItemReference = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.jMenuItemImage = new JMenuItem();
        this.jMenuItemBundle = new JMenuItem();
        this.jMenuItemJrxml = new JMenuItem();
        this.jMenuItemJar = new JMenuItem();
        this.jMenuItemFont = new JMenuItem();
        this.jSeparator6 = new JSeparator();
        this.jMenuItemDatasource = new JMenuItem();
        this.jMenuItemXMLADatasource = new JMenuItem();
        this.jSeparator7 = new JSeparator();
        this.jMenuItemDataType = new JMenuItem();
        this.jMenuItemListOfValues = new JMenuItem();
        this.jMenuItemQuery = new JMenuItem();
        this.jMenuItemInputControl = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.jMenuItemLogin = new JMenuItem();
        this.jMenuItemNewServer = new JMenuItem();
        this.jMenuItemServerSettings = new JMenuItem();
        this.jMenuItemServerDelete = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.jMenuItemRefresh = new JMenuItem();
        this.jMenuItemRefreshContent = new JMenuItem();
        this.jMenuItemProperties = new JMenuItem();
        this.jPopupMenuRUInputControls = new JPopupMenu();
        this.jMenuItemLocalInputControl = new JMenuItem();
        this.jMenuItemLinkInputControl = new JMenuItem();
        this.jToolBar1 = new JToolBar();
        this.jButtonAddServer = new JButton();
        this.jButtonNewReportUnit = new JButton();
        this.jButtonSaveJrxml = new JButton();
        this.jButtonRunReport = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTreeRepository = new JTree();
        this.jPopupMenuServer.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                RepositoryExplorer.this.jPopupMenuServerMouseClicked(evt);
            }
        });
        this.jMenuItemRunRU.setText("Run Report Unit");
        this.jMenuItemRunRU.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorer.this.jMenuItemRunRUActionPerformed(evt);
            }
        });
        this.jPopupMenuServer.add(this.jMenuItemRunRU);
        this.jMenuItemEditJRXML.setText("Edit JRXML");
        this.jMenuItemEditJRXML.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorer.this.jMenuItemEditJRXMLActionPerformed(evt);
            }
        });
        this.jPopupMenuServer.add(this.jMenuItemEditJRXML);
        this.jMenuItemConnection.setText("Import JDBC connection definition");
        this.jMenuItemConnection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorer.this.jMenuItemConnectionActionPerformed(evt);
            }
        });
        this.jPopupMenuServer.add(this.jMenuItemConnection);
        this.jMenuItemImportFont.setText("Add this font to the font list");
        this.jMenuItemImportFont.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorer.this.jMenuItemImportFontActionPerformed(evt);
            }
        });
        this.jPopupMenuServer.add(this.jMenuItemImportFont);
        this.jMenuItemExplore.setText("Explore");
        this.jMenuItemExplore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorer.this.jMenuItemExploreActionPerformed(evt);
            }
        });
        this.jPopupMenuServer.add(this.jMenuItemExplore);
        this.jMenuItemGet.setText("Export file");
        this.jMenuItemGet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorer.this.jMenuItemGetActionPerformed(evt);
            }
        });
        this.jPopupMenuServer.add(this.jMenuItemGet);
        this.jMenuItemDelete.setText("Delete");
        this.jMenuItemDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorer.this.jMenuItemDeleteActionPerformed(evt);
            }
        });
        this.jPopupMenuServer.add(this.jMenuItemDelete);
        this.jPopupMenuServer.add(this.jSeparator3);
        this.jMenuAdd.setText("Add");
        this.jMenuItemReportUnit.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/jasperserver/irplugin/res/reportunit.png")));
        this.jMenuItemReportUnit.setText("Report Unit");
        this.jMenuItemReportUnit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorer.this.jMenuItemReportUnitActionPerformed(evt);
            }
        });
        this.jMenuAdd.add(this.jMenuItemReportUnit);
        this.jMenuAdd.add(this.jSeparator5);
        this.jMenuItemFolder.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/jasperserver/irplugin/res/folder.png")));
        this.jMenuItemFolder.setText("Folder");
        this.jMenuItemFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorer.this.jMenuItemFolderActionPerformed(evt);
            }
        });
        this.jMenuAdd.add(this.jMenuItemFolder);
        this.jMenuItemReference.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/jasperserver/irplugin/res/link.png")));
        this.jMenuItemReference.setText("Reference");
        this.jMenuItemReference.setEnabled(false);
        this.jMenuItemReference.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorer.this.jMenuItemReferenceActionPerformed(evt);
            }
        });
        this.jMenuAdd.add(this.jMenuItemReference);
        this.jMenuAdd.add(this.jSeparator4);
        this.jMenuItemImage.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/jasperserver/irplugin/res/picture.png")));
        this.jMenuItemImage.setText("Image");
        this.jMenuItemImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorer.this.jMenuItemImageActionPerformed(evt);
            }
        });
        this.jMenuAdd.add(this.jMenuItemImage);
        this.jMenuItemBundle.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/jasperserver/irplugin/res/bundle.png")));
        this.jMenuItemBundle.setText("Resource bundle");
        this.jMenuItemBundle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorer.this.jMenuItemBundleActionPerformed(evt);
            }
        });
        this.jMenuAdd.add(this.jMenuItemBundle);
        this.jMenuItemJrxml.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/jasperserver/irplugin/res/jrxml_file.png")));
        this.jMenuItemJrxml.setText("JRXML document");
        this.jMenuItemJrxml.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorer.this.jMenuItemJrxmlActionPerformed(evt);
            }
        });
        this.jMenuAdd.add(this.jMenuItemJrxml);
        this.jMenuItemJar.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/jasperserver/irplugin/res/jar.png")));
        this.jMenuItemJar.setText("Jar archive");
        this.jMenuItemJar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorer.this.jMenuItemJarActionPerformed(evt);
            }
        });
        this.jMenuAdd.add(this.jMenuItemJar);
        this.jMenuItemFont.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/jasperserver/irplugin/res/font.png")));
        this.jMenuItemFont.setText("Font file");
        this.jMenuItemFont.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorer.this.jMenuItemFontActionPerformed(evt);
            }
        });
        this.jMenuAdd.add(this.jMenuItemFont);
        this.jMenuAdd.add(this.jSeparator6);
        this.jMenuItemDatasource.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/jasperserver/irplugin/res/datasource.png")));
        this.jMenuItemDatasource.setText("Datasource");
        this.jMenuItemDatasource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorer.this.jMenuItemDataSourceActionPerformed(evt);
            }
        });
        this.jMenuAdd.add(this.jMenuItemDatasource);
        this.jMenuItemXMLADatasource.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/jasperserver/irplugin/res/datasource.png")));
        this.jMenuItemXMLADatasource.setText("XMLA Connection");
        this.jMenuItemXMLADatasource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorer.this.jMenuItemDatasourcejMenuItemDataSourceActionPerformed1(evt);
            }
        });
        this.jMenuAdd.add(this.jMenuItemXMLADatasource);
        this.jMenuAdd.add(this.jSeparator7);
        this.jMenuItemDataType.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/jasperserver/irplugin/res/datatype.png")));
        this.jMenuItemDataType.setText("Datatype");
        this.jMenuItemDataType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorer.this.jMenuItemDatasourcejMenuItemDataSourceActionPerformed(evt);
            }
        });
        this.jMenuAdd.add(this.jMenuItemDataType);
        this.jMenuItemListOfValues.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/jasperserver/irplugin/res/lov.png")));
        this.jMenuItemListOfValues.setText("List of values");
        this.jMenuItemListOfValues.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorer.this.jMenuItemDataTypejMenuItemDatasourcejMenuItemDataSourceActionPerformed(evt);
            }
        });
        this.jMenuAdd.add(this.jMenuItemListOfValues);
        this.jMenuItemQuery.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/jasperserver/irplugin/res/query.png")));
        this.jMenuItemQuery.setText("Query");
        this.jMenuItemQuery.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorer.this.jMenuItemQueryActionPerformed(evt);
            }
        });
        this.jMenuAdd.add(this.jMenuItemQuery);
        this.jMenuItemInputControl.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/jasperserver/irplugin/res/inputcontrol.png")));
        this.jMenuItemInputControl.setText("Input control");
        this.jMenuItemInputControl.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorer.this.jMenuItemInputControlActionPerformed(evt);
            }
        });
        this.jMenuAdd.add(this.jMenuItemInputControl);
        this.jPopupMenuServer.add(this.jMenuAdd);
        this.jPopupMenuServer.add(this.jSeparator1);
        this.jMenuItemLogin.setText("Login");
        this.jMenuItemLogin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorer.this.jMenuItemLoginActionPerformed(evt);
            }
        });
        this.jPopupMenuServer.add(this.jMenuItemLogin);
        this.jMenuItemNewServer.setText("New server");
        this.jMenuItemNewServer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorer.this.jMenuItemNewServerActionPerformed(evt);
            }
        });
        this.jPopupMenuServer.add(this.jMenuItemNewServer);
        this.jMenuItemServerSettings.setText("Server settings");
        this.jMenuItemServerSettings.setEnabled(false);
        this.jMenuItemServerSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorer.this.jMenuItemServerSettingsActionPerformed(evt);
            }
        });
        this.jPopupMenuServer.add(this.jMenuItemServerSettings);
        this.jMenuItemServerDelete.setText("Delete server");
        this.jMenuItemServerDelete.setEnabled(false);
        this.jMenuItemServerDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorer.this.jMenuItemServerDeleteActionPerformed(evt);
            }
        });
        this.jPopupMenuServer.add(this.jMenuItemServerDelete);
        this.jPopupMenuServer.add(this.jSeparator2);
        this.jMenuItemRefresh.setText("Refresh");
        this.jMenuItemRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorer.this.jMenuItemRefreshActionPerformed(evt);
            }
        });
        this.jPopupMenuServer.add(this.jMenuItemRefresh);
        this.jMenuItemRefreshContent.setText("Refresh content");
        this.jMenuItemRefreshContent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorer.this.jMenuItemRefreshContentActionPerformed(evt);
            }
        });
        this.jPopupMenuServer.add(this.jMenuItemRefreshContent);
        this.jMenuItemProperties.setText("Properties");
        this.jMenuItemProperties.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorer.this.jMenuItemPropertiesActionPerformed(evt);
            }
        });
        this.jPopupMenuServer.add(this.jMenuItemProperties);
        this.jMenuItemLocalInputControl.setText("Create a local input control");
        this.jMenuItemLocalInputControl.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorer.this.jMenuItemLocalInputControlActionPerformed(evt);
            }
        });
        this.jPopupMenuRUInputControls.add(this.jMenuItemLocalInputControl);
        this.jMenuItemLinkInputControl.setText("Link an existing input control");
        this.jMenuItemLinkInputControl.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorer.this.jMenuItemLinkInputControlActionPerformed(evt);
            }
        });
        this.jPopupMenuRUInputControls.add(this.jMenuItemLinkInputControl);
        this.setLayout(new BorderLayout());
        this.jButtonAddServer.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/jasperserver/irplugin/res/server_add.png")));
        this.jButtonAddServer.setText("\n");
        this.jButtonAddServer.setToolTipText("Add new server");
        this.jButtonAddServer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorer.this.jButtonAddServerActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonAddServer);
        this.jButtonNewReportUnit.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/jasperserver/irplugin/res/publish.png")));
        this.jButtonNewReportUnit.setToolTipText("Create a new Report Unit");
        this.jButtonNewReportUnit.setEnabled(false);
        this.jButtonNewReportUnit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorer.this.jButtonPublishReportActionPerformed1(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNewReportUnit);
        this.jButtonSaveJrxml.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/jasperserver/irplugin/res/upload_jrxml.png")));
        this.jButtonSaveJrxml.setToolTipText("Save jrxml");
        this.jButtonSaveJrxml.setEnabled(false);
        this.jButtonSaveJrxml.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorer.this.jButtonSaveJrxmlActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonSaveJrxml);
        this.jButtonRunReport.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/jasperserver/irplugin/res/run_report.png")));
        this.jButtonRunReport.setToolTipText("Run Report Unit");
        this.jButtonRunReport.setEnabled(false);
        this.jButtonRunReport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorer.this.jButtonRunReportActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonRunReport);
        this.add((Component)this.jToolBar1, "North");
        this.jTreeRepository.setRootVisible(false);
        this.jTreeRepository.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                RepositoryExplorer.this.jTreeRepositoryMouseClicked(evt);
            }

            public void mousePressed(MouseEvent evt) {
                RepositoryExplorer.this.jTreeRepositoryMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                RepositoryExplorer.this.jTreeRepositoryMouseReleased(evt);
            }
        });
        this.jTreeRepository.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                RepositoryExplorer.this.jTreeRepositoryValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTreeRepository);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private void jMenuItemDatasourcejMenuItemDataSourceActionPerformed1(ActionEvent evt) {
        this.newResource("olapXmlaCon");
    }

    private void jMenuItemQueryActionPerformed(ActionEvent evt) {
        this.newResource("query");
    }

    private void jMenuItemRunRUActionPerformed(ActionEvent evt) {
        this.jButtonRunReportActionPerformed(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonRunReportActionPerformed(ActionEvent evt) {
        TreePath path = this.jTreeRepository.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        RepositoryReportUnit reportUnit = null;
        ResourceDescriptor optionsRd = null;
        HashMap<String, Object> defaultValues = new HashMap<String, Object>();
        if (selectedNode.getUserObject() instanceof RepositoryFolder && ((RepositoryFolder)selectedNode.getUserObject()).getDescriptor().getWsType().equals("ReportOptionsResource")) {
            try {
                optionsRd = ((RepositoryFolder)selectedNode.getUserObject()).getDescriptor();
                String ruURI = optionsRd.getResourcePropertyValue("PROP_RU_URI");
                ResourceDescriptor reportRd = new ResourceDescriptor();
                reportRd.setUriString(ruURI);
                reportRd = ((RepositoryFolder)selectedNode.getUserObject()).getServer().getWSClient().get(reportRd, null);
                reportUnit = new RepositoryReportUnit(((RepositoryFolder)selectedNode.getUserObject()).getServer(), reportRd);
                reportUnit.setLoaded(false);
                ResourceProperty rp = optionsRd.getResourceProperty("PROP_VALUES");
                List list = rp.getProperties();
                if (list != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        String value;
                        ResourceProperty li = (ResourceProperty)list.get(i);
                        String string = value = li.getValue() == null ? "" : li.getValue();
                        if (li.getProperties().size() > 0) {
                            ArrayList<String> listVal = new ArrayList<String>();
                            for (int k = 0; k < li.getProperties().size(); ++k) {
                                ResourceProperty sli = (ResourceProperty)li.getProperties().get(k);
                                listVal.add(sli.getValue());
                            }
                            defaultValues.put(li.getName(), listVal);
                            continue;
                        }
                        defaultValues.put(li.getName(), value);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (reportUnit == null) {
            reportUnit = RepositoryExplorer.getParentReportUnit(selectedNode);
        }
        if (reportUnit != null) {
            JServer server = reportUnit.getServer();
            LogTextArea lta = MainFrame.getMainInstance().getLogPane().createNewLog();
            lta.setTitle(IRPlugin.getFormattedString("repositoryExplorer.message.runningReport", "Running {0}", new Object[]{reportUnit.getDescriptor().getName()}));
            MainFrame.getMainInstance().getLogPane().setActiveLog(lta);
            try {
                int i;
                List list = server.getWSClient().list(reportUnit.getDescriptor());
                String dsUri = null;
                ArrayList<ResourceDescriptor> inputcontrols = new ArrayList<ResourceDescriptor>();
                for (i = 0; i < list.size(); ++i) {
                    ResourceDescriptor sub_rd = (ResourceDescriptor)list.get(i);
                    if (sub_rd.getWsType().equals("inputControl")) {
                        inputcontrols.add(sub_rd);
                        continue;
                    }
                    if (sub_rd.getWsType().equals("datasource")) {
                        dsUri = sub_rd.getReferenceUri();
                        continue;
                    }
                    if (!RepositoryExplorer.isDataSource(sub_rd)) continue;
                    dsUri = sub_rd.getUriString();
                }
                for (i = 0; i < inputcontrols.size(); ++i) {
                    ResourceDescriptor ic = (ResourceDescriptor)inputcontrols.get(i);
                    if (ic.getControlType() != 4 && ic.getControlType() != 9 && ic.getControlType() != 7 && ic.getControlType() != 11) continue;
                    String dsUriQuery = null;
                    inputcontrols.remove(ic);
                    System.out.println("Looking for the right ds...");
                    ArrayList<Argument> args = new ArrayList<Argument>();
                    block12: for (int k = 0; dsUriQuery == null && k < ic.getChildren().size(); ++k) {
                        ResourceDescriptor sub_ic = (ResourceDescriptor)ic.getChildren().get(k);
                        System.out.println("Found child..." + sub_ic.getName() + " (" + sub_ic.getWsType() + ")");
                        if (!sub_ic.getWsType().equals("query")) continue;
                        System.out.println("Found the query child...");
                        for (int k2 = 0; k2 < sub_ic.getChildren().size(); ++k2) {
                            ResourceDescriptor sub_sub_ic = (ResourceDescriptor)sub_ic.getChildren().get(k2);
                            if (!RepositoryExplorer.isDataSource(sub_sub_ic)) continue;
                            System.out.println("Found the ds child...");
                            dsUriQuery = sub_sub_ic.getUriString();
                            continue block12;
                        }
                    }
                    if (dsUriQuery == null) {
                        dsUriQuery = dsUri;
                    }
                    System.out.println("Using..." + dsUriQuery);
                    ic.setResourceProperty("PROP_QUERY_DATA", null);
                    args.add(new Argument("IC_GET_QUERY_DATA", dsUriQuery));
                    ic = server.getWSClient().get(ic, null, args);
                    inputcontrols.add(i, ic);
                }
                Map map = null;
                if (inputcontrols.size() > 0) {
                    ReportUnitRunDialog rurd = new ReportUnitRunDialog((Frame)MainFrame.getMainInstance(), true);
                    rurd.setServer(server);
                    rurd.setInputControls(inputcontrols, defaultValues);
                    ((Component)rurd).setVisible(true);
                    if (rurd.getDialogResult() != 0) {
                        return;
                    }
                    map = rurd.getParametersValues();
                } else {
                    map = new HashMap();
                }
                ReportRunner rr = new ReportRunner();
                rr.setLta(lta);
                rr.setMap(map);
                rr.setReportUnit(reportUnit);
                rr.setServer(server);
                Thread t = new Thread(rr);
                t.start();
            }
            catch (Exception ex) {
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                sw.flush();
                lta.logOnConsole(sw.toString(), false);
                ex.printStackTrace();
            }
            finally {
                lta.setRemovable(true);
            }
        }
    }

    private void jMenuItemLinkInputControlActionPerformed(ActionEvent evt) {
        ResourceChooser rc = new ResourceChooser();
        TreePath path = this.jTreeRepository.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object server = null;
        String reportUnitUri = null;
        if (selectedNode.getUserObject() instanceof ControlsSet) {
            RepositoryReportUnit rf = ((ControlsSet)selectedNode.getUserObject()).getReportUnit();
            rc.setServer(rf.getServer());
            reportUnitUri = rf.getDescriptor().getUriString();
            if (rc.showDialog(this, null) == 0) {
                ResourceDescriptor rd = rc.getSelectedDescriptor();
                if (rd == null || rd.getUriString() == null) {
                    return;
                }
                if (!rd.getWsType().equals("inputControl")) {
                    JOptionPane.showMessageDialog((Component)this.getPlugin().getMainFrame(), IRPlugin.getFormattedString("repositoryExplorer.message.invalidInputControl", "{0} is not an Input Control!", new Object[]{rd.getName()}), "", 0);
                    return;
                }
                ResourceDescriptor newRd = new ResourceDescriptor();
                newRd.setWsType("inputControl");
                newRd.setIsReference(true);
                newRd.setReferenceUri(rd.getUriString());
                newRd.setIsNew(true);
                newRd.setUriString(reportUnitUri + "/<cotnrols>");
                try {
                    newRd = rf.getServer().getWSClient().modifyReportUnitResource(reportUnitUri, newRd, null);
                    this.addChild(selectedNode, rf.getServer(), newRd);
                    if (!this.jTreeRepository.isExpanded(path)) {
                        this.jTreeRepository.expandPath(path);
                    }
                    this.jTreeRepository.updateUI();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog((Component)this.getPlugin().getMainFrame(), IRPlugin.getFormattedString("messages.error.3", "Error:\n {0}", new Object[]{ex.getMessage()}));
                    ex.printStackTrace();
                }
            }
        }
    }

    private void jMenuItemLocalInputControlActionPerformed(ActionEvent evt) {
        this.newResource("inputControl");
    }

    private void jMenuItemInputControlActionPerformed(ActionEvent evt) {
        this.newResource("inputControl");
    }

    private void jMenuItemDataTypejMenuItemDatasourcejMenuItemDataSourceActionPerformed(ActionEvent evt) {
        this.newResource("lov");
    }

    private void jMenuItemDatasourcejMenuItemDataSourceActionPerformed(ActionEvent evt) {
        this.newResource("dataType");
    }

    private void jMenuItemReferenceActionPerformed(ActionEvent evt) {
        this.newResource("reference");
    }

    private void jMenuItemDataSourceActionPerformed(ActionEvent evt) {
        this.newResource("datasource");
    }

    private void jMenuItemImportFontActionPerformed(ActionEvent evt) {
        RepositoryFile repoFile;
        TreePath path = this.jTreeRepository.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (selectedNode.getUserObject() instanceof RepositoryFile && (repoFile = (RepositoryFile)selectedNode.getUserObject()).getDescriptor().getWsType().equals("font")) {
            Vector currentFonts = MainFrame.getMainInstance().getTtfFonts();
            for (int i = 0; i < currentFonts.size(); ++i) {
                IRFont irfont = (IRFont)currentFonts.elementAt(i);
                if (!(irfont.getFile() + "").equals("repo:" + repoFile.getDescriptor().getUriString())) continue;
                return;
            }
            try {
                String fontFile = repoFile.getFile();
                if (fontFile != null) {
                    IRFont newFont = new IRFont(FontListLoader.loadFont((String)fontFile), "repo:" + repoFile.getDescriptor().getUriString());
                    MainFrame.getMainInstance().getTtfFonts().add(newFont);
                    MainFrame.getMainInstance().updateFontsLists();
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog((Component)this.getPlugin().getMainFrame(), IRPlugin.getFormattedString("messages.error.3", "Error:\n {0}", new Object[]{ex.getMessage()}));
                ex.printStackTrace();
            }
        }
    }

    private void jMenuItemConnectionActionPerformed(ActionEvent evt) {
        RepositoryFile rf;
        TreePath path = this.jTreeRepository.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (selectedNode.getUserObject() instanceof RepositoryFile && (rf = (RepositoryFile)selectedNode.getUserObject()).getDescriptor().getWsType().equals("jdbc")) {
            Vector v = MainFrame.getMainInstance().getConnections();
            int index = -1;
            for (int i = 0; i < v.size(); ++i) {
                IReportConnection con = (IReportConnection)v.elementAt(i);
                if (!con.getName().equals(rf.getDescriptor().getLabel())) continue;
                if (JOptionPane.showConfirmDialog(this, IRPlugin.getFormattedString("repositoryExplorer.message.duplicatedConnectionName", "A connection named {0} is already present.\nWould you like to replace the existing connection?", new Object[]{rf.getDescriptor().getLabel()})) != 0) {
                    return;
                }
                index = i;
                break;
            }
            JDBCConnection jdbcConnection = new JDBCConnection();
            jdbcConnection.setName(rf.getDescriptor().getLabel());
            jdbcConnection.setUrl(rf.getDescriptor().getConnectionUrl());
            jdbcConnection.setJDBCDriver(rf.getDescriptor().getDriverClass());
            jdbcConnection.setUsername(rf.getDescriptor().getUsername());
            jdbcConnection.setPassword(rf.getDescriptor().getPassword());
            if (index >= 0) {
                MainFrame.getMainInstance().getConnections().setElementAt(jdbcConnection, index);
            } else {
                MainFrame.getMainInstance().getConnections().add(jdbcConnection);
            }
            MainFrame.getMainInstance().setActiveConnection((IReportConnection)jdbcConnection);
        }
    }

    private void jMenuItemReportUnitActionPerformed(ActionEvent evt) {
        this.jButtonPublishReportActionPerformed1(evt);
    }

    private void jMenuItemDeleteActionPerformed(ActionEvent evt) {
        TreePath path = this.jTreeRepository.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (selectedNode.getUserObject() instanceof RepositoryFolder) {
            RepositoryFolder rf = (RepositoryFolder)selectedNode.getUserObject();
            String reportUnitUri = null;
            String msg = IRPlugin.getFormattedString("repositoryExplorer.message.confirmDeleteFolder", "Are you sure you want to remove the folder {0}\n and all its contents?", new Object[]{rf.getDescriptor().getLabel()});
            RepositoryFolder reportUnit = null;
            for (int i = path.getPathCount() - 2; i > 0; --i) {
                DefaultMutableTreeNode ancestorNode = (DefaultMutableTreeNode)path.getPath()[i];
                if (!(ancestorNode.getUserObject() instanceof RepositoryReportUnit)) continue;
                reportUnit = (RepositoryReportUnit)ancestorNode.getUserObject();
                break;
            }
            if (reportUnit != null) {
                reportUnitUri = reportUnit.getDescriptor().getUriString();
            }
            if (rf.getDescriptor().getWsType().equals("folder")) {
                msg = IRPlugin.getFormattedString("repositoryExplorer.message.confirmDeleteFolder", "Are you sure you want to remove the folder {0}\n and all its contents?", new Object[]{rf.getDescriptor().getLabel()});
            } else if (rf.getDescriptor().getWsType().equals("reportUnit")) {
                msg = IRPlugin.getFormattedString("repositoryExplorer.message.confirmDeleteReportUnit", "Are you sure you want to remove the report unit {0}\n and all its contents?", new Object[]{rf.getDescriptor().getLabel()});
            }
            System.out.println(rf.getDescriptor().getWsType());
            if (RepositoryExplorer.isDataSource(rf.getDescriptor())) {
                if (((DefaultMutableTreeNode)selectedNode.getParent()).getUserObject() instanceof ResourcesSet) {
                    JOptionPane.showMessageDialog((Component)MainFrame.getMainInstance(), IRPlugin.getString("repositoryExplorer.message.cannotDeleteRUDatasource", "You can not delete the report datasource.\nUse Report Unit properties menu item to modify the datasource type."), "", 0);
                    return;
                }
            } else {
                msg = IRPlugin.getFormattedString("repositoryExplorer.message.confirmDeleteResource", "Are you sure you want to remove the resource {0} ?", new Object[]{rf.getDescriptor().getLabel()});
            }
            if (JOptionPane.showConfirmDialog(this, msg) == 0) {
                try {
                    rf.getServer().getWSClient().delete(rf.getDescriptor(), reportUnitUri);
                    DefaultMutableTreeNode parent = (DefaultMutableTreeNode)selectedNode.getParent();
                    if (parent != null) {
                        parent.remove(selectedNode);
                        this.jTreeRepository.updateUI();
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog((Component)this.getPlugin().getMainFrame(), IRPlugin.getFormattedString("messages.error.3", "Error:\n {0}", new Object[]{ex.getMessage()}));
                    ex.printStackTrace();
                }
            }
        }
    }

    private void jMenuItemFontActionPerformed(ActionEvent evt) {
        this.newResource("font");
    }

    private void jMenuItemJarActionPerformed(ActionEvent evt) {
        this.newResource("jar");
    }

    private void jMenuItemJrxmlActionPerformed(ActionEvent evt) {
        this.newResource("jrxml");
    }

    private void jMenuItemBundleActionPerformed(ActionEvent evt) {
        this.newResource("prop");
    }

    private void jMenuItemImageActionPerformed(ActionEvent evt) {
        this.newResource("img");
    }

    private void jMenuItemFolderActionPerformed(ActionEvent evt) {
        this.newResource("folder");
    }

    private void jButtonPublishReportActionPerformed1(ActionEvent evt) {
        TreePath path = this.jTreeRepository.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        String parentFolder = "/";
        JServer server = null;
        if (selectedNode.getUserObject() instanceof JServer) {
            server = (JServer)selectedNode.getUserObject();
        } else if (selectedNode.getUserObject() instanceof RepositoryFolder) {
            RepositoryFolder rf = (RepositoryFolder)selectedNode.getUserObject();
            parentFolder = rf.getDescriptor().getUriString();
            server = rf.getServer();
        }
        List datasources = null;
        if (IRPlugin.getMainInstance().getBrandingProperties().getProperty("ireport.manage.datasources.enabled", "true").equals("true")) {
            try {
                datasources = server.getWSClient().listDatasources();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog((Component)this.getPlugin().getMainFrame(), IRPlugin.getFormattedString("repositoryExplorer.message.errorListingDatasources", "Error getting the list of available datasources:\n{0}", new Object[]{ex.getMessage()}));
                ex.printStackTrace();
                return;
            }
            if (datasources == null || datasources.size() == 0) {
                JOptionPane.showMessageDialog((Component)this.getPlugin().getMainFrame(), IRPlugin.getString("repositoryExplorer.message.noDatasourceFound", "No datasources was found on the server.\nPlease create a new datasource on the server before create a report unit."));
                return;
            }
        } else {
            datasources = new ArrayList();
        }
        NewReportUnitWizard sr = new NewReportUnitWizard();
        sr.setParentFolder(parentFolder);
        sr.setDatasources(datasources);
        sr.setServer(server);
        sr.startWizard();
        ResourceDescriptor rd = sr.getNewResourceDescriptor();
        if (rd != null) {
            this.addChild(selectedNode, server, rd);
            this.jTreeRepository.updateUI();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void jButtonSaveJrxmlActionPerformed(ActionEvent evt) {
        TreePath path = this.jTreeRepository.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (!(selectedNode.getUserObject() instanceof RepositoryJrxmlFile)) return;
        RepositoryJrxmlFile rf = (RepositoryJrxmlFile)selectedNode.getUserObject();
        if (rf.getReportFrame() == null) return;
        if (MainFrame.getMainInstance().getActiveReportFrame() != rf.getReportFrame()) {
            MainFrame.getMainInstance().setActiveReportForm(rf.getReportFrame());
        }
        MainFrame.getMainInstance().jMenuItemSaveActionPerformed(new ActionEvent(this, 0, "Save"));
        String fileToUpdate = rf.getReportFrame().getReport().getFilename();
        try {
            RepositoryFolder reportUnit = null;
            for (int i = path.getPathCount() - 1; i > 0; --i) {
                DefaultMutableTreeNode ancestorNode = (DefaultMutableTreeNode)path.getPath()[i];
                if (!(ancestorNode.getUserObject() instanceof RepositoryReportUnit)) continue;
                reportUnit = (RepositoryReportUnit)ancestorNode.getUserObject();
                break;
            }
            if (reportUnit != null) {
                if (!rf.validateUrls(reportUnit.getServer(), (RepositoryReportUnit)reportUnit)) {
                    JOptionPane.showMessageDialog((Component)this.getPlugin().getMainFrame(), IRPlugin.getString("repositoryExplorer.message.operationCanceledByUser", "Operation canceled by the user"), IRPlugin.getString("repositoryExplorer.message.operationResult", "Operation result"), 2);
                    return;
                }
                rf.getServer().getWSClient().modifyReportUnitResource(reportUnit.getDescriptor().getUriString(), rf.getDescriptor(), new File(fileToUpdate));
            } else {
                rf.getServer().getWSClient().modifyReportUnitResource(null, rf.getDescriptor(), new File(fileToUpdate));
            }
            JOptionPane.showMessageDialog((Component)this.getPlugin().getMainFrame(), IRPlugin.getString("repositoryExplorer.message.jrxmlUpdated", "Jrxml file succesfully updated."), IRPlugin.getString("repositoryExplorer.message.operationResult", "Operation result"), 1);
            return;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog((Component)this.getPlugin().getMainFrame(), IRPlugin.getFormattedString("messages.error.3", "Error:\n {0}", new Object[]{ex.getMessage()}), "Operation result", 0);
            ex.printStackTrace();
        }
    }

    private void jTreeRepositoryValueChanged(TreeSelectionEvent evt) {
        this.updateToolBar();
    }

    private void jMenuItemEditJRXMLActionPerformed(ActionEvent evt) {
        TreePath path = this.jTreeRepository.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (selectedNode.getUserObject() instanceof RepositoryJrxmlFile) {
            RepositoryJrxmlFile rf = (RepositoryJrxmlFile)selectedNode.getUserObject();
            try {
                rf.editFile();
                this.jButtonSaveJrxml.setEnabled(true);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog((Component)this.getPlugin().getMainFrame(), IRPlugin.getFormattedString("messages.error.3", "Error:\n {0}", new Object[]{ex.getMessage()}));
                ex.printStackTrace();
            }
        }
    }

    private void jMenuItemGetActionPerformed(ActionEvent evt) {
        TreePath path = this.jTreeRepository.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (selectedNode.getUserObject() instanceof RepositoryFile) {
            RepositoryFile rf = (RepositoryFile)selectedNode.getUserObject();
            JFileChooser jfc = new JFileChooser();
            jfc.setSelectedFile(new File(rf.getDescriptor().getName()));
            if (jfc.showSaveDialog(this) == 0) {
                try {
                    rf.getServer().getWSClient().get(rf.getDescriptor(), jfc.getSelectedFile());
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog((Component)this.getPlugin().getMainFrame(), IRPlugin.getFormattedString("messages.error.3", "Error:\n {0}", new Object[]{ex.getMessage()}));
                    ex.printStackTrace();
                }
            }
        }
    }

    public void refreshContentNode(DefaultMutableTreeNode selectedNode) {
        if (selectedNode == null) {
            return;
        }
        TreePath path = new TreePath(selectedNode.getPath());
        boolean isLoaded = false;
        String uri = "/";
        Object obj = selectedNode.getUserObject();
        if (obj == null) {
            return;
        }
        JServer server = null;
        if (obj instanceof JServer) {
            server = (JServer)obj;
            isLoaded = server.isLoaded();
        } else if (obj instanceof RepositoryFolder) {
            RepositoryFolder rf = (RepositoryFolder)obj;
            isLoaded = rf.isLoaded();
            uri = rf.getDescriptor().getUriString();
            server = rf.getServer();
        }
        if (!isLoaded) {
            selectedNode.removeAllChildren();
            this.jMenuItemExploreActionPerformed(null);
        } else {
            try {
                ResourceDescriptor descriptor = new ResourceDescriptor();
                descriptor.setWsType("folder");
                descriptor.setUriString(uri);
                if (selectedNode.getUserObject() instanceof RepositoryReportUnit) {
                    descriptor.setWsType("reportUnit");
                }
                List list = server.getWSClient().list(descriptor);
                if (descriptor.getWsType().equals("reportUnit")) {
                    this.updateReportUnitNodeContent(selectedNode, list);
                } else {
                    ArrayList<TreeNode> updatedNodes = new ArrayList<TreeNode>();
                    for (int i = 0; i < list.size(); ++i) {
                        ResourceDescriptor rd = (ResourceDescriptor)list.get(i);
                        boolean found = false;
                        for (int j = 0; j < selectedNode.getChildCount(); ++j) {
                            RepositoryFolder rf = (RepositoryFolder)((DefaultMutableTreeNode)selectedNode.getChildAt(j)).getUserObject();
                            if (!rf.getDescriptor().getUriString().equals(rd.getUriString())) continue;
                            rf.setDescriptor(rd);
                            updatedNodes.add(selectedNode.getChildAt(j));
                            found = true;
                            break;
                        }
                        if (found) continue;
                        DefaultMutableTreeNode newNode = this.addChild(selectedNode, server, rd);
                        updatedNodes.add(newNode);
                    }
                    for (int j = 0; j < selectedNode.getChildCount(); ++j) {
                        if (updatedNodes.contains(selectedNode.getChildAt(j))) continue;
                        selectedNode.remove(j);
                        --j;
                    }
                }
                if (list.size() > 0 && !this.jTreeRepository.isExpanded(path)) {
                    this.jTreeRepository.expandPath(path);
                }
                this.jTreeRepository.updateUI();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog((Component)this.getPlugin().getMainFrame(), IRPlugin.getFormattedString("messages.error.3", "Error:\n {0}", new Object[]{ex.getMessage()}));
                ex.printStackTrace();
            }
        }
    }

    public void refreshContentNodeObject(Object obj) {
        this.refreshContentNode(Misc.findNodeWithUserObject((Object)obj, (TreeNode)((DefaultMutableTreeNode)this.jTreeRepository.getModel().getRoot())));
    }

    private void jMenuItemRefreshContentActionPerformed(ActionEvent evt) {
        TreePath path = this.jTreeRepository.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        this.refreshContentNode(selectedNode);
    }

    private void jMenuItemRefreshActionPerformed(ActionEvent evt) {
        TreePath path = this.jTreeRepository.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (selectedNode.getUserObject() instanceof JServer) {
            return;
        }
        if (selectedNode.getUserObject() instanceof RepositoryFolder) {
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        Thread.currentThread().setContextClassLoader((ClassLoader)MainFrame.getMainInstance().getReportClassLoader());
                        RepositoryExplorer.this.jTreeRepository.setCursor(new Cursor(3));
                        TreePath path = RepositoryExplorer.this.jTreeRepository.getSelectionPath();
                        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                        if (selectedNode.getUserObject() instanceof RepositoryFolder) {
                            RepositoryFolder rf = (RepositoryFolder)selectedNode.getUserObject();
                            JServer server = rf.getServer();
                            WSClient wsclient = server.getWSClient();
                            ResourceDescriptor rd = wsclient.get(rf.getDescriptor(), null);
                            rf.setDescriptor(rd);
                            RepositoryExplorer.this.jTreeRepository.updateUI();
                        }
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog((Component)RepositoryExplorer.this.getPlugin().getMainFrame(), IRPlugin.getFormattedString("messages.error.3", "Error:\n {0}", new Object[]{ex.getMessage()}));
                        ex.printStackTrace();
                    }
                    finally {
                        RepositoryExplorer.this.jTreeRepository.setCursor(null);
                    }
                }
            });
        }
    }

    private void jMenuItemPropertiesActionPerformed(ActionEvent evt) {
        TreePath path = this.jTreeRepository.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (selectedNode.getUserObject() instanceof JServer) {
            this.jMenuItemServerSettingsActionPerformed(evt);
        } else if (selectedNode.getUserObject() instanceof RepositoryReportUnit) {
            RepositoryReportUnit rf = (RepositoryReportUnit)selectedNode.getUserObject();
            ReportUnitDialog rrd = new ReportUnitDialog((Frame)MainFrame.getMainInstance(), true);
            rrd.setParentFolder(rf.getDescriptor().getParentFolder());
            rrd.setServer(rf.getServer());
            rrd.setControlsSupportActive(false);
            rrd.setResourcesSupportActive(false);
            List datasources = null;
            if (IRPlugin.getMainInstance().getBrandingProperties().getProperty("ireport.manage.datasources.enabled", "true").equals("true")) {
                try {
                    datasources = rf.getServer().getWSClient().listDatasources();
                    rrd.setDatasources(datasources);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog((Component)this.getPlugin().getMainFrame(), IRPlugin.getFormattedString("repositoryExplorer.message.errorListingDatasources", "Error getting the list of available datasources:\n{0}", new Object[]{ex.getMessage()}));
                    ex.printStackTrace();
                }
            }
            rrd.setResource(rf);
            ((Component)rrd).setVisible(true);
            if (rrd.getDialogResult() == 0) {
                this.refreshContentNode(selectedNode);
                this.jTreeRepository.updateUI();
            }
        } else if (selectedNode.getUserObject() instanceof RepositoryFolder) {
            RepositoryFolder rf = (RepositoryFolder)selectedNode.getUserObject();
            if (rf.getDescriptor().getWsType().equals("jdbc") || rf.getDescriptor().getWsType().equals("jndi") || rf.getDescriptor().getWsType().equals("bean")) {
                DataSourceDialog dsd = new DataSourceDialog((Frame)MainFrame.getMainInstance(), true);
                dsd.setParentFolder(rf.getDescriptor().getParentFolder());
                dsd.setServer(rf.getServer());
                dsd.setResource(rf);
                ((Component)dsd).setVisible(true);
                if (dsd.getDialogResult() == 0) {
                    this.jTreeRepository.updateUI();
                }
            } else if (rf.getDescriptor().getWsType().equals("olapXmlaCon")) {
                XMLAConnectionDialog dsd = new XMLAConnectionDialog((Frame)MainFrame.getMainInstance(), true);
                dsd.setParentFolder(rf.getDescriptor().getParentFolder());
                dsd.setServer(rf.getServer());
                dsd.setResource(rf);
                ((Component)dsd).setVisible(true);
                if (dsd.getDialogResult() == 0) {
                    this.jTreeRepository.updateUI();
                }
            } else if (rf.getDescriptor().getWsType().equals("reference")) {
                ResourceReferenceDialog rrd = new ResourceReferenceDialog((Frame)MainFrame.getMainInstance(), true);
                rrd.setParentFolder(rf.getDescriptor().getParentFolder());
                rrd.setServer(rf.getServer());
                rrd.setResource(rf);
                ((Component)rrd).setVisible(true);
                if (rrd.getDialogResult() == 0) {
                    this.jTreeRepository.updateUI();
                }
            } else if (rf.getDescriptor().getWsType().equals("dataType")) {
                DataTypeDialog rrd = new DataTypeDialog((Frame)MainFrame.getMainInstance(), true);
                rrd.setParentFolder(rf.getDescriptor().getParentFolder());
                rrd.setServer(rf.getServer());
                rrd.setResource(rf);
                ((Component)rrd).setVisible(true);
                if (rrd.getDialogResult() == 0) {
                    this.jTreeRepository.updateUI();
                }
            } else if (rf.getDescriptor().getWsType().equals("lov")) {
                ListOfValuesDialog rrd = new ListOfValuesDialog((Frame)MainFrame.getMainInstance(), true);
                rrd.setParentFolder(rf.getDescriptor().getParentFolder());
                rrd.setServer(rf.getServer());
                rrd.setResource(rf);
                ((Component)rrd).setVisible(true);
                if (rrd.getDialogResult() == 0) {
                    this.jTreeRepository.updateUI();
                }
            } else if (rf.getDescriptor().getWsType().equals("query")) {
                QueryDialog rrd = new QueryDialog((Frame)MainFrame.getMainInstance(), true);
                rrd.setParentFolder(rf.getDescriptor().getParentFolder());
                rrd.setServer(rf.getServer());
                List datasources = null;
                if (IRPlugin.getMainInstance().getBrandingProperties().getProperty("ireport.manage.datasources.enabled", "true").equals("true")) {
                    try {
                        datasources = rf.getServer().getWSClient().listDatasources();
                        rrd.setDatasources(datasources);
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog((Component)MainFrame.getMainInstance(), IRPlugin.getFormattedString("repositoryExplorer.message.errorListingDatasources", "Error getting the list of available datasources:\n{0}", new Object[]{ex.getMessage()}));
                        ex.printStackTrace();
                    }
                }
                rrd.setResource(rf);
                ((Component)rrd).setVisible(true);
                if (rrd.getDialogResult() == 0) {
                    this.jTreeRepository.updateUI();
                }
            } else if (rf.getDescriptor().getWsType().equals("inputControl")) {
                InputControlDialog rrd = new InputControlDialog((Frame)MainFrame.getMainInstance(), true);
                rrd.setParentFolder(rf.getDescriptor().getParentFolder());
                rrd.setServer(rf.getServer());
                rrd.setResource(rf);
                ((Component)rrd).setVisible(true);
                if (rrd.getDialogResult() == 0) {
                    this.jTreeRepository.updateUI();
                }
            } else if (rf.getDescriptor().getWsType().equals("ReportOptionsResource")) {
                ReportOptionsDialog rrd = new ReportOptionsDialog((Frame)MainFrame.getMainInstance(), true);
                rrd.setParentFolder(rf.getDescriptor().getParentFolder());
                rrd.setServer(rf.getServer());
                rrd.setResource(rf);
                ((Component)rrd).setVisible(true);
                if (rrd.getDialogResult() == 0) {
                    this.jTreeRepository.updateUI();
                }
            } else {
                ObjectPropertiesDialog opd = new ObjectPropertiesDialog((Frame)MainFrame.getMainInstance(), true);
                opd.setResource(rf);
                ((Component)opd).setVisible(true);
                if (opd.getDialogResult() == 0) {
                    this.jTreeRepository.updateUI();
                }
            }
        }
    }

    private void jMenuItemLoginActionPerformed(ActionEvent evt) {
        TreePath path = this.jTreeRepository.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        JServer server = null;
        if (selectedNode.getUserObject() instanceof JServer) {
            server = (JServer)selectedNode.getUserObject();
        } else if (selectedNode.getUserObject() instanceof RepositoryFolder) {
            server = ((RepositoryFolder)selectedNode.getUserObject()).getServer();
        }
        if (server == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Thread.currentThread().setContextClassLoader((ClassLoader)MainFrame.getMainInstance().getReportClassLoader());
                    RepositoryExplorer.this.jTreeRepository.setCursor(new Cursor(3));
                    TreePath path = RepositoryExplorer.this.jTreeRepository.getSelectionPath();
                    DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                    JServer server = null;
                    if (selectedNode.getUserObject() instanceof JServer) {
                        server = (JServer)selectedNode.getUserObject();
                    } else if (selectedNode.getUserObject() instanceof RepositoryFolder) {
                        server = ((RepositoryFolder)selectedNode.getUserObject()).getServer();
                    }
                    WSClient wsclient = server.getWSClient();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog((Component)RepositoryExplorer.this.getPlugin().getMainFrame(), IRPlugin.getFormattedString("messages.error.3", "Error:\n {0}", new Object[]{ex.getMessage()}));
                    ex.printStackTrace();
                }
                finally {
                    RepositoryExplorer.this.jTreeRepository.setCursor(null);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exploreSelectedNode() {
        RepositoryFolder folder;
        JServer server;
        final TreePath path = this.jTreeRepository.getSelectionPath();
        if (path == null) {
            return;
        }
        final DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (selectedNode.getUserObject() instanceof JServer && !(server = (JServer)selectedNode.getUserObject()).isLoaded()) {
            Runnable r;
            block35: {
                WSClient wsclient;
                block34: {
                    this.setTreeEnabled(false);
                    r = new Runnable(){

                        public void run() {
                            server.setLoading(true);
                            RepositoryExplorer.this.jTreeRepository.updateUI();
                            RepositoryExplorer.this.jTreeRepository.setCursor(new Cursor(3));
                        }
                    };
                    if (SwingUtilities.isEventDispatchThread()) {
                        r.run();
                    } else {
                        try {
                            SwingUtilities.invokeLater(r);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    System.out.println("Getting ws client...." + new Date());
                    System.out.flush();
                    wsclient = server.getWSClient();
                    System.out.println("Getting version...." + new Date());
                    System.out.flush();
                    String v = wsclient.getVersion();
                    if (v != null && v.compareTo(IRPlugin.REQUIRED_VERSION) >= 0) break block34;
                    this.showMessageFromWorker(IRPlugin.getFormattedString("repositoryExplorer.message.notSupportedServer", "Server not supported.\nMinimum version required: {0}\nFound version: {1}", new Object[]{IRPlugin.REQUIRED_VERSION, v}));
                    Runnable r2 = new Runnable(server){
                        private final /* synthetic */ JServer val$server;
                        {
                            this.val$server = jServer;
                        }

                        public void run() {
                            this.val$server.setLoading(false);
                            RepositoryExplorer.this.jTreeRepository.updateUI();
                            RepositoryExplorer.this.jTreeRepository.setCursor(null);
                        }
                    };
                    if (SwingUtilities.isEventDispatchThread()) {
                        r2.run();
                    } else {
                        try {
                            SwingUtilities.invokeLater(r2);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    this.setTreeEnabled(true);
                    return;
                }
                try {
                    ResourceDescriptor descriptor = new ResourceDescriptor();
                    descriptor.setWsType("folder");
                    descriptor.setUriString("/");
                    final List list = wsclient.list(descriptor);
                    final JTree jTree = this.jTreeRepository;
                    r = new Runnable(){

                        public void run() {
                            RepositoryExplorer.this.addChilds(selectedNode, server, list);
                            if (list.size() > 0) {
                                if (!jTree.isExpanded(path)) {
                                    jTree.expandPath(path);
                                }
                                jTree.updateUI();
                            }
                            server.setLoaded(true);
                        }
                    };
                    if (SwingUtilities.isEventDispatchThread()) {
                        r.run();
                        break block35;
                    }
                    try {
                        SwingUtilities.invokeLater(r);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                catch (Exception ex) {
                    try {
                        this.showMessageFromWorker(IRPlugin.getFormattedString("messages.error.3", "Error:\n {0}", new Object[]{ex.getMessage()}));
                        ex.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        Runnable r3 = new /* invalid duplicate definition of identical inner class */;
                        if (SwingUtilities.isEventDispatchThread()) {
                            r3.run();
                        } else {
                            try {
                                SwingUtilities.invokeLater(r3);
                            }
                            catch (Exception ex2) {
                                // empty catch block
                            }
                        }
                        this.setTreeEnabled(true);
                        throw throwable;
                    }
                    Runnable r4 = new /* invalid duplicate definition of identical inner class */;
                    if (SwingUtilities.isEventDispatchThread()) {
                        r4.run();
                    } else {
                        try {
                            SwingUtilities.invokeLater(r4);
                        }
                        catch (Exception ex3) {
                            // empty catch block
                        }
                    }
                    this.setTreeEnabled(true);
                }
            }
            r = new /* invalid duplicate definition of identical inner class */;
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                try {
                    SwingUtilities.invokeLater(r);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            this.setTreeEnabled(true);
        }
        if (selectedNode.getUserObject() instanceof RepositoryReportUnit) {
            RepositoryReportUnit reportUnit = (RepositoryReportUnit)selectedNode.getUserObject();
            if (!reportUnit.isLoaded()) {
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            Thread.currentThread().setContextClassLoader((ClassLoader)MainFrame.getMainInstance().getReportClassLoader());
                            RepositoryExplorer.this.jTreeRepository.setCursor(new Cursor(3));
                            TreePath path = RepositoryExplorer.this.jTreeRepository.getSelectionPath();
                            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                            RepositoryReportUnit reportUnit = (RepositoryReportUnit)selectedNode.getUserObject();
                            JServer server = reportUnit.getServer();
                            WSClient wsclient = server.getWSClient();
                            ResourceDescriptor descriptor = new ResourceDescriptor();
                            descriptor.setWsType("reportUnit");
                            descriptor.setUriString(reportUnit.getDescriptor().getUriString());
                            Request req = new Request();
                            req.setOperationName("list");
                            req.setResourceDescriptor(descriptor);
                            StringWriter xmlStringWriter = new StringWriter();
                            Marshaller.marshal((Object)req, (StringWriter)xmlStringWriter);
                            List list = wsclient.list(xmlStringWriter.toString());
                            RepositoryExplorer.this.updateReportUnitNodeContent(selectedNode, list);
                            if (list.size() > 0) {
                                if (!RepositoryExplorer.this.jTreeRepository.isExpanded(path)) {
                                    RepositoryExplorer.this.jTreeRepository.expandPath(path);
                                }
                                RepositoryExplorer.this.jTreeRepository.updateUI();
                            }
                            reportUnit.setLoaded(true);
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog((Component)RepositoryExplorer.this.getPlugin().getMainFrame(), IRPlugin.getFormattedString("messages.error.3", "Error:\n {0}", new Object[]{ex.getMessage()}));
                            ex.printStackTrace();
                        }
                        finally {
                            RepositoryExplorer.this.jTreeRepository.setCursor(null);
                        }
                    }
                });
            }
        } else if (selectedNode.getUserObject() instanceof RepositoryFolder && !(folder = (RepositoryFolder)selectedNode.getUserObject()).isLoaded()) {
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        Thread.currentThread().setContextClassLoader((ClassLoader)MainFrame.getMainInstance().getReportClassLoader());
                        RepositoryExplorer.this.jTreeRepository.setCursor(new Cursor(3));
                        TreePath path = RepositoryExplorer.this.jTreeRepository.getSelectionPath();
                        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                        RepositoryFolder folder = (RepositoryFolder)selectedNode.getUserObject();
                        JServer server = folder.getServer();
                        WSClient wsclient = server.getWSClient();
                        ResourceDescriptor descriptor = new ResourceDescriptor();
                        descriptor.setWsType("folder");
                        descriptor.setUriString(folder.getDescriptor().getUriString());
                        Request req = new Request();
                        req.setOperationName("list");
                        req.setResourceDescriptor(descriptor);
                        StringWriter xmlStringWriter = new StringWriter();
                        Marshaller.marshal((Object)req, (StringWriter)xmlStringWriter);
                        List list = wsclient.list(xmlStringWriter.toString());
                        RepositoryExplorer.this.addChilds(selectedNode, server, list);
                        if (list.size() > 0) {
                            if (!RepositoryExplorer.this.jTreeRepository.isExpanded(path)) {
                                RepositoryExplorer.this.jTreeRepository.expandPath(path);
                            }
                            RepositoryExplorer.this.jTreeRepository.updateUI();
                        }
                        folder.setLoaded(true);
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog((Component)RepositoryExplorer.this.getPlugin().getMainFrame(), IRPlugin.getFormattedString("messages.error.3", "Error:\n {0}", new Object[]{ex.getMessage()}));
                        ex.printStackTrace();
                    }
                    finally {
                        RepositoryExplorer.this.jTreeRepository.setCursor(null);
                    }
                }
            });
        }
    }

    private void jMenuItemExploreActionPerformed(ActionEvent evt) {
        if (!this.isTreeEnabled()) {
            return;
        }
        Runnable r = new Runnable(){

            public void run() {
                RepositoryExplorer.this.exploreSelectedNode();
            }
        };
        TreePath path = this.jTreeRepository.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (selectedNode.getUserObject() instanceof JServer) {
            Thread t = new Thread(r);
            t.start();
        } else {
            r.run();
        }
    }

    private void jMenuItemNewServerActionPerformed(ActionEvent evt) {
        this.jButtonAddServerActionPerformed(null);
    }

    private void jMenuItemServerDeleteActionPerformed(ActionEvent evt) {
        TreePath path = this.jTreeRepository.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        JServer server = null;
        if (selectedNode.getUserObject() instanceof JServer) {
            server = (JServer)selectedNode.getUserObject();
        } else if (selectedNode.getUserObject() instanceof RepositoryFolder) {
            server = ((RepositoryFolder)selectedNode.getUserObject()).getServer();
        }
        if (server == null) {
            return;
        }
        if (JOptionPane.showConfirmDialog((Component)this.getPlugin().getMainFrame(), "Are you sure you want to delete the server '" + server + "' ?", "Deleting server", 1, 2) == 0) {
            this.getPlugin().getJServers().remove(selectedNode.getUserObject());
            this.getPlugin().saveConfiguration();
            ((DefaultMutableTreeNode)this.jTreeRepository.getModel().getRoot()).remove(selectedNode);
            this.jTreeRepository.updateUI();
        }
    }

    private void jMenuItemServerSettingsActionPerformed(ActionEvent evt) {
        TreePath path = this.jTreeRepository.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        JServer server = null;
        if (selectedNode.getUserObject() instanceof JServer) {
            server = (JServer)selectedNode.getUserObject();
        } else if (selectedNode.getUserObject() instanceof RepositoryFolder) {
            server = ((RepositoryFolder)selectedNode.getUserObject()).getServer();
        }
        if (server == null) {
            return;
        }
        ServerDialog sd = new ServerDialog((Frame)this.getPlugin().getMainFrame(), true);
        sd.setJServer(server);
        ((Component)sd).setVisible(true);
        if (sd.getDialogResult() == 0) {
            server.setName(sd.getJServer().getName());
            server.setUsername(sd.getJServer().getUsername());
            server.setPassword(sd.getJServer().getPassword());
            server.setUrl(sd.getJServer().getUrl());
            this.getPlugin().saveConfiguration();
            this.jTreeRepository.updateUI();
        }
    }

    private void jTreeRepositoryMouseClicked(MouseEvent evt) {
        if (!this.isTreeEnabled()) {
            return;
        }
        if (evt.getClickCount() == 2) {
            if (evt.getButton() == 1) {
                TreePath path = this.jTreeRepository.getSelectionPath();
                DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (selectedNode.getUserObject() instanceof JServer) {
                    this.jMenuItemExploreActionPerformed(null);
                } else if (selectedNode.getUserObject() instanceof RepositoryJrxmlFile) {
                    this.jMenuItemEditJRXMLActionPerformed(null);
                } else if (selectedNode.getUserObject() instanceof RepositoryFile) {
                    this.jMenuItemPropertiesActionPerformed(null);
                } else if (selectedNode.getUserObject() instanceof RepositoryFolder) {
                    this.jMenuItemExploreActionPerformed(null);
                }
            }
        }
    }

    private void jPopupMenuServerMouseClicked(MouseEvent evt) {
    }

    private void jButtonAddServerActionPerformed(ActionEvent evt) {
        ServerDialog sd = new ServerDialog((Frame)this.getPlugin().getMainFrame(), true);
        ((Component)sd).setVisible(true);
        if (sd.getDialogResult() == 0) {
            IRPlugin.getMainInstance().getJServers().add(sd.getJServer());
            IRPlugin.getMainInstance().saveConfiguration();
            ((DefaultMutableTreeNode)this.jTreeRepository.getModel().getRoot()).add(new DefaultMutableTreeNode(sd.getJServer()));
            this.jTreeRepository.updateUI();
        }
    }

    private void jTreeRepositoryMousePressed(MouseEvent evt) {
        if (!this.isTreeEnabled()) {
            return;
        }
        if (evt.getClickCount() == 1) {
            if (evt.getButton() == 3) {
                this.jTreeRepository.setSelectionPath(this.jTreeRepository.getPathForLocation(evt.getX(), evt.getY()));
            }
        }
    }

    private void jTreeRepositoryMouseReleased(MouseEvent evt) {
        if (evt.getClickCount() == 1) {
            if (evt.getButton() == 3) {
                TreePath path = this.jTreeRepository.getSelectionPath();
                if (!IRPlugin.getMainInstance().getBrandingProperties().getProperty("ireport.manage.datasources.enabled", "true").equals("true")) {
                    this.jMenuItemDatasource.setVisible(false);
                    this.jMenuItemXMLADatasource.setVisible(false);
                    this.jSeparator7.setVisible(false);
                }
                if (path == null) {
                    this.jMenuItemEditJRXML.setVisible(false);
                    this.jMenuItemExplore.setVisible(false);
                    this.jMenuItemGet.setVisible(false);
                    this.jMenuItemServerDelete.setEnabled(false);
                    this.jMenuItemServerSettings.setEnabled(false);
                    this.jMenuItemProperties.setEnabled(false);
                    this.jMenuItemRefresh.setVisible(false);
                    this.jMenuItemRefreshContent.setVisible(false);
                    this.jMenuAdd.setVisible(false);
                    this.jMenuItemConnection.setVisible(false);
                    this.jMenuItemImportFont.setVisible(false);
                    this.jMenuItemRunRU.setVisible(false);
                    this.jPopupMenuServer.show(this.jTreeRepository, evt.getX(), evt.getY());
                    return;
                }
                this.jMenuItemServerDelete.setEnabled(true);
                this.jMenuItemServerSettings.setEnabled(true);
                this.jMenuItemProperties.setEnabled(true);
                this.jMenuItemRefresh.setVisible(true);
                this.jMenuItemRefreshContent.setVisible(true);
                this.jMenuItemFolder.setEnabled(true);
                this.jMenuItemReportUnit.setEnabled(true);
                this.jMenuAdd.setVisible(true);
                this.jMenuItemConnection.setVisible(false);
                this.jMenuItemImportFont.setVisible(false);
                this.jMenuItemReference.setEnabled(false);
                this.jMenuItemDataType.setEnabled(true);
                this.jMenuItemListOfValues.setEnabled(true);
                this.jMenuItemRunRU.setVisible(false);
                DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (selectedNode.getUserObject() instanceof JServer) {
                    this.jMenuItemEditJRXML.setVisible(false);
                    this.jMenuItemExplore.setVisible(true);
                    this.jMenuItemGet.setVisible(false);
                    this.jMenuAdd.setEnabled(true);
                    this.jMenuItemDelete.setVisible(false);
                } else if (selectedNode.getUserObject() instanceof RepositoryJrxmlFile) {
                    this.jMenuItemEditJRXML.setVisible(true);
                    this.jMenuItemExplore.setVisible(false);
                    this.jMenuItemGet.setVisible(false);
                    this.jMenuAdd.setEnabled(false);
                    this.jMenuItemDelete.setVisible(true);
                } else if (selectedNode.getUserObject() instanceof RepositoryFile) {
                    this.jMenuItemEditJRXML.setVisible(false);
                    this.jMenuItemExplore.setVisible(false);
                    this.jMenuItemGet.setVisible(false);
                    this.jMenuAdd.setEnabled(false);
                    this.jMenuItemDelete.setVisible(true);
                    String resType = ((RepositoryFile)selectedNode.getUserObject()).getDescriptor().getWsType();
                    if (resType.equals("jdbc")) {
                        this.jMenuItemConnection.setVisible(true);
                    } else if (resType.equals("jar") || resType.equals("font") || resType.equals("img") || resType.equals("jrxml") || resType.equals("prop")) {
                        this.jMenuItemGet.setVisible(true);
                    }
                    if (resType.equals("font")) {
                        this.jMenuItemImportFont.setVisible(true);
                    }
                    if (((RepositoryFolder)selectedNode.getUserObject()).getDescriptor().getWsType().equals("ReportOptionsResource")) {
                        this.jMenuItemRunRU.setVisible(true);
                    }
                } else if (selectedNode.getUserObject() instanceof RepositoryFolder) {
                    this.jMenuItemEditJRXML.setVisible(false);
                    this.jMenuItemExplore.setVisible(true);
                    this.jMenuItemGet.setVisible(false);
                    this.jMenuAdd.setEnabled(true);
                    this.jMenuItemDatasource.setEnabled(true);
                    this.jMenuItemXMLADatasource.setEnabled(true);
                    this.jMenuItemDelete.setVisible(true);
                    if (selectedNode.getUserObject() instanceof RepositoryReportUnit) {
                        this.jMenuItemFolder.setEnabled(false);
                        this.jMenuItemReference.setEnabled(true);
                        this.jMenuItemReportUnit.setEnabled(false);
                        this.jMenuItemDataType.setEnabled(false);
                        this.jMenuItemListOfValues.setEnabled(false);
                        this.jMenuItemRunRU.setVisible(true);
                        this.jMenuItemDatasource.setEnabled(false);
                        this.jMenuItemXMLADatasource.setEnabled(false);
                    }
                } else {
                    if (selectedNode.getUserObject() instanceof ControlsSet) {
                        this.jPopupMenuRUInputControls.show(this.jTreeRepository, evt.getX(), evt.getY());
                        return;
                    }
                    if (selectedNode.getUserObject() instanceof ResourcesSet) {
                        this.jMenuItemEditJRXML.setVisible(false);
                        this.jMenuItemExplore.setVisible(false);
                        this.jMenuItemGet.setVisible(false);
                        this.jMenuAdd.setEnabled(true);
                        this.jMenuItemFolder.setEnabled(false);
                        this.jMenuItemReference.setEnabled(true);
                        this.jMenuItemReportUnit.setEnabled(false);
                        this.jMenuItemDataType.setEnabled(false);
                        this.jMenuItemListOfValues.setEnabled(false);
                        this.jMenuItemDatasource.setEnabled(false);
                        this.jMenuItemXMLADatasource.setEnabled(false);
                        this.jMenuItemDelete.setVisible(false);
                    }
                }
                this.jMenuItemExplore.setEnabled(true);
                this.jMenuItemServerDelete.setEnabled(true);
                this.jMenuItemServerSettings.setEnabled(true);
                this.jPopupMenuServer.show(this.jTreeRepository, evt.getX(), evt.getY());
                return;
            }
        }
    }

    private void addChilds(DefaultMutableTreeNode selectedNode, JServer server, List resourceDescriptors) {
        for (int i = 0; i < resourceDescriptors.size(); ++i) {
            ResourceDescriptor rd = (ResourceDescriptor)resourceDescriptors.get(i);
            this.addChild(selectedNode, server, rd);
        }
    }

    private DefaultMutableTreeNode addChild(DefaultMutableTreeNode selectedNode, JServer server, ResourceDescriptor rd) {
        if (RepositoryExplorer.isDataSource(rd) && !IRPlugin.getMainInstance().getBrandingProperties().getProperty("ireport.manage.datasources.enabled", "true").equals("true")) {
            return null;
        }
        DefaultMutableTreeNode newNode = null;
        RepositoryFolder obj = RepositoryExplorer.createRepositoryObject(server, rd);
        if (obj != null) {
            newNode = new DefaultMutableTreeNode(obj);
            selectedNode.add(newNode);
        }
        return newNode;
    }

    public static RepositoryFolder createRepositoryObject(JServer server, ResourceDescriptor rd) {
        if (rd.getWsType() == null) {
            rd.setWsType("unknow");
        }
        if (rd.getWsType().equals("reportUnit")) {
            return new RepositoryReportUnit(server, rd);
        }
        if (rd.getWsType().equals("folder")) {
            return new RepositoryFolder(server, rd);
        }
        if (rd.getWsType().equals("jrxml")) {
            return new RepositoryJrxmlFile(server, rd);
        }
        return new RepositoryFile(server, rd);
    }

    private void newResource(String resourceType) {
        JDialog nrd;
        RepositoryFolder rf;
        TreePath path = this.jTreeRepository.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        JServer server = null;
        String currentUri = "/";
        String reportUnitUri = null;
        boolean parentLoaded = false;
        if (selectedNode.getUserObject() instanceof JServer) {
            server = (JServer)selectedNode.getUserObject();
            parentLoaded = server.isLoaded();
        } else if (selectedNode.getUserObject() instanceof RepositoryReportUnit) {
            rf = (RepositoryFolder)selectedNode.getUserObject();
            server = rf.getServer();
            reportUnitUri = currentUri = rf.getDescriptor().getUriString();
            parentLoaded = rf.isLoaded();
        } else if (selectedNode.getUserObject() instanceof RepositoryFolder) {
            rf = (RepositoryFolder)selectedNode.getUserObject();
            server = rf.getServer();
            currentUri = rf.getDescriptor().getUriString();
            parentLoaded = rf.isLoaded();
        } else if (selectedNode.getUserObject() instanceof ControlsSet) {
            rf = ((ControlsSet)selectedNode.getUserObject()).getReportUnit();
            server = rf.getServer();
            reportUnitUri = currentUri = rf.getDescriptor().getUriString();
            parentLoaded = rf.isLoaded();
        } else if (selectedNode.getUserObject() instanceof ResourcesSet) {
            rf = ((ResourcesSet)selectedNode.getUserObject()).getReportUnit();
            server = rf.getServer();
            reportUnitUri = currentUri = rf.getDescriptor().getUriString();
            parentLoaded = rf.isLoaded();
        }
        if (resourceType.equals("datasource")) {
            nrd = new DataSourceDialog((Frame)MainFrame.getMainInstance(), true);
            ((DataSourceDialog)nrd).setParentFolder(currentUri);
            ((DataSourceDialog)nrd).setServer(server);
            ((Component)nrd).setVisible(true);
            if (((DataSourceDialog)nrd).getDialogResult() == 0) {
                if (parentLoaded) {
                    this.addChild(selectedNode, server, ((DataSourceDialog)nrd).getNewResourceDescriptor());
                    this.jTreeRepository.updateUI();
                } else {
                    this.jMenuItemExploreActionPerformed(null);
                }
            }
        } else if (resourceType.equals("olapXmlaCon")) {
            nrd = new XMLAConnectionDialog((Frame)MainFrame.getMainInstance(), true);
            ((XMLAConnectionDialog)nrd).setParentFolder(currentUri);
            ((XMLAConnectionDialog)nrd).setServer(server);
            ((Component)nrd).setVisible(true);
            if (((XMLAConnectionDialog)nrd).getDialogResult() == 0) {
                if (parentLoaded) {
                    this.addChild(selectedNode, server, ((XMLAConnectionDialog)nrd).getNewResourceDescriptor());
                    this.jTreeRepository.updateUI();
                } else {
                    this.jMenuItemExploreActionPerformed(null);
                }
            }
        } else if (resourceType.equals("reference")) {
            ResourceReferenceDialog rrd = new ResourceReferenceDialog((Frame)MainFrame.getMainInstance(), true);
            rrd.setServer(server);
            rrd.setParentFolder(currentUri);
            ((Component)rrd).setVisible(true);
            if (rrd.getDialogResult() == 0) {
                if (parentLoaded) {
                    this.addChild(selectedNode, server, rrd.getNewResourceDescriptor());
                    this.jTreeRepository.updateUI();
                } else {
                    this.jMenuItemExploreActionPerformed(null);
                }
            }
        } else if (resourceType.equals("dataType")) {
            nrd = new DataTypeDialog((Frame)MainFrame.getMainInstance(), true);
            ((DataTypeDialog)nrd).setParentFolder(currentUri);
            ((DataTypeDialog)nrd).setServer(server);
            ((Component)nrd).setVisible(true);
            if (((DataTypeDialog)nrd).getDialogResult() == 0) {
                if (parentLoaded) {
                    this.addChild(selectedNode, server, ((DataTypeDialog)nrd).getNewResourceDescriptor());
                    this.jTreeRepository.updateUI();
                } else {
                    this.jMenuItemExploreActionPerformed(null);
                }
            }
        } else if (resourceType.equals("lov")) {
            nrd = new ListOfValuesDialog((Frame)MainFrame.getMainInstance(), true);
            ((ListOfValuesDialog)nrd).setParentFolder(currentUri);
            ((ListOfValuesDialog)nrd).setServer(server);
            ((Component)nrd).setVisible(true);
            if (((ListOfValuesDialog)nrd).getDialogResult() == 0) {
                if (parentLoaded) {
                    this.addChild(selectedNode, server, ((ListOfValuesDialog)nrd).getNewResourceDescriptor());
                    this.jTreeRepository.updateUI();
                } else {
                    this.jMenuItemExploreActionPerformed(null);
                }
            }
        } else if (resourceType.equals("query")) {
            nrd = new QueryDialog((Frame)MainFrame.getMainInstance(), true);
            ((QueryDialog)nrd).setParentFolder(currentUri);
            ((QueryDialog)nrd).setServer(server);
            if (IRPlugin.getMainInstance().getBrandingProperties().getProperty("ireport.manage.datasources.enabled", "true").equals("true")) {
                List datasources = null;
                try {
                    datasources = server.getWSClient().listDatasources();
                    ((QueryDialog)nrd).setDatasources(datasources);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog((Component)MainFrame.getMainInstance(), IRPlugin.getFormattedString("repositoryExplorer.message.errorListingDatasources", "Error getting the list of available datasources:\n{0}", new Object[]{ex.getMessage()}));
                    ex.printStackTrace();
                }
            }
            ((Component)nrd).setVisible(true);
            if (((QueryDialog)nrd).getDialogResult() == 0) {
                if (parentLoaded) {
                    this.addChild(selectedNode, server, ((QueryDialog)nrd).getNewResourceDescriptor());
                    this.jTreeRepository.updateUI();
                } else {
                    this.jMenuItemExploreActionPerformed(null);
                }
            }
        } else if (resourceType.equals("inputControl")) {
            nrd = new InputControlDialog((Frame)MainFrame.getMainInstance(), true);
            ((InputControlDialog)nrd).setParentFolder(currentUri);
            ((InputControlDialog)nrd).setServer(server);
            ((InputControlDialog)nrd).setReportUnitUri(reportUnitUri);
            ((Component)nrd).setVisible(true);
            if (((InputControlDialog)nrd).getDialogResult() == 0) {
                if (parentLoaded) {
                    if (reportUnitUri != null) {
                        if (selectedNode.getUserObject() instanceof ControlsSet) {
                            this.addChild(selectedNode, server, ((InputControlDialog)nrd).getNewResourceDescriptor());
                        } else if (selectedNode.getUserObject() instanceof RepositoryReportUnit) {
                            for (int i = 0; i < selectedNode.getChildCount(); ++i) {
                                DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)selectedNode.getChildAt(i);
                                if (!(dmtn.getUserObject() instanceof ControlsSet)) continue;
                                this.addChild(dmtn, server, ((InputControlDialog)nrd).getNewResourceDescriptor());
                                break;
                            }
                        }
                    } else {
                        this.addChild(selectedNode, server, ((InputControlDialog)nrd).getNewResourceDescriptor());
                    }
                    this.jTreeRepository.updateUI();
                } else {
                    this.jMenuItemExploreActionPerformed(null);
                }
            }
        } else {
            nrd = new NewResourceDialog((Frame)MainFrame.getMainInstance(), true);
            ((NewResourceDialog)nrd).setParentUri(currentUri);
            ((NewResourceDialog)nrd).setServer(server);
            ((NewResourceDialog)nrd).setReportUnitUri(reportUnitUri);
            ((NewResourceDialog)nrd).setResourceType(resourceType);
            ((Component)nrd).setVisible(true);
            if (((NewResourceDialog)nrd).getDialogResult() == 0) {
                if (parentLoaded) {
                    this.addChild(selectedNode, server, ((NewResourceDialog)nrd).getNewResourceDescriptor());
                    this.jTreeRepository.updateUI();
                } else {
                    this.jMenuItemExploreActionPerformed(null);
                }
            }
        }
    }

    public JTree getTreeRepository() {
        return this.jTreeRepository;
    }

    public List getOpenedReportSources(JServer server) {
        ArrayList list = new ArrayList();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.jTreeRepository.getModel().getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode dmn = (DefaultMutableTreeNode)root.getChildAt(i);
            if (dmn.getUserObject() != server) continue;
            return this.getOpenedReportSources(dmn, list);
        }
        return list;
    }

    private List getOpenedReportSources(DefaultMutableTreeNode dmn, List list) {
        if (dmn.getUserObject() instanceof RepositoryJrxmlFile) {
            RepositoryJrxmlFile rf = (RepositoryJrxmlFile)dmn.getUserObject();
            if (rf.getReportFrame() != null) {
                list.add(rf);
            }
            return list;
        }
        for (int i = 0; i < dmn.getChildCount(); ++i) {
            list = this.getOpenedReportSources((DefaultMutableTreeNode)dmn.getChildAt(i), list);
        }
        return list;
    }

    private void updateReportUnitNodeContent(DefaultMutableTreeNode selectedNode, List list) {
        int i;
        RepositoryFolder repoFolder;
        int k;
        boolean found;
        ResourceDescriptor rd;
        int i2;
        RepositoryReportUnit reportUnit = (RepositoryReportUnit)selectedNode.getUserObject();
        Vector<Object> existingNodes = new Vector<Object>();
        for (int k2 = 0; k2 < selectedNode.getChildCount(); ++k2) {
            Object obj = ((DefaultMutableTreeNode)selectedNode.getChildAt(k2)).getUserObject();
            if (!(obj instanceof RepositoryFolder)) continue;
            existingNodes.add(obj);
            selectedNode.remove(k2);
            --k2;
        }
        for (i2 = 0; i2 < list.size(); ++i2) {
            rd = (ResourceDescriptor)list.get(i2);
            if (!RepositoryExplorer.isDataSource(rd)) continue;
            list.remove(i2);
            if (rd.getIsReference()) continue;
            found = false;
            for (k = 0; k < existingNodes.size(); ++k) {
                if (!(existingNodes.elementAt(k) instanceof RepositoryFolder) || !(repoFolder = (RepositoryFolder)existingNodes.elementAt(k)).getDescriptor().getUriString().equals(rd.getUriString())) continue;
                repoFolder.setDescriptor(rd);
                found = true;
                existingNodes.remove(k);
                selectedNode.add(new DefaultMutableTreeNode(repoFolder));
                break;
            }
            if (found) continue;
            RepositoryFolder rf = RepositoryExplorer.createRepositoryObject(reportUnit.getServer(), rd);
            selectedNode.add(new DefaultMutableTreeNode(rf));
        }
        for (i2 = 0; i2 < list.size(); ++i2) {
            rd = (ResourceDescriptor)list.get(i2);
            if (!rd.getWsType().equals("jrxml") || !rd.isMainReport()) continue;
            list.remove(i2);
            found = false;
            for (k = 0; k < existingNodes.size(); ++k) {
                if (!(existingNodes.elementAt(k) instanceof RepositoryFolder) || !(repoFolder = (RepositoryFolder)existingNodes.elementAt(k)).getDescriptor().getUriString().equals(rd.getUriString())) continue;
                repoFolder.setDescriptor(rd);
                found = true;
                existingNodes.remove(k);
                selectedNode.add(new DefaultMutableTreeNode(repoFolder));
                break;
            }
            if (found) break;
            RepositoryFolder rf = RepositoryExplorer.createRepositoryObject(reportUnit.getServer(), rd);
            selectedNode.add(new DefaultMutableTreeNode(rf));
            break;
        }
        DefaultMutableTreeNode controlSet = null;
        for (int i3 = 0; i3 < selectedNode.getChildCount(); ++i3) {
            Object obj = ((DefaultMutableTreeNode)selectedNode.getChildAt(i3)).getUserObject();
            if (!(obj instanceof ControlsSet)) continue;
            controlSet = (DefaultMutableTreeNode)selectedNode.getChildAt(i3);
        }
        if (controlSet == null) {
            ControlsSet cs = new ControlsSet();
            cs.setReportUnit(reportUnit);
            controlSet = new DefaultMutableTreeNode(cs);
            selectedNode.add(controlSet);
        }
        controlSet.removeAllChildren();
        for (int i4 = 0; i4 < list.size(); ++i4) {
            ResourceDescriptor rd2 = (ResourceDescriptor)list.get(i4);
            if (!rd2.getWsType().equals("inputControl")) continue;
            RepositoryFolder rf = RepositoryExplorer.createRepositoryObject(reportUnit.getServer(), rd2);
            controlSet.add(new DefaultMutableTreeNode(rf));
        }
        DefaultMutableTreeNode resourcesSet = null;
        for (int i5 = 0; i5 < selectedNode.getChildCount(); ++i5) {
            Object obj = ((DefaultMutableTreeNode)selectedNode.getChildAt(i5)).getUserObject();
            if (!(obj instanceof ResourcesSet)) continue;
            resourcesSet = (DefaultMutableTreeNode)selectedNode.getChildAt(i5);
        }
        if (resourcesSet == null) {
            ResourcesSet cs = new ResourcesSet();
            cs.setReportUnit(reportUnit);
            resourcesSet = new DefaultMutableTreeNode(cs);
            selectedNode.add(resourcesSet);
        }
        existingNodes = new Vector();
        for (i = 0; i < resourcesSet.getChildCount(); ++i) {
            existingNodes.add(((DefaultMutableTreeNode)resourcesSet.getChildAt(i)).getUserObject());
        }
        resourcesSet.removeAllChildren();
        for (i = 0; i < list.size(); ++i) {
            ResourceDescriptor rd3 = (ResourceDescriptor)list.get(i);
            if (rd3.getWsType().equals("inputControl") || rd3.isMainReport() || rd3.getIsReference() && RepositoryExplorer.isDataSource(rd3)) continue;
            boolean found2 = false;
            for (int k3 = 0; k3 < existingNodes.size(); ++k3) {
                RepositoryFile repoFile;
                if (!(existingNodes.elementAt(k3) instanceof RepositoryFile) || !(repoFile = (RepositoryFile)existingNodes.elementAt(k3)).getDescriptor().getUriString().equals(rd3.getUriString())) continue;
                repoFile.setDescriptor(rd3);
                found2 = true;
                existingNodes.remove(k3);
                resourcesSet.add(new DefaultMutableTreeNode(repoFile));
                break;
            }
            if (found2) continue;
            RepositoryFolder rf = RepositoryExplorer.createRepositoryObject(reportUnit.getServer(), rd3);
            resourcesSet.add(new DefaultMutableTreeNode(rf));
        }
        selectedNode.remove(controlSet);
        selectedNode.add(controlSet);
        selectedNode.remove(resourcesSet);
        selectedNode.add(resourcesSet);
    }

    public static boolean isDataSource(ResourceDescriptor rd) {
        block6: {
            block5: {
                if (rd == null) {
                    return false;
                }
                if (rd.getWsType() == null) {
                    return false;
                }
                if (rd.getWsType().equals("datasource")) break block5;
                if (rd.getWsType().equals("jdbc")) break block5;
                if (rd.getWsType().equals("jndi")) break block5;
                if (!rd.getWsType().equals("bean")) break block6;
            }
            return true;
        }
        return false;
    }

    public static RepositoryReportUnit getParentReportUnit(DefaultMutableTreeNode node) {
        if (node.getUserObject() instanceof RepositoryReportUnit) {
            return (RepositoryReportUnit)node.getUserObject();
        }
        Object[] parents = node.getUserObjectPath();
        for (int i = parents.length - 1; i >= 0; --i) {
            if (parents[i] == null || !(parents[i] instanceof RepositoryReportUnit)) continue;
            return (RepositoryReportUnit)parents[i];
        }
        return null;
    }

    public void showMessageFromWorker(final String message) {
        Runnable r = new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog((Component)MainFrame.getMainInstance(), message);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeLater(r);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isTreeEnabled() {
        return this.treeEnabled;
    }

    public void setTreeEnabled(boolean enabled) {
        this.treeEnabled = enabled;
    }
}

