/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.irplugin.gui;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.irplugin.IRPlugin;
import com.jaspersoft.jasperserver.irplugin.JServer;
import com.jaspersoft.jasperserver.irplugin.RepositoryFolder;
import com.jaspersoft.jasperserver.irplugin.gui.ObjectPropertiesDialog;
import com.jaspersoft.jasperserver.irplugin.gui.RepositoryExplorer;
import com.jaspersoft.jasperserver.irplugin.gui.ValidationUtils;
import com.jaspersoft.jasperserver.irplugin.gui.explorer.ResourceChooser;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.Misc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ResourceReferenceDialog
extends JDialog {
    private int dialogResult = 2;
    private JServer server = null;
    private String parentFolder = null;
    private RepositoryFolder referenceResource = null;
    private ResourceDescriptor resourceReferenceDescriptor = null;
    private ResourceDescriptor newResourceDescriptor = null;
    private ButtonGroup buttonGroup1;
    private JButton jButton1;
    private JButton jButtonClose;
    private JButton jButtonOpenReferencedResource;
    private JButton jButtonSave;
    private JEditorPane jEditorPaneDescription;
    private JLabel jLabel1;
    private JLabel jLabelDescription;
    private JLabel jLabelLabel;
    private JLabel jLabelName;
    private JLabel jLabelName1;
    private JLabel jLabelName2;
    private JLabel jLabelResourceFile;
    private JLabel jLabelUriString;
    private JLabel jLabelUriString1;
    private JLabel jLabelUriString2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator5;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextFieldLabel;
    private JTextField jTextFieldName;
    private JTextField jTextFieldReferenceUri;
    private JTextField jTextFieldResLabel;
    private JTextField jTextFieldResName;
    private JTextField jTextFieldResType;
    private JTextField jTextFieldResUriString;
    private JTextField jTextFieldUriString;

    public ResourceReferenceDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        Misc.centerFrame((Component)this);
        DocumentListener changesListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                ResourceReferenceDialog.this.updateSaveButton();
            }

            public void insertUpdate(DocumentEvent evt) {
                ResourceReferenceDialog.this.updateSaveButton();
            }

            public void removeUpdate(DocumentEvent evt) {
                ResourceReferenceDialog.this.updateSaveButton();
            }
        };
        this.jTextFieldLabel.getDocument().addDocumentListener(changesListener);
        this.jTextFieldName.getDocument().addDocumentListener(changesListener);
        this.jTextFieldReferenceUri.getDocument().addDocumentListener(changesListener);
        this.jTextFieldName.requestFocusInWindow();
        this.applyI18n();
    }

    public void applyI18n() {
        this.jButtonClose.setText(IRPlugin.getString("resourceReferenceDialog.buttonCancel", "Cancel"));
        this.jButtonSave.setText(IRPlugin.getString("resourceReferenceDialog.buttonCreateReference", "Create reference"));
        this.jLabel1.setText(IRPlugin.getString("resourceReferenceDialog.title", "Resource reference"));
        this.jLabelDescription.setText(IRPlugin.getString("resourceReferenceDialog.labelDescription", "Description"));
        this.jLabelLabel.setText(IRPlugin.getString("resourceReferenceDialog.labelLabel", "Label"));
        this.jLabelName.setText(IRPlugin.getString("resourceReferenceDialog.labelName", "Name"));
        this.jLabelUriString.setText(IRPlugin.getString("resourceReferenceDialog.labelParentFolder", "Parent folder"));
        this.jButtonOpenReferencedResource.setText(IRPlugin.getString("resourceReferenceDialog.buttonOpenResource", "Open this resource"));
        this.jButton1.setText(IRPlugin.getString("resourceReferenceDialog.buttonBrowse", "Browse"));
        this.jLabelName1.setText(IRPlugin.getString("resourceReferenceDialog.labelResourceName", "Name"));
        this.jLabelName2.setText(IRPlugin.getString("resourceReferenceDialog.labelResourceLabel", "Label"));
        this.jLabelResourceFile.setText(IRPlugin.getString("resourceReferenceDialog.labelResourceFile", " Reference URI"));
        this.jLabelUriString1.setText(IRPlugin.getString("resourceReferenceDialog.labelResourceURI", "URI"));
        this.jLabelUriString2.setText(IRPlugin.getString("resourceReferenceDialog.labelResourceType", "Type"));
        this.jTabbedPane1.setTitleAt(0, IRPlugin.getString("resourceReferenceDialog.tabGeneral", "General"));
        this.jTabbedPane1.setTitleAt(1, IRPlugin.getString("resourceReferenceDialog.tabDetails", "Referenced resource details"));
    }

    private void updateSaveButton() {
        if (this.jTextFieldLabel.getText().length() > 0 && this.jTextFieldName.getText().length() > 0 && this.jTextFieldReferenceUri.getText().length() > 0) {
            this.jButtonSave.setEnabled(true);
        } else {
            this.jButtonSave.setEnabled(false);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jLabelUriString = new JLabel();
        this.jTextFieldUriString = new JTextField();
        this.jLabelName = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jSeparator2 = new JSeparator();
        this.jLabelLabel = new JLabel();
        this.jTextFieldLabel = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jEditorPaneDescription = new JEditorPane();
        this.jLabelDescription = new JLabel();
        this.jSeparator3 = new JSeparator();
        this.jLabelResourceFile = new JLabel();
        this.jTextFieldReferenceUri = new JTextField();
        this.jButton1 = new JButton();
        this.jPanel3 = new JPanel();
        this.jLabelUriString1 = new JLabel();
        this.jTextFieldResUriString = new JTextField();
        this.jLabelUriString2 = new JLabel();
        this.jTextFieldResType = new JTextField();
        this.jLabelName1 = new JLabel();
        this.jTextFieldResName = new JTextField();
        this.jLabelName2 = new JLabel();
        this.jTextFieldResLabel = new JTextField();
        this.jSeparator5 = new JSeparator();
        this.jButtonOpenReferencedResource = new JButton();
        this.jPanel4 = new JPanel();
        this.jButtonSave = new JButton();
        this.jButtonClose = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.setTitle("DataSource");
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jLabel1.setFont(new Font("Dialog", 1, 12));
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/jasperserver/irplugin/res/datasource_new.png")));
        this.jLabel1.setText("Resource reference");
        this.jLabel1.setVerticalAlignment(3);
        this.jLabel1.setVerticalTextPosition(3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jSeparator1.setMinimumSize(new Dimension(2, 2));
        this.jSeparator1.setPreferredSize(new Dimension(2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setPreferredSize(new Dimension(400, 185));
        this.jLabelUriString.setText("Parent folder");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabelUriString, gridBagConstraints);
        this.jTextFieldUriString.setEditable(false);
        this.jTextFieldUriString.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jTextFieldUriString.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jTextFieldUriString, gridBagConstraints);
        this.jLabelName.setText("Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabelName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jTextFieldName, gridBagConstraints);
        this.jSeparator2.setMinimumSize(new Dimension(0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 6, 4);
        this.jPanel2.add((Component)this.jSeparator2, gridBagConstraints);
        this.jLabelLabel.setText("Label");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabelLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jTextFieldLabel, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.jEditorPaneDescription);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabelDescription.setText("Description");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel2.add((Component)this.jLabelDescription, gridBagConstraints);
        this.jSeparator3.setMinimumSize(new Dimension(0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 6, 4);
        this.jPanel2.add((Component)this.jSeparator3, gridBagConstraints);
        this.jLabelResourceFile.setText(" Reference URI");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 8, 4);
        this.jPanel2.add((Component)this.jLabelResourceFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 8, 4);
        this.jPanel2.add((Component)this.jTextFieldReferenceUri, gridBagConstraints);
        this.jButton1.setText("Browse");
        this.jButton1.setMinimumSize(new Dimension(73, 19));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResourceReferenceDialog.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(0, 0, 8, 4);
        this.jPanel2.add((Component)this.jButton1, gridBagConstraints);
        this.jTabbedPane1.addTab("General", this.jPanel2);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabelUriString1.setText("URI");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel3.add((Component)this.jLabelUriString1, gridBagConstraints);
        this.jTextFieldResUriString.setEditable(false);
        this.jTextFieldResUriString.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jTextFieldResUriString.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel3.add((Component)this.jTextFieldResUriString, gridBagConstraints);
        this.jLabelUriString2.setText("Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel3.add((Component)this.jLabelUriString2, gridBagConstraints);
        this.jTextFieldResType.setEditable(false);
        this.jTextFieldResType.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jTextFieldResType.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel3.add((Component)this.jTextFieldResType, gridBagConstraints);
        this.jLabelName1.setText("Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel3.add((Component)this.jLabelName1, gridBagConstraints);
        this.jTextFieldResName.setEditable(false);
        this.jTextFieldResName.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jTextFieldResName.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel3.add((Component)this.jTextFieldResName, gridBagConstraints);
        this.jLabelName2.setText("Label");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel3.add((Component)this.jLabelName2, gridBagConstraints);
        this.jTextFieldResLabel.setEditable(false);
        this.jTextFieldResLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jTextFieldResLabel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel3.add((Component)this.jTextFieldResLabel, gridBagConstraints);
        this.jSeparator5.setMinimumSize(new Dimension(0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 6, 4);
        this.jPanel3.add((Component)this.jSeparator5, gridBagConstraints);
        this.jButtonOpenReferencedResource.setText("Open this resource");
        this.jButtonOpenReferencedResource.setEnabled(false);
        this.jButtonOpenReferencedResource.setMinimumSize(new Dimension(73, 19));
        this.jButtonOpenReferencedResource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResourceReferenceDialog.this.jButton1ActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel3.add((Component)this.jButtonOpenReferencedResource, gridBagConstraints);
        this.jTabbedPane1.addTab("Referenced resource details", this.jPanel3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jTabbedPane1, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setMinimumSize(new Dimension(10, 30));
        this.jPanel4.setPreferredSize(new Dimension(10, 30));
        this.jButtonSave.setText("Create reference");
        this.jButtonSave.setEnabled(false);
        this.jButtonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResourceReferenceDialog.this.jButtonSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel4.add((Component)this.jButtonSave, gridBagConstraints);
        this.jButtonClose.setText("Cancel");
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResourceReferenceDialog.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.jButtonClose, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jPanel4, gridBagConstraints);
        this.pack();
    }

    private void jButton1ActionPerformed1(ActionEvent evt) {
        if (this.resourceReferenceDescriptor != null) {
            try {
                RepositoryFolder rf = RepositoryExplorer.createRepositoryObject(this.server, this.resourceReferenceDescriptor);
                ObjectPropertiesDialog opd = new ObjectPropertiesDialog((Frame)MainFrame.getMainInstance(), true);
                opd.setResource(rf);
                ((Component)opd).setVisible(true);
                if (opd.getDialogResult() == 0) {
                    this.updateReferenceDescriptor();
                    IRPlugin.getMainInstance().getRepositoryExplorer().getTreeRepository().updateUI();
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, IRPlugin.getFormattedString("messages.error.3", "Error:\n {0}", new Object[]{ex.getMessage()}));
                ex.printStackTrace();
            }
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        ResourceChooser rc = new ResourceChooser();
        rc.setServer(this.getServer());
        if (rc.showDialog(this, null) == 0) {
            ResourceDescriptor rd = rc.getSelectedDescriptor();
            this.jTextFieldReferenceUri.setText(rd.getUriString());
            this.updateSaveButton();
        }
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        String uri;
        ResourceDescriptor rd = new ResourceDescriptor();
        rd.setDescription(this.jEditorPaneDescription.getText().trim());
        rd.setName(this.jTextFieldName.getText());
        String parentUnit = uri = this.getParentFolder();
        if (parentUnit.endsWith("/")) {
            parentUnit = parentUnit.substring(0, parentUnit.length() - 1);
        }
        if (!uri.endsWith("/")) {
            uri = uri + "/";
        }
        uri = uri + this.jTextFieldName.getText();
        rd.setUriString(uri);
        rd.setLabel(this.jTextFieldLabel.getText().trim());
        rd.setParentFolder(this.getParentFolder());
        rd.setIsNew(this.referenceResource == null);
        rd.setIsReference(true);
        rd.setWsType("reference");
        rd.setReferenceUri(this.jTextFieldReferenceUri.getText());
        try {
            this.validate(rd);
            this.newResourceDescriptor = this.getServer().getWSClient().modifyReportUnitResource(parentUnit, rd, null);
            this.setDialogResult(0);
            if (this.referenceResource != null) {
                this.referenceResource.setDescriptor(this.newResourceDescriptor);
            }
            ((Component)this).setVisible(false);
            this.dispose();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, IRPlugin.getFormattedString("messages.error.3", "Error:\n {0}", new Object[]{ex.getMessage()}));
            ex.printStackTrace();
            return;
        }
    }

    public void validate(ResourceDescriptor dataType) throws Exception {
        ValidationUtils.validateName(dataType.getName());
        ValidationUtils.validateLabel(dataType.getLabel());
        ValidationUtils.validateDesc(dataType.getDescription());
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public JServer getServer() {
        return this.server;
    }

    public void setServer(JServer server) {
        this.server = server;
    }

    public String getParentFolder() {
        return this.parentFolder;
    }

    public void setParentFolder(String parentFolder) {
        this.parentFolder = parentFolder;
        this.jTextFieldUriString.setText(parentFolder);
    }

    public ResourceDescriptor getNewResourceDescriptor() {
        return this.newResourceDescriptor;
    }

    public void setResource(RepositoryFolder referenceResource) {
        this.referenceResource = referenceResource;
        this.jTextFieldName.setText(referenceResource.getDescriptor().getName());
        this.jTextFieldName.setEditable(false);
        this.jTextFieldName.setOpaque(false);
        this.jTextFieldLabel.setText(referenceResource.getDescriptor().getLabel());
        this.jEditorPaneDescription.setText(referenceResource.getDescriptor().getDescription());
        this.jTextFieldReferenceUri.setText(referenceResource.getDescriptor().getReferenceUri());
        this.resourceReferenceDescriptor = new ResourceDescriptor();
        this.resourceReferenceDescriptor.setUriString(referenceResource.getDescriptor().getReferenceUri());
        try {
            this.resourceReferenceDescriptor = this.getServer().getWSClient().get(this.resourceReferenceDescriptor, null);
            this.updateReferenceDescriptor();
        }
        catch (Exception ex) {
            this.jTextFieldResName.setText(IRPlugin.getFormattedString("resourceReferenceDialog.message.errorLoadingResource", "Error loading resource: {0}\n{1}", new Object[]{referenceResource.getDescriptor().getReferenceUri(), ex.getMessage()}));
            ex.printStackTrace();
        }
        this.jButtonSave.setText(IRPlugin.getString("resourceReferenceDialog.buttonModifyReference", "Modify reference"));
    }

    private void updateReferenceDescriptor() {
        if (this.resourceReferenceDescriptor != null) {
            this.jTextFieldResUriString.setText(this.resourceReferenceDescriptor.getUriString());
            this.jTextFieldResName.setText(this.resourceReferenceDescriptor.getName());
            this.jTextFieldResLabel.setText(this.resourceReferenceDescriptor.getLabel());
            this.jTextFieldResType.setText(this.resourceReferenceDescriptor.getWsType());
            this.jButtonOpenReferencedResource.setEnabled(true);
        } else {
            this.jTextFieldResUriString.setText("");
            this.jTextFieldResName.setText("");
            this.jTextFieldResLabel.setText("");
            this.jTextFieldResType.setText("");
            this.jButtonOpenReferencedResource.setEnabled(false);
        }
    }
}

