/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.irplugin.gui;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.irplugin.IRPlugin;
import com.jaspersoft.jasperserver.irplugin.JServer;
import com.jaspersoft.jasperserver.irplugin.RepositoryReportUnit;
import com.jaspersoft.jasperserver.irplugin.gui.DataSourceDialog;
import com.jaspersoft.jasperserver.irplugin.gui.QualityLabel;
import com.jaspersoft.jasperserver.irplugin.gui.RepositoryExplorer;
import com.jaspersoft.jasperserver.irplugin.gui.ValidationUtils;
import com.jaspersoft.jasperserver.irplugin.gui.explorer.ResourceChooser;
import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.Misc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class ReportUnitDialog
extends JDialog {
    private int dialogResult = 2;
    private JServer server = null;
    private String parentFolder = null;
    private ResourceDescriptor newResourceDescriptor = null;
    private ResourceDescriptor dataSourceDescriptor = null;
    private RepositoryReportUnit resource = null;
    private boolean controlsSupportActive = false;
    private boolean resourcesSupportActive = false;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JButton jButtonBrowse;
    private JButton jButtonClose;
    private JButton jButtonEditLocalDataSource;
    private JButton jButtonGetCurrentReport;
    private JButton jButtonPickJrxml;
    private JButton jButtonPickResource;
    private JButton jButtonSave;
    private JComboBox jComboBoxDatasources;
    private JEditorPane jEditorPaneDescription;
    private JLabel jLabel1;
    private JLabel jLabelDescription;
    private JLabel jLabelInputControlRenderingView;
    private JLabel jLabelLabel;
    private JLabel jLabelName;
    private JLabel jLabelReportRenderingView;
    private JLabel jLabelResourceFile;
    private JLabel jLabelResourceType1;
    private JLabel jLabelUriString;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel3;
    private JPanel jPanel6;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JPanel jPanelButtons;
    private JPanel jPanelCommon;
    private JPanel jPanelMainReport;
    private JPanel jPanelOther;
    private JRadioButton jRadioButtonLocal;
    private JRadioButton jRadioButtonLocal1;
    private JRadioButton jRadioButtonRepo;
    private JRadioButton jRadioButtonRepo1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextFieldFile;
    private JTextField jTextFieldFileRepo;
    private JTextField jTextFieldInputControlRenderingView;
    private JTextField jTextFieldLabel;
    private JTextField jTextFieldName;
    private JTextField jTextFieldReportRenderingView;
    private JTextField jTextFieldUriString;

    public ReportUnitDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        Misc.centerFrame((Component)this);
        this.jTextFieldLabel.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                ReportUnitDialog.this.updateSaveButton();
            }

            public void insertUpdate(DocumentEvent evt) {
                ReportUnitDialog.this.updateSaveButton();
            }

            public void removeUpdate(DocumentEvent evt) {
                ReportUnitDialog.this.updateSaveButton();
            }
        });
        this.jTextFieldFile.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                ReportUnitDialog.this.updateSaveButton();
            }

            public void insertUpdate(DocumentEvent evt) {
                ReportUnitDialog.this.updateSaveButton();
            }

            public void removeUpdate(DocumentEvent evt) {
                ReportUnitDialog.this.updateSaveButton();
            }
        });
        this.jTextFieldName.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                ReportUnitDialog.this.updateSaveButton();
            }

            public void insertUpdate(DocumentEvent evt) {
                ReportUnitDialog.this.updateSaveButton();
            }

            public void removeUpdate(DocumentEvent evt) {
                ReportUnitDialog.this.updateSaveButton();
            }
        });
        this.jTextFieldName.requestFocusInWindow();
        this.jRadioButtonRepo.setSelected(true);
        this.jRadioButtonLocal.setSelected(false);
        this.setControlsSupportActive(false);
        this.setResourcesSupportActive(false);
        this.updateResourceFromType();
        if (!IRPlugin.getMainInstance().getBrandingProperties().getProperty("ireport.manage.datasources.enabled", "true").equals("true")) {
            this.jPanel3.removeAll();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            QualityLabel jlabel = new QualityLabel();
            jlabel.setText("<html><b>" + IRPlugin.getString("reportUnitDialog.useDefaultDatasource", "This server uses a default data source to run the reports and execute queries") + "</b></html>");
            this.jPanel3.add((Component)jlabel, gridBagConstraints);
        }
        this.jButtonGetCurrentReport.setEnabled(MainFrame.getMainInstance().getActiveReportFrame() != null);
        this.applyI18n();
    }

    public void applyI18n() {
        this.jButtonClose.setText(IRPlugin.getString("reportUnitDialog.buttonCancel", "Cancel"));
        this.jButtonSave.setText(IRPlugin.getString("reportUnitDialog.buttonSave", "Save"));
        this.jLabel1.setText(IRPlugin.getString("reportUnitDialog.title", "Report unit"));
        this.jLabelDescription.setText(IRPlugin.getString("reportUnitDialog.labelDescription", "Description"));
        this.jLabelLabel.setText(IRPlugin.getString("reportUnitDialog.labelLabel", "Label"));
        this.jLabelName.setText(IRPlugin.getString("reportUnitDialog.labelName", "Name"));
        this.jLabelUriString.setText(IRPlugin.getString("reportUnitDialog.labelParentFolder", "Parent folder"));
        this.jButtonBrowse.setText(IRPlugin.getString("reportUnitDialog.buttonBrowse", "Browse"));
        this.jButtonEditLocalDataSource.setText(IRPlugin.getString("reportUnitDialog.buttonEditLocalResource", "Edit local datasource"));
        this.jButtonGetCurrentReport.setText(IRPlugin.getString("reportUnitDialog.buttonGetCurrentReport", "Get source from current opened report"));
        this.jButtonPickJrxml.setText(IRPlugin.getString("reportUnitDialog.buttonBrowse", "Browse"));
        this.jButtonPickResource.setText(IRPlugin.getString("reportUnitDialog.buttonBrowse", "Browse"));
        this.jLabelResourceFile.setText(IRPlugin.getString("reportUnitDialog.labelMainJRXML", "Main JRXML"));
        this.jLabelResourceType1.setText(IRPlugin.getString("reportUnitDialog.labelDatasource", "Datasource"));
        this.jRadioButtonLocal.setText(IRPlugin.getString("reportUnitDialog.radioLocal", "Locally Defined"));
        this.jRadioButtonLocal1.setText(IRPlugin.getString("reportUnitDialog.radioLocal", "Locally Defined"));
        this.jRadioButtonRepo.setText(IRPlugin.getString("reportUnitDialog.radioRepo", "From the repository"));
        this.jRadioButtonRepo1.setText(IRPlugin.getString("reportUnitDialog.radioRepo", "From the repository"));
        this.jLabelInputControlRenderingView.setText(IRPlugin.getString("reportUnitDialog.labelInputControlRenderingView", "JSP for running Input Controls (blank for default)"));
        this.jLabelReportRenderingView.setText(IRPlugin.getString("reportUnitDialog.labelReportRenderingView", "JSP for Report View (blank for default)"));
        this.jTabbedPane1.setTitleAt(0, IRPlugin.getString("reportUnitDialog.tabGeneral", "General"));
        this.jTabbedPane1.setTitleAt(1, IRPlugin.getString("reportUnitDialog.tabDetails", "Main report and Data Source"));
        this.jTabbedPane1.setTitleAt(2, IRPlugin.getString("reportUnitDialog.tabOther", "Other"));
    }

    private void updateSaveButton() {
        if (this.jTextFieldLabel.getText().length() > 0 && this.jTextFieldName.getText().length() > 0) {
            this.jButtonSave.setEnabled(true);
        } else {
            this.jButtonSave.setEnabled(false);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelCommon = new JPanel();
        this.jLabelUriString = new JLabel();
        this.jTextFieldUriString = new JTextField();
        this.jLabelName = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jSeparator2 = new JSeparator();
        this.jLabelLabel = new JLabel();
        this.jTextFieldLabel = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jEditorPaneDescription = new JEditorPane();
        this.jLabelDescription = new JLabel();
        this.jPanelMainReport = new JPanel();
        this.jLabelResourceFile = new JLabel();
        this.jRadioButtonRepo1 = new JRadioButton();
        this.jPanel6 = new JPanel();
        this.jTextFieldFileRepo = new JTextField();
        this.jButtonPickJrxml = new JButton();
        this.jRadioButtonLocal1 = new JRadioButton();
        this.jPanel8 = new JPanel();
        this.jTextFieldFile = new JTextField();
        this.jButtonBrowse = new JButton();
        this.jButtonGetCurrentReport = new JButton();
        this.jSeparator5 = new JSeparator();
        this.jLabelResourceType1 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jRadioButtonRepo = new JRadioButton();
        this.jComboBoxDatasources = new JComboBox();
        this.jButtonPickResource = new JButton();
        this.jRadioButtonLocal = new JRadioButton();
        this.jButtonEditLocalDataSource = new JButton();
        this.jPanel9 = new JPanel();
        this.jPanelOther = new JPanel();
        this.jLabelInputControlRenderingView = new JLabel();
        this.jTextFieldInputControlRenderingView = new JTextField();
        this.jLabelReportRenderingView = new JLabel();
        this.jTextFieldReportRenderingView = new JTextField();
        this.jPanel10 = new JPanel();
        this.jSeparator4 = new JSeparator();
        this.jPanelButtons = new JPanel();
        this.jButtonSave = new JButton();
        this.jButtonClose = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Report unit");
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setFont(new Font("Dialog", 1, 12));
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/jasperserver/irplugin/res/documents_label.png")));
        this.jLabel1.setText("Report unit");
        this.jLabel1.setVerticalAlignment(3);
        this.jLabel1.setVerticalTextPosition(3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jSeparator1.setMinimumSize(new Dimension(2, 2));
        this.jSeparator1.setPreferredSize(new Dimension(2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanelCommon.setPreferredSize(new Dimension(400, 185));
        this.jPanelCommon.setLayout(new GridBagLayout());
        this.jLabelUriString.setText("Parent folder");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelCommon.add((Component)this.jLabelUriString, gridBagConstraints);
        this.jTextFieldUriString.setEditable(false);
        this.jTextFieldUriString.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jTextFieldUriString.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelCommon.add((Component)this.jTextFieldUriString, gridBagConstraints);
        this.jLabelName.setText("Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanelCommon.add((Component)this.jLabelName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanelCommon.add((Component)this.jTextFieldName, gridBagConstraints);
        this.jSeparator2.setMinimumSize(new Dimension(0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 6, 4);
        this.jPanelCommon.add((Component)this.jSeparator2, gridBagConstraints);
        this.jLabelLabel.setText("Label");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanelCommon.add((Component)this.jLabelLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelCommon.add((Component)this.jTextFieldLabel, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.jEditorPaneDescription);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanelCommon.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabelDescription.setText("Description");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanelCommon.add((Component)this.jLabelDescription, gridBagConstraints);
        this.jTabbedPane1.addTab("Common", this.jPanelCommon);
        this.jPanelMainReport.setLayout(new GridBagLayout());
        this.jLabelResourceFile.setText("Main JRXML");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 4, 0, 4);
        this.jPanelMainReport.add((Component)this.jLabelResourceFile, gridBagConstraints);
        this.buttonGroup2.add(this.jRadioButtonRepo1);
        this.jRadioButtonRepo1.setText("From the repository");
        this.jRadioButtonRepo1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonRepo1.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonRepo1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportUnitDialog.this.jRadioButtonRepoActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 4, 4);
        this.jPanelMainReport.add((Component)this.jRadioButtonRepo1, gridBagConstraints);
        this.jPanel6.setLayout(new GridBagLayout());
        this.jTextFieldFileRepo.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel6.add((Component)this.jTextFieldFileRepo, gridBagConstraints);
        this.jButtonPickJrxml.setText("Browse");
        this.jButtonPickJrxml.setEnabled(false);
        this.jButtonPickJrxml.setMinimumSize(new Dimension(73, 21));
        this.jButtonPickJrxml.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportUnitDialog.this.jButton1ActionPerformed12(evt);
            }
        });
        this.jPanel6.add((Component)this.jButtonPickJrxml, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 30, 0, 4);
        this.jPanelMainReport.add((Component)this.jPanel6, gridBagConstraints);
        this.buttonGroup2.add(this.jRadioButtonLocal1);
        this.jRadioButtonLocal1.setSelected(true);
        this.jRadioButtonLocal1.setText("Locally Defined");
        this.jRadioButtonLocal1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonLocal1.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonLocal1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportUnitDialog.this.jRadioButtonLocalActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 4, 4);
        this.jPanelMainReport.add((Component)this.jRadioButtonLocal1, gridBagConstraints);
        this.jPanel8.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel8.add((Component)this.jTextFieldFile, gridBagConstraints);
        this.jButtonBrowse.setText("Browse");
        this.jButtonBrowse.setMinimumSize(new Dimension(73, 21));
        this.jButtonBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportUnitDialog.this.jButtonBrowseActionPerformed1(evt);
            }
        });
        this.jPanel8.add((Component)this.jButtonBrowse, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 30, 0, 4);
        this.jPanelMainReport.add((Component)this.jPanel8, gridBagConstraints);
        this.jButtonGetCurrentReport.setText("Get source from current opened report");
        this.jButtonGetCurrentReport.setMinimumSize(null);
        this.jButtonGetCurrentReport.setPreferredSize(null);
        this.jButtonGetCurrentReport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportUnitDialog.this.jButton1ActionPerformed11(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 30, 2, 4);
        this.jPanelMainReport.add((Component)this.jButtonGetCurrentReport, gridBagConstraints);
        this.jSeparator5.setMinimumSize(new Dimension(0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 4, 6, 4);
        this.jPanelMainReport.add((Component)this.jSeparator5, gridBagConstraints);
        this.jLabelResourceType1.setText("Datasource");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanelMainReport.add((Component)this.jLabelResourceType1, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.buttonGroup1.add(this.jRadioButtonRepo);
        this.jRadioButtonRepo.setText("From the repository");
        this.jRadioButtonRepo.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonRepo.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonRepo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportUnitDialog.this.jRadioButtonRepoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 4, 4);
        this.jPanel3.add((Component)this.jRadioButtonRepo, gridBagConstraints);
        this.jComboBoxDatasources.setEditable(true);
        this.jComboBoxDatasources.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 30, 4, 2);
        this.jPanel3.add((Component)this.jComboBoxDatasources, gridBagConstraints);
        this.jButtonPickResource.setText("Browse");
        this.jButtonPickResource.setEnabled(false);
        this.jButtonPickResource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportUnitDialog.this.jButtonPickResourceActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 4, 8);
        this.jPanel3.add((Component)this.jButtonPickResource, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButtonLocal);
        this.jRadioButtonLocal.setSelected(true);
        this.jRadioButtonLocal.setText("Locally Defined");
        this.jRadioButtonLocal.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonLocal.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonLocal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportUnitDialog.this.jRadioButtonLocalActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 4, 4);
        this.jPanel3.add((Component)this.jRadioButtonLocal, gridBagConstraints);
        this.jButtonEditLocalDataSource.setText("Edit local datasource");
        this.jButtonEditLocalDataSource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportUnitDialog.this.jButtonEditLocalDataSourceActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 30, 0, 0);
        this.jPanel3.add((Component)this.jButtonEditLocalDataSource, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanelMainReport.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelMainReport.add((Component)this.jPanel9, gridBagConstraints);
        this.jTabbedPane1.addTab("Main report and Data Source", this.jPanelMainReport);
        this.jPanelOther.setLayout(new GridBagLayout());
        this.jLabelInputControlRenderingView.setText("JSP for running Input Controls (blank for default)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 4, 0, 4);
        this.jPanelOther.add((Component)this.jLabelInputControlRenderingView, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanelOther.add((Component)this.jTextFieldInputControlRenderingView, gridBagConstraints);
        this.jLabelReportRenderingView.setText("JSP for Report View (blank for default)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 4, 0, 4);
        this.jPanelOther.add((Component)this.jLabelReportRenderingView, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanelOther.add((Component)this.jTextFieldReportRenderingView, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelOther.add((Component)this.jPanel10, gridBagConstraints);
        this.jTabbedPane1.addTab("Other", this.jPanelOther);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jTabbedPane1, gridBagConstraints);
        this.jSeparator4.setMinimumSize(new Dimension(2, 2));
        this.jSeparator4.setPreferredSize(new Dimension(2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jSeparator4, gridBagConstraints);
        this.jPanelButtons.setMinimumSize(new Dimension(10, 30));
        this.jPanelButtons.setPreferredSize(new Dimension(10, 30));
        this.jPanelButtons.setLayout(new GridBagLayout());
        this.jButtonSave.setText("Create report unit");
        this.jButtonSave.setEnabled(false);
        this.jButtonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportUnitDialog.this.jButtonSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanelButtons.add((Component)this.jButtonSave, gridBagConstraints);
        this.jButtonClose.setText("Cancel");
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportUnitDialog.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jPanelButtons.add((Component)this.jButtonClose, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jPanelButtons, gridBagConstraints);
        this.pack();
    }

    private void jButton1ActionPerformed12(ActionEvent evt) {
        ResourceChooser rc = new ResourceChooser();
        rc.setServer(this.getServer());
        if (rc.showDialog(this, null) == 0) {
            ResourceDescriptor rd = rc.getSelectedDescriptor();
            if (rd == null || rd.getUriString() == null) {
                this.jTextFieldFileRepo.setText("");
            } else {
                if (!rd.getWsType().equals("jrxml")) {
                    JOptionPane.showMessageDialog((Component)MainFrame.getMainInstance(), IRPlugin.getString("reportUnitDialog.message.chooseJrxml", "Please choose a JRXML resource"), "", 2);
                    return;
                }
                this.jTextFieldFileRepo.setText(rd.getUriString());
            }
        }
    }

    private void jRadioButtonLocalActionPerformed1(ActionEvent evt) {
        this.updateJrxmlFromType();
    }

    private void jRadioButtonRepoActionPerformed1(ActionEvent evt) {
        this.updateJrxmlFromType();
    }

    private void jButton1ActionPerformed11(ActionEvent evt) {
        Report report = MainFrame.getMainInstance().getActiveReportFrame().getReport();
        if (report.getFilename() == null) {
            if (JOptionPane.showConfirmDialog(this, IRPlugin.getString("reportUnitDialog.message.saveNow", "Save the report now?")) == 0) {
                MainFrame.getMainInstance().save(MainFrame.getMainInstance().getActiveReportFrame());
            } else {
                return;
            }
        }
        this.jTextFieldFile.setText(report.getFilename());
    }

    private void jButtonEditLocalDataSourceActionPerformed(ActionEvent evt) {
        DataSourceDialog dtd = new DataSourceDialog((Frame)MainFrame.getMainInstance(), true);
        dtd.setServer(this.getServer());
        dtd.setParentFolder(this.getParentFolder() + "/<dataSource>");
        dtd.setDoNotStore(true);
        if (this.dataSourceDescriptor != null) {
            dtd.setResource(this.dataSourceDescriptor);
        }
        ((Component)dtd).setVisible(true);
        if (dtd.getDialogResult() == 0) {
            this.dataSourceDescriptor = dtd.getNewResourceDescriptor();
        }
    }

    private void jRadioButtonLocalActionPerformed(ActionEvent evt) {
        this.updateResourceFromType();
    }

    private void jButtonPickResourceActionPerformed(ActionEvent evt) {
        ResourceChooser rc = new ResourceChooser();
        rc.setServer(this.getServer());
        if (rc.showDialog(this, null) == 0) {
            ResourceDescriptor rd = rc.getSelectedDescriptor();
            if (rd == null || rd.getUriString() == null) {
                this.jComboBoxDatasources.setSelectedItem("");
            } else {
                this.jComboBoxDatasources.setSelectedItem(rd.getUriString());
            }
            this.updateSaveButton();
        }
    }

    private void jRadioButtonRepoActionPerformed(ActionEvent evt) {
        this.updateResourceFromType();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        ResourceDescriptor rd = new ResourceDescriptor();
        File resourceFile = null;
        rd.setWsType("reportUnit");
        rd.setDescription(this.jEditorPaneDescription.getText().trim());
        rd.setName(this.jTextFieldName.getText());
        String uri = this.getParentFolder();
        if (!uri.endsWith("/")) {
            uri = uri + "/";
        }
        uri = uri + this.jTextFieldName.getText();
        rd.setUriString(uri);
        rd.setLabel(this.jTextFieldLabel.getText().trim());
        rd.setParentFolder(this.getParentFolder());
        rd.setIsNew(this.resource == null);
        if (this.jTextFieldInputControlRenderingView.getText().trim().length() > 0) {
            rd.setResourceProperty("PROP_RU_INPUTCONTROL_RENDERING_VIEW", this.jTextFieldInputControlRenderingView.getText().trim());
        }
        if (this.jTextFieldReportRenderingView.getText().trim().length() > 0) {
            rd.setResourceProperty("PROP_RU_REPORT_RENDERING_VIEW", this.jTextFieldReportRenderingView.getText().trim());
        }
        if (IRPlugin.getMainInstance().getBrandingProperties().getProperty("ireport.manage.datasources.enabled", "true").equals("true")) {
            ResourceDescriptor tmpDataSourceDescriptor;
            if (this.jRadioButtonRepo.isSelected()) {
                tmpDataSourceDescriptor = new ResourceDescriptor();
                tmpDataSourceDescriptor.setWsType("datasource");
                tmpDataSourceDescriptor.setReferenceUri(this.jComboBoxDatasources.getSelectedItem() + "");
                tmpDataSourceDescriptor.setIsReference(true);
            } else {
                if (this.dataSourceDescriptor == null) {
                    JOptionPane.showMessageDialog(this, IRPlugin.getString("reportUnitDialog.message.localDatasourceNotDefined", "The local datasource is not correctly defined.\nPress the button \"Edit local datasource\" to fix the problem."));
                    return;
                }
                tmpDataSourceDescriptor = this.dataSourceDescriptor;
                tmpDataSourceDescriptor.setIsReference(false);
            }
            rd.getChildren().add(tmpDataSourceDescriptor);
        }
        ResourceDescriptor jrxmlDescriptor = new ResourceDescriptor();
        jrxmlDescriptor.setWsType("jrxml");
        if (this.jRadioButtonRepo1.isSelected()) {
            jrxmlDescriptor.setIsNew(true);
            jrxmlDescriptor.setMainReport(true);
            jrxmlDescriptor.setIsReference(true);
            jrxmlDescriptor.setReferenceUri(this.jTextFieldFileRepo.getText());
            rd.getChildren().add(jrxmlDescriptor);
        } else if (this.resource == null || this.jTextFieldFile.getText().trim().length() > 0) {
            jrxmlDescriptor.setName(this.jTextFieldName.getText() + "_jrxml");
            jrxmlDescriptor.setLabel("Main jrxml");
            jrxmlDescriptor.setDescription("Main jrxml");
            jrxmlDescriptor.setIsNew(true);
            jrxmlDescriptor.setHasData(true);
            jrxmlDescriptor.setMainReport(true);
            resourceFile = new File(this.jTextFieldFile.getText());
            if (!resourceFile.exists()) {
                JOptionPane.showMessageDialog(this, IRPlugin.getFormattedString("reportUnitDialog.message.fileNotFound", "{0}\n\nFile not found!", new Object[]{this.jTextFieldFile.getText()}));
                return;
            }
            rd.getChildren().add(jrxmlDescriptor);
        }
        try {
            this.validate(rd);
            this.newResourceDescriptor = this.getServer().getWSClient().addOrModifyResource(rd, resourceFile);
            this.setDialogResult(0);
            if (this.resource != null && this.newResourceDescriptor != null) {
                this.resource.setDescriptor(this.newResourceDescriptor);
            }
            ((Component)this).setVisible(false);
            this.dispose();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, IRPlugin.getFormattedString("messages.error.3", "Error:\n {0}", new Object[]{ex.getMessage()}));
            ex.printStackTrace();
            return;
        }
    }

    private void jButtonBrowseActionPerformed1(ActionEvent evt) {
        String fileName = "";
        JFileChooser jfc = new JFileChooser(MainFrame.getMainInstance().getCurrentDirectory());
        jfc.setDialogTitle("Pick a file....");
        jfc.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String filename = file.getName();
                return filename.toLowerCase().endsWith(".xml") || file.isDirectory() || filename.toLowerCase().endsWith(".jrxml");
            }

            public String getDescription() {
                return "JasperReports XML *.xml, *.jrxml";
            }
        });
        jfc.setMultiSelectionEnabled(false);
        jfc.setDialogType(0);
        if (jfc.showOpenDialog(this) == 0) {
            this.jTextFieldFile.setText(jfc.getSelectedFile() + "");
            this.updateSaveButton();
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ((Component)new ReportUnitDialog((Frame)new JFrame(), true)).setVisible(true);
            }
        });
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public void setDatasources(List datasources) {
        this.jComboBoxDatasources.removeAllItems();
        for (int i = 0; i < datasources.size(); ++i) {
            Object datasource = datasources.get(i);
            if (datasource instanceof String) {
                this.jComboBoxDatasources.addItem(datasource);
                continue;
            }
            if (!(datasource instanceof ResourceDescriptor)) continue;
            this.jComboBoxDatasources.addItem(((ResourceDescriptor)datasource).getUriString());
        }
        if (this.jComboBoxDatasources.getItemCount() > 0) {
            this.jComboBoxDatasources.setSelectedIndex(0);
        }
    }

    public JServer getServer() {
        return this.server;
    }

    public void setServer(JServer server) {
        this.server = server;
    }

    public String getParentFolder() {
        return this.parentFolder;
    }

    public void setParentFolder(String parentFolder) {
        this.parentFolder = parentFolder;
        this.jTextFieldUriString.setText(parentFolder);
    }

    public void updateResourceFromType() {
        this.jComboBoxDatasources.setEnabled(this.jRadioButtonRepo.isSelected());
        this.jButtonPickResource.setEnabled(this.jRadioButtonRepo.isSelected());
        this.jButtonEditLocalDataSource.setEnabled(this.jRadioButtonLocal.isSelected());
    }

    public void updateJrxmlFromType() {
        this.jTextFieldFileRepo.setEnabled(this.jRadioButtonRepo1.isSelected());
        this.jButtonPickJrxml.setEnabled(this.jRadioButtonRepo1.isSelected());
        this.jTextFieldFile.setEnabled(this.jRadioButtonLocal1.isSelected());
        this.jButtonBrowse.setEnabled(this.jRadioButtonLocal1.isSelected());
        this.jButtonGetCurrentReport.setEnabled(this.jRadioButtonLocal1.isSelected());
    }

    public ResourceDescriptor getNewResourceDescriptor() {
        return this.newResourceDescriptor;
    }

    public void setResource(RepositoryReportUnit resource) {
        this.resource = resource;
        if (resource != null) {
            this.setResource(resource.getDescriptor());
        }
        this.jTextFieldName.setEditable(false);
        this.jTextFieldName.setOpaque(false);
        this.jButtonSave.setText("Save Report Unit");
    }

    public void setResource(ResourceDescriptor descriptor) {
        System.out.println("Setting resource...");
        System.out.flush();
        if (descriptor == null) {
            return;
        }
        this.jTextFieldName.setText(descriptor.getName());
        this.jTextFieldLabel.setText(descriptor.getLabel());
        this.jEditorPaneDescription.setText(descriptor.getDescription());
        if (descriptor.getResourcePropertyValue("PROP_RU_INPUTCONTROL_RENDERING_VIEW") != null) {
            this.jTextFieldInputControlRenderingView.setText(descriptor.getResourcePropertyValue("PROP_RU_INPUTCONTROL_RENDERING_VIEW"));
        }
        if (descriptor.getResourcePropertyValue("PROP_RU_REPORT_RENDERING_VIEW") != null) {
            this.jTextFieldReportRenderingView.setText(descriptor.getResourcePropertyValue("PROP_RU_REPORT_RENDERING_VIEW"));
        }
        System.out.println("Descriptor children: " + descriptor.getChildren().size());
        System.out.flush();
        try {
            List children = this.getServer().getWSClient().list(descriptor);
            if (children != null) {
                descriptor.setChildren(children);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (int i = 0; i < descriptor.getChildren().size(); ++i) {
            ResourceDescriptor rd = (ResourceDescriptor)descriptor.getChildren().get(i);
            System.out.println("Resource " + i + " " + rd.getWsType());
            System.out.flush();
            if (rd.getWsType().equals("datasource")) {
                this.jComboBoxDatasources.setSelectedItem(rd.getReferenceUri());
                this.jRadioButtonRepo.setSelected(true);
                this.jRadioButtonLocal.setSelected(false);
            } else if (RepositoryExplorer.isDataSource(rd)) {
                System.out.println("Setting URI: " + rd.getReferenceUri());
                this.dataSourceDescriptor = rd;
                this.jRadioButtonLocal.setSelected(true);
                this.jRadioButtonRepo.setSelected(false);
            } else if (rd.getWsType().equals("jrxml") && rd.isMainReport()) {
                if (!rd.getUriString().startsWith(descriptor.getUriString())) {
                    this.jRadioButtonLocal1.setSelected(false);
                    this.jRadioButtonRepo1.setSelected(true);
                    this.jTextFieldFileRepo.setText(rd.getUriString());
                } else {
                    this.jRadioButtonLocal1.setSelected(true);
                    this.jRadioButtonRepo1.setSelected(false);
                }
            }
            this.updateResourceFromType();
            this.updateJrxmlFromType();
        }
    }

    public RepositoryReportUnit getResource() {
        return this.resource;
    }

    public boolean isControlsSupportActive() {
        return this.controlsSupportActive;
    }

    public void setControlsSupportActive(boolean controlsSupportActive) {
        this.controlsSupportActive = controlsSupportActive;
    }

    public boolean isResourcesSupportActive() {
        return this.resourcesSupportActive;
    }

    public void setResourcesSupportActive(boolean resourcesSupportActive) {
        this.resourcesSupportActive = resourcesSupportActive;
    }

    public void validate(ResourceDescriptor dataType) throws Exception {
        ValidationUtils.validateName(dataType.getName());
        ValidationUtils.validateLabel(dataType.getLabel());
        ValidationUtils.validateDesc(dataType.getDescription());
    }
}

