/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.plugin.checkupdate;

import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.plugin.checkupdate.CheckUpdateDialog;
import it.businesslogic.ireport.util.I18n;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.w3c.tools.codec.Base64Encoder;

public class UpgradeSearch
implements Runnable {
    private CheckUpdateDialog win = null;

    public void run() {
        try {
            InputStream is;
            int readed;
            String version;
            Properties props = MainFrame.getMainInstance().getProperties();
            if (props.getProperty("update.useProxy", "false").equals("true")) {
                System.getProperties().put("proxySet", "true");
                String urlProxy = props.getProperty("update.proxyUrl", "");
                String port = "8080";
                String server = urlProxy;
                if (urlProxy.indexOf(":") > 0) {
                    port = urlProxy.substring(urlProxy.indexOf(":") + 1);
                    server = urlProxy.substring(0, urlProxy.indexOf(":"));
                }
                System.getProperties().put("proxyHost", server);
                System.getProperties().put("proxyPort", port);
                MainFrame.getMainInstance().logOnConsole("Using proxy: " + urlProxy);
            }
            URL url = new URL("http://ireport.sf.net/lastversion.php");
            byte[] webBuffer = new byte[100];
            URLConnection uConn = url.openConnection();
            if (props.getProperty("update.useProxy", "false").equals("true") && props.getProperty("update.useAuth", "false").equals("true")) {
                String password = props.getProperty("update.username", "") + ":" + props.getProperty("update.password", "");
                Base64Encoder b = new Base64Encoder(password);
                String encodedPassword = b.processString();
                uConn.setRequestProperty("Proxy-Authorization", encodedPassword);
            }
            if ((version = new String(webBuffer, 0, readed = (is = uConn.getInputStream()).read(webBuffer))).toLowerCase().startsWith("ireport") && version.compareTo(MainFrame.constTitle) > 0) {
                final String fversion = version;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(MainFrame.getMainInstance(), I18n.getFormattedString("messages.upgradeSearch.newVersion", "{0} is available on http://ireport.sf.net!", new Object[]{fversion}));
                    }
                });
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        if (this.win != null) {
            this.win.setVisible(false);
        }
    }

    public CheckUpdateDialog getWin() {
        return this.win;
    }

    public void setWin(CheckUpdateDialog win) {
        this.win = win;
    }
}

