/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaProcessExecuter {
    private List<String> classpathEntries;
    private List<String> parameters = new ArrayList<String>();
    private String mainClass = null;
    private String javaExecutable = null;

    public List<String> getClasspathEntries() {
        return this.classpathEntries;
    }

    public void setClasspathEntries(List<String> calsspathEntries) {
        this.classpathEntries = calsspathEntries;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<String> parameters) {
        this.parameters = parameters;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public String getJavaExecutable() {
        return this.javaExecutable;
    }

    public void setJavaExecutable(String javaExecutable) {
        this.javaExecutable = javaExecutable;
    }

    public JavaProcessExecuter() {
        this.classpathEntries = new ArrayList<String>();
        String java_home = System.getProperty("java.home");
        if (java_home != null) {
            this.javaExecutable = java_home + File.separator + "bin" + File.separator + "java";
            if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                this.javaExecutable = this.javaExecutable + ".exe";
            }
        }
    }

    public void dumpOutput(final InputStream in) {
        Runnable r = new Runnable(){

            public void run() {
                try {
                    String s = "";
                    byte[] buffer = new byte[1024];
                    int count = 0;
                    while ((count = in.read(buffer)) >= 0) {
                        if (count <= 0) continue;
                        s = s + new String(buffer, 0, count);
                    }
                    System.out.println(s);
                    System.out.flush();
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        new Thread(r).start();
    }

    public void execute() throws IOException {
        try {
            String classpath = "";
            for (String cpitem : this.getClasspathEntries()) {
                classpath = classpath + cpitem + File.pathSeparator;
            }
            ArrayList<String> cmdList = new ArrayList<String>();
            cmdList.add(this.javaExecutable);
            cmdList.add("-Xmx512m");
            cmdList.add("-cp");
            cmdList.add(classpath);
            cmdList.add(this.getMainClass());
            cmdList.addAll(this.getParameters());
            String[] cmdArray = new String[cmdList.size()];
            Process process = Runtime.getRuntime().exec(cmdList.toArray(cmdArray));
            this.dumpOutput(process.getErrorStream());
            this.dumpOutput(process.getInputStream());
            process.waitFor();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }
}

