/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Color;
import java.awt.Component;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;

public class LegacyHighlighter
extends AbstractHighlighter {
    public static final LegacyHighlighter ledgerBackground = new LegacyHighlighter(new Color(245, 255, 245), null, true);
    public static final LegacyHighlighter notePadBackground = new LegacyHighlighter(new Color(255, 255, 204), null, true);
    private Color background = null;
    private Color foreground = null;
    private Color selectedBackground = null;
    private Color selectedForeground = null;

    public LegacyHighlighter() {
        this(null, null);
    }

    public LegacyHighlighter(Color cellBackground, Color cellForeground) {
        this(cellBackground, cellForeground, false);
    }

    public LegacyHighlighter(Color cellBackground, Color cellForeground, boolean immutable) {
        this(cellBackground, cellForeground, null, null, immutable);
    }

    public LegacyHighlighter(Color cellBackground, Color cellForeground, Color selectedBackground, Color selectedForeground) {
        this(cellBackground, cellForeground, selectedBackground, selectedForeground, false);
    }

    public LegacyHighlighter(Color cellBackground, Color cellForeground, Color selectedBackground, Color selectedForeground, boolean immutable) {
        super(immutable);
        this.background = cellBackground;
        this.foreground = cellForeground;
        this.selectedBackground = selectedBackground;
        this.selectedForeground = selectedForeground;
    }

    public Component highlight(Component renderer, ComponentAdapter adapter) {
        return this.doHighlight(renderer, adapter);
    }

    protected Component doHighlight(Component renderer, ComponentAdapter adapter) {
        this.applyBackground(renderer, adapter);
        this.applyForeground(renderer, adapter);
        return renderer;
    }

    protected void applyBackground(Component renderer, ComponentAdapter adapter) {
        Color color = this.computeBackground(renderer, adapter);
        if (color != null) {
            renderer.setBackground(color);
        }
    }

    protected void applyForeground(Component renderer, ComponentAdapter adapter) {
        Color color = this.computeForeground(renderer, adapter);
        if (color != null) {
            renderer.setForeground(color);
        }
    }

    protected Color computeBackground(Component renderer, ComponentAdapter adapter) {
        return adapter.isSelected() ? this.computeSelectedBackground(renderer, adapter) : this.computeUnselectedBackground(renderer, adapter);
    }

    protected Color computeUnselectedBackground(Component renderer, ComponentAdapter adapter) {
        return this.getBackground();
    }

    protected Color computeSelectedBackground(Component renderer, ComponentAdapter adapter) {
        return this.getSelectedBackground();
    }

    protected Color computeForeground(Component renderer, ComponentAdapter adapter) {
        return adapter.isSelected() ? this.computeSelectedForeground(renderer, adapter) : this.computeUnselectedForeground(renderer, adapter);
    }

    protected Color computeUnselectedForeground(Component renderer, ComponentAdapter adapter) {
        return this.getForeground();
    }

    protected Color computeSelectedForeground(Component renderer, ComponentAdapter adapter) {
        return this.getSelectedForeground();
    }

    protected Color computeSelectedBackground(Color seed) {
        return this.selectedBackground;
    }

    protected Color computeSelectedForeground(Color seed) {
        return this.selectedForeground;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color color) {
        if (this.isImmutable()) {
            return;
        }
        this.background = color;
        this.fireStateChanged();
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color color) {
        if (this.isImmutable()) {
            return;
        }
        this.foreground = color;
        this.fireStateChanged();
    }

    public Color getSelectedBackground() {
        return this.selectedBackground;
    }

    public void setSelectedBackground(Color color) {
        if (this.isImmutable()) {
            return;
        }
        this.selectedBackground = color;
        this.fireStateChanged();
    }

    public Color getSelectedForeground() {
        return this.selectedForeground;
    }

    public void setSelectedForeground(Color color) {
        if (this.isImmutable()) {
            return;
        }
        this.selectedForeground = color;
        this.fireStateChanged();
    }

    public static interface UIHighlighter {
        public void updateUI();
    }
}

