/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.MetaClass;
import groovy.lang.Range;
import groovy.lang.Reference;
import groovy.lang.Script;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.vmplugin.VMPluginFactory;

public class ClassHelper {
    private static final Class[] classes = new Class[]{Object.class, Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Double.TYPE, Float.TYPE, Void.TYPE, Closure.class, GString.class, List.class, Map.class, Range.class, Pattern.class, Script.class, String.class, Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Double.class, Float.class, BigDecimal.class, BigInteger.class, Void.class, Reference.class, Class.class, MetaClass.class};
    private static final String[] primitiveClassNames = new String[]{"", "boolean", "char", "byte", "short", "int", "long", "double", "float", "void"};
    public static final ClassNode DYNAMIC_TYPE;
    public static final ClassNode OBJECT_TYPE;
    public static final ClassNode VOID_TYPE;
    public static final ClassNode CLOSURE_TYPE;
    public static final ClassNode GSTRING_TYPE;
    public static final ClassNode LIST_TYPE;
    public static final ClassNode MAP_TYPE;
    public static final ClassNode RANGE_TYPE;
    public static final ClassNode PATTERN_TYPE;
    public static final ClassNode STRING_TYPE;
    public static final ClassNode SCRIPT_TYPE;
    public static final ClassNode REFERENCE_TYPE;
    public static final ClassNode boolean_TYPE;
    public static final ClassNode char_TYPE;
    public static final ClassNode byte_TYPE;
    public static final ClassNode int_TYPE;
    public static final ClassNode long_TYPE;
    public static final ClassNode short_TYPE;
    public static final ClassNode double_TYPE;
    public static final ClassNode float_TYPE;
    public static final ClassNode Byte_TYPE;
    public static final ClassNode Short_TYPE;
    public static final ClassNode Integer_TYPE;
    public static final ClassNode Long_TYPE;
    public static final ClassNode Character_TYPE;
    public static final ClassNode Float_TYPE;
    public static final ClassNode Double_TYPE;
    public static final ClassNode Boolean_TYPE;
    public static final ClassNode BigInteger_TYPE;
    public static final ClassNode BigDecimal_TYPE;
    public static final ClassNode void_WRAPPER_TYPE;
    public static final ClassNode CLASS_Type;
    public static final ClassNode METACLASS_TYPE;
    public static final ClassNode GENERATED_CLOSURE_Type;
    public static final ClassNode Enum_Type;
    private static ClassNode[] types;
    private static ClassNode[] numbers;
    protected static final ClassNode[] EMPTY_TYPE_ARRAY;
    public static final String OBJECT = "java.lang.Object";

    public static ClassNode[] make(Class[] classes) {
        ClassNode[] cns = new ClassNode[classes.length];
        for (int i = 0; i < cns.length; ++i) {
            cns[i] = ClassHelper.make(classes[i]);
        }
        return cns;
    }

    public static ClassNode make(Class c) {
        return ClassHelper.make(c, true);
    }

    public static ClassNode make(Class c, boolean includeGenerics) {
        for (int i = 0; i < classes.length; ++i) {
            if (c != classes[i]) continue;
            return types[i];
        }
        if (c.isArray()) {
            ClassNode cn = ClassHelper.make(c.getComponentType(), includeGenerics);
            return cn.makeArray();
        }
        return ClassHelper.makeWithoutCaching(c, includeGenerics);
    }

    public static ClassNode makeWithoutCaching(Class c) {
        return ClassHelper.makeWithoutCaching(c, true);
    }

    public static ClassNode makeWithoutCaching(Class c, boolean includeGenerics) {
        ClassNode t = new ClassNode(c);
        if (includeGenerics) {
            VMPluginFactory.getPlugin().setGenericsTypes(t);
        }
        return t;
    }

    public static ClassNode makeWithoutCaching(String name) {
        ClassNode cn = new ClassNode(name, 1, OBJECT_TYPE);
        cn.isPrimaryNode = false;
        return cn;
    }

    public static ClassNode make(String name) {
        int i;
        if (name == null || name.length() == 0) {
            return DYNAMIC_TYPE;
        }
        for (i = 0; i < primitiveClassNames.length; ++i) {
            if (!primitiveClassNames[i].equals(name)) continue;
            return types[i];
        }
        for (i = 0; i < classes.length; ++i) {
            String cname = classes[i].getName();
            if (!name.equals(cname)) continue;
            return types[i];
        }
        return ClassHelper.makeWithoutCaching(name);
    }

    public static ClassNode getWrapper(ClassNode cn) {
        if (!ClassHelper.isPrimitiveType(cn = cn.redirect())) {
            return cn;
        }
        if (cn == boolean_TYPE) {
            return Boolean_TYPE;
        }
        if (cn == byte_TYPE) {
            return Byte_TYPE;
        }
        if (cn == char_TYPE) {
            return Character_TYPE;
        }
        if (cn == short_TYPE) {
            return Short_TYPE;
        }
        if (cn == int_TYPE) {
            return Integer_TYPE;
        }
        if (cn == long_TYPE) {
            return Long_TYPE;
        }
        if (cn == float_TYPE) {
            return Float_TYPE;
        }
        if (cn == double_TYPE) {
            return Double_TYPE;
        }
        if (cn == VOID_TYPE) {
            return void_WRAPPER_TYPE;
        }
        return cn;
    }

    public static boolean isPrimitiveType(ClassNode cn) {
        return cn == boolean_TYPE || cn == char_TYPE || cn == byte_TYPE || cn == short_TYPE || cn == int_TYPE || cn == long_TYPE || cn == float_TYPE || cn == double_TYPE || cn == VOID_TYPE;
    }

    public static ClassNode makeReference() {
        return ClassHelper.make(Reference.class);
    }

    public static boolean isUnresolvedEnum(ClassNode node) {
        if (Enum_Type.isResolved()) {
            return false;
        }
        if (node.isResolved()) {
            return false;
        }
        ClassNode superClass = node.getSuperClass();
        if (superClass == null) {
            return false;
        }
        return superClass.redirect() == Enum_Type;
    }

    static {
        OBJECT_TYPE = DYNAMIC_TYPE = new ClassNode(Object.class);
        VOID_TYPE = new ClassNode(Void.TYPE);
        CLOSURE_TYPE = new ClassNode(Closure.class);
        GSTRING_TYPE = new ClassNode(GString.class);
        LIST_TYPE = ClassHelper.makeWithoutCaching(List.class);
        MAP_TYPE = new ClassNode(Map.class);
        RANGE_TYPE = new ClassNode(Range.class);
        PATTERN_TYPE = new ClassNode(Pattern.class);
        STRING_TYPE = new ClassNode(String.class);
        SCRIPT_TYPE = new ClassNode(Script.class);
        REFERENCE_TYPE = ClassHelper.makeWithoutCaching(Reference.class);
        boolean_TYPE = new ClassNode(Boolean.TYPE);
        char_TYPE = new ClassNode(Character.TYPE);
        byte_TYPE = new ClassNode(Byte.TYPE);
        int_TYPE = new ClassNode(Integer.TYPE);
        long_TYPE = new ClassNode(Long.TYPE);
        short_TYPE = new ClassNode(Short.TYPE);
        double_TYPE = new ClassNode(Double.TYPE);
        float_TYPE = new ClassNode(Float.TYPE);
        Byte_TYPE = new ClassNode(Byte.class);
        Short_TYPE = new ClassNode(Short.class);
        Integer_TYPE = new ClassNode(Integer.class);
        Long_TYPE = new ClassNode(Long.class);
        Character_TYPE = new ClassNode(Character.class);
        Float_TYPE = new ClassNode(Float.class);
        Double_TYPE = new ClassNode(Double.class);
        Boolean_TYPE = new ClassNode(Boolean.class);
        BigInteger_TYPE = new ClassNode(BigInteger.class);
        BigDecimal_TYPE = new ClassNode(BigDecimal.class);
        void_WRAPPER_TYPE = new ClassNode(Void.class);
        CLASS_Type = new ClassNode(Class.class);
        METACLASS_TYPE = new ClassNode(MetaClass.class);
        GENERATED_CLOSURE_Type = new ClassNode(GeneratedClosure.class);
        Enum_Type = new ClassNode("java.lang.Enum", 0, OBJECT_TYPE);
        ClassHelper.Enum_Type.isPrimaryNode = false;
        types = new ClassNode[]{OBJECT_TYPE, boolean_TYPE, char_TYPE, byte_TYPE, short_TYPE, int_TYPE, long_TYPE, double_TYPE, float_TYPE, VOID_TYPE, CLOSURE_TYPE, GSTRING_TYPE, LIST_TYPE, MAP_TYPE, RANGE_TYPE, PATTERN_TYPE, SCRIPT_TYPE, STRING_TYPE, Boolean_TYPE, Character_TYPE, Byte_TYPE, Short_TYPE, Integer_TYPE, Long_TYPE, Double_TYPE, Float_TYPE, BigDecimal_TYPE, BigInteger_TYPE, void_WRAPPER_TYPE, REFERENCE_TYPE, CLASS_Type, METACLASS_TYPE, GENERATED_CLOSURE_Type, Enum_Type};
        numbers = new ClassNode[]{char_TYPE, byte_TYPE, short_TYPE, int_TYPE, long_TYPE, double_TYPE, float_TYPE, Short_TYPE, Byte_TYPE, Character_TYPE, Integer_TYPE, Float_TYPE, Long_TYPE, Double_TYPE, BigInteger_TYPE, BigDecimal_TYPE};
        EMPTY_TYPE_ARRAY = new ClassNode[0];
    }
}

