/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.export.flex;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.geom.Dimension2D;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.export.FontKey;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JROriginExporterFilter;
import net.sf.jasperreports.engine.util.JRValueStringUtils;
import net.sf.jasperreports.engine.util.JRXmlWriteHelper;
import net.sf.jasperreports.export.flex.JRMxmlConstants;
import net.sf.jasperreports.export.flex.JRMxmlExporterParameter;
import org.w3c.tools.codec.Base64Encoder;

public class JRMxmlExporter
extends JRAbstractExporter {
    private static final String MXML_ORIGIN_EXPORTER_FILTER_PREFIX = "net.sf.jasperreports.export.mxml.exclude.origin.";
    protected static final String DEFAULT_XML_ENCODING = "UTF-8";
    protected static final String DEFAULT_OBJECT_TYPE = "java.lang.String";
    protected static final String HTML_FILES_SUFFIX = "_files";
    protected static final String IMAGE_PREFIX = "img_";
    protected JRXmlWriteHelper xmlWriter = null;
    protected String encoding = null;
    protected JRExportProgressMonitor progressMonitor = null;
    protected Map rendererToImagePathMap = null;
    protected Map imageNameToImageDataMap = null;
    protected Map fontsMap = new HashMap();
    protected Map stylesMap = new HashMap();
    protected Map embeddedFontMap = new HashMap();
    private Map embeddedCharacterMap = new HashMap();
    protected String dtdLocation = null;
    protected boolean isEmbeddingImages = true;
    protected boolean isEmbeddingFonts = true;
    protected File destFile = null;
    protected File imagesDir = null;
    protected String comment = null;
    private static int imageId = 0;
    private static Set allFontNames;
    static /* synthetic */ Class class$net$sf$jasperreports$export$flex$JRMxmlExporter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReport() throws JRException {
        block17: {
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            this.setOffset();
            try {
                StringBuffer sb;
                this.setExportContext();
                this.setInput();
                if (!this.parameters.containsKey(JRExporterParameter.FILTER)) {
                    this.filter = JROriginExporterFilter.getFilter((JRPropertiesMap)this.jasperPrint.getPropertiesMap(), (String)MXML_ORIGIN_EXPORTER_FILTER_PREFIX);
                }
                this.setPageRange();
                this.encoding = (String)this.parameters.get(JRExporterParameter.CHARACTER_ENCODING);
                if (this.encoding == null) {
                    this.encoding = DEFAULT_XML_ENCODING;
                }
                if ((sb = (StringBuffer)this.parameters.get(JRExporterParameter.OUTPUT_STRING_BUFFER)) != null) {
                    StringBuffer buffer = this.exportReportToBuffer();
                    sb.append(buffer.toString());
                    break block17;
                }
                Writer outWriter = (Writer)this.parameters.get(JRExporterParameter.OUTPUT_WRITER);
                if (outWriter != null) {
                    try {
                        this.exportReportToStream(outWriter);
                        break block17;
                    }
                    catch (IOException e) {
                        throw new JRException("Error writing to writer : " + this.jasperPrint.getName(), (Throwable)e);
                    }
                }
                OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (os != null) {
                    try {
                        this.exportReportToStream(new OutputStreamWriter(os, this.encoding));
                        break block17;
                    }
                    catch (Exception e) {
                        throw new JRException("Error writing to OutputStream : " + this.jasperPrint.getName(), (Throwable)e);
                    }
                }
                this.destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (this.destFile == null) {
                    String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (fileName != null) {
                        this.destFile = new File(fileName);
                    } else {
                        throw new JRException("No output specified for the exporter.");
                    }
                }
                this.imagesDir = new File(this.destFile.getParent(), this.destFile.getName() + HTML_FILES_SUFFIX);
                Boolean isEmbeddingImagesParameter = (Boolean)this.parameters.get(JRMxmlExporterParameter.IS_EMBEDDING_IMAGES);
                if (isEmbeddingImagesParameter == null) {
                    isEmbeddingImagesParameter = Boolean.TRUE;
                }
                this.isEmbeddingImages = isEmbeddingImagesParameter;
                Boolean isEmbeddingFontsParameter = (Boolean)this.parameters.get((Object)JRMxmlExporterParameter.IS_EMBEDDING_FONTS);
                if (isEmbeddingFontsParameter == null) {
                    isEmbeddingFontsParameter = Boolean.TRUE;
                }
                this.isEmbeddingFonts = isEmbeddingFontsParameter;
                this.comment = (String)this.parameters.get((Object)JRMxmlExporterParameter.COMMENT);
                this.exportReportToFile();
            }
            finally {
                this.resetExportContext();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void exportReportToFile() throws JRException {
        block16: {
            this.rendererToImagePathMap = new HashMap();
            this.imageNameToImageDataMap = new HashMap();
            Writer writer = null;
            try {
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(this.destFile);
                    writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, this.encoding));
                    this.exportReportToStream(writer);
                }
                catch (IOException e) {
                    throw new JRException("Error writing to file : " + this.destFile, (Throwable)e);
                }
                Object var4_4 = null;
                if (writer == null) break block16;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (writer == null) throw throwable;
                try {
                    writer.close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException e) {}
            writer.close();
        }
        if (this.isEmbeddingImages) return;
        Set imageNames = this.imageNameToImageDataMap.keySet();
        if (imageNames == null) return;
        if (imageNames.size() <= 0) return;
        if (!this.imagesDir.exists()) {
            this.imagesDir.mkdir();
        }
        Iterator it = imageNames.iterator();
        while (it.hasNext()) {
            IOException e3;
            Object var10_12;
            String imageName = (String)it.next();
            byte[] imageData = (byte[])this.imageNameToImageDataMap.get(imageName);
            File imageFile = new File(this.imagesDir, imageName);
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(imageFile);
                    ((OutputStream)fos).write(imageData, 0, imageData.length);
                }
                catch (IOException e2) {
                    throw new JRException("Error writing to image file : " + imageFile, (Throwable)e2);
                }
                var10_12 = null;
                if (fos == null) continue;
                {
                }
            }
            catch (Throwable throwable) {
                var10_12 = null;
                if (fos == null) throw throwable;
                try {
                    ((OutputStream)fos).close();
                    throw throwable;
                }
                catch (IOException e3) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException e3) {}
            ((OutputStream)fos).close();
        }
    }

    protected StringBuffer exportReportToBuffer() throws JRException {
        StringWriter buffer = new StringWriter();
        try {
            this.exportReportToStream(buffer);
        }
        catch (IOException e) {
            throw new JRException("Error while exporting report to buffer", (Throwable)e);
        }
        return buffer.getBuffer();
    }

    protected void exportReportToStream(Writer writer) throws JRException, IOException {
        JRStyle[] styles;
        this.xmlWriter = new JRXmlWriteHelper(writer);
        this.xmlWriter.writeProlog(this.encoding);
        writer.write(MessageFormat.format("<!--\nGenerated by JRMxmlExporter from JasperReports - Free Java report-generating library.\nCopyright (C) 2001-2007 JasperSoft Corporation http://www.jaspersoft.com\n{0}\n\nTo generate the SWF-file use command:\n%FLEX_SDK_HOME%\\bin\\mxmlc.exe -library-path+=JRMxmlLib.swc -use-network=true|false {1}\nwhere JRMxmlLib.swc - Flex Component Library from JasperReports\n-->\n", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ").format(new Date()), this.jasperPrint.getName() + ".mxml"));
        if (this.comment != null && this.comment.length() > 0) {
            writer.write("<!--" + this.comment + "-->\n");
        }
        this.xmlWriter.startElement("mx:Application");
        this.xmlWriter.addAttribute("xmlns:mx", "http://www.adobe.com/2006/mxml");
        this.xmlWriter.addAttribute("xmlns:jr", "net.sf.jasperreports.export.flex.*");
        this.xmlWriter.addAttribute("pageTitle", this.jasperPrint.getName());
        this.xmlWriter.addAttribute("layout", "vertical");
        this.xmlWriter.addAttribute("verticalGap", "20");
        this.xmlWriter.addAttribute("backgroundGradientColors", "[#c0c0c0, #c0c0c0]");
        this.xmlWriter.addAttribute("creationCompleteEffect", "{Effects.FADE_IN}");
        this.xmlWriter.addAttribute("preinitialize", "init()");
        this.xmlWriter.addAttribute("paddingLeft", "10");
        this.xmlWriter.addAttribute("paddingRight", "10");
        this.xmlWriter.addAttribute("paddingTop", "10");
        this.xmlWriter.addAttribute("paddingBottom", "10");
        this.xmlWriter.addAttribute("horizontalScrollPolicy", "off");
        this.xmlWriter.addAttribute("verticalScrollPolicy", "off");
        this.xmlWriter.startElement("mx:Object");
        this.xmlWriter.addEncodedAttribute("id", "initObject");
        this.xmlWriter.addEncodedAttribute("name", this.jasperPrint.getName());
        this.xmlWriter.addAttribute("pageWidth", this.jasperPrint.getPageWidth());
        this.xmlWriter.addAttribute("pageHeight", this.jasperPrint.getPageHeight());
        this.xmlWriter.addAttribute("orientation", this.jasperPrint.getOrientation(), JRMxmlConstants.getOrientationMap(), (byte)1);
        this.xmlWriter.addAttribute("formatFactoryClass", this.jasperPrint.getFormatFactoryClass());
        this.xmlWriter.addEncodedAttribute("locale", this.jasperPrint.getLocaleCode());
        this.xmlWriter.addEncodedAttribute("timezone", this.jasperPrint.getTimeZoneId());
        this.xmlWriter.addAttribute("isFontsEmbedded", this.isEmbeddingFonts, false);
        this.xmlWriter.closeElement();
        JRReportFont[] fonts = this.jasperPrint.getFonts();
        if (fonts != null && fonts.length > 0) {
            for (int i = 0; i < fonts.length; ++i) {
                this.fontsMap.put(fonts[i].getName(), fonts[i]);
                this.exportReportFont(fonts[i]);
            }
        }
        if ((styles = this.jasperPrint.getStyles()) != null && styles.length > 0) {
            for (int i = 0; i < styles.length; ++i) {
                this.stylesMap.put(styles[i].getName(), styles[i]);
                this.exportStyle(styles[i]);
            }
        }
        this.xmlWriter.startElement("jr:Viewer");
        this.xmlWriter.addAttribute("pageStack", "{pageStack}");
        this.xmlWriter.closeElement();
        this.xmlWriter.startElement("mx:ViewStack");
        this.xmlWriter.addAttribute("id", "pageStack");
        List pages = this.jasperPrint.getPages();
        if (pages != null && pages.size() > 0) {
            JRPrintPage page = null;
            for (int i = this.startPageIndex; i <= this.endPageIndex; ++i) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new JRException("Current thread interrupted.");
                }
                page = (JRPrintPage)pages.get(i);
                this.exportPage(page);
            }
        }
        this.xmlWriter.closeElement();
        this.xmlWriter.startElement("mx:Script");
        InputStream is = (class$net$sf$jasperreports$export$flex$JRMxmlExporter == null ? (class$net$sf$jasperreports$export$flex$JRMxmlExporter = JRMxmlExporter.class$("net.sf.jasperreports.export.flex.JRMxmlExporter")) : class$net$sf$jasperreports$export$flex$JRMxmlExporter).getResourceAsStream("Script.as");
        byte[] buf = new byte[8192];
        int length = is.read(buf);
        this.xmlWriter.writeCDATA(new String(buf, 0, length));
        this.xmlWriter.closeElement();
        this.exportEmbeddedFonts();
        this.xmlWriter.closeElement();
        writer.flush();
    }

    protected void exportEmbeddedFonts() throws IOException {
        if (this.embeddedFontMap.size() == 0) {
            return;
        }
        this.xmlWriter.startElement("mx:Style");
        Iterator it = this.embeddedFontMap.keySet().iterator();
        String embeddedFonts = "";
        while (it.hasNext()) {
            FontKey fk = (FontKey)it.next();
            String fontFace = (String)this.embeddedFontMap.get(fk);
            Set charSet = (Set)this.embeddedCharacterMap.get(fontFace);
            String charList = "";
            if (charSet != null) {
                Iterator charIt = charSet.iterator();
                while (charIt.hasNext()) {
                    Character c = (Character)charIt.next();
                    String hexString = Integer.toHexString(c.charValue());
                    hexString = ("000" + hexString).substring(hexString.length() - 1);
                    charList = charList + ", U+" + hexString + "-U+" + hexString;
                }
            }
            Object[] objectArray = new Object[5];
            objectArray[0] = fk.getFontName();
            objectArray[1] = fontFace;
            Object object = objectArray[2] = fk.isItalic() ? "italic" : "normal";
            objectArray[3] = fk.isBold() ? (";serif;arial;".indexOf(';' + fk.getFontName().toLowerCase() + ';') >= 0 ? "heavy" : "bold") : "normal";
            objectArray[4] = charList;
            embeddedFonts = embeddedFonts + MessageFormat.format("\n@font-face '{'src: local(\"{0}\"); fontFamily: \"{1}\"; fontStyle: {2}; fontWeight: {3}; advancedAntiAliasing: false; unicodeRange: U+0000-U+0000{4};}", objectArray);
        }
        this.xmlWriter.writeCDATA(embeddedFonts);
        this.xmlWriter.closeElement();
    }

    protected void exportReportFont(JRReportFont font) throws IOException {
        this.xmlWriter.startElement("jr:ReportFont");
        this.xmlWriter.addEncodedAttribute("name", font.getName());
        this.xmlWriter.addAttribute("isDefault", font.isDefault());
        this.xmlWriter.addEncodedAttribute("fontName", this.ownFontName((JRFont)font));
        this.xmlWriter.addAttribute("size", font.getFontSize());
        this.xmlWriter.addAttribute("isBold", font.isBold());
        this.xmlWriter.addAttribute("isItalic", font.isItalic());
        this.xmlWriter.addAttribute("isUnderline", font.isUnderline());
        this.xmlWriter.addAttribute("isStrikeThrough", font.isStrikeThrough());
        this.xmlWriter.closeElement();
    }

    protected void exportStyle(JRStyle style) throws IOException {
        this.xmlWriter.startElement("jr:Style");
        this.xmlWriter.addEncodedAttribute("name", style.getName());
        this.xmlWriter.addAttribute("isDefault", style.isDefault());
        if (style.getStyle() != null) {
            JRStyle baseStyle = (JRStyle)this.stylesMap.get(style.getStyle().getName());
            if (baseStyle != null) {
                this.xmlWriter.addEncodedAttribute("style", style.getStyle().getName());
            } else {
                throw new JRRuntimeException("Referenced report style not found : " + style.getStyle().getName());
            }
        }
        this.xmlWriter.addAttribute("mode", (Object)style.getOwnMode(), JRMxmlConstants.getModeMap());
        this.xmlWriter.addAttribute("forecolor", style.getOwnForecolor());
        this.xmlWriter.addAttribute("backcolor", style.getOwnBackcolor());
        this.exportPen(style.getLinePen());
        this.xmlWriter.addAttribute("fill", (Object)style.getOwnFill(), JRMxmlConstants.getFillMap());
        this.xmlWriter.addAttribute("radius", (Object)style.getOwnRadius());
        this.xmlWriter.addAttribute("scaleImage", (Object)style.getOwnScaleImage(), JRMxmlConstants.getScaleImageMap());
        this.xmlWriter.addAttribute("hAlign", (Object)style.getOwnHorizontalAlignment(), JRMxmlConstants.getHorizontalAlignMap());
        this.xmlWriter.addAttribute("vAlign", (Object)style.getOwnVerticalAlignment(), JRMxmlConstants.getVerticalAlignMap());
        this.xmlWriter.addAttribute("Rotation", (Object)style.getOwnRotation(), JRMxmlConstants.getRotationMap());
        this.xmlWriter.addAttribute("lineSpacing", (Object)style.getOwnLineSpacing(), JRMxmlConstants.getLineSpacingMap());
        this.xmlWriter.addAttribute("markup", style.getOwnMarkup());
        this.xmlWriter.addEncodedAttribute("fontName", this.ownFontName(style));
        this.xmlWriter.addAttribute("fontSize", (Object)style.getOwnFontSize());
        this.xmlWriter.addAttribute("isBold", (Object)style.isOwnBold());
        this.xmlWriter.addAttribute("isItalic", (Object)style.isOwnItalic());
        this.xmlWriter.addAttribute("isUnderline", (Object)style.isOwnUnderline());
        this.xmlWriter.addAttribute("isStrikeThrough", (Object)style.isOwnStrikeThrough());
        this.exportBox(style.getLineBox());
        this.xmlWriter.closeElement();
    }

    protected void exportPage(JRPrintPage page) throws JRException, IOException {
        this.xmlWriter.startElement("jr:Page");
        this.xmlWriter.addAttribute("width", this.jasperPrint.getPageWidth());
        this.xmlWriter.addAttribute("height", this.jasperPrint.getPageHeight());
        List elements = page.getElements();
        this.exportElements(elements);
        this.xmlWriter.closeElement();
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected void exportElements(Collection elements) throws IOException, JRException {
        if (elements != null && elements.size() > 0) {
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                JRPrintElement element = (JRPrintElement)it.next();
                if (this.filter != null && !this.filter.isToExport(element)) continue;
                if (element instanceof JRPrintLine) {
                    this.exportLine((JRPrintLine)element);
                    continue;
                }
                if (element instanceof JRPrintRectangle) {
                    this.exportRectangle((JRPrintRectangle)element);
                    continue;
                }
                if (element instanceof JRPrintEllipse) {
                    this.exportEllipse((JRPrintEllipse)element);
                    continue;
                }
                if (element instanceof JRPrintImage) {
                    this.exportImage((JRPrintImage)element);
                    continue;
                }
                if (element instanceof JRPrintText) {
                    this.exportText((JRPrintText)element);
                    continue;
                }
                if (!(element instanceof JRPrintFrame)) continue;
                this.exportFrame((JRPrintFrame)element);
            }
        }
    }

    protected void exportLine(JRPrintLine line) throws IOException {
        this.xmlWriter.startElement("jr:Line");
        this.xmlWriter.addAttribute("direction", line.getDirection(), JRMxmlConstants.getDirectionMap(), (byte)1);
        this.exportReportElement((JRPrintElement)line);
        this.exportGraphicElement((JRPrintGraphicElement)line);
        this.xmlWriter.closeElement();
    }

    protected void exportReportElement(JRPrintElement element) throws IOException {
        this.xmlWriter.addEncodedAttribute("key", element.getKey());
        JRStyle style = element.getStyle();
        if (style != null) {
            this.xmlWriter.addEncodedAttribute("style", style.getName());
        }
        this.xmlWriter.addAttribute("mode", (Object)element.getOwnMode(), JRMxmlConstants.getModeMap());
        this.xmlWriter.addAttribute("x", element.getX() + this.getOffsetX());
        this.xmlWriter.addAttribute("y", element.getY() + this.getOffsetY());
        this.xmlWriter.addAttribute("width", element.getWidth());
        this.xmlWriter.addAttribute("height", element.getHeight());
        this.xmlWriter.addAttribute("forecolor", element.getOwnForecolor());
        this.xmlWriter.addAttribute("backcolor", element.getOwnBackcolor());
    }

    protected void exportGraphicElement(JRPrintGraphicElement element) throws IOException {
        this.xmlWriter.addAttribute("fill", (Object)element.getOwnFill(), JRMxmlConstants.getFillMap());
        this.exportPen(element.getLinePen());
    }

    protected void exportPen(JRPen pen) throws IOException {
        if (pen != null) {
            this.xmlWriter.addAttribute("penWidth", (Object)pen.getOwnLineWidth());
            this.xmlWriter.addAttribute("penStyle", (Object)pen.getOwnLineStyle(), JRMxmlConstants.getLineStyleMap());
            this.xmlWriter.addAttribute("penColor", pen.getOwnLineColor());
        }
    }

    protected void exportBoxPen(String side, JRPen pen) throws IOException {
        if (pen != null) {
            this.xmlWriter.addAttribute("box" + side + "PenWidth", (Object)pen.getOwnLineWidth());
            this.xmlWriter.addAttribute("box" + side + "PenStyle", (Object)pen.getOwnLineStyle(), JRMxmlConstants.getLineStyleMap());
            this.xmlWriter.addAttribute("box" + side + "PenColor", pen.getOwnLineColor());
        }
    }

    protected void exportRectangle(JRPrintRectangle rectangle) throws IOException {
        this.xmlWriter.startElement("jr:Rectangle");
        this.xmlWriter.addAttribute("radius", (Object)rectangle.getOwnRadius());
        this.exportReportElement((JRPrintElement)rectangle);
        this.exportGraphicElement((JRPrintGraphicElement)rectangle);
        this.xmlWriter.closeElement();
    }

    protected void exportEllipse(JRPrintEllipse ellipse) throws IOException {
        this.xmlWriter.startElement("jr:Ellipse");
        this.exportReportElement((JRPrintElement)ellipse);
        this.exportGraphicElement((JRPrintGraphicElement)ellipse);
        this.xmlWriter.closeElement();
    }

    protected void exportImage(JRPrintImage image) throws JRException, IOException {
        this.xmlWriter.startElement("jr:Image");
        this.xmlWriter.addAttribute("scaleImage", (Object)image.getOwnScaleImage(), JRMxmlConstants.getScaleImageMap());
        this.xmlWriter.addAttribute("hAlign", (Object)image.getOwnHorizontalAlignment(), JRMxmlConstants.getHorizontalAlignMap());
        this.xmlWriter.addAttribute("vAlign", (Object)image.getOwnVerticalAlignment(), JRMxmlConstants.getVerticalAlignMap());
        this.xmlWriter.addAttribute("isLazy", image.isLazy(), false);
        this.xmlWriter.addAttribute("onErrorType", image.getOnErrorType(), JRMxmlConstants.getOnErrorTypeMap(), (byte)1);
        this.xmlWriter.addEncodedAttribute("hyperlinkType", image.getLinkType());
        this.xmlWriter.addAttribute("hyperlinkTarget", image.getHyperlinkTarget(), JRMxmlConstants.getHyperlinkTargetMap(), (byte)1);
        this.xmlWriter.addEncodedAttribute("anchorName", image.getAnchorName());
        this.xmlWriter.addEncodedAttribute("hyperlinkReference", image.getHyperlinkReference());
        this.xmlWriter.addEncodedAttribute("hyperlinkAnchor", image.getHyperlinkAnchor());
        this.xmlWriter.addAttribute("hyperlinkPage", (Object)image.getHyperlinkPage());
        this.xmlWriter.addEncodedAttribute("hyperlinkTooltip", image.getHyperlinkTooltip());
        this.xmlWriter.addAttribute("bookmarkLevel", image.getBookmarkLevel(), 0);
        this.exportReportElement((JRPrintElement)image);
        this.exportBox(image.getLineBox());
        this.exportGraphicElement((JRPrintGraphicElement)image);
        JRRenderable renderer = image.getRenderer();
        if (renderer != null) {
            this.xmlWriter.startElement("jr:ImageSource");
            this.xmlWriter.addAttribute("isEmbedded", this.isEmbeddingImages && !image.isLazy(), false);
            String imageSource = "";
            if (renderer.getType() == 1) {
                renderer = new JRWrappingSvgRenderer(renderer, (Dimension2D)new Dimension(image.getWidth(), image.getHeight()), 1 == image.getMode() ? image.getBackcolor() : null);
            }
            if (this.isEmbeddingImages && !image.isLazy()) {
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(renderer.getImageData());
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    Base64Encoder encoder = new Base64Encoder((InputStream)bais, (OutputStream)baos);
                    encoder.process();
                    imageSource = new String(baos.toByteArray(), DEFAULT_XML_ENCODING);
                }
                catch (IOException e) {
                    throw new JRException("Error embedding image into XML.", (Throwable)e);
                }
            } else if (renderer.getType() == 0 && this.rendererToImagePathMap.containsKey(renderer)) {
                imageSource = (String)this.rendererToImagePathMap.get(renderer);
            } else {
                if (image.isLazy()) {
                    imageSource = ((JRImageRenderer)renderer).getImageLocation();
                } else {
                    imageSource = IMAGE_PREFIX + JRMxmlExporter.getNextImageId();
                    this.imageNameToImageDataMap.put(imageSource, renderer.getImageData());
                    imageSource = new File(this.imagesDir.getName(), imageSource).getPath();
                }
                this.rendererToImagePathMap.put(renderer, imageSource);
            }
            this.xmlWriter.writeCDATA(imageSource);
            this.xmlWriter.closeElement();
        }
        this.exportHyperlinkParameters((JRPrintHyperlink)image);
        this.xmlWriter.closeElement();
    }

    protected void exportText(JRPrintText text) throws IOException {
        this.xmlWriter.startElement("jr:Text");
        this.xmlWriter.addAttribute("textAlignment", (Object)text.getOwnHorizontalAlignment(), JRMxmlConstants.getHorizontalAlignMap());
        this.xmlWriter.addAttribute("verticalAlignment", (Object)text.getOwnVerticalAlignment(), JRMxmlConstants.getVerticalAlignMap());
        this.xmlWriter.addAttribute("textHeight", text.getTextHeight());
        this.xmlWriter.addAttribute("Rotation", (Object)text.getOwnRotation(), JRMxmlConstants.getRotationMap());
        this.xmlWriter.addAttribute("runDirection", text.getRunDirection(), JRMxmlConstants.getRunDirectionMap(), (byte)0);
        this.xmlWriter.addAttribute("lineSpacing", (Object)text.getOwnLineSpacing(), JRMxmlConstants.getLineSpacingMap());
        this.xmlWriter.addAttribute("markup", text.getOwnMarkup());
        this.xmlWriter.addAttribute("lineSpacingFactor", text.getLineSpacingFactor());
        this.xmlWriter.addAttribute("leadingOffset", text.getLeadingOffset());
        this.xmlWriter.addEncodedAttribute("hyperlinkType", text.getLinkType());
        this.xmlWriter.addAttribute("hyperlinkTarget", text.getHyperlinkTarget(), JRMxmlConstants.getHyperlinkTargetMap(), (byte)1);
        this.xmlWriter.addEncodedAttribute("anchorName", text.getAnchorName());
        this.xmlWriter.addEncodedAttribute("hyperlinkReference", text.getHyperlinkReference());
        this.xmlWriter.addEncodedAttribute("hyperlinkAnchor", text.getHyperlinkAnchor());
        this.xmlWriter.addAttribute("hyperlinkPage", (Object)text.getHyperlinkPage());
        this.xmlWriter.addEncodedAttribute("hyperlinkTooltip", text.getHyperlinkTooltip());
        this.xmlWriter.addAttribute("bookmarkLevel", text.getBookmarkLevel(), 0);
        this.xmlWriter.addAttribute("valueClass", text.getValueClassName());
        this.xmlWriter.addEncodedAttribute("pattern", text.getPattern());
        this.xmlWriter.addAttribute("formatFactoryClass", text.getFormatFactoryClass());
        this.xmlWriter.addEncodedAttribute("locale", text.getLocaleCode());
        this.xmlWriter.addEncodedAttribute("timezone", text.getTimeZoneId());
        this.exportReportElement((JRPrintElement)text);
        this.exportBox(text.getLineBox());
        this.exportFont((JRFont)text);
        if (text.getText() != null) {
            this.xmlWriter.writeCDATAElement("jr:textContent", text.getText());
            if (this.isEmbeddingFonts) {
                this.embedCharacters(text);
            }
        }
        this.exportHyperlinkParameters((JRPrintHyperlink)text);
        this.xmlWriter.closeElement();
    }

    private void embedCharacters(JRPrintText text) {
        String fontFamily = this.ownFontName((JRFont)text);
        HashSet<Character> charSet = (HashSet<Character>)this.embeddedCharacterMap.get(fontFamily);
        if (charSet == null) {
            charSet = new HashSet<Character>();
            this.embeddedCharacterMap.put(fontFamily, charSet);
        }
        String content = text.getText();
        for (int i = 0; i < content.length(); ++i) {
            charSet.add(new Character(content.charAt(i)));
        }
    }

    private void exportBox(JRLineBox box) throws IOException {
        if (box != null) {
            this.xmlWriter.addAttribute("boxPadding", (Object)box.getOwnPadding());
            this.xmlWriter.addAttribute("boxTopPadding", (Object)box.getOwnTopPadding());
            this.xmlWriter.addAttribute("boxLeftPadding", (Object)box.getOwnLeftPadding());
            this.xmlWriter.addAttribute("boxBottomPadding", (Object)box.getOwnBottomPadding());
            this.xmlWriter.addAttribute("boxRightPadding", (Object)box.getOwnRightPadding());
            this.exportBoxPen("", (JRPen)box.getPen());
            this.exportBoxPen("Top", (JRPen)box.getTopPen());
            this.exportBoxPen("Left", (JRPen)box.getLeftPen());
            this.exportBoxPen("Bottom", (JRPen)box.getBottomPen());
            this.exportBoxPen("Right", (JRPen)box.getRightPen());
        }
    }

    private String ownFontName(JRStyle style) {
        if (this.isEmbeddingFonts && JRMxmlExporter.fontExists(style.getFontName())) {
            boolean bold = style.isBold() != null && style.isBold() != false;
            boolean italic = style.isItalic() != null && style.isItalic() != false;
            String fontName = "jr_" + style.getFontName().replace(' ', '_') + (bold ? "_Bold" : "") + (italic ? "_Italic" : "");
            this.embeddedFontMap.put(new FontKey(style.getFontName(), bold, italic), fontName);
            return fontName;
        }
        return style.getOwnFontName();
    }

    private String ownFontName(JRFont font) {
        if (this.isEmbeddingFonts && JRMxmlExporter.fontExists(font.getFontName())) {
            boolean bold = font.isBold();
            boolean italic = font.isItalic();
            String fontName = "jr_" + font.getFontName().replace(' ', '_') + (bold ? "_Bold" : "") + (italic ? "_Italic" : "");
            this.embeddedFontMap.put(new FontKey(font.getFontName(), bold, italic), fontName);
            return fontName;
        }
        return font.getOwnFontName();
    }

    protected void exportFont(JRFont font) throws IOException {
        if (font != null) {
            this.xmlWriter.startElement("jr:Font");
            if (font.getReportFont() != null) {
                JRFont baseFont = (JRFont)this.fontsMap.get(font.getReportFont().getName());
                if (baseFont != null) {
                    this.xmlWriter.addEncodedAttribute("reportFont", font.getReportFont().getName());
                } else {
                    throw new JRRuntimeException("Referenced report font not found : " + font.getReportFont().getName());
                }
            }
            this.xmlWriter.addEncodedAttribute("fontName", this.ownFontName(font));
            this.xmlWriter.addAttribute("size", (Object)font.getOwnFontSize());
            this.xmlWriter.addAttribute("isBold", (Object)font.isOwnBold());
            this.xmlWriter.addAttribute("isItalic", (Object)font.isOwnItalic());
            this.xmlWriter.addAttribute("isUnderline", (Object)font.isOwnUnderline());
            this.xmlWriter.addAttribute("isStrikeThrough", (Object)font.isOwnStrikeThrough());
            this.xmlWriter.closeElement(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportFrame(JRPrintFrame frame) throws IOException, JRException {
        this.xmlWriter.startElement("jr:Frame");
        this.setFrameElementsOffset(frame, true);
        try {
            this.exportReportElement((JRPrintElement)frame);
            this.exportBox(frame.getLineBox());
            this.exportElements(frame.getElements());
            this.xmlWriter.closeElement();
        }
        finally {
            this.restoreElementOffsets();
        }
    }

    private static synchronized int getNextImageId() {
        return imageId++;
    }

    protected void exportHyperlinkParameters(JRPrintHyperlink hyperlink) throws IOException {
        JRPrintHyperlinkParameters hyperlinkParameters = hyperlink.getHyperlinkParameters();
        if (hyperlinkParameters != null) {
            this.xmlWriter.startElement("jr:hyperlinkParameters");
            Iterator it = hyperlinkParameters.getParameters().iterator();
            while (it.hasNext()) {
                JRPrintHyperlinkParameter parameter = (JRPrintHyperlinkParameter)it.next();
                this.exportHyperlinkParameter(parameter);
            }
            this.xmlWriter.closeElement();
        }
    }

    protected void exportHyperlinkParameter(JRPrintHyperlinkParameter parameter) throws IOException {
        this.xmlWriter.startElement("jr:HyperlinkParameter");
        this.xmlWriter.addEncodedAttribute("name", parameter.getName());
        this.xmlWriter.addAttribute("Class", parameter.getValueClass(), DEFAULT_OBJECT_TYPE);
        if (parameter.getValue() != null) {
            String data = JRValueStringUtils.serialize((String)parameter.getValueClass(), (Object)parameter.getValue());
            this.xmlWriter.writeCDATA(data);
        }
        this.xmlWriter.closeElement();
    }

    private static boolean fontExists(String fontName) {
        if (allFontNames == null) {
            allFontNames = new HashSet();
            Font[] allFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
            for (int i = 0; i < allFonts.length; ++i) {
                allFontNames.add(allFonts[i].getFamily().toLowerCase());
            }
        }
        return allFontNames.contains(fontName.toLowerCase());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

