/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.awt.Image;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillGraphicElement;
import net.sf.jasperreports.engine.fill.JRFillHyperlinkHelper;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRRecordedValuesPrintImage;
import net.sf.jasperreports.engine.fill.JRTemplateImage;
import net.sf.jasperreports.engine.fill.JRTemplatePrintImage;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.LineBoxWrapper;

public class JRFillImage
extends JRFillGraphicElement
implements JRImage {
    private JRGroup evaluationGroup = null;
    private JRRenderable renderer = null;
    private String anchorName = null;
    private String hyperlinkReference = null;
    private String hyperlinkAnchor = null;
    private Integer hyperlinkPage = null;
    private String hyperlinkTooltip;
    private JRPrintHyperlinkParameters hyperlinkParameters;

    protected JRFillImage(JRBaseFiller filler, JRImage image, JRFillObjectFactory factory) {
        super(filler, image, factory);
        this.evaluationGroup = factory.getGroup(image.getEvaluationGroup());
    }

    protected JRFillImage(JRFillImage image, JRFillCloneFactory factory) {
        super(image, factory);
        this.evaluationGroup = image.evaluationGroup;
    }

    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    public byte getScaleImage() {
        return JRStyleResolver.getScaleImage(this);
    }

    public Byte getOwnScaleImage() {
        return ((JRImage)this.parent).getOwnScaleImage();
    }

    public void setScaleImage(byte scaleImage) {
    }

    public void setScaleImage(Byte scaleImage) {
    }

    public byte getHorizontalAlignment() {
        return JRStyleResolver.getHorizontalAlignment(this);
    }

    public Byte getOwnHorizontalAlignment() {
        return ((JRImage)this.parent).getOwnHorizontalAlignment();
    }

    public void setHorizontalAlignment(byte horizontalAlignment) {
    }

    public void setHorizontalAlignment(Byte horizontalAlignment) {
    }

    public byte getVerticalAlignment() {
        return JRStyleResolver.getVerticalAlignment(this);
    }

    public Byte getOwnVerticalAlignment() {
        return ((JRImage)this.parent).getOwnVerticalAlignment();
    }

    public void setVerticalAlignment(byte verticalAlignment) {
    }

    public void setVerticalAlignment(Byte verticalAlignment) {
    }

    public boolean isUsingCache() {
        return ((JRImage)this.parent).isUsingCache();
    }

    public Boolean isOwnUsingCache() {
        return ((JRImage)this.parent).isOwnUsingCache();
    }

    public void setUsingCache(boolean isUsingCache) {
    }

    public void setUsingCache(Boolean isUsingCache) {
    }

    public boolean isLazy() {
        return ((JRImage)this.parent).isLazy();
    }

    public void setLazy(boolean isLazy) {
    }

    public byte getOnErrorType() {
        return ((JRImage)this.parent).getOnErrorType();
    }

    public void setOnErrorType(byte onErrorType) {
    }

    public byte getEvaluationTime() {
        return ((JRImage)this.parent).getEvaluationTime();
    }

    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public JRBox getBox() {
        return new LineBoxWrapper(this.getLineBox());
    }

    public JRLineBox getLineBox() {
        return ((JRImage)this.parent).getLineBox();
    }

    public byte getBorder() {
        return this.getBox().getBorder();
    }

    public Byte getOwnBorder() {
        return this.getBox().getOwnBorder();
    }

    public void setBorder(byte border) {
        this.getBox().setBorder(border);
    }

    public void setBorder(Byte border) {
        this.getBox().setBorder(border);
    }

    public Color getBorderColor() {
        return this.getBox().getBorderColor();
    }

    public Color getOwnBorderColor() {
        return this.getBox().getOwnBorderColor();
    }

    public void setBorderColor(Color borderColor) {
        this.getBox().setBorderColor(borderColor);
    }

    public int getPadding() {
        return this.getBox().getPadding();
    }

    public Integer getOwnPadding() {
        return this.getBox().getOwnPadding();
    }

    public void setPadding(int padding) {
        this.getBox().setPadding(padding);
    }

    public void setPadding(Integer padding) {
        this.getBox().setPadding(padding);
    }

    public byte getTopBorder() {
        return this.getBox().getTopBorder();
    }

    public Byte getOwnTopBorder() {
        return this.getBox().getOwnTopBorder();
    }

    public void setTopBorder(byte topBorder) {
        this.getBox().setTopBorder(topBorder);
    }

    public void setTopBorder(Byte topBorder) {
        this.getBox().setTopBorder(topBorder);
    }

    public Color getTopBorderColor() {
        return this.getBox().getTopBorderColor();
    }

    public Color getOwnTopBorderColor() {
        return this.getBox().getOwnTopBorderColor();
    }

    public void setTopBorderColor(Color topBorderColor) {
        this.getBox().setTopBorderColor(topBorderColor);
    }

    public int getTopPadding() {
        return this.getBox().getTopPadding();
    }

    public Integer getOwnTopPadding() {
        return this.getBox().getOwnTopPadding();
    }

    public void setTopPadding(int topPadding) {
        this.getBox().setTopPadding(topPadding);
    }

    public void setTopPadding(Integer topPadding) {
        this.getBox().setTopPadding(topPadding);
    }

    public byte getLeftBorder() {
        return this.getBox().getLeftBorder();
    }

    public Byte getOwnLeftBorder() {
        return this.getBox().getOwnLeftBorder();
    }

    public void setLeftBorder(byte leftBorder) {
        this.getBox().setLeftBorder(leftBorder);
    }

    public void setLeftBorder(Byte leftBorder) {
        this.getBox().setLeftBorder(leftBorder);
    }

    public Color getLeftBorderColor() {
        return this.getBox().getLeftBorderColor();
    }

    public Color getOwnLeftBorderColor() {
        return this.getBox().getOwnLeftBorderColor();
    }

    public void setLeftBorderColor(Color leftBorderColor) {
        this.getBox().setLeftBorderColor(leftBorderColor);
    }

    public int getLeftPadding() {
        return this.getBox().getLeftPadding();
    }

    public Integer getOwnLeftPadding() {
        return this.getBox().getOwnLeftPadding();
    }

    public void setLeftPadding(int leftPadding) {
        this.getBox().setLeftPadding(leftPadding);
    }

    public void setLeftPadding(Integer leftPadding) {
        this.getBox().setLeftPadding(leftPadding);
    }

    public byte getBottomBorder() {
        return this.getBox().getBottomBorder();
    }

    public Byte getOwnBottomBorder() {
        return this.getBox().getOwnBottomBorder();
    }

    public void setBottomBorder(byte bottomBorder) {
        this.getBox().setBottomBorder(bottomBorder);
    }

    public void setBottomBorder(Byte bottomBorder) {
        this.getBox().setBottomBorder(bottomBorder);
    }

    public Color getBottomBorderColor() {
        return this.getBox().getBottomBorderColor();
    }

    public Color getOwnBottomBorderColor() {
        return this.getBox().getOwnBottomBorderColor();
    }

    public void setBottomBorderColor(Color bottomBorderColor) {
        this.getBox().setBottomBorderColor(bottomBorderColor);
    }

    public int getBottomPadding() {
        return this.getBox().getBottomPadding();
    }

    public Integer getOwnBottomPadding() {
        return this.getBox().getOwnBottomPadding();
    }

    public void setBottomPadding(int bottomPadding) {
        this.getBox().setBottomPadding(bottomPadding);
    }

    public void setBottomPadding(Integer bottomPadding) {
        this.getBox().setBottomPadding(bottomPadding);
    }

    public byte getRightBorder() {
        return this.getBox().getRightBorder();
    }

    public Byte getOwnRightBorder() {
        return this.getBox().getOwnRightBorder();
    }

    public void setRightBorder(byte rightBorder) {
        this.getBox().setRightBorder(rightBorder);
    }

    public void setRightBorder(Byte rightBorder) {
        this.getBox().setRightBorder(rightBorder);
    }

    public Color getRightBorderColor() {
        return this.getBox().getRightBorderColor();
    }

    public Color getOwnRightBorderColor() {
        return this.getBox().getOwnRightBorderColor();
    }

    public void setRightBorderColor(Color rightBorderColor) {
        this.getBox().setRightBorderColor(rightBorderColor);
    }

    public int getRightPadding() {
        return this.getBox().getRightPadding();
    }

    public Integer getOwnRightPadding() {
        return this.getBox().getOwnRightPadding();
    }

    public void setRightPadding(int rightPadding) {
        this.getBox().setRightPadding(rightPadding);
    }

    public void setRightPadding(Integer rightPadding) {
        this.getBox().setRightPadding(rightPadding);
    }

    public byte getHyperlinkType() {
        return ((JRImage)this.parent).getHyperlinkType();
    }

    public byte getHyperlinkTarget() {
        return ((JRImage)this.parent).getHyperlinkTarget();
    }

    public JRExpression getExpression() {
        return ((JRImage)this.parent).getExpression();
    }

    public JRExpression getAnchorNameExpression() {
        return ((JRImage)this.parent).getAnchorNameExpression();
    }

    public JRExpression getHyperlinkReferenceExpression() {
        return ((JRImage)this.parent).getHyperlinkReferenceExpression();
    }

    public JRExpression getHyperlinkAnchorExpression() {
        return ((JRImage)this.parent).getHyperlinkAnchorExpression();
    }

    public JRExpression getHyperlinkPageExpression() {
        return ((JRImage)this.parent).getHyperlinkPageExpression();
    }

    protected JRRenderable getRenderer() {
        return this.renderer;
    }

    protected String getAnchorName() {
        return this.anchorName;
    }

    protected String getHyperlinkReference() {
        return this.hyperlinkReference;
    }

    protected String getHyperlinkAnchor() {
        return this.hyperlinkAnchor;
    }

    protected Integer getHyperlinkPage() {
        return this.hyperlinkPage;
    }

    protected String getHyperlinkTooltip() {
        return this.hyperlinkTooltip;
    }

    protected JRTemplateImage getJRTemplateImage() {
        JRStyle style = this.getStyle();
        JRTemplateImage template = (JRTemplateImage)this.getTemplate(style);
        if (template == null) {
            template = new JRTemplateImage(this.band == null ? null : this.band.getOrigin(), this.filler.getJasperPrint().getDefaultStyleProvider(), this);
            this.transferProperties(template);
            this.registerTemplate(style, template);
        }
        return template;
    }

    protected void evaluate(byte evaluation) throws JRException {
        this.initDelayedEvaluations();
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        if ((this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) && this.isEvaluateNow()) {
            this.evaluateImage(evaluation);
        }
    }

    protected void evaluateImage(byte evaluation) throws JRException {
        this.evaluateProperties(evaluation);
        JRExpression expression = this.getExpression();
        JRRenderable newRenderer = null;
        Object source = this.evaluateExpression(expression, evaluation);
        if (source != null) {
            if (this.isUsingCache() && this.filler.fillContext.hasLoadedImage(source)) {
                newRenderer = this.filler.fillContext.getLoadedImage(source).getRenderer();
            } else {
                Object img;
                Class expressionClass = expression.getValueClass();
                if (Image.class.getName().equals(expressionClass.getName())) {
                    img = (Image)source;
                    newRenderer = JRImageRenderer.getInstance((Image)img, this.getOnErrorType());
                } else if (InputStream.class.getName().equals(expressionClass.getName())) {
                    InputStream is = (InputStream)source;
                    newRenderer = JRImageRenderer.getInstance(is, this.getOnErrorType());
                } else if (URL.class.getName().equals(expressionClass.getName())) {
                    URL url = (URL)source;
                    newRenderer = JRImageRenderer.getInstance(url, this.getOnErrorType());
                } else if (File.class.getName().equals(expressionClass.getName())) {
                    File file = (File)source;
                    newRenderer = JRImageRenderer.getInstance(file, this.getOnErrorType());
                } else if (String.class.getName().equals(expressionClass.getName())) {
                    String location = (String)source;
                    newRenderer = JRImageRenderer.getInstance(location, this.getOnErrorType(), this.isLazy(), this.filler.reportClassLoader, this.filler.urlHandlerFactory, this.filler.fileResolver);
                } else if (JRRenderable.class.getName().equals(expressionClass.getName())) {
                    newRenderer = (JRRenderable)source;
                }
                if (this.isUsingCache()) {
                    img = new JRTemplatePrintImage(this.getJRTemplateImage());
                    img.setRenderer(newRenderer);
                    this.filler.fillContext.registerLoadedImage(source, (JRPrintImage)img);
                }
            }
        }
        this.setValueRepeating(this.renderer == newRenderer);
        this.renderer = newRenderer;
        this.anchorName = (String)this.evaluateExpression(this.getAnchorNameExpression(), evaluation);
        this.hyperlinkReference = (String)this.evaluateExpression(this.getHyperlinkReferenceExpression(), evaluation);
        this.hyperlinkAnchor = (String)this.evaluateExpression(this.getHyperlinkAnchorExpression(), evaluation);
        this.hyperlinkPage = (Integer)this.evaluateExpression(this.getHyperlinkPageExpression(), evaluation);
        this.hyperlinkTooltip = (String)this.evaluateExpression(this.getHyperlinkTooltipExpression(), evaluation);
        this.hyperlinkParameters = JRFillHyperlinkHelper.evaluateHyperlinkParameters(this, this.expressionEvaluator, evaluation);
    }

    protected boolean prepare(int availableStretchHeight, boolean isOverflow) {
        boolean willOverflow = false;
        if (this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) {
            this.setToPrint(true);
        } else {
            this.setToPrint(false);
        }
        if (!this.isToPrint()) {
            return willOverflow;
        }
        boolean isToPrint = true;
        boolean isReprinted = false;
        if (this.isEvaluateNow()) {
            if (isOverflow && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
                isToPrint = false;
            }
            if (!(!isToPrint || !this.isPrintWhenExpressionNull() || this.isPrintRepeatedValues() || !this.isValueRepeating() || this.isPrintInFirstWholeBand() && this.getBand().isFirstWholeOnPageColumn() || this.getPrintWhenGroupChanges() != null && this.getBand().isNewGroup(this.getPrintWhenGroupChanges()) || isOverflow && this.isPrintWhenDetailOverflows())) {
                isToPrint = false;
            }
            if (isToPrint && availableStretchHeight < this.getRelativeY() - this.getY() - this.getBandBottomY()) {
                isToPrint = false;
                willOverflow = true;
            }
            if (isToPrint && isOverflow && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues())) {
                isReprinted = true;
            }
            if (isToPrint && this.isRemoveLineWhenBlank() && this.getRenderer() == null) {
                isToPrint = false;
            }
        } else {
            if (isOverflow && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
                isToPrint = false;
            }
            if (isToPrint && availableStretchHeight < this.getRelativeY() - this.getY() - this.getBandBottomY()) {
                isToPrint = false;
                willOverflow = true;
            }
            if (isToPrint && isOverflow && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues())) {
                isReprinted = true;
            }
        }
        this.setToPrint(isToPrint);
        this.setReprinted(isReprinted);
        return willOverflow;
    }

    protected JRPrintElement fill() throws JRException {
        JRTemplatePrintImage printImage;
        JRRecordedValuesPrintImage recordedValuesImage;
        byte evaluationType = this.getEvaluationTime();
        if (this.isEvaluateAuto()) {
            recordedValuesImage = new JRRecordedValuesPrintImage(this.getJRTemplateImage());
            printImage = recordedValuesImage;
        } else {
            printImage = new JRTemplatePrintImage(this.getJRTemplateImage());
            recordedValuesImage = null;
        }
        printImage.setX(this.getX());
        printImage.setY(this.getRelativeY());
        printImage.setWidth(this.getWidth());
        printImage.setHeight(this.getStretchHeight());
        if (this.isEvaluateNow()) {
            this.copy(printImage);
        } else if (this.isEvaluateAuto()) {
            this.initDelayedEvaluationPrint(recordedValuesImage);
        } else {
            this.filler.addBoundElement(this, printImage, evaluationType, this.getEvaluationGroup(), this.band);
        }
        return printImage;
    }

    protected void copy(JRPrintImage printImage) {
        printImage.setRenderer(this.getRenderer());
        printImage.setAnchorName(this.getAnchorName());
        printImage.setHyperlinkReference(this.getHyperlinkReference());
        printImage.setHyperlinkAnchor(this.getHyperlinkAnchor());
        printImage.setHyperlinkPage(this.getHyperlinkPage());
        printImage.setHyperlinkTooltip(this.getHyperlinkTooltip());
        printImage.setBookmarkLevel(this.getBookmarkLevel());
        printImage.setHyperlinkParameters(this.hyperlinkParameters);
        this.transferProperties(printImage);
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public void visit(JRVisitor visitor) {
        visitor.visitImage(this);
    }

    protected void resolveElement(JRPrintElement element, byte evaluation) throws JRException {
        this.evaluateImage(evaluation);
        this.copy((JRPrintImage)element);
    }

    public int getBookmarkLevel() {
        return ((JRImage)this.parent).getBookmarkLevel();
    }

    public JRFillCloneable createClone(JRFillCloneFactory factory) {
        return new JRFillImage(this, factory);
    }

    protected void collectDelayedEvaluations() {
        this.collectDelayedEvaluations(this.getExpression());
        this.collectDelayedEvaluations(this.getAnchorNameExpression());
        this.collectDelayedEvaluations(this.getHyperlinkReferenceExpression());
        this.collectDelayedEvaluations(this.getHyperlinkAnchorExpression());
        this.collectDelayedEvaluations(this.getHyperlinkPageExpression());
    }

    public JRHyperlinkParameter[] getHyperlinkParameters() {
        return ((JRImage)this.parent).getHyperlinkParameters();
    }

    public String getLinkType() {
        return ((JRImage)this.parent).getLinkType();
    }

    public JRExpression getHyperlinkTooltipExpression() {
        return ((JRImage)this.parent).getHyperlinkTooltipExpression();
    }
}

