/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import nickyb.sqleonardo.common.util.Appearance;
import nickyb.sqleonardo.common.util.I18n;
import nickyb.sqleonardo.common.util.Resources;
import nickyb.sqleonardo.common.util.Store;
import nickyb.sqleonardo.common.util.Text;
import nickyb.sqleonardo.environment.Preferences;
import nickyb.sqleonardo.environment._Constants;
import nickyb.sqleonardo.environment._Version;
import nickyb.sqleonardo.environment.mdi.MDIWindow;

public class Application
extends Appearance
implements _Constants,
_Version {
    public static final ClipboardOwner defaultClipboardOwner = new ClipboardOwner(){

        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    };
    public static MDIWindow window = null;
    public static final Store session = new Store();
    public static final Resources resources = new Resources();

    private static void loadIcons() {
        resources.loadIcon("icon.001", "/images/connect.png");
        resources.loadIcon("icon.002", "/images/disconnect.png");
        resources.loadIcon("icon.010", "/images/disk.png");
        resources.loadIcon("icon.011", "/images/stop.png");
        resources.loadIcon("icon.053", "/images/table_error.png");
        resources.loadIcon("icon.051", "/images/database_lightning.png");
        resources.loadIcon("icon.052", "/images/page_edit.png");
        resources.loadIcon("icon.050", "/images/wrench.png");
        resources.loadIcon("icon.100", "/images/database_gear.png");
        resources.loadIcon("icon.101", "/images/database_connect.png");
        resources.loadIcon("icon.102", "/images/database.png");
        resources.loadIcon("icon.103", "/images/folder_database.png");
        resources.loadIcon("icon.104", "/images/folder_table.png");
        resources.loadIcon("icon.105", "/images/table_multiple.png");
        resources.loadIcon("icon.106", "/images/table_link.png");
        resources.loadIcon("icon.107", "/images/cart_add.png");
        resources.loadIcon("icon.108", "/images/cart_delete.png");
        resources.loadIcon("icon.110", "/images/folder_page.png");
        resources.loadIcon("icon.111", "/images/page_save.png");
        resources.loadIcon("icon.112", "/images/page_gear.png");
        resources.loadIcon("icon.162", "/images/database_save.png");
        resources.loadIcon("icon.161", "/images/table_row_delete.png");
        resources.loadIcon("icon.160", "/images/table_row_insert.png");
        resources.loadIcon("icon.151", "/images/table_gear.png");
    }

    private static void loadSession() {
        try {
            if (new File(Application.sessionFilename()).exists()) {
                session.load(Application.sessionFilename());
                if (session.canMount("$INFO")) {
                    session.mount("$INFO");
                    Application.println("\tversion: " + session.jump("version").get(0));
                }
            }
            Preferences.loadDefaults();
        }
        catch (Exception e) {
            Application.println(e, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        window.dispose();
        try {
            session.mount("$INFO");
            session.home();
            session.jump("version");
            if (session.jump().size() == 0) {
                session.jump().add(Application.getVersion());
            } else {
                session.jump().set(0, Application.getVersion());
            }
            session.save(Application.sessionFilename());
        }
        catch (IOException e) {
            Application.println(e, false);
        }
        finally {
            System.exit(0);
        }
    }

    private static String sessionFilename() {
        return System.getProperty("user.home") + File.separator + ".sqleonardo";
    }

    public static String getVersion() {
        return "2007.02";
    }

    public static String getVersion2() {
        return "SQLeonardo." + Application.getVersion();
    }

    public static String getVersion3() {
        return Application.getVersion2() + " [ " + "http://sqleonardo.altervista.org" + " ]";
    }

    public static void alert(String title, String message) {
        JOptionPane.showMessageDialog(window, message, title, 2);
    }

    public static boolean confirm(String title, String message) {
        return JOptionPane.showConfirmDialog(window, message, title, 0) == 0;
    }

    public static String input(String title, String message) {
        return JOptionPane.showInputDialog(window, message, title, -1);
    }

    public static void println(Exception e, boolean alert) {
        if (alert) {
            Application.alert(e.getClass().getName(), Text.wrap(e.toString(), 100));
        } else {
            System.out.println(e);
        }
    }

    public static void println(String s) {
        System.out.println(s);
    }

    public static void initI18n() {
        String s = Preferences.getString("app.locale", "en_EN");
        if (s != null && s.length() > 0) {
            String language = s;
            if (s.indexOf("_") > 0) {
                language = s.substring(0, s.indexOf("_"));
                s = s.substring(s.indexOf("_") + 1);
            } else {
                s = "";
            }
            String country = s;
            if (s.indexOf("_") > 0) {
                country = s.substring(0, s.indexOf("_"));
                s = s.substring(s.indexOf("_") + 1);
            } else {
                s = "";
            }
            String variant = s;
            if (language.length() > 0 && country.length() > 0 && variant.length() > 0) {
                I18n.setCurrentLocale(new Locale(language, country, variant));
            } else if (language.length() > 0 && country.length() > 0) {
                I18n.setCurrentLocale(new Locale(language, country));
            } else {
                I18n.setCurrentLocale(new Locale(language));
            }
        }
    }

    public static void main(String[] args) {
        System.setProperty("sun.swing.enableImprovedDragGesture", "");
        if (System.getProperty("nickyb.sqleonardo.laf.class") != null) {
            try {
                UIManager.setLookAndFeel(System.getProperty("nickyb.sqleonardo.laf.class"));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        System.out.println(UIManager.getSystemLookAndFeelClassName());
        Application.println("loading resources...");
        Application.loadIcons();
        Application.println("loading session...");
        Application.loadSession();
        Application.initI18n();
        window = new MDIWindow();
        Application.println("loading window...");
        window.show();
    }
}

