/*
 * Copyright (C) 2005 - 2008 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 *
 *
 *
 *
 * StaticTextReportElement.java
 *
 * Created on 19 maggio 2003, 17.55
 *
 */

package it.businesslogic.ireport;

/**
 *
 * @author  Administrator
 */
public class StaticTextReportElement extends it.businesslogic.ireport.TextReportElement {

    /** Creates a new instance of StaticTextReportElement */
    public StaticTextReportElement(int x, int y, int width, int height)
    {
		super(x,y,width,height);
                //this.setText("Static text");
                this.setText(it.businesslogic.ireport.util.I18n.getString("staticText", "Static text"));
                setKey("staticText");
    }

    public ReportElement cloneMe()
	{
		StaticTextReportElement newReportElement = new StaticTextReportElement(position.x, position.y, width, height);
		copyBaseReportElement(newReportElement, this);
		return newReportElement;
	}
}
