/*
 * EJBQLConnectionEditor.java
 *
 * Created on March 27, 2007, 1:18 PM
 */

package it.businesslogic.ireport.connection.gui;

import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.IReportConnectionEditor;
import it.businesslogic.ireport.connection.JDBCConnection;
import it.businesslogic.ireport.connection.MondrianConnection;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.I18n;
import java.util.Vector;

/**
 *
 * @author  gtoffoli
 */
public class MondrianConnectionEditor extends javax.swing.JPanel implements IReportConnectionEditor {
    
    private IReportConnection iReportConnection = null;
    private boolean init = false;
    
    /** Creates new form EJBQLConnectionEditor */
    public MondrianConnectionEditor() {
        initComponents();
        
        Vector conns = MainFrame.getMainInstance().getConnections();
        for (int i=0; i<conns.size(); ++i)
        {
            IReportConnection con = (IReportConnection)conns.elementAt(i);
            if (con instanceof JDBCConnection)
            {
                jComboBoxMondrianJdbc.addItem( con.getName() );
            }
        }
        
        if (jComboBoxMondrianJdbc.getItemCount() > 0)
        {
            jComboBoxMondrianJdbc.setSelectedIndex(0);
        }
        
        applyI18n();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanelMondrian = new javax.swing.JPanel();
        jLabel20 = new javax.swing.JLabel();
        jComboBoxMondrianJdbc = new javax.swing.JComboBox();
        jLabel19 = new javax.swing.JLabel();
        jTextFieldCatalogURI = new javax.swing.JTextField();
        jButtonBrowseCatalog = new javax.swing.JButton();
        jPanel14 = new javax.swing.JPanel();

        setLayout(new java.awt.BorderLayout());

        jPanelMondrian.setLayout(new java.awt.GridBagLayout());

        jLabel20.setText("Jdbc Connection");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 2, 4);
        jPanelMondrian.add(jLabel20, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 4, 4);
        jPanelMondrian.add(jComboBoxMondrianJdbc, gridBagConstraints);

        jLabel19.setText("Catalog URI (i.e. file:/path/schema.xml) ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 2, 4);
        jPanelMondrian.add(jLabel19, gridBagConstraints);

        jTextFieldCatalogURI.setMargin(new java.awt.Insets(0, 5, 2, 4));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 3, 4);
        jPanelMondrian.add(jTextFieldCatalogURI, gridBagConstraints);

        jButtonBrowseCatalog.setText("Browse...");
        jButtonBrowseCatalog.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonBrowseCatalogActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        jPanelMondrian.add(jButtonBrowseCatalog, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        jPanelMondrian.add(jPanel14, gridBagConstraints);

        add(jPanelMondrian, java.awt.BorderLayout.CENTER);

    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonBrowseCatalog;
    private javax.swing.JComboBox jComboBoxMondrianJdbc;
    private javax.swing.JLabel jLabel19;
    private javax.swing.JLabel jLabel20;
    private javax.swing.JPanel jPanel14;
    private javax.swing.JPanel jPanelMondrian;
    private javax.swing.JTextField jTextFieldCatalogURI;
    // End of variables declaration//GEN-END:variables
    
    
    public void setIReportConnection(IReportConnection c) {
        this.iReportConnection = c;
        
        
        if (iReportConnection instanceof MondrianConnection)
        {
            MondrianConnection con = (MondrianConnection)iReportConnection;
            this.jTextFieldCatalogURI.setText( it.businesslogic.ireport.util.Misc.nvl(con.getProperties().get(MondrianConnection.CATALOG_URI), "") );            
            jComboBoxMondrianJdbc.setSelectedItem( con.getConnectionName() );
        }
    }

    public IReportConnection getIReportConnection() {
        
        if (this.jComboBoxMondrianJdbc.getSelectedIndex() < 0) {
            javax.swing.JOptionPane.showMessageDialog(this,
                    I18n.getString("messages.connectionDialog.setJDBCConnection","You have to choose a JDBC connection in order to configure the Mondrian OLAP connection.\nIf JDBC connection are not yet available, please create one before creating this connection."),
                    I18n.getString("messages.connectionDialog.setJDBCConnectionCaption","Invalid JDBC connection!"),javax.swing.JOptionPane.WARNING_MESSAGE );
            return null;
        }

        if (this.jTextFieldCatalogURI.getText().trim().length() == 0) {
            javax.swing.JOptionPane.showMessageDialog(this,
                    I18n.getString("messages.connectionDialog.setCatalogUri","Please set the Catalog URI"),
                    I18n.getString("messages.connectionDialog.setCatalogUriCaption","Invalid URI!"),javax.swing.JOptionPane.WARNING_MESSAGE );
            return null;
        }

        IReportConnection irConn = new MondrianConnection();
        irConn.getProperties().put(MondrianConnection.CATALOG_URI, jTextFieldCatalogURI.getText().trim());
        irConn.getProperties().put(MondrianConnection.CONNECTION_NAME, jComboBoxMondrianJdbc.getSelectedItem()+"");
        
        iReportConnection = irConn;
        return iReportConnection;
    }
    
    public void applyI18n(){
                jButtonBrowseCatalog.setText(I18n.getString("connectionDialog.buttonBrowseCatalog","Browse..."));
                jLabel19.setText(I18n.getString("connectionDialog.label19","Catalog URI (i.e. file:/path/schema.xml)"));
                jLabel20.setText(I18n.getString("connectionDialog.label20","Jdbc Connection"));
                
    }
    
    
    private void jButtonBrowseCatalogActionPerformed(java.awt.event.ActionEvent evt) {                                                     
            
            String fileName = "";
	    javax.swing.JFileChooser jfc = new javax.swing.JFileChooser( MainFrame.getMainInstance().getCurrentDirectory());
	    
	    jfc.setDialogTitle("Select file....");
	    
	    jfc.addChoosableFileFilter( new javax.swing.filechooser.FileFilter() {
		    public boolean accept(java.io.File file) {
			    String filename = file.getName();
			    return (filename.toLowerCase().endsWith(".xml") || file.isDirectory()) ;
		    }
		    public String getDescription() {
			    return "XML *.xml";
		    }
	    });
	    
	    jfc.setMultiSelectionEnabled(false);
	    jfc.setDialogType( javax.swing.JFileChooser.OPEN_DIALOG);
	    if  (jfc.showOpenDialog( this) == javax.swing.JOptionPane.OK_OPTION) {
		    java.io.File file = jfc.getSelectedFile();		
                    try {
                        jTextFieldCatalogURI.setText( file.toURI() + "");
                    } catch (Exception ex){}
	    }        
        
        
    } 
    
    
}
