/*
 * EJBQLConnectionEditor.java
 *
 * Created on March 27, 2007, 1:18 PM
 */

package it.businesslogic.ireport.connection.gui;

import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.IReportConnectionEditor;
import it.businesslogic.ireport.connection.JRXMLADataSourceConnection;
import it.businesslogic.ireport.data.olap.CustomHTTPAuthenticator;
import it.businesslogic.ireport.util.I18n;
import java.net.Authenticator;
import javax.swing.JOptionPane;
import rex.graphics.datasourcetree.elements.DataSourceTreeElement;

/**
 *
 * @author  gtoffoli
 */
public class XMLADataSourceConnectionEditor extends javax.swing.JPanel implements IReportConnectionEditor {
    
    private IReportConnection iReportConnection = null;
    private boolean init = false;
    
    /** Creates new form EJBQLConnectionEditor */
    public XMLADataSourceConnectionEditor() {
        initComponents();
        applyI18n();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanelXMLA = new javax.swing.JPanel();
        jLabelXMLAUrl = new javax.swing.JLabel();
        jTextFieldXMLAUrl = new javax.swing.JTextField();
        jButtonGetXMLAMetadata = new javax.swing.JButton();
        jLabelXMLADatasource = new javax.swing.JLabel();
        jComboBoxXMLADatasource = new javax.swing.JComboBox();
        jLabelXMLACatalog = new javax.swing.JLabel();
        jComboBoxXMLACatalog = new javax.swing.JComboBox();
        jSeparator8 = new javax.swing.JSeparator();
        jLabelXMLACube = new javax.swing.JLabel();
        jComboBoxXMLACube = new javax.swing.JComboBox();
        jSeparator10 = new javax.swing.JSeparator();
        jPanel16 = new javax.swing.JPanel();
        jLabel26 = new javax.swing.JLabel();
        jLabel27 = new javax.swing.JLabel();
        jTextFieldUsername1 = new javax.swing.JTextField();
        jTextFieldPassword1 = new javax.swing.JPasswordField();
        jCheckBoxSavePassword1 = new javax.swing.JCheckBox();
        jLabelAttention = new javax.swing.JLabel();

        setLayout(new java.awt.BorderLayout());

        jPanelXMLA.setLayout(new java.awt.GridBagLayout());

        jLabelXMLAUrl.setText("Url of XML/A server");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 0, 4);
        jPanelXMLA.add(jLabelXMLAUrl, gridBagConstraints);

        jTextFieldXMLAUrl.setText("http://localhost:8080/mondrian/xmla");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 4, 4, 4);
        jPanelXMLA.add(jTextFieldXMLAUrl, gridBagConstraints);

        jButtonGetXMLAMetadata.setText("Get metadata");
        jButtonGetXMLAMetadata.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonGetXMLAMetadataActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 4, 4);
        jPanelXMLA.add(jButtonGetXMLAMetadata, gridBagConstraints);

        jLabelXMLADatasource.setText("Datasource");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 2, 4);
        jPanelXMLA.add(jLabelXMLADatasource, gridBagConstraints);

        jComboBoxXMLADatasource.setMinimumSize(new java.awt.Dimension(23, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 4, 4);
        jPanelXMLA.add(jComboBoxXMLADatasource, gridBagConstraints);

        jLabelXMLACatalog.setText("Catalog");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 2, 4);
        jPanelXMLA.add(jLabelXMLACatalog, gridBagConstraints);

        jComboBoxXMLACatalog.setMinimumSize(new java.awt.Dimension(23, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 4, 4);
        jPanelXMLA.add(jComboBoxXMLACatalog, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanelXMLA.add(jSeparator8, gridBagConstraints);

        jLabelXMLACube.setText("Cube");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 2, 4);
        jPanelXMLA.add(jLabelXMLACube, gridBagConstraints);

        jComboBoxXMLACube.setMinimumSize(new java.awt.Dimension(23, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 4, 4);
        jPanelXMLA.add(jComboBoxXMLACube, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanelXMLA.add(jSeparator10, gridBagConstraints);

        jPanel16.setLayout(new java.awt.GridBagLayout());

        jLabel26.setText("Username");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanel16.add(jLabel26, gridBagConstraints);

        jLabel27.setText("Password");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanel16.add(jLabel27, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanel16.add(jTextFieldUsername1, gridBagConstraints);

        jTextFieldPassword1.setFont(new java.awt.Font("Tahoma", 0, 11));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanel16.add(jTextFieldPassword1, gridBagConstraints);

        jCheckBoxSavePassword1.setText("Save password");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 6);
        jPanel16.add(jCheckBoxSavePassword1, gridBagConstraints);

        jLabelAttention.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/problems/warning.png")));
        jLabelAttention.setText("<html>ATTENTION! Passwords are stored in clear text. If you dont specify a password now, iReport will ask you for one only when required and will not save it.");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel16.add(jLabelAttention, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanelXMLA.add(jPanel16, gridBagConstraints);

        add(jPanelXMLA, java.awt.BorderLayout.NORTH);

    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonGetXMLAMetadata;
    private javax.swing.JCheckBox jCheckBoxSavePassword1;
    private javax.swing.JComboBox jComboBoxXMLACatalog;
    private javax.swing.JComboBox jComboBoxXMLACube;
    private javax.swing.JComboBox jComboBoxXMLADatasource;
    private javax.swing.JLabel jLabel26;
    private javax.swing.JLabel jLabel27;
    private javax.swing.JLabel jLabelAttention;
    private javax.swing.JLabel jLabelXMLACatalog;
    private javax.swing.JLabel jLabelXMLACube;
    private javax.swing.JLabel jLabelXMLADatasource;
    private javax.swing.JLabel jLabelXMLAUrl;
    private javax.swing.JPanel jPanel16;
    private javax.swing.JPanel jPanelXMLA;
    private javax.swing.JSeparator jSeparator10;
    private javax.swing.JSeparator jSeparator8;
    private javax.swing.JPasswordField jTextFieldPassword1;
    private javax.swing.JTextField jTextFieldUsername1;
    private javax.swing.JTextField jTextFieldXMLAUrl;
    // End of variables declaration//GEN-END:variables
    
    
    public void setIReportConnection(IReportConnection c) {
        
        this.iReportConnection = c;
        if (iReportConnection instanceof JRXMLADataSourceConnection)
        {
            /**   
             * Copyright (C) 2005, 2006 CINCOM SYSTEMS, INC.
             * All Rights Reserved
             * www.cincom.com
             *
             */
            JRXMLADataSourceConnection con = (JRXMLADataSourceConnection)iReportConnection;
            this.jTextFieldXMLAUrl.setText( con.getUrl() );  
            this.jComboBoxXMLADatasource.removeAllItems();
            this.jComboBoxXMLADatasource.addItem(con.getDatasource());
            this.jComboBoxXMLACatalog.removeAllItems();
            this.jComboBoxXMLACatalog.addItem(con.getCatalog());
            this.jComboBoxXMLACube.removeAllItems();
            this.jComboBoxXMLACube.addItem(con.getCube());
            
            this.jTextFieldUsername1.setText( con.getUsername());
            if (con.isSavePassword())
                this.jTextFieldPassword1.setText( con.getPassword());
            else 
                this.jTextFieldPassword1.setText( "");
            this.jCheckBoxSavePassword1.setSelected( con.isSavePassword());
        }
    }

    public IReportConnection getIReportConnection() {
        

        /**   
         * Copyright (C) 2005, 2006 CINCOM SYSTEMS, INC.
         * All Rights Reserved
         * www.cincom.com
         *
         */
        IReportConnection irConn = new JRXMLADataSourceConnection();

        if (this.jTextFieldXMLAUrl.getText().trim().length() == 0) {
            javax.swing.JOptionPane.showMessageDialog(this,
                    I18n.getString("messages.connectionDialog.xmla.invalidURL","Please specify a valid server URL"),
                    I18n.getString("messages.connectionDialog.xmla.invalidProperty","Invalid property!"),javax.swing.JOptionPane.WARNING_MESSAGE );
            return null;
        }

        ((JRXMLADataSourceConnection)irConn).setUrl( this.jTextFieldXMLAUrl.getText().trim());

        if (this.jComboBoxXMLADatasource.getSelectedIndex() < 0) {
            javax.swing.JOptionPane.showMessageDialog(this,
                    I18n.getString("messages.connectionDialog.xmla.invalidDatasource","Please specify a valid Datasource"),
                    I18n.getString("messages.connectionDialog.setJDBCConnectionCaption","Invalid JDBC connection!"),javax.swing.JOptionPane.WARNING_MESSAGE );
            return null;
        }

        ((JRXMLADataSourceConnection)irConn).setDatasource( 
                ((String)this.jComboBoxXMLADatasource.getSelectedItem()).trim());

        if (this.jComboBoxXMLACatalog.getSelectedIndex() < 0) {
            javax.swing.JOptionPane.showMessageDialog(this,
                    I18n.getString("messages.connectionDialog.xmla.invalidCatalog","Please specify a valid Catalog"),
                    I18n.getString("messages.connectionDialog.setJDBCConnectionCaption","Invalid JDBC connection!"),javax.swing.JOptionPane.WARNING_MESSAGE );
            return null;
        }

        ((JRXMLADataSourceConnection)irConn).setCatalog( 
                ((String)this.jComboBoxXMLACatalog.getSelectedItem()).trim());

        if (this.jComboBoxXMLACube.getSelectedIndex() < 0) {
            javax.swing.JOptionPane.showMessageDialog(this,
                    I18n.getString("messages.connectionDialog.xmla.invalidCube","Please specify a valid Cube"),
                    I18n.getString("messages.connectionDialog.setJDBCConnectionCaption","Invalid JDBC connection!"),javax.swing.JOptionPane.WARNING_MESSAGE );
            return null;
        }

        ((JRXMLADataSourceConnection)irConn).setCube( 
                ((String)this.jComboBoxXMLACube.getSelectedItem()).trim());

        ((JRXMLADataSourceConnection)irConn).setUsername( this.jTextFieldUsername1.getText().trim() );
        if (jCheckBoxSavePassword1.isSelected())
            ((JRXMLADataSourceConnection)irConn).setPassword( this.jTextFieldPassword1.getText());
        else
            ((JRXMLADataSourceConnection)irConn).setPassword("");
        ((JRXMLADataSourceConnection)irConn).setSavePassword( jCheckBoxSavePassword1.isSelected() );
            
        iReportConnection = irConn;
        return iReportConnection;
    }
    
    public void applyI18n(){
                // Start autogenerated code ----------------------
                jLabelAttention.setText( "<html>" + I18n.getString("connectionDialog.textArea1","ATTENTION! Passwords are stored in clear text. If you dont specify a password now, iReport will ask you for one only when required and will not save it."));
                jLabelXMLAUrl.setText(I18n.getString("connectionDialog.labelXMLAUrl","Url of XML/A server"));
                jButtonGetXMLAMetadata.setText(I18n.getString("connectionDialog.buttonGetXMLAMetadata","Get metadata"));
                jLabelXMLADatasource.setText(I18n.getString("connectionDialog.labelXMLADatasource","Datasource"));
                jLabelXMLACatalog.setText(I18n.getString("connectionDialog.labelXMLACatalog","Catalog"));
                jLabelXMLACube.setText(I18n.getString("connectionDialog.labelXMLACube","Cube"));
    }
    
    
    /**   
     * Copyright (C) 2005, 2006 CINCOM SYSTEMS, INC.
     * All Rights Reserved
     * www.cincom.com
     *
     */
    private class jComboBoxCatListener implements java.awt.event.ActionListener
    {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxCatActionPerformed(evt);
            }
    }
    jComboBoxCatListener catListener=new jComboBoxCatListener();
    
    private class jComboBoxdsListener implements java.awt.event.ActionListener
    {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxDatasourceActionPerformed(evt);
            }
    }    
    jComboBoxdsListener dsListener=new jComboBoxdsListener();
    
    private void jComboBoxDatasourceActionPerformed(java.awt.event.ActionEvent evt) {                                                    

            jComboBoxXMLACatalog.removeActionListener(catListener);
            if (this.jComboBoxXMLADatasource.getItemCount() == 0 || this.jComboBoxXMLADatasource.getSelectedIndex() == -1) {
              return;
            }
            String urlstr = this.jTextFieldXMLAUrl.getText().trim();
            rex.metadata.ServerMetadata smd = new rex.metadata.ServerMetadata(urlstr,this);
            if (smd.isValidUrl() == false) {
                JOptionPane.showMessageDialog(this,
                        I18n.getString("messages.connectionDialog.xmla.invalidUrl","Unable to connect to XMLA server."),"",JOptionPane.INFORMATION_MESSAGE);
                return;
            }

            this.jComboBoxXMLACatalog.removeAllItems();
            this.jComboBoxXMLACube.removeAllItems();
          
            DataSourceTreeElement dste[] = smd.discoverDataSources();
            
            if (dste == null || dste.length == 0) {
                JOptionPane.showMessageDialog(this,
                        I18n.getString("messages.connectionDialog.xmla.noDatasource","No Datasources found."),"",JOptionPane.INFORMATION_MESSAGE);
                return;
            } 
            //filling catalogs
            boolean found = false;
            int intI = 0;
            while (!found && intI < dste.length) {
                if (dste[intI].getDataSourceInfo().compareTo((String)this.jComboBoxXMLADatasource.getSelectedItem()) == 0){
                    found = true;
                }
                else{
                    intI++;
                }
            }
            if (!found) {
                return;
            }
            rex.graphics.datasourcetree.elements.DataSourceTreeElement catalogs[] = dste[intI].getChildren();
            if (catalogs == null || catalogs.length == 0) {
                JOptionPane.showMessageDialog(this,
                        I18n.getString("messages.connectionDialog.xmla.noCatalogs","No catalogs found for selected datasource."),"",JOptionPane.INFORMATION_MESSAGE);            
                return;
            }
            this.jComboBoxXMLACatalog.removeAllItems();
   
            for (intI = 0;intI<catalogs.length;intI++){
                this.jComboBoxXMLACatalog.addItem(((rex.graphics.datasourcetree.elements.CatalogElement)catalogs[intI]).toString());            
            }
        
            found = false;
             intI= 0;
            while (!found && intI < catalogs.length) {
                if (catalogs[intI].toString().trim().compareTo((String)this.jComboBoxXMLACatalog.getSelectedItem()) == 0){
                    found = true;
                }
                else{
                    intI++;
                }
            }    
            if (!found) {
             return;
            }
            rex.graphics.datasourcetree.elements.DataSourceTreeElement cubes[] = catalogs[intI].getChildren();
            if (cubes == null || cubes.length == 0) {
                return;
            }
            this.jComboBoxXMLACube.removeAllItems();
            for (intI = 0;intI<cubes.length;intI++){
                this.jComboBoxXMLACube.addItem(((rex.graphics.datasourcetree.elements.CubeElement)cubes[intI]).toString());           
            }     
            jComboBoxXMLACatalog.addActionListener(catListener);
            
        }
    
    
    private void jComboBoxCatActionPerformed(java.awt.event.ActionEvent evt) {                                             
      
        jComboBoxXMLADatasource.removeActionListener(dsListener);
         
       if (this.jComboBoxXMLACatalog.getItemCount() == 0 || this.jComboBoxXMLACatalog.getSelectedIndex() == -1 ) {
            return;
       }
        String urlstr = this.jTextFieldXMLAUrl.getText().trim();
        rex.metadata.ServerMetadata smd = new rex.metadata.ServerMetadata(urlstr,this);
        if (smd.isValidUrl() == false) {
            JOptionPane.showMessageDialog(this,
                    I18n.getString("messages.connectionDialog.xmla.invalidUrl","Unable to connect to XMLA server."),"",JOptionPane.INFORMATION_MESSAGE);
            return;
        }
        
        this.jComboBoxXMLACube.removeAllItems();
        
        rex.graphics.datasourcetree.elements.DataSourceTreeElement dste[] = smd.discoverDataSources();
        if (dste == null || dste.length == 0) {
            JOptionPane.showMessageDialog(this,
                    I18n.getString("messages.connectionDialog.xmla.noDatasource","No Datasources found."),"",JOptionPane.INFORMATION_MESSAGE);
            return;
        }
        boolean found = false;
        int intI = 0;
        while (!found && intI < dste.length) {
            if (dste[intI].getDataSourceInfo().compareTo((String)this.jComboBoxXMLADatasource.getSelectedItem()) == 0){
                found = true;
            } else{
                intI++;
            }
        }if (!found) {
            return;
        }
        rex.graphics.datasourcetree.elements.DataSourceTreeElement catalogs[] = dste[intI].getChildren();
        if (catalogs == null || catalogs.length == 0) {
            JOptionPane.showMessageDialog(this,
                    I18n.getString("messages.connectionDialog.xmla.noCatalogs","No catalogs found for selected datasource."),"",JOptionPane.INFORMATION_MESSAGE);
            return;
        }
        //add catalogs
        this.jComboBoxXMLACatalog.removeAllItems();
        for (intI = 0;intI<catalogs.length;intI++){
            this.jComboBoxXMLACatalog.addItem(((rex.graphics.datasourcetree.elements.CatalogElement)catalogs[intI]).toString());
        }
        found = false;
        intI = 0;
        while (!found && intI < catalogs.length) {
            if (catalogs[intI].toString().compareTo((String)this.jComboBoxXMLACatalog.getSelectedItem()) == 0){
                found = true;
            }
            else{
                intI++;
                found=false;
            }
        }
        if (!found) {return;
        }
        rex.graphics.datasourcetree.elements.DataSourceTreeElement cubes[] = catalogs[intI].getChildren();
        if (cubes == null || cubes.length == 0) {
            JOptionPane.showMessageDialog(this,
                    I18n.getString("messages.connectionDialog.xmla.noCubes","No cubes found for selected datasource."),"",JOptionPane.INFORMATION_MESSAGE);
            return;
        }
        this.jComboBoxXMLACube.removeAllItems();
        for (intI = 0;intI<cubes.length;intI++){
            this.jComboBoxXMLACube.addItem(((rex.graphics.datasourcetree.elements.CubeElement)cubes[intI]).toString());
        }   
        jComboBoxXMLADatasource.addActionListener(dsListener);
        
    }  
    
    private void jButtonGetXMLAMetadataActionPerformed(java.awt.event.ActionEvent evt) {                                                       
        jComboBoxXMLADatasource.removeActionListener(dsListener);
        jComboBoxXMLACatalog.removeActionListener(catListener);
        
        String urlstr = this.jTextFieldXMLAUrl.getText().trim();
        
        Authenticator.setDefault(new CustomHTTPAuthenticator( jTextFieldUsername1.getText(), new String(jTextFieldPassword1.getPassword()) ));

        
        rex.metadata.ServerMetadata smd = new rex.metadata.ServerMetadata(urlstr,this);
       
        if (smd.isValidUrl() == false) {
            JOptionPane.showMessageDialog(this,
                    I18n.getString("messages.connectionDialog.xmla.invalidUrl","Unable to connect to XMLA server.") ,"",JOptionPane.INFORMATION_MESSAGE);
            return;
        }
        this.jComboBoxXMLADatasource.removeAllItems();
        this.jComboBoxXMLACatalog.removeAllItems();
        this.jComboBoxXMLACube.removeAllItems(); 
        rex.graphics.datasourcetree.elements.DataSourceTreeElement dste[] = smd.discoverDataSources();
        if (dste == null) {
            JOptionPane.showMessageDialog(this,
                    "No Datasources found.","",JOptionPane.INFORMATION_MESSAGE);
            return;
        }
        for (int i=0;i<dste.length;i++){
            this.jComboBoxXMLADatasource.addItem(dste[i].getDataSourceInfo());
        }
        rex.graphics.datasourcetree.elements.DataSourceTreeElement catalogs[] = dste[0].getChildren();
        if (catalogs == null || catalogs.length == 0) {
            return;
        }
        this.jComboBoxXMLACatalog.removeAllItems();
        for (int i = 0;i<catalogs.length;i++){
            this.jComboBoxXMLACatalog.addItem(((rex.graphics.datasourcetree.elements.CatalogElement)catalogs[i]).toString());
        }
         //get Cube information for the selected catalog...
         rex.graphics.datasourcetree.elements.DataSourceTreeElement cubes[] = catalogs[0].getChildren();
        if(cubes ==null || cubes.length==0){
            return;
        }
         this.jComboBoxXMLACube.removeAllItems(); 
         for(int i=0;i<cubes.length; i++){
             this.jComboBoxXMLACube.addItem(((rex.graphics.datasourcetree.elements.CubeElement)cubes[i]).toString());
         }       
        jComboBoxXMLADatasource.addActionListener(dsListener);
        jComboBoxXMLACatalog.addActionListener(catListener);
    }
    
}
