/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.env.IBinaryNestedType;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SignatureWrapper;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;

public final class BinaryTypeBinding
extends ReferenceBinding {
    private ReferenceBinding superclass;
    private ReferenceBinding enclosingType;
    private ReferenceBinding[] superInterfaces;
    private FieldBinding[] fields;
    private MethodBinding[] methods;
    private ReferenceBinding[] memberTypes;
    protected TypeVariableBinding[] typeVariables;
    private LookupEnvironment environment;

    public static ReferenceBinding resolveType(ReferenceBinding type, LookupEnvironment environment, boolean convertGenericToRawType) {
        if (type instanceof UnresolvedReferenceBinding) {
            return ((UnresolvedReferenceBinding)type).resolve(environment, convertGenericToRawType);
        }
        if (type.isParameterizedType()) {
            return ((ParameterizedTypeBinding)type).resolve();
        }
        if (type.isWildcard()) {
            return ((WildcardBinding)type).resolve();
        }
        if (convertGenericToRawType) {
            return (ReferenceBinding)environment.convertToRawType(type);
        }
        return type;
    }

    public static TypeBinding resolveType(TypeBinding type, LookupEnvironment environment, ParameterizedTypeBinding parameterizedType, int rank) {
        switch (type.kind()) {
            case 260: {
                return ((ParameterizedTypeBinding)type).resolve();
            }
            case 516: {
                return ((WildcardBinding)type).resolve();
            }
            case 68: {
                BinaryTypeBinding.resolveType(((ArrayBinding)type).leafComponentType, environment, parameterizedType, rank);
                break;
            }
            case 4100: {
                ((TypeVariableBinding)type).resolve(environment);
                break;
            }
            case 2052: {
                if (parameterizedType != null) break;
                return environment.convertToRawType(type);
            }
            default: {
                if (!(type instanceof UnresolvedReferenceBinding)) break;
                return ((UnresolvedReferenceBinding)type).resolve(environment, parameterizedType == null);
            }
        }
        return type;
    }

    static ReferenceBinding resolveUnresolvedType(ReferenceBinding type, LookupEnvironment environment, boolean convertGenericToRawType) {
        if (type instanceof UnresolvedReferenceBinding) {
            return ((UnresolvedReferenceBinding)type).resolve(environment, convertGenericToRawType);
        }
        if (type.isParameterizedType()) {
            BinaryTypeBinding.resolveUnresolvedType(((ParameterizedTypeBinding)type).type, environment, false);
        } else if (type.isWildcard()) {
            BinaryTypeBinding.resolveType(((WildcardBinding)type).genericType, environment, null, 0);
        }
        return type;
    }

    public BinaryTypeBinding(PackageBinding packageBinding, IBinaryType binaryType, LookupEnvironment environment) {
        this.compoundName = CharOperation.splitOn('/', binaryType.getName());
        this.computeId();
        this.tagBits |= 0x40L;
        this.environment = environment;
        this.fPackage = packageBinding;
        this.fileName = binaryType.getFileName();
        char[] typeSignature = environment.globalOptions.sourceLevel >= 0x310000L ? binaryType.getGenericSignature() : null;
        this.typeVariables = typeSignature != null && typeSignature.length > 0 && typeSignature[0] == '<' ? null : NoTypeVariables;
        char[] possibleSourceName = this.compoundName[this.compoundName.length - 1];
        int start = CharOperation.lastIndexOf('$', possibleSourceName) + 1;
        if (start == 0) {
            this.sourceName = possibleSourceName;
        } else {
            this.sourceName = new char[possibleSourceName.length - start];
            System.arraycopy(possibleSourceName, start, this.sourceName, 0, this.sourceName.length);
        }
        this.modifiers = binaryType.getModifiers();
        if (binaryType.isAnonymous()) {
            this.tagBits |= 0x34L;
        } else if (binaryType.isLocal()) {
            this.tagBits |= 0x14L;
        } else if (binaryType.isMember()) {
            this.tagBits |= 0xCL;
        }
        char[] enclosingTypeName = binaryType.getEnclosingTypeName();
        if (enclosingTypeName != null) {
            this.enclosingType = environment.getTypeFromConstantPoolName(enclosingTypeName, 0, -1, true);
            this.tagBits |= 0xCL;
            this.tagBits |= 0x8000000L;
            if (this.enclosingType().isStrictfp()) {
                this.modifiers |= 0x800;
            }
            if (this.enclosingType().isDeprecated()) {
                this.modifiers |= 0x200000;
            }
        }
    }

    public FieldBinding[] availableFields() {
        if ((this.tagBits & 0x1000L) != 0L) {
            return this.fields;
        }
        FieldBinding[] availableFields = new FieldBinding[this.fields.length];
        int count = 0;
        int i = 0;
        while (i < this.fields.length) {
            try {
                availableFields[count] = this.resolveTypeFor(this.fields[i]);
                ++count;
            }
            catch (AbortCompilation abortCompilation) {}
            ++i;
        }
        if (count < availableFields.length) {
            FieldBinding[] fieldBindingArray = availableFields;
            availableFields = new FieldBinding[count];
            System.arraycopy(fieldBindingArray, 0, availableFields, 0, count);
        }
        return availableFields;
    }

    public MethodBinding[] availableMethods() {
        if ((this.tagBits & 0x2000L) != 0L) {
            return this.methods;
        }
        MethodBinding[] availableMethods = new MethodBinding[this.methods.length];
        int count = 0;
        int i = 0;
        while (i < this.methods.length) {
            try {
                availableMethods[count] = this.resolveTypesFor(this.methods[i]);
                ++count;
            }
            catch (AbortCompilation abortCompilation) {}
            ++i;
        }
        if (count < availableMethods.length) {
            MethodBinding[] methodBindingArray = availableMethods;
            availableMethods = new MethodBinding[count];
            System.arraycopy(methodBindingArray, 0, availableMethods, 0, count);
        }
        return availableMethods;
    }

    void cachePartsFrom(IBinaryType binaryType, boolean needFieldsAndMethods) {
        int size;
        this.typeVariables = NoTypeVariables;
        this.superInterfaces = NoSuperInterfaces;
        long sourceLevel = this.environment.globalOptions.sourceLevel;
        char[] typeSignature = null;
        if (sourceLevel >= 0x310000L) {
            typeSignature = binaryType.getGenericSignature();
            this.tagBits |= binaryType.getTagBits();
        }
        if (typeSignature == null) {
            int size2;
            char[] superclassName = binaryType.getSuperclassName();
            if (superclassName != null) {
                this.superclass = this.environment.getTypeFromConstantPoolName(superclassName, 0, -1, false);
                this.tagBits |= 0x2000000L;
            }
            this.superInterfaces = NoSuperInterfaces;
            char[][] interfaceNames = binaryType.getInterfaceNames();
            if (interfaceNames != null && (size2 = interfaceNames.length) > 0) {
                this.superInterfaces = new ReferenceBinding[size2];
                int i = 0;
                while (i < size2) {
                    this.superInterfaces[i] = this.environment.getTypeFromConstantPoolName(interfaceNames[i], 0, -1, false);
                    ++i;
                }
                this.tagBits |= 0x4000000L;
            }
        } else {
            SignatureWrapper wrapper = new SignatureWrapper(typeSignature);
            if (wrapper.signature[wrapper.start] == '<') {
                ++wrapper.start;
                this.typeVariables = this.createTypeVariables(wrapper, this);
                ++wrapper.start;
                this.tagBits |= 0x1000000L;
                this.modifiers |= 0x40000000;
            }
            this.superclass = (ReferenceBinding)this.environment.getTypeFromTypeSignature(wrapper, NoTypeVariables, this);
            this.tagBits |= 0x2000000L;
            this.superInterfaces = NoSuperInterfaces;
            if (!wrapper.atEnd()) {
                ArrayList<TypeBinding> types = new ArrayList<TypeBinding>(2);
                do {
                    types.add(this.environment.getTypeFromTypeSignature(wrapper, NoTypeVariables, this));
                } while (!wrapper.atEnd());
                this.superInterfaces = new ReferenceBinding[types.size()];
                types.toArray(this.superInterfaces);
                this.tagBits |= 0x4000000L;
            }
        }
        this.memberTypes = NoMemberTypes;
        IBinaryNestedType[] memberTypeStructures = binaryType.getMemberTypes();
        if (memberTypeStructures != null && (size = memberTypeStructures.length) > 0) {
            this.memberTypes = new ReferenceBinding[size];
            int i = 0;
            while (i < size) {
                this.memberTypes[i] = this.environment.getTypeFromConstantPoolName(memberTypeStructures[i].getName(), 0, -1, false);
                ++i;
            }
            this.tagBits |= 0x10000000L;
        }
        if (needFieldsAndMethods) {
            this.createFields(binaryType.getFields(), sourceLevel);
            this.createMethods(binaryType.getMethods(), sourceLevel);
        } else {
            this.fields = NoFields;
            this.methods = NoMethods;
        }
    }

    private void createFields(IBinaryField[] iFields, long sourceLevel) {
        int size;
        this.fields = NoFields;
        if (iFields != null && (size = iFields.length) > 0) {
            this.fields = new FieldBinding[size];
            boolean use15specifics = sourceLevel >= 0x310000L;
            boolean isViewedAsDeprecated = this.isViewedAsDeprecated();
            int i = 0;
            while (i < size) {
                IBinaryField binaryField = iFields[i];
                char[] fieldSignature = use15specifics ? binaryField.getGenericSignature() : null;
                TypeBinding type = fieldSignature == null ? this.environment.getTypeFromSignature(binaryField.getTypeName(), 0, -1, false, this) : this.environment.getTypeFromTypeSignature(new SignatureWrapper(fieldSignature), NoTypeVariables, this);
                FieldBinding field = new FieldBinding(binaryField.getName(), type, binaryField.getModifiers() | 0x2000000, this, binaryField.getConstant());
                field.id = i;
                if (use15specifics) {
                    field.tagBits |= binaryField.getTagBits();
                }
                if (isViewedAsDeprecated && !field.isDeprecated()) {
                    field.modifiers |= 0x200000;
                }
                if (fieldSignature != null) {
                    field.modifiers |= 0x40000000;
                }
                this.fields[i] = field;
                ++i;
            }
        }
    }

    private MethodBinding createMethod(IBinaryMethod method, long sourceLevel) {
        MethodBinding result;
        char[] methodSignature;
        int methodModifiers = method.getModifiers() | 0x2000000;
        if (sourceLevel < 0x310000L) {
            methodModifiers &= 0xFFFFFF7F;
        }
        ReferenceBinding[] exceptions = NoExceptions;
        TypeBinding[] parameters = NoParameters;
        TypeVariableBinding[] typeVars = NoTypeVariables;
        TypeBinding returnType = null;
        boolean use15specifics = sourceLevel >= 0x310000L;
        char[] cArray = methodSignature = use15specifics ? method.getGenericSignature() : null;
        if (methodSignature == null) {
            char[][] exceptionTypes;
            int i;
            char nextChar;
            char[] methodDescriptor = method.getMethodDescriptor();
            int numOfParams = 0;
            int index = 0;
            while ((nextChar = methodDescriptor[++index]) != ')') {
                if (nextChar == '[') continue;
                ++numOfParams;
                if (nextChar != 'L') continue;
                while ((nextChar = methodDescriptor[++index]) != ';') {
                }
            }
            int startIndex = method.isConstructor() && this.isMemberType() && !this.isStatic() ? 1 : 0;
            int size = numOfParams - startIndex;
            if (size > 0) {
                parameters = new TypeBinding[size];
                index = 1;
                int end = 0;
                i = 0;
                while (i < numOfParams) {
                    while ((nextChar = methodDescriptor[++end]) == '[') {
                    }
                    if (nextChar == 'L') {
                        while ((nextChar = methodDescriptor[++end]) != ';') {
                        }
                    }
                    if (i >= startIndex) {
                        parameters[i - startIndex] = this.environment.getTypeFromSignature(methodDescriptor, index, end, false, this);
                    }
                    index = end + 1;
                    ++i;
                }
            }
            if ((exceptionTypes = method.getExceptionTypeNames()) != null && (size = exceptionTypes.length) > 0) {
                exceptions = new ReferenceBinding[size];
                i = 0;
                while (i < size) {
                    exceptions[i] = this.environment.getTypeFromConstantPoolName(exceptionTypes[i], 0, -1, false);
                    ++i;
                }
            }
            if (!method.isConstructor()) {
                returnType = this.environment.getTypeFromSignature(methodDescriptor, index + 1, -1, false, this);
            }
        } else {
            ArrayList<TypeBinding> types;
            methodModifiers |= 0x40000000;
            SignatureWrapper wrapper = new SignatureWrapper(methodSignature);
            if (wrapper.signature[wrapper.start] == '<') {
                ++wrapper.start;
                typeVars = this.createTypeVariables(wrapper, this);
                ++wrapper.start;
            }
            if (wrapper.signature[wrapper.start] == '(') {
                ++wrapper.start;
                if (wrapper.signature[wrapper.start] == ')') {
                    ++wrapper.start;
                } else {
                    types = new ArrayList<TypeBinding>(2);
                    while (wrapper.signature[wrapper.start] != ')') {
                        types.add(this.environment.getTypeFromTypeSignature(wrapper, typeVars, this));
                    }
                    ++wrapper.start;
                    parameters = new TypeBinding[types.size()];
                    types.toArray(parameters);
                }
            }
            if (!method.isConstructor()) {
                returnType = this.environment.getTypeFromTypeSignature(wrapper, typeVars, this);
            }
            if (!wrapper.atEnd() && wrapper.signature[wrapper.start] == '^') {
                types = new ArrayList(2);
                do {
                    ++wrapper.start;
                    types.add(this.environment.getTypeFromTypeSignature(wrapper, typeVars, this));
                } while (!wrapper.atEnd() && wrapper.signature[wrapper.start] == '^');
                exceptions = new ReferenceBinding[types.size()];
                types.toArray(exceptions);
            } else {
                int size;
                char[][] exceptionTypes = method.getExceptionTypeNames();
                if (exceptionTypes != null && (size = exceptionTypes.length) > 0) {
                    exceptions = new ReferenceBinding[size];
                    int i = 0;
                    while (i < size) {
                        exceptions[i] = this.environment.getTypeFromConstantPoolName(exceptionTypes[i], 0, -1, false);
                        ++i;
                    }
                }
            }
        }
        MethodBinding methodBinding = result = method.isConstructor() ? new MethodBinding(methodModifiers, parameters, exceptions, this) : new MethodBinding(methodModifiers, method.getSelector(), returnType, parameters, exceptions, this);
        if (use15specifics) {
            result.tagBits |= method.getTagBits();
        }
        result.typeVariables = typeVars;
        int i = 0;
        int length = typeVars.length;
        while (i < length) {
            typeVars[i].declaringElement = result;
            ++i;
        }
        return result;
    }

    private void createMethods(IBinaryMethod[] iMethods, long sourceLevel) {
        int total = 0;
        int initialTotal = 0;
        int iClinit = -1;
        int[] toSkip = null;
        if (iMethods != null) {
            int i = total = (initialTotal = iMethods.length);
            while (--i >= 0) {
                char[] methodName;
                IBinaryMethod method = iMethods[i];
                if ((method.getModifiers() & 0x1000) != 0) {
                    if (toSkip == null) {
                        toSkip = new int[iMethods.length];
                    }
                    toSkip[i] = -1;
                    --total;
                    continue;
                }
                if (iClinit != -1 || (methodName = method.getSelector()).length != 8 || methodName[0] != '<') continue;
                iClinit = i;
                --total;
            }
        }
        if (total == 0) {
            this.methods = NoMethods;
            return;
        }
        boolean isViewedAsDeprecated = this.isViewedAsDeprecated();
        this.methods = new MethodBinding[total];
        if (total == initialTotal) {
            int i = 0;
            while (i < initialTotal) {
                MethodBinding method = this.createMethod(iMethods[i], sourceLevel);
                if (isViewedAsDeprecated && !method.isDeprecated()) {
                    method.modifiers |= 0x200000;
                }
                this.methods[i] = method;
                ++i;
            }
        } else {
            int i = 0;
            int index = 0;
            while (i < initialTotal) {
                if (iClinit != i && (toSkip == null || toSkip[i] != -1)) {
                    MethodBinding method = this.createMethod(iMethods[i], sourceLevel);
                    if (isViewedAsDeprecated && !method.isDeprecated()) {
                        method.modifiers |= 0x200000;
                    }
                    this.methods[index++] = method;
                }
                ++i;
            }
        }
    }

    private TypeVariableBinding[] createTypeVariables(SignatureWrapper wrapper, Binding declaringElement) {
        char[] typeSignature = wrapper.signature;
        int depth = 0;
        int length = typeSignature.length;
        int rank = 0;
        ArrayList<TypeVariableBinding> variables = new ArrayList<TypeVariableBinding>(1);
        depth = 0;
        boolean pendingVariable = true;
        int i = 1;
        block5: while (i < length) {
            switch (typeSignature[i]) {
                case '<': {
                    ++depth;
                    break;
                }
                case '>': {
                    if (--depth >= 0) break;
                    break block5;
                }
                case ';': {
                    if (depth != 0 || i + 1 >= length || typeSignature[i + 1] == ':') break;
                    pendingVariable = true;
                    break;
                }
                default: {
                    if (!pendingVariable) break;
                    pendingVariable = false;
                    int colon = CharOperation.indexOf(':', typeSignature, i);
                    char[] variableName = CharOperation.subarray(typeSignature, i, colon);
                    variables.add(new TypeVariableBinding(variableName, declaringElement, rank++));
                }
            }
            ++i;
        }
        TypeVariableBinding[] result = new TypeVariableBinding[rank];
        variables.toArray(result);
        int i2 = 0;
        while (i2 < rank) {
            this.initializeTypeVariable(result[i2], result, wrapper);
            ++i2;
        }
        return result;
    }

    public ReferenceBinding enclosingType() {
        if ((this.tagBits & 0x8000000L) == 0L) {
            return this.enclosingType;
        }
        this.enclosingType = BinaryTypeBinding.resolveUnresolvedType(this.enclosingType, this.environment, false);
        this.tagBits &= 0xFFFFFFFFF7FFFFFFL;
        this.enclosingType = BinaryTypeBinding.resolveType(this.enclosingType, this.environment, false);
        return this.enclosingType;
    }

    public FieldBinding[] fields() {
        if ((this.tagBits & 0x1000L) != 0L) {
            return this.fields;
        }
        int i = this.fields.length;
        while (--i >= 0) {
            this.resolveTypeFor(this.fields[i]);
        }
        this.tagBits |= 0x1000L;
        return this.fields;
    }

    public char[] genericTypeSignature() {
        return this.computeGenericTypeSignature(this.typeVariables);
    }

    public MethodBinding getExactConstructor(TypeBinding[] argumentTypes) {
        int argCount = argumentTypes.length;
        int m = this.methods.length;
        block0: while (--m >= 0) {
            MethodBinding method = this.methods[m];
            if (method.selector != TypeConstants.INIT || method.parameters.length != argCount) continue;
            this.resolveTypesFor(method);
            TypeBinding[] toMatch = method.parameters;
            int p = 0;
            while (p < argCount) {
                if (toMatch[p] != argumentTypes[p]) continue block0;
                ++p;
            }
            return method;
        }
        return null;
    }

    public MethodBinding getExactMethod(char[] selector, TypeBinding[] argumentTypes, CompilationUnitScope refScope) {
        int argCount = argumentTypes.length;
        int selectorLength = selector.length;
        boolean foundNothing = true;
        int m = this.methods.length;
        block0: while (--m >= 0) {
            MethodBinding method = this.methods[m];
            if (method.selector.length != selectorLength || !CharOperation.equals(method.selector, selector)) continue;
            foundNothing = false;
            if (method.parameters.length != argCount) continue;
            this.resolveTypesFor(method);
            TypeBinding[] toMatch = method.parameters;
            int p = 0;
            while (p < argCount) {
                if (toMatch[p] != argumentTypes[p]) continue block0;
                ++p;
            }
            return method;
        }
        if (foundNothing) {
            if (this.isInterface()) {
                if (this.superInterfaces().length == 1) {
                    if (refScope != null) {
                        refScope.recordTypeReference(this.superInterfaces[0]);
                    }
                    return this.superInterfaces[0].getExactMethod(selector, argumentTypes, refScope);
                }
            } else if (this.superclass() != null) {
                if (refScope != null) {
                    refScope.recordTypeReference(this.superclass);
                }
                return this.superclass.getExactMethod(selector, argumentTypes, refScope);
            }
        }
        return null;
    }

    public FieldBinding getField(char[] fieldName, boolean needResolve) {
        int fieldLength = fieldName.length;
        int f = this.fields.length;
        while (--f >= 0) {
            char[] name = this.fields[f].name;
            if (name.length != fieldLength || !CharOperation.equals(name, fieldName)) continue;
            return needResolve ? this.resolveTypeFor(this.fields[f]) : this.fields[f];
        }
        return null;
    }

    public ReferenceBinding getMemberType(char[] typeName) {
        int i = this.memberTypes.length;
        while (--i >= 0) {
            ReferenceBinding memberType = this.memberTypes[i];
            if (memberType instanceof UnresolvedReferenceBinding) {
                char[] name = memberType.sourceName;
                int prefixLength = this.compoundName[this.compoundName.length - 1].length + 1;
                if (name.length != prefixLength + typeName.length || !CharOperation.fragmentEquals(typeName, name, prefixLength, true)) continue;
                this.memberTypes[i] = BinaryTypeBinding.resolveType(memberType, this.environment, false);
                return this.memberTypes[i];
            }
            if (!CharOperation.equals(typeName, memberType.sourceName)) continue;
            return memberType;
        }
        return null;
    }

    public MethodBinding[] getMethods(char[] selector) {
        MethodBinding method;
        int count = 0;
        int lastIndex = -1;
        int selectorLength = selector.length;
        int m = 0;
        int length = this.methods.length;
        while (m < length) {
            method = this.methods[m];
            if (method.selector.length == selectorLength && CharOperation.equals(method.selector, selector)) {
                this.resolveTypesFor(method);
                ++count;
                lastIndex = m;
            }
            ++m;
        }
        if (count == 1) {
            return new MethodBinding[]{this.methods[lastIndex]};
        }
        if (count > 0) {
            MethodBinding[] result = new MethodBinding[count];
            count = 0;
            int m2 = 0;
            while (m2 <= lastIndex) {
                method = this.methods[m2];
                if (method.selector.length == selectorLength && CharOperation.equals(method.selector, selector)) {
                    result[count++] = method;
                }
                ++m2;
            }
            return result;
        }
        return NoMethods;
    }

    public boolean hasMemberTypes() {
        return this.memberTypes.length > 0;
    }

    public TypeVariableBinding getTypeVariable(char[] variableName) {
        TypeVariableBinding variable = super.getTypeVariable(variableName);
        variable.resolve(this.environment);
        return variable;
    }

    private void initializeTypeVariable(TypeVariableBinding variable, TypeVariableBinding[] existingVariables, SignatureWrapper wrapper) {
        ReferenceBinding type;
        int colon = CharOperation.indexOf(':', wrapper.signature, wrapper.start);
        wrapper.start = colon + 1;
        ReferenceBinding firstBound = null;
        if (wrapper.signature[wrapper.start] == ':') {
            type = this.environment.getType(JAVA_LANG_OBJECT);
        } else {
            firstBound = type = (ReferenceBinding)this.environment.getTypeFromTypeSignature(wrapper, existingVariables, this);
        }
        variable.modifiers |= 0x2000000;
        variable.superclass = type;
        ReferenceBinding[] bounds = null;
        if (wrapper.signature[wrapper.start] == ':') {
            ArrayList<TypeBinding> types = new ArrayList<TypeBinding>(2);
            do {
                ++wrapper.start;
                types.add(this.environment.getTypeFromTypeSignature(wrapper, existingVariables, this));
            } while (wrapper.signature[wrapper.start] == ':');
            bounds = new ReferenceBinding[types.size()];
            types.toArray(bounds);
        }
        ReferenceBinding[] referenceBindingArray = variable.superInterfaces = bounds == null ? NoSuperInterfaces : bounds;
        if (firstBound == null) {
            firstBound = variable.superInterfaces.length == 0 ? null : variable.superInterfaces[0];
            variable.modifiers |= 0x200;
        }
        variable.firstBound = firstBound;
    }

    public boolean isEquivalentTo(TypeBinding otherType) {
        if (this == otherType) {
            return true;
        }
        if (otherType == null) {
            return false;
        }
        switch (otherType.kind()) {
            case 516: {
                return ((WildcardBinding)otherType).boundCheck(this);
            }
            case 1028: {
                return otherType.erasure() == this;
            }
        }
        return false;
    }

    public boolean isGenericType() {
        return this.typeVariables != NoTypeVariables;
    }

    public int kind() {
        if (this.typeVariables != NoTypeVariables) {
            return 2052;
        }
        return 4;
    }

    public ReferenceBinding[] memberTypes() {
        if ((this.tagBits & 0x10000000L) == 0L) {
            return this.memberTypes;
        }
        int i = this.memberTypes.length;
        while (--i >= 0) {
            this.memberTypes[i] = BinaryTypeBinding.resolveUnresolvedType(this.memberTypes[i], this.environment, false);
        }
        this.tagBits &= 0xFFFFFFFFEFFFFFFFL;
        i = this.memberTypes.length;
        while (--i >= 0) {
            this.memberTypes[i] = BinaryTypeBinding.resolveType(this.memberTypes[i], this.environment, false);
        }
        return this.memberTypes;
    }

    public MethodBinding[] methods() {
        if ((this.tagBits & 0x2000L) != 0L) {
            return this.methods;
        }
        int i = this.methods.length;
        while (--i >= 0) {
            this.resolveTypesFor(this.methods[i]);
        }
        this.tagBits |= 0x2000L;
        return this.methods;
    }

    private FieldBinding resolveTypeFor(FieldBinding field) {
        if ((field.modifiers & 0x2000000) == 0) {
            return field;
        }
        field.type = BinaryTypeBinding.resolveType(field.type, this.environment, null, 0);
        field.modifiers &= 0xFDFFFFFF;
        return field;
    }

    MethodBinding resolveTypesFor(MethodBinding method) {
        if ((method.modifiers & 0x2000000) == 0) {
            return method;
        }
        if (!method.isConstructor()) {
            method.returnType = BinaryTypeBinding.resolveType(method.returnType, this.environment, null, 0);
        }
        int i = method.parameters.length;
        while (--i >= 0) {
            method.parameters[i] = BinaryTypeBinding.resolveType(method.parameters[i], this.environment, null, 0);
        }
        i = method.thrownExceptions.length;
        while (--i >= 0) {
            method.thrownExceptions[i] = BinaryTypeBinding.resolveType(method.thrownExceptions[i], this.environment, true);
        }
        i = method.typeVariables.length;
        while (--i >= 0) {
            method.typeVariables[i].resolve(this.environment);
        }
        method.modifiers &= 0xFDFFFFFF;
        return method;
    }

    public ReferenceBinding superclass() {
        if ((this.tagBits & 0x2000000L) == 0L) {
            return this.superclass;
        }
        this.superclass = BinaryTypeBinding.resolveUnresolvedType(this.superclass, this.environment, true);
        this.tagBits &= 0xFFFFFFFFFDFFFFFFL;
        this.superclass = BinaryTypeBinding.resolveType(this.superclass, this.environment, true);
        return this.superclass;
    }

    public ReferenceBinding[] superInterfaces() {
        if ((this.tagBits & 0x4000000L) == 0L) {
            return this.superInterfaces;
        }
        int i = this.superInterfaces.length;
        while (--i >= 0) {
            this.superInterfaces[i] = BinaryTypeBinding.resolveUnresolvedType(this.superInterfaces[i], this.environment, true);
        }
        this.tagBits &= 0xFFFFFFFFFBFFFFFFL;
        i = this.superInterfaces.length;
        while (--i >= 0) {
            this.superInterfaces[i] = BinaryTypeBinding.resolveType(this.superInterfaces[i], this.environment, true);
        }
        return this.superInterfaces;
    }

    public TypeVariableBinding[] typeVariables() {
        if ((this.tagBits & 0x1000000L) == 0L) {
            return this.typeVariables;
        }
        int i = this.typeVariables.length;
        while (--i >= 0) {
            this.typeVariables[i].resolve(this.environment);
        }
        this.tagBits &= 0xFFFFFFFFFEFFFFFFL;
        return this.typeVariables;
    }

    public String toString() {
        int length;
        int i;
        StringBuffer buffer = new StringBuffer();
        if (this.isDeprecated()) {
            buffer.append("deprecated ");
        }
        if (this.isPublic()) {
            buffer.append("public ");
        }
        if (this.isProtected()) {
            buffer.append("protected ");
        }
        if (this.isPrivate()) {
            buffer.append("private ");
        }
        if (this.isAbstract() && this.isClass()) {
            buffer.append("abstract ");
        }
        if (this.isStatic() && this.isNestedType()) {
            buffer.append("static ");
        }
        if (this.isFinal()) {
            buffer.append("final ");
        }
        if (this.isEnum()) {
            buffer.append("enum ");
        } else if (this.isAnnotationType()) {
            buffer.append("@interface ");
        } else if (this.isClass()) {
            buffer.append("class ");
        } else {
            buffer.append("interface ");
        }
        buffer.append(this.compoundName != null ? CharOperation.toString(this.compoundName) : "UNNAMED TYPE");
        buffer.append("\n\textends ");
        buffer.append(this.superclass != null ? this.superclass.debugName() : "NULL TYPE");
        if (this.superInterfaces != null) {
            if (this.superInterfaces != NoSuperInterfaces) {
                buffer.append("\n\timplements : ");
                i = 0;
                length = this.superInterfaces.length;
                while (i < length) {
                    if (i > 0) {
                        buffer.append(", ");
                    }
                    buffer.append(this.superInterfaces[i] != null ? this.superInterfaces[i].debugName() : "NULL TYPE");
                    ++i;
                }
            }
        } else {
            buffer.append("NULL SUPERINTERFACES");
        }
        if (this.enclosingType != null) {
            buffer.append("\n\tenclosing type : ");
            buffer.append(this.enclosingType.debugName());
        }
        if (this.fields != null) {
            if (this.fields != NoFields) {
                buffer.append("\n/*   fields   */");
                i = 0;
                length = this.fields.length;
                while (i < length) {
                    buffer.append(this.fields[i] != null ? "\n" + this.fields[i].toString() : "\nNULL FIELD");
                    ++i;
                }
            }
        } else {
            buffer.append("NULL FIELDS");
        }
        if (this.methods != null) {
            if (this.methods != NoMethods) {
                buffer.append("\n/*   methods   */");
                i = 0;
                length = this.methods.length;
                while (i < length) {
                    buffer.append(this.methods[i] != null ? "\n" + this.methods[i].toString() : "\nNULL METHOD");
                    ++i;
                }
            }
        } else {
            buffer.append("NULL METHODS");
        }
        if (this.memberTypes != null) {
            if (this.memberTypes != NoMemberTypes) {
                buffer.append("\n/*   members   */");
                i = 0;
                length = this.memberTypes.length;
                while (i < length) {
                    buffer.append(this.memberTypes[i] != null ? "\n" + this.memberTypes[i].toString() : "\nNULL TYPE");
                    ++i;
                }
            }
        } else {
            buffer.append("NULL MEMBER TYPES");
        }
        buffer.append("\n\n\n");
        return buffer.toString();
    }

    MethodBinding[] unResolvedMethods() {
        return this.methods;
    }
}

