/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.analyzer;

import flash.css.Logger;
import flash.css.StyleParser;
import flash.css.StyleSheet;
import flash.fonts.FontManager;
import flash.util.FileUtils;
import flex2.compiler.CompilationUnit;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.mxml.Configuration;
import flex2.compiler.mxml.ParseException;
import flex2.compiler.mxml.Parser;
import flex2.compiler.mxml.Token;
import flex2.compiler.mxml.dom.AnalyzerAdapter;
import flex2.compiler.mxml.dom.ArgumentsNode;
import flex2.compiler.mxml.dom.ArrayNode;
import flex2.compiler.mxml.dom.BindingNode;
import flex2.compiler.mxml.dom.BooleanNode;
import flex2.compiler.mxml.dom.CDATANode;
import flex2.compiler.mxml.dom.InlineComponentNode;
import flex2.compiler.mxml.dom.IntNode;
import flex2.compiler.mxml.dom.MetaDataNode;
import flex2.compiler.mxml.dom.ModelNode;
import flex2.compiler.mxml.dom.Node;
import flex2.compiler.mxml.dom.NumberNode;
import flex2.compiler.mxml.dom.PrimitiveNode;
import flex2.compiler.mxml.dom.RequestNode;
import flex2.compiler.mxml.dom.Scanner;
import flex2.compiler.mxml.dom.ScannerError;
import flex2.compiler.mxml.dom.ScriptNode;
import flex2.compiler.mxml.dom.StringNode;
import flex2.compiler.mxml.dom.StyleNode;
import flex2.compiler.mxml.dom.SyntaxTreeBuilder;
import flex2.compiler.mxml.dom.UIntNode;
import flex2.compiler.mxml.dom.XMLListNode;
import flex2.compiler.mxml.dom.XMLNode;
import flex2.compiler.mxml.lang.TextParser;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Set;

public class SyntaxAnalyzer
extends AnalyzerAdapter {
    public SyntaxAnalyzer(CompilationUnit unit, Configuration configuration) {
        super(unit, configuration);
    }

    public void analyze(Node node) {
        super.analyze(node);
    }

    public void analyze(CDATANode node) {
    }

    public void analyze(StyleNode node) {
        this.checkForExtraAttributes(StyleNode.attributes, node);
        String source = (String)node.getAttribute("source");
        CDATANode cdata = (CDATANode)node.getChildAt(0);
        if (source != null && cdata != null) {
            this.log(node, node.getLineNumber("source"), new IgnoreEmbeddedStylesheet());
        }
        if (source != null) {
            VirtualFile[] sourcePath;
            if (TextParser.getBindingExpressionFromString(source) != null) {
                this.log(node, node.getLineNumber("source"), new CompileTimeAttributeBindingExpressionUnsupported());
                return;
            }
            VirtualFile file = this.unit.getSource().resolve(source);
            if (file == null && (sourcePath = this.configuration.getSourcePath()) != null) {
                for (int i = 0; i < sourcePath.length && file == null; ++i) {
                    file = sourcePath[i].resolve(source);
                }
            }
            if (file == null) {
                this.log(node, node.getLineNumber("source"), new StylesheetNotFound(source));
            } else {
                this.unit.getSource().addFileInclude(file);
                cdata = this.parseExternalFile(node, file);
                if (cdata != null) {
                    this.parseStyle(node, file.getName(), file.getLastModified(), cdata);
                }
            }
        } else if (cdata != null) {
            this.parseStyle(node, this.unit.getSource().getName(), this.unit.getSource().getLastModified(), cdata.beginLine);
        }
    }

    public void analyze(ScriptNode node) {
        this.checkForExtraAttributes(ScriptNode.attributes, node);
        this.script(node);
    }

    public void analyze(MetaDataNode node) {
        this.checkForExtraAttributes(MetaDataNode.attributes, node);
    }

    public void analyze(ModelNode node) {
        this.checkForExtraAttributes(ModelNode.attributes, node);
        String source = (String)node.getAttribute("source");
        int count = node.getChildCount();
        if (source != null && count > 0) {
            this.log(node, node.getLineNumber("source"), new EmptyTagIfSourceSpecified());
        }
        if (source != null) {
            if (TextParser.getBindingExpressionFromString(source) != null) {
                this.log(node, node.getLineNumber("source"), new CompileTimeAttributeBindingExpressionUnsupported());
                return;
            }
            VirtualFile f = this.unit.getSource().resolve(source);
            if (f == null) {
                this.log(node, node.getLineNumber("source"), new ModelNotFound(source));
            } else {
                this.unit.getSource().addFileInclude(f);
                Node root = this.parseExternalXML(node, f);
                if (root != null) {
                    node.setSourceFile(new Node[]{root});
                }
            }
        }
    }

    public void analyze(XMLNode node) {
        this.checkForExtraAttributes(XMLNode.attributes, node);
        String source = (String)node.getAttribute("source");
        int count = node.getChildCount();
        if (source != null && count > 0) {
            this.log(node, node.getLineNumber("source"), new IgnoreInlineXML());
        }
        if (source != null) {
            if (TextParser.getBindingExpressionFromString(source) != null) {
                this.log(node, node.getLineNumber("source"), new CompileTimeAttributeBindingExpressionUnsupported());
                return;
            }
            VirtualFile f = this.unit.getSource().resolve(source);
            if (f == null) {
                this.log(node, node.getLineNumber("source"), new XMLNotFound(source));
            } else {
                this.unit.getSource().addFileInclude(f);
                Node root = this.parseExternalXML(node, f);
                if (root != null) {
                    node.setSourceFile(new Node[]{root});
                }
            }
        }
    }

    public void analyze(XMLListNode node) {
        this.checkForExtraAttributes(XMLListNode.attributes, node);
    }

    public void analyze(ArrayNode node) {
        this.checkForExtraAttributes(ArrayNode.attributes, node);
        super.analyze(node);
    }

    public void analyze(BindingNode node) {
        String destination;
        this.checkForExtraAttributes(BindingNode.attributes, node);
        String source = (String)node.getAttribute("source");
        if (source == null || source.trim().length() == 0) {
            this.log(node, (CompilerMessage)new BindingMustHaveSource());
        }
        if ((destination = (String)node.getAttribute("destination")) == null || destination.trim().length() == 0) {
            this.log(node, (CompilerMessage)new BindingMustHaveDestination());
        }
    }

    public void analyze(StringNode node) {
        this.checkForExtraAttributes(StringNode.attributes, node);
        this.primitive(node);
    }

    public void analyze(NumberNode node) {
        this.checkForExtraAttributes(NumberNode.attributes, node);
        this.primitive(node);
    }

    public void analyze(IntNode node) {
        this.checkForExtraAttributes(IntNode.attributes, node);
        this.primitive(node);
    }

    public void analyze(UIntNode node) {
        this.checkForExtraAttributes(UIntNode.attributes, node);
        this.primitive(node);
    }

    public void analyze(BooleanNode node) {
        this.checkForExtraAttributes(BooleanNode.attributes, node);
        this.primitive(node);
    }

    public void analyze(RequestNode node) {
        this.checkForExtraAttributes(RequestNode.attributes, node);
        super.analyze(node);
    }

    public void analyze(ArgumentsNode node) {
        this.checkForExtraAttributes(ArgumentsNode.attributes, node);
        super.analyze(node);
    }

    public void analyze(InlineComponentNode node) {
        this.checkForExtraAttributes(InlineComponentNode.attributes, node);
        if (node.getChildCount() == 0) {
            this.log(node, (CompilerMessage)new InlineComponentMustHaveOneChild());
        }
        super.analyze(node);
    }

    private void checkForExtraAttributes(Set validAttributes, Node node) {
        Iterator attributes = node.getAttributeNames();
        while (attributes != null && attributes.hasNext()) {
            QName qname = (QName)attributes.next();
            if (validAttributes.contains(qname)) continue;
            this.log(node, node.getLineNumber(qname), new UnknownAttribute(qname, node.image));
        }
    }

    private void script(ScriptNode node) {
        String source = (String)node.getAttribute("source");
        CDATANode cdata = (CDATANode)node.getChildAt(0);
        if (source != null && cdata != null) {
            this.log(node, node.getLineNumber("source"), new IgnoreInlineScript());
        }
        if (source != null) {
            if (TextParser.getBindingExpressionFromString(source) != null) {
                this.log(node, node.getLineNumber("source"), new CompileTimeAttributeBindingExpressionUnsupported());
                return;
            }
            VirtualFile f = this.unit.getSource().resolve(source);
            if (f == null) {
                this.log(node, node.getLineNumber("source"), new ScriptNotFound(source));
            } else {
                this.unit.getSource().addFileInclude(f);
                CDATANode n = this.parseExternalFile(node, f);
                if (n != null) {
                    cdata = n;
                    node.setSourceFile(n);
                }
            }
        }
    }

    private void primitive(PrimitiveNode node) {
        String source = (String)node.getAttribute("source");
        CDATANode cdata = (CDATANode)node.getChildAt(0);
        if (source != null && cdata != null) {
            this.log(node, node.getLineNumber("source"), new IgnoreEmbeddedString());
        }
        if (source != null) {
            if (TextParser.getBindingExpressionFromString(source) != null) {
                this.log(node, node.getLineNumber("source"), new CompileTimeAttributeBindingExpressionUnsupported());
                return;
            }
            VirtualFile f = this.unit.getSource().resolve(source);
            if (f == null) {
                this.log(node, node.getLineNumber("source"), new PrimitiveFileNotFound(source));
            } else {
                this.unit.getSource().addFileInclude(f);
                CDATANode n = this.parseExternalFile(node, f);
                if (n != null) {
                    cdata = n;
                    node.setSourceFile(n);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Node parseExternalXML(Node node, VirtualFile f) {
        BufferedInputStream in = null;
        Node anonymousObject = null;
        in = new BufferedInputStream(f.getInputStream());
        Scanner s = new Scanner(in);
        Parser p = new Parser(s);
        SyntaxTreeBuilder v = new SyntaxTreeBuilder();
        p.setVisitor(v);
        anonymousObject = (Node)p.parseAnonymousObject();
        Object var9_12 = null;
        if (in == null) return anonymousObject;
        try {
            in.close();
            return anonymousObject;
        }
        catch (IOException ex2) {}
        return anonymousObject;
        {
            catch (ScannerError se) {
                this.log(node, (CompilerMessage)new XMLParseProblem1(f.getName(), se.getLineNumber(), se.getReason()));
                Object var9_13 = null;
                if (in == null) return anonymousObject;
                try {
                    in.close();
                    return anonymousObject;
                }
                catch (IOException ex2) {}
                return anonymousObject;
            }
            catch (ParseException ex) {
                this.log(node, (CompilerMessage)new XMLParseProblem2(f.getName()));
                Token token = ex.currentToken.next;
                this.logError(node, token.beginLine, ex.getMessage());
                Object var9_14 = null;
                if (in == null) return anonymousObject;
                try {
                    in.close();
                    return anonymousObject;
                }
                catch (IOException ex2) {}
                return anonymousObject;
            }
            catch (IOException ex) {
                this.log(node, (CompilerMessage)new XMLParseProblem3(f.getName(), ex.getMessage()));
                Object var9_15 = null;
                if (in == null) return anonymousObject;
                try {
                    in.close();
                    return anonymousObject;
                }
                catch (IOException ex2) {}
                return anonymousObject;
            }
        }
        catch (Throwable throwable) {
            Object var9_16 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CDATANode parseExternalFile(Node node, VirtualFile f) {
        String charsetName;
        BufferedInputStream bufferedInputStream;
        CDATANode cdata;
        BufferedReader reader;
        block16: {
            reader = null;
            cdata = null;
            bufferedInputStream = new BufferedInputStream(f.getInputStream());
            charsetName = null;
            if (!f.getName().toLowerCase().endsWith(".css")) break block16;
            try {
                charsetName = StyleParser.readCSSCharset(bufferedInputStream);
            }
            catch (StyleParser.StyleSheetInvalidCharset e) {
                this.log(node, (CompilerMessage)new StyleParser.StyleSheetInvalidCharset(f.getName(), e.charsetName));
                CDATANode cDATANode = null;
                Object var12_13 = null;
                if (reader == null) return cDATANode;
                try {
                    reader.close();
                    return cDATANode;
                }
                catch (IOException ex2) {
                    // empty catch block
                }
                return cDATANode;
            }
        }
        String bomCharsetName = FileUtils.consumeBOM((InputStream)bufferedInputStream, null, (boolean)true);
        if (charsetName == null) {
            charsetName = bomCharsetName;
        }
        reader = new BufferedReader(new InputStreamReader((InputStream)bufferedInputStream, charsetName));
        StringWriter buffer = new StringWriter();
        PrintWriter out = new PrintWriter(buffer);
        String str = null;
        while ((str = reader.readLine()) != null) {
            out.println(str);
        }
        out.flush();
        cdata = new CDATANode();
        cdata.image = buffer.toString().trim();
        Object var12_14 = null;
        if (reader == null) return cdata;
        try {
            reader.close();
            return cdata;
        }
        catch (IOException ex2) {}
        return cdata;
        {
            catch (FileNotFoundException ex) {
                this.log(node, (CompilerMessage)new ExternalFileNotFound(f.getName()));
                Object var12_15 = null;
                if (reader == null) return cdata;
                try {
                    reader.close();
                    return cdata;
                }
                catch (IOException ex2) {}
                return cdata;
            }
            catch (IOException ex) {
                this.log(node, (CompilerMessage)new ParseFileProblem(f.getName(), ex.getMessage()));
                Object var12_16 = null;
                if (reader == null) return cdata;
                try {
                    reader.close();
                    return cdata;
                }
                catch (IOException ex2) {}
                return cdata;
            }
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void parseStyle(StyleNode node, String stylePath, long lastModified, CDATANode cdata) {
        FontManager fontManager = this.configuration.getFontsConfiguration().getTopLevelManager();
        StyleSheet styleSheet = new StyleSheet();
        styleSheet.checkDeprecation(this.configuration.showDeprecationWarnings());
        styleSheet.parse(stylePath, new StringReader(cdata.image), (Logger)ThreadLocalToolkit.getLogger(), fontManager);
        if (styleSheet.errorsExist()) {
            this.log(node, (CompilerMessage)new StyleSheetParseError(stylePath));
        }
        node.setStyleSheet(styleSheet);
    }

    private void parseStyle(StyleNode node, String enclosingDocumentPath, long lastModified, int startLine) {
        FontManager fontManager = this.configuration.getFontsConfiguration().getTopLevelManager();
        CDATANode cdata = (CDATANode)node.getChildAt(0);
        StyleSheet styleSheet = new StyleSheet();
        styleSheet.checkDeprecation(this.configuration.showDeprecationWarnings());
        styleSheet.parse(enclosingDocumentPath, startLine, new StringReader(cdata.image), ThreadLocalToolkit.getLogger(), fontManager);
        if (styleSheet.errorsExist()) {
            this.log(node, (CompilerMessage)new StyleSheetParseError(enclosingDocumentPath));
        }
        node.setStyleSheet(styleSheet);
    }

    public static class InlineComponentMustHaveOneChild
    extends CompilerMessage.CompilerError {
    }

    public static class StyleSheetParseError
    extends CompilerMessage.CompilerError {
        public final String stylePath;

        public StyleSheetParseError(String stylePath) {
            this.stylePath = stylePath;
        }
    }

    public static class ParseFileProblem
    extends CompilerMessage.CompilerError {
        public final String name;
        public final String message;

        public ParseFileProblem(String name, String message) {
            this.name = name;
            this.message = message;
        }
    }

    public static class ExternalFileNotFound
    extends CompilerMessage.CompilerError {
        public final String name;

        public ExternalFileNotFound(String name) {
            this.name = name;
        }
    }

    public static class XMLParseProblem3
    extends CompilerMessage.CompilerError {
        public final String name;
        public final String message;

        public XMLParseProblem3(String name, String message) {
            this.name = name;
            this.message = message;
        }
    }

    public static class XMLParseProblem2
    extends CompilerMessage.CompilerError {
        public final String name;

        public XMLParseProblem2(String name) {
            this.name = name;
        }
    }

    public static class XMLParseProblem1
    extends CompilerMessage.CompilerError {
        public final String name;
        public final int line;
        public final String reason;

        public XMLParseProblem1(String name, int line, String reason) {
            this.name = name;
            this.line = line;
            this.reason = reason;
        }
    }

    public static class PrimitiveFileNotFound
    extends CompilerMessage.CompilerError {
        public final String source;

        public PrimitiveFileNotFound(String source) {
            this.source = source;
        }
    }

    public static class IgnoreEmbeddedString
    extends CompilerMessage.CompilerWarning {
    }

    public static class ScriptNotFound
    extends CompilerMessage.CompilerError {
        public final String source;

        public ScriptNotFound(String source) {
            this.source = source;
        }
    }

    public static class UnknownAttribute
    extends CompilerMessage.CompilerError {
        public final QName qname;
        public final String tag;

        public UnknownAttribute(QName qname, String tag) {
            this.qname = qname;
            this.tag = tag;
        }
    }

    public static class BindingMustHaveDestination
    extends CompilerMessage.CompilerError {
    }

    public static class BindingMustHaveSource
    extends CompilerMessage.CompilerError {
    }

    public static class XMLNotFound
    extends CompilerMessage.CompilerError {
        public final String source;

        public XMLNotFound(String source) {
            this.source = source;
        }
    }

    public static class IgnoreInlineXML
    extends CompilerMessage.CompilerWarning {
    }

    public static class IgnoreInlineScript
    extends CompilerMessage.CompilerWarning {
    }

    public static class ScalarContentOnlyUnsupportedInExternalModel
    extends CompilerMessage.CompilerError {
    }

    public static class ModelNotFound
    extends CompilerMessage.CompilerError {
        public final String source;

        public ModelNotFound(String source) {
            this.source = source;
        }
    }

    public static class EmptyTagIfSourceSpecified
    extends CompilerMessage.CompilerWarning {
    }

    public static class StylesheetNotFound
    extends CompilerMessage.CompilerError {
        public final String source;

        public StylesheetNotFound(String source) {
            this.source = source;
        }
    }

    public static class CompileTimeAttributeBindingExpressionUnsupported
    extends CompilerMessage.CompilerError {
    }

    public static class IgnoreEmbeddedStylesheet
    extends CompilerMessage.CompilerWarning {
    }
}

